/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.preferences;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import com.ibm.pdp.pac.migration.help.validation.preferences.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ValidationTypeDialog
extends Dialog {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ValidationType _valType;
    public boolean okPressed = false;
    private Text _nameTextField;
    private Button _visibleCheckbox;
    private Button _keepLocalButton;
    private Button _KeepMigratedButton;
    private Table _templateTable;
    private Table _regexTable;
    private TableViewer _templateTableViewer;
    private TableViewer _regexTableViewer;
    private Composite _tablesCompsite;
    private Composite _mainComposite;
    private Combo _scopeCombo;
    private Button _templatesAddButton;
    private Button _templatesRemoveButton;
    private Button _regexAddButton;
    private Button _regexRemoveButton;
    private final String TEMPLATE_DELETED_COLUMN = "Deleted";
    private final String TEMPLATE_ADDED_COLUMN = "Added";
    private final String PAC_REGEX_COLUMN = Messages.ValidationTypeDialog_Pac_REGEX;
    private final String LOCAL_REGEX_COLUMN = Messages.ValidationTypeDialog_Local_REGEX;
    private String[] columnNamesForTemplates = new String[]{"Deleted", "Added"};
    private String[] columnNamesForREGEX = new String[]{this.PAC_REGEX_COLUMN, this.LOCAL_REGEX_COLUMN};

    public ValidationTypeDialog(Shell shell, ValidationType valType) {
        super(shell);
        this._valType = valType;
    }

    private void addRegex() {
        ValidationTypeConditionRegex vtcr = new ValidationTypeConditionRegex("", "");
        this._valType.getRegexList().add(vtcr);
        this.refreshRegexTable();
        this._regexTableViewer.editElement((Object)vtcr, 0);
    }

    private void addTemplate() {
        this._valType.getTemplatesSelection().add(new ValidationTypeTemplateSelection(""));
        this.refreshTemplatesTable();
        this._templateTableViewer.editElement((Object)"", 0);
    }

    private void addSelectionListener(Button pbControl) {
        pbControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ValidationTypeDialog.this._templatesRemoveButton) {
                    ValidationTypeDialog.this.removeTemplate();
                    return;
                }
                if (e.getSource() == ValidationTypeDialog.this._regexRemoveButton) {
                    ValidationTypeDialog.this.removeRegex();
                    return;
                }
                if (e.getSource() == ValidationTypeDialog.this._templatesAddButton) {
                    ValidationTypeDialog.this.addTemplate();
                    return;
                }
                if (e.getSource() == ValidationTypeDialog.this._regexAddButton) {
                    ValidationTypeDialog.this.addRegex();
                    return;
                }
            }
        });
    }

    void clearTablesContents() {
        switch (this._scopeCombo.getSelectionIndex()) {
            case 0: {
                this._valType.getRegexList().clear();
                break;
            }
            case 1: {
                this._valType.getTemplatesSelection().clear();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this._valType.getTemplatesSelection().clear();
                break;
            }
            default: {
                this.setRegexTableVisible(true);
                this.setTemplatesTableVisible(true);
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ValidationTypeDialog_Validation_type);
    }

    public void create() {
        this.setShellStyle(67696);
        super.create();
    }

    protected Control createContents(Composite parent) {
        this._mainComposite = (Composite)super.createContents(parent);
        this.refreshAllComposite();
        MigrationHelpPlugin.setHelpMechanism(parent, "preferences_migration_type");
        return this._mainComposite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout2 = new GridLayout();
        composite.setLayout((Layout)layout2);
        final ScrolledComposite scrollComposite = new ScrolledComposite(composite, 768);
        scrollComposite.setLayoutData((Object)new GridData(1808));
        final Composite rootComposite = new Composite((Composite)scrollComposite, 0);
        GridData rootGridData = new GridData();
        rootGridData.minimumHeight = 100;
        rootGridData.minimumWidth = 100;
        rootComposite.setLayoutData((Object)rootGridData);
        GridLayout layout = new GridLayout();
        rootComposite.setLayout((Layout)layout);
        scrollComposite.setContent((Control)rootComposite);
        scrollComposite.setExpandVertical(true);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollComposite.getClientArea();
                scrollComposite.setMinSize(rootComposite.computeSize(r.width, -1));
            }
        });
        Composite composite2 = PTWidgetTool.createComposite((Composite)rootComposite, (int)2, (boolean)false);
        PTWidgetTool.createLabel((Composite)composite2, (String)Messages.ValidationTypeDialog_Name);
        this._nameTextField = PTWidgetTool.createTextField((Composite)composite2, (boolean)false, (boolean)false);
        Composite composite3 = PTWidgetTool.createComposite((Composite)rootComposite, (int)2, (boolean)false);
        Group grpContext = PTWidgetTool.createGroup((Composite)composite3, (int)1, (int)20, (String)Messages.ValidationTypeDialog_Migration_choice);
        GridData gridData = new GridData(4, 4, true, true);
        grpContext.setLayoutData((Object)gridData);
        this._keepLocalButton = PTWidgetTool.createRadioButton((Composite)grpContext, (String)Messages.ValidationTypeDialog_Keep_local, (boolean)false);
        this._KeepMigratedButton = PTWidgetTool.createRadioButton((Composite)grpContext, (String)Messages.ValidationTypeDialog_Override_local, (boolean)false);
        this._visibleCheckbox = PTWidgetTool.createCheckBox((Composite)composite3, (String)Messages.ValidationTypeDialog_Visible);
        Group group = PTWidgetTool.createGroup((Composite)composite3, (int)1, (int)2, (String)Messages.ValidationTypeDialog_Filter);
        Composite scopeComposite = PTWidgetTool.createComposite((Composite)group, (int)2, (boolean)false);
        PTWidgetTool.createLabel((Composite)scopeComposite, (String)Messages.ValidationTypeDialog_Scope);
        this._scopeCombo = PTWidgetTool.createCombo((Composite)scopeComposite, (int)1);
        this._scopeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ValidationTypeDialog.this._scopeCombo) {
                    ValidationTypeDialog.this.clearTablesContents();
                    ValidationTypeDialog.this.refreshRegexTable();
                    ValidationTypeDialog.this.refreshTemplatesTable();
                    ValidationTypeDialog.this.refreshEnableStateForTables();
                }
            }
        });
        this._scopeCombo.add(Messages.ValidationTypeDialog_Selected_templates);
        this._scopeCombo.add(Messages.ValidationTypeDialog_All_templates);
        this._scopeCombo.add(Messages.ValidationTypeDialog_All_differences_selected_templates);
        this._scopeCombo.add(Messages.ValidationTypeDialog_All_differences);
        this._scopeCombo.setVisibleItemCount(4);
        this._scopeCombo.select(0);
        this.createTables((Composite)group);
        this.initializeDialogUnits((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createTableForRegex(Composite parent) {
        int style = 67588;
        this._regexTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = 50;
        gridData.minimumWidth = 60;
        this._regexTable.setLayoutData((Object)gridData);
        this._regexTable.setLinesVisible(true);
        this._regexTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._regexTable, 16384, 0);
        column.setText(Messages.ValidationTypeDialog_Regex_for_migrated);
        column.setWidth(50);
        column = new TableColumn(this._regexTable, 16384, 1);
        column.setText(Messages.ValidationTypeDialog_Regex_for_local);
        column.setWidth(50);
        this.createTableRegexSelectionButtons(parent);
    }

    private void createTableForTemplatesSelection(Composite parent) {
        int style = 67588;
        this._templateTable = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.minimumHeight = 50;
        gridData.minimumWidth = 60;
        this._templateTable.setLayoutData((Object)gridData);
        this._templateTable.setLinesVisible(true);
        this._templateTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._templateTable, 16384, 0);
        column.setText(Messages.ValidationTypeDialog_Deleted);
        column = new TableColumn(this._templateTable, 16384, 1);
        column.setText(Messages.ValidationTypeDialog_Added);
        this.createTableTemplatesSelectionButtons(parent);
    }

    private void createTableRegexSelectionButtons(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        GridData gridData = new GridData(1, 4, false, true);
        composite.setLayoutData((Object)gridData);
        this._regexAddButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationTypeDialog_Add_regex, (int)0x1000008);
        this.addSelectionListener(this._regexAddButton);
        this._regexRemoveButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationTypeDialog_Remove_regex, (int)0x1000008);
        this.addSelectionListener(this._regexRemoveButton);
    }

    private void createTables(Composite parent) {
        TableColumn[] regexcolumns;
        TableColumn[] columns;
        this._tablesCompsite = PTWidgetTool.createComposite((Composite)parent, (int)4, (int)2, (boolean)false);
        this.createTableForTemplatesSelection(this._tablesCompsite);
        this.createTableViewerForTemplateSelection();
        this._templateTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                Object[] array = new Object[]{};
                if (object instanceof ValidationType) {
                    ValidationType val = (ValidationType)object;
                    ArrayList<ValidationTypeTemplateSelection> list = val.getTemplatesSelection();
                    array = new ValidationTypeTemplateSelection[list.size()];
                    int i = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        array[i++] = iterator.next();
                    }
                }
                return array;
            }
        });
        this._templateTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object object, int column) {
                if (object instanceof ValidationTypeTemplateSelection) {
                    ValidationTypeTemplateSelection vtcr = (ValidationTypeTemplateSelection)object;
                    if (column == 0) {
                        return vtcr.getDeletedCode();
                    }
                    if (column == 1) {
                        return vtcr.getAddedCode();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this._templateTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidationTypeDialog.this.refreshTemplatesButtons();
            }
        });
        this._templateTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    ValidationTypeDialog.this.removeTemplate();
                }
            }
        });
        this.createTableForRegex(this._tablesCompsite);
        this.createTableViewerForRegex();
        this._regexTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                Object[] array = new Object[]{};
                if (object instanceof ValidationType) {
                    ValidationType val = (ValidationType)object;
                    ArrayList<ValidationTypeConditionRegex> list = val.getRegexList();
                    array = new ValidationTypeConditionRegex[list.size()];
                    int i = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        array[i++] = iterator.next();
                    }
                }
                return array;
            }
        });
        this._regexTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object object, int column) {
                if (object instanceof ValidationTypeConditionRegex) {
                    ValidationTypeConditionRegex vtcr = (ValidationTypeConditionRegex)object;
                    if (column == 0) {
                        return vtcr.getRegexForPacbaseCode();
                    }
                    if (column == 1) {
                        return vtcr.getRegexForRPPCode();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this._regexTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ValidationTypeDialog.this.refreshRegexButtons();
            }
        });
        this._regexTableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    ValidationTypeDialog.this.removeRegex();
                }
            }
        });
        this._templateTableViewer.setInput((Object)this._valType);
        TableColumn[] tableColumnArray = columns = this._templateTable.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            ++n2;
        }
        this._regexTableViewer.setInput((Object)this._valType);
        TableColumn[] tableColumnArray2 = regexcolumns = this._regexTable.getColumns();
        int n3 = regexcolumns.length;
        n = 0;
        while (n < n3) {
            TableColumn tableColumn = tableColumnArray2[n];
            tableColumn.pack();
            ++n;
        }
    }

    private void createTableTemplatesSelectionButtons(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        GridData gridData = new GridData(1, 4, false, true);
        composite.setLayoutData((Object)gridData);
        this._templatesAddButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationTypeDialog_Add_template, (int)0x1000008);
        this.addSelectionListener(this._templatesAddButton);
        this._templatesRemoveButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationTypeDialog_Remove_template, (int)0x1000008);
        this.addSelectionListener(this._templatesRemoveButton);
    }

    private void createTableViewerForRegex() {
        this._regexTableViewer = new TableViewer(this._regexTable);
        this._regexTableViewer.setUseHashlookup(true);
        this._regexTableViewer.setColumnProperties(this.columnNamesForREGEX);
        CellEditor[] editors = new CellEditor[this.columnNamesForREGEX.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this._regexTable);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this._regexTable);
        editors[1] = textEditor;
        this._regexTableViewer.setCellEditors(editors);
        this._regexTableViewer.setCellModifier((ICellModifier)new RegexCellModifier());
    }

    private void createTableViewerForTemplateSelection() {
        this._templateTableViewer = new TableViewer(this._templateTable);
        this._templateTableViewer.setUseHashlookup(true);
        this._templateTableViewer.setColumnProperties(this.columnNamesForTemplates);
        CellEditor[] editors = new CellEditor[this.columnNamesForTemplates.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this._templateTable);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this._templateTable);
        editors[1] = textEditor;
        this._templateTableViewer.setCellEditors(editors);
        this._templateTableViewer.setCellModifier((ICellModifier)new TemplateCellModifier());
    }

    protected void okPressed() {
        this.okPressed = true;
        this._valType.setName(this._nameTextField.getText());
        int selectionIndex = this._scopeCombo.getSelectionIndex();
        switch (selectionIndex) {
            case 0: {
                this._valType.setConditionScope(ValidationTypeScope.SELECTED_TEMPLATES);
                this._valType.getRegexList().clear();
                break;
            }
            case 1: {
                this._valType.setConditionScope(ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX);
                this._valType.getTemplatesSelection().clear();
                break;
            }
            case 2: {
                this._valType.setConditionScope(ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX);
                break;
            }
            case 3: {
                this._valType.setConditionScope(ValidationTypeScope.ALL_DIFF_WITH_REGEX);
                this._valType.getTemplatesSelection().clear();
            }
        }
        this._valType.setMigrationChoice(this._KeepMigratedButton.getSelection() ? 1 : 0);
        this._valType.setWarningVisible(this._visibleCheckbox.getSelection());
        super.okPressed();
    }

    private void refreshAllComposite() {
        this._nameTextField.setText(this._valType.getName());
        this._visibleCheckbox.setSelection(this._valType.isWarningVisible());
        if (this._valType.getMigrationChoice() == 0) {
            this._keepLocalButton.setSelection(true);
        } else {
            this._KeepMigratedButton.setSelection(true);
        }
        ValidationTypeScope scope = this._valType.getConditionScope();
        if (scope == ValidationTypeScope.SELECTED_TEMPLATES) {
            this._scopeCombo.select(0);
        } else if (scope == ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX) {
            this._scopeCombo.select(1);
        } else if (scope == ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX) {
            this._scopeCombo.select(2);
        } else if (scope == ValidationTypeScope.ALL_DIFF_WITH_REGEX) {
            this._scopeCombo.select(3);
        }
        this.refreshEnableStateForTables();
        this.refreshRegexTable();
        this.refreshTemplatesTable();
    }

    void refreshEnableStateForTables() {
        switch (this._scopeCombo.getSelectionIndex()) {
            case 0: {
                this.setRegexTableVisible(false);
                this.setTemplatesTableVisible(true);
                break;
            }
            case 1: {
                this.setRegexTableVisible(true);
                this.setTemplatesTableVisible(false);
                break;
            }
            case 2: {
                this.setRegexTableVisible(true);
                this.setTemplatesTableVisible(true);
                break;
            }
            case 3: {
                this.setRegexTableVisible(true);
                this.setTemplatesTableVisible(false);
                break;
            }
            default: {
                this.setRegexTableVisible(true);
                this.setTemplatesTableVisible(true);
            }
        }
    }

    private void refreshRegexButtons() {
        StructuredSelection selection = (StructuredSelection)this._regexTableViewer.getSelection();
        if (selection.size() == 0) {
            this._regexRemoveButton.setEnabled(false);
            return;
        }
        Object firstSelection = selection.getFirstElement();
        if (firstSelection != null && this._regexTable.isEnabled()) {
            this._regexRemoveButton.setEnabled(true);
        }
    }

    private void refreshRegexTable() {
        if (this._regexTableViewer != null && !this._regexTableViewer.getTable().isDisposed()) {
            this._regexTableViewer.refresh();
        }
        this.refreshRegexButtons();
    }

    private void refreshTemplatesButtons() {
        StructuredSelection selection = (StructuredSelection)this._templateTableViewer.getSelection();
        if (selection.size() == 0) {
            this._templatesRemoveButton.setEnabled(false);
            return;
        }
        Object firstSelection = selection.getFirstElement();
        if (firstSelection != null && this._templateTable.isEnabled()) {
            this._templatesRemoveButton.setEnabled(true);
        }
    }

    private void refreshTemplatesTable() {
        if (this._templateTableViewer != null && !this._templateTableViewer.getTable().isDisposed()) {
            this._templateTableViewer.refresh();
        }
        this.refreshTemplatesButtons();
    }

    private void removeTemplate() {
        StructuredSelection selection = (StructuredSelection)this._templateTableViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this._valType.getTemplatesSelection().remove(selection.getFirstElement());
        this.refreshTemplatesTable();
    }

    private void removeRegex() {
        StructuredSelection selection = (StructuredSelection)this._regexTableViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        this._valType.getRegexList().remove(selection.getFirstElement());
        this.refreshRegexTable();
    }

    void setRegexTableVisible(boolean visible) {
        this._regexTable.setEnabled(visible);
        this._regexAddButton.setEnabled(visible);
        this._regexRemoveButton.setEnabled(visible);
    }

    void setTemplatesTableVisible(boolean visible) {
        this._templateTable.setEnabled(visible);
        this._templatesAddButton.setEnabled(visible);
        this._templatesRemoveButton.setEnabled(visible);
    }

    public class RegexCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(ValidationTypeDialog.this.columnNamesForREGEX).indexOf(property);
            String result = null;
            ValidationTypeConditionRegex vtcr = (ValidationTypeConditionRegex)element;
            switch (columnIndex) {
                case 0: {
                    result = vtcr.getRegexForPacbaseCode();
                    break;
                }
                case 1: {
                    result = vtcr.getRegexForRPPCode();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(ValidationTypeDialog.this.columnNamesForREGEX).indexOf(property);
            TableItem item = (TableItem)element;
            ValidationTypeConditionRegex oldValue = (ValidationTypeConditionRegex)item.getData();
            switch (columnIndex) {
                case 0: {
                    oldValue.setRegexForPacbaseCode((String)value);
                    ValidationTypeDialog.this._regexTableViewer.refresh();
                    break;
                }
                case 1: {
                    oldValue.setRegexForRPPCode((String)value);
                    ValidationTypeDialog.this._regexTableViewer.refresh();
                }
            }
        }
    }

    public class TemplateCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(ValidationTypeDialog.this.columnNamesForTemplates).indexOf(property);
            String result = null;
            ValidationTypeTemplateSelection vtts = (ValidationTypeTemplateSelection)element;
            switch (columnIndex) {
                case 0: {
                    result = vtts.getDeletedCode();
                    break;
                }
                case 1: {
                    result = vtts.getAddedCode();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(ValidationTypeDialog.this.columnNamesForTemplates).indexOf(property);
            TableItem item = (TableItem)element;
            ValidationTypeTemplateSelection oldValue = (ValidationTypeTemplateSelection)item.getData();
            int oldValueIndex = ValidationTypeDialog.this._valType.getTemplatesSelection().indexOf(oldValue);
            if (oldValueIndex >= 0) {
                switch (columnIndex) {
                    case 0: {
                        oldValue.setDeletedCode((String)value);
                        ValidationTypeDialog.this._templateTableViewer.refresh();
                        break;
                    }
                    case 1: {
                        oldValue.setAddedCode((String)value);
                        ValidationTypeDialog.this._templateTableViewer.refresh();
                    }
                }
            }
        }
    }
}

