/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation.preferences;

import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.pac.migration.help.MigrationControlExtension;
import com.ibm.pdp.pac.migration.help.MigrationHelp2;
import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.preferences.Messages;
import com.ibm.pdp.pac.migration.help.validation.preferences.ValidationTypeDialog;
import com.ibm.pdp.pac.migration.help.validation.preferences.ValidationTypesContentProvider;
import com.ibm.pdp.pac.migration.help.validation.preferences.ValidationTypesLabelProvider;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializer;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationSerializer;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MigrationHelpValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IPreferenceStore store = null;
    private Button _templateFileNameButton;
    private Button _importButton;
    private Button _exportButton;
    private Text _templateFileNameTextField;
    private Button _pbAddNode;
    private Button _pbRemoveNode;
    private Button _pbMoveNodeUp;
    private Button _pbMoveNodeDown;
    private Button _pbProperties;
    private TableViewer _tbvLayers = null;
    private Validation validation;

    public Validation getValidation() {
        return this.validation;
    }

    public MigrationHelpValidationPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    private Button createButton(Composite parent, String label, int style) {
        Button pbButton = PTWidgetTool.createPushButton((Composite)parent, (String)label, (int)style);
        this.addSelectionListener(pbButton);
        return pbButton;
    }

    protected Control createContents(Composite parent) {
        this.createImportExportComposite(parent);
        this.createTemplateFileComposite(parent);
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        this.createTableGroup(composite);
        Validation val = ValidationContoler.getValidation();
        this.validation = val.duplicate();
        this.updateallFields();
        MigrationHelpPlugin.setHelpMechanism(parent, "preferences_migration");
        return composite;
    }

    private Composite createImportExportComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        this._importButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationPreferencePage_Import, (boolean)true);
        this._importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String extensionXml = "*.xml";
                String[] extensions = new String[]{extensionXml};
                FileDialog dialog = new FileDialog(MigrationHelpValidationPreferencePage.this.getShell(), 36864);
                dialog.setFilterExtensions(extensions);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                FileInputStream inputStream = null;
                File file = new File(fileName);
                try {
                    try {
                        inputStream = new FileInputStream(file);
                        ValidationDeserializer vd = new ValidationDeserializer();
                        MigrationHelpValidationPreferencePage.this.validation = new Validation();
                        vd.deserialize(MigrationHelpValidationPreferencePage.this.validation, inputStream);
                        MigrationHelpValidationPreferencePage.this.updateallFields();
                    }
                    catch (FileNotFoundException fnfex) {
                        System.out.println("File " + fileName + " could not be read. Error mess : " + fnfex.getMessage());
                        try {
                            if (inputStream != null) {
                                ((InputStream)inputStream).close();
                            }
                        }
                        catch (IOException ioException) {
                            ioException.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            ((InputStream)inputStream).close();
                        }
                    }
                    catch (IOException ioException) {
                        ioException.printStackTrace();
                    }
                }
            }
        });
        this._exportButton = PTWidgetTool.createPushButton((Composite)composite, (String)Messages.ValidationPreferencePage_Export, (boolean)true);
        this._exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String extensionXml = "*.xml";
                String[] extensions = new String[]{extensionXml};
                FileDialog dialog = new FileDialog(MigrationHelpValidationPreferencePage.this.getShell(), 40960);
                dialog.setFilterExtensions(extensions);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                MigrationHelpValidationPreferencePage.this.saveValidationtoFile(fileName);
            }
        });
        return composite;
    }

    private void createTableButtons(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        GridData gridData = new GridData(1, 4, false, true);
        composite.setLayoutData((Object)gridData);
        this._pbAddNode = this.createButton(composite, Messages.ValidationPreferencePage_Add, 0x1000008);
        this._pbRemoveNode = this.createButton(composite, Messages.ValidationPreferencePage_Remove, 0x1000008);
        this._pbMoveNodeUp = this.createButton(composite, Messages.ValidationPreferencePage_Up, 8);
        this._pbMoveNodeDown = this.createButton(composite, Messages.ValidationPreferencePage_Down, 8);
        this._pbProperties = this.createButton(composite, Messages.ValidationPreferencePage_Edit, 0x1000008);
    }

    private void createTableGroup(Composite parent) {
        Composite group = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        this.createTableLayers(group);
        this.createTableButtons(group);
    }

    private void createTableLayers(Composite parent) {
        Composite tableComposite = PTWidgetTool.createComposite((Composite)parent, (int)1, (boolean)false);
        this._tbvLayers = new TableViewer(new Table(tableComposite, 66304));
        this._tbvLayers.getTable().setHeaderVisible(true);
        this._tbvLayers.setUseHashlookup(true);
        GridData data = new GridData(1808);
        data.minimumHeight = 50;
        data.minimumWidth = 50;
        data.widthHint = 300;
        data.heightHint = 300;
        this._tbvLayers.getTable().setLayoutData((Object)data);
        this._tbvLayers.setContentProvider((IContentProvider)new ValidationTypesContentProvider());
        this._tbvLayers.setLabelProvider((IBaseLabelProvider)new ValidationTypesLabelProvider());
        String[] headers = new String[]{"", Messages.ValidationPreferencePage_Name, Messages.ValidationPreferencePage_Visible, Messages.ValidationPreferencePage_Migration_Choice};
        int i = 0;
        while (i < headers.length) {
            TableColumn column = new TableColumn(this._tbvLayers.getTable(), 0);
            column.setText(headers[i]);
            if (i == 0) {
                column.setResizable(false);
            } else if (i == 1) {
                column.setResizable(true);
            } else if (i == 2) {
                column.setResizable(true);
            } else if (i == 3) {
                column.setResizable(true);
            }
            ++i;
        }
        this._tbvLayers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MigrationHelpValidationPreferencePage.this.refreshButtons();
            }
        });
        this._tbvLayers.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127) {
                    MigrationHelpValidationPreferencePage.this.removeValidationType();
                }
            }
        });
    }

    private Composite createTemplateFileComposite(Composite parent) {
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)4, (boolean)false);
        PTWidgetTool.createLabel((Composite)composite, (String)Messages.ValidationPreferencePage_Template_file);
        this._templateFileNameTextField = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        String pbLabel = Messages.ValidationPreferencePage_Browse;
        this._templateFileNameButton = PTWidgetTool.createPushButton((Composite)composite, (String)pbLabel, (boolean)true);
        this._templateFileNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String extensionXml = "*.xml";
                String[] extensions = new String[]{extensionXml};
                FileDialog dialog = new FileDialog(MigrationHelpValidationPreferencePage.this.getShell(), 36864);
                dialog.setFilterExtensions(extensions);
                String fileName = dialog.open();
                if (fileName != null) {
                    MigrationHelpValidationPreferencePage.this._templateFileNameTextField.setText(fileName);
                }
            }
        });
        String rebuildLabel = Messages.MigrationHelpValidationPreferencePage_Rebuild_template_file;
        Button rebuildFromWorkspaceButton = PTWidgetTool.createPushButton((Composite)composite, (String)rebuildLabel, (boolean)true);
        rebuildFromWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String differenceBankFileName = MigrationHelpValidationPreferencePage.this._templateFileNameTextField.getText();
                RunnableWithProgress genProcess = new RunnableWithProgress(parentShell, differenceBankFileName);
                try {
                    if (PlatformUI.isWorkbenchRunning()) {
                        try {
                            new ProgressMonitorDialog(parentShell).run(true, true, (IRunnableWithProgress)genProcess);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        genProcess.run((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (InvocationTargetException e2) {
                    Util.rethrow((Throwable)e2.getCause());
                    return;
                }
                catch (InterruptedException f) {
                    Util.rethrow((Throwable)f);
                    return;
                }
            }
        });
        return composite;
    }

    private void addSelectionListener(Button pbControl) {
        pbControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == MigrationHelpValidationPreferencePage.this._pbAddNode) {
                    MigrationHelpValidationPreferencePage.this.addValidationType();
                } else if (e.widget == MigrationHelpValidationPreferencePage.this._pbRemoveNode) {
                    MigrationHelpValidationPreferencePage.this.removeValidationType();
                } else if (e.widget == MigrationHelpValidationPreferencePage.this._pbMoveNodeUp) {
                    MigrationHelpValidationPreferencePage.this.moveUp();
                } else if (e.widget == MigrationHelpValidationPreferencePage.this._pbMoveNodeDown) {
                    MigrationHelpValidationPreferencePage.this.moveDown();
                } else if (e.widget == MigrationHelpValidationPreferencePage.this._pbProperties) {
                    MigrationHelpValidationPreferencePage.this.editValidationType();
                }
            }
        });
    }

    protected boolean addValidationType() {
        int insertionIndex = -1;
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            insertionIndex = this.validation.getValidationTypes().size();
        } else {
            Object obj = selection.getFirstElement();
            if (obj instanceof ValidationType) {
                ValidationType valType = (ValidationType)obj;
                insertionIndex = this.validation.getValidationTypes().indexOf(valType) + 1;
            }
        }
        ValidationType newValidationType = new ValidationType("", false, 0);
        ValidationTypeDialog valTypeDialog = new ValidationTypeDialog(this.getShell(), newValidationType);
        valTypeDialog.open();
        if (valTypeDialog.okPressed) {
            this.validation.getValidationTypes().add(insertionIndex, newValidationType);
            this.refreshTable();
        }
        return true;
    }

    protected boolean editValidationType() {
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof ValidationType) {
            ValidationType valType = (ValidationType)obj;
            ValidationType newValidationType = valType.duplicate();
            ValidationTypeDialog valTypeDialog = new ValidationTypeDialog(this.getShell(), newValidationType);
            valTypeDialog.open();
            if (valTypeDialog.okPressed) {
                valType.copyFrom(newValidationType);
                this.refreshTable();
            }
        }
        return true;
    }

    public void init(IWorkbench arg0) {
        this.store = MigrationHelpPlugin.getDefault().getPreferenceStore();
    }

    private boolean moveDown() {
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            return false;
        }
        Object ob = selection.getFirstElement();
        if (ob instanceof ValidationType) {
            ArrayList<ValidationType> valTypes = this.validation.getValidationTypes();
            int indexElementToMoveDown = valTypes.indexOf(ob);
            if (indexElementToMoveDown == valTypes.size() - 1) {
                return false;
            }
            ValidationType nextElement = valTypes.get(indexElementToMoveDown + 1);
            valTypes.remove(indexElementToMoveDown + 1);
            valTypes.add(indexElementToMoveDown, nextElement);
            this.refreshTable();
            return true;
        }
        return false;
    }

    private boolean moveUp() {
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            return false;
        }
        Object ob = selection.getFirstElement();
        if (ob instanceof ValidationType) {
            ArrayList<ValidationType> valTypes = this.validation.getValidationTypes();
            int indexElementToMoveUP = valTypes.indexOf(ob);
            if (indexElementToMoveUP == 0) {
                return false;
            }
            ValidationType previousElement = valTypes.get(indexElementToMoveUP - 1);
            valTypes.remove(indexElementToMoveUP - 1);
            valTypes.add(indexElementToMoveUP, previousElement);
            this.refreshTable();
            return true;
        }
        return false;
    }

    public boolean performOk() {
        this.updateValidationFromComposites();
        String message = this.checkAllRegex();
        if (message.length() != 0) {
            MessageDialog.openError(null, (String)Messages.MigrationHelpValidationPreferencePage_Validation_Type_Error, (String)message);
            return false;
        }
        if (this.validation.isEqualsTo(ValidationContoler.getValidation())) {
            return true;
        }
        String validationFolderName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + ".metadata/.plugins/com.ibm.pdp.migration.help/";
        File folder = new File(validationFolderName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        String validationFileName = String.valueOf(validationFolderName) + "validation_types.xml";
        this.saveValidationtoFile(validationFileName);
        ArrayList<ValidationType> list = this.validation.getValidationTypes();
        int i = 0;
        while (i < list.size()) {
            list.get(i).setLineNumber("" + (i + 1));
            ++i;
        }
        if (this.validation.isEqualsForRebuildMarkers(ValidationContoler.getValidation())) {
            ValidationContoler.setValidation(this.validation);
            return true;
        }
        ValidationContoler.setValidation(this.validation);
        String differenceBankFileName = MigrationControlExtension.getDiffBankFileName();
        File file = new File(differenceBankFileName);
        if (!file.exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.MigrationHelpValidationPreferencePage_Missing_template_file, (String)Messages.MigrationHelpValidationPreferencePage_Filter_is_desactivated);
            return true;
        }
        if (ValidationCache.refreshInProgress) {
            Job oldJob = ValidationCache.job;
            oldJob.cancel();
        }
        Job job = new Job(Messages.MigrationHelpValidationPreferencePage_Filter_in_progress){

            public IStatus run(IProgressMonitor monitor) {
                ValidationCache.job = this;
                ValidationCache.refreshInProgress = true;
                ValidationContoler valControler = new ValidationContoler();
                valControler.createValidationCacheFromWorkspace(monitor);
                if (ValidationCache.job == this) {
                    ValidationCache.job = null;
                    ValidationCache.refreshInProgress = false;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private String checkAllRegex() {
        return this.validation.checkAllRegex();
    }

    private void refreshButtons() {
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            this._pbRemoveNode.setEnabled(false);
            this._pbMoveNodeDown.setEnabled(false);
            this._pbMoveNodeUp.setEnabled(false);
            this._pbProperties.setEnabled(false);
            return;
        }
        Object firstSelection = selection.getFirstElement();
        if (firstSelection instanceof ValidationType && this.validation != null) {
            ArrayList<ValidationType> valTypes = this.validation.getValidationTypes();
            int indexOfFirstElement = valTypes.indexOf(firstSelection);
            if (indexOfFirstElement == 0) {
                this._pbRemoveNode.setEnabled(true);
                this._pbMoveNodeDown.setEnabled(true);
                this._pbMoveNodeUp.setEnabled(false);
                this._pbProperties.setEnabled(true);
            } else if (indexOfFirstElement == valTypes.size() - 1) {
                this._pbRemoveNode.setEnabled(true);
                this._pbMoveNodeDown.setEnabled(false);
                this._pbMoveNodeUp.setEnabled(true);
                this._pbProperties.setEnabled(true);
            } else {
                this._pbRemoveNode.setEnabled(true);
                this._pbMoveNodeDown.setEnabled(true);
                this._pbMoveNodeUp.setEnabled(true);
                this._pbProperties.setEnabled(true);
            }
        }
    }

    private void refreshTable() {
        if (this._tbvLayers != null && !this._tbvLayers.getTable().isDisposed()) {
            this._tbvLayers.refresh();
        }
        this.refreshButtons();
    }

    protected boolean removeValidationType() {
        StructuredSelection selection = (StructuredSelection)this._tbvLayers.getSelection();
        if (selection.size() == 0) {
            return false;
        }
        Iterator iterator = selection.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Object selectedItem = iterator.next();
            if (!(selectedItem instanceof ValidationType)) continue;
            removed = true;
            this.validation.getValidationTypes().remove(selectedItem);
        }
        if (removed) {
            this.refreshTable();
            return true;
        }
        return false;
    }

    private void saveValidationtoFile(String fileName) {
        this.updateValidationFromComposites();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
            ValidationSerializer x = new ValidationSerializer();
            ByteArrayOutputStream baos = x.serialize(this.validation);
            baos.writeTo(outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException fileNotFound) {
            System.out.println("File " + fileName + " could not be saved. Error mess : " + fileNotFound.getMessage());
        }
        catch (IOException io) {
            System.out.println("File " + fileName + " could not be saved. Error mess : " + io.getMessage());
        }
    }

    protected void updateallFields() {
        if (this.validation != null) {
            String diffBankFileName;
            String defaultDiffBankFileName = MigrationControlExtension.getDefaultDiffBankFileName();
            if ((defaultDiffBankFileName = defaultDiffBankFileName.replace('/', '\\')).startsWith("\\")) {
                defaultDiffBankFileName = defaultDiffBankFileName.substring(1);
            }
            if ((diffBankFileName = this.validation.getTemplatesFilesPath()) == null || diffBankFileName.trim().length() == 0) {
                diffBankFileName = defaultDiffBankFileName;
            }
            this._templateFileNameTextField.setText(diffBankFileName);
            this._tbvLayers.setInput((Object)this.validation);
            this.refreshButtons();
            TableColumn[] tableColumnArray = this._tbvLayers.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn tc = tableColumnArray[n2];
                tc.pack();
                ++n2;
            }
        }
    }

    private void updateValidationFromComposites() {
        String diffBankFileName;
        if (this.validation == null) {
            this.validation = new Validation();
        }
        String defaultDiffBankFileName = MigrationControlExtension.getDefaultDiffBankFileName();
        if ((defaultDiffBankFileName = defaultDiffBankFileName.replace('/', '\\')).startsWith("\\")) {
            defaultDiffBankFileName = defaultDiffBankFileName.substring(1);
        }
        if ((diffBankFileName = this._templateFileNameTextField.getText()).trim().length() == 0 || diffBankFileName.equals(defaultDiffBankFileName)) {
            diffBankFileName = "";
        }
        this.validation.setTemplatesFilesPath(diffBankFileName);
    }

    private static class RunnableWithProgress
    implements IRunnableWithProgress {
        private Shell _parent;
        private String diffBankFileName;

        public RunnableWithProgress(Shell parent, String differenceBankFileName) {
            this._parent = parent;
            this.diffBankFileName = differenceBankFileName;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            MigrationHelp2.rebuildDifferenceBankFromWorkspace(monitor, this.diffBankFileName);
        }
    }
}

