/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.util.diff.DifferenceNature;

public class ValidationTypeTemplateSelection {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final char QUOTE_DELIM = '\"';
    private String _hashcode;
    private String _deletedCode;
    private String _addedCode;

    public ValidationTypeTemplateSelection(String hashcode) {
        this._hashcode = hashcode;
    }

    public ValidationTypeTemplateSelection(String deletedCode, String addedCode) {
        this._deletedCode = deletedCode;
        this._addedCode = addedCode;
    }

    public ValidationTypeTemplateSelection(String deletedCode, String addedCode, String hashcode) {
        this._deletedCode = deletedCode;
        this._addedCode = addedCode;
        this._hashcode = hashcode;
    }

    public String getHashcode() {
        return this._hashcode;
    }

    public String getDeletedCode() {
        return this._deletedCode;
    }

    public String getAddedCode() {
        return this._addedCode;
    }

    public ValidationTypeTemplateSelection getCopyFrom() {
        ValidationTypeTemplateSelection result = new ValidationTypeTemplateSelection(this._hashcode);
        result._addedCode = this._addedCode;
        result._deletedCode = this._deletedCode;
        return result;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof ValidationTypeTemplateSelection)) {
            return false;
        }
        ValidationTypeTemplateSelection other = (ValidationTypeTemplateSelection)ob;
        if (other._addedCode != this._addedCode) {
            return false;
        }
        if (other._deletedCode != this._deletedCode) {
            return false;
        }
        return other._hashcode == this._hashcode;
    }

    public int hashCode() {
        String s = String.valueOf(this._addedCode) + this._deletedCode + this._hashcode;
        return s.hashCode();
    }

    public void setDeletedCode(String _deletedCode) {
        this._deletedCode = _deletedCode;
    }

    public void setAddedCode(String _addedCode) {
        this._addedCode = _addedCode;
    }

    public void setHashcode(String hashcode) {
        this._hashcode = hashcode;
    }

    public String computeHashCodeFromFields() {
        String computedHashCode = null;
        String deletedCode = this.getDeletedCode();
        deletedCode = this.removeSpacesBeetwenWords(deletedCode);
        String addedCode = this.getAddedCode();
        addedCode = this.removeSpacesBeetwenWords(addedCode);
        if (deletedCode == null) {
            deletedCode = "";
        }
        if (addedCode == null) {
            addedCode = "";
        }
        DifferenceNature nature = deletedCode.equals(addedCode) ? DifferenceNature.Identical : (deletedCode.length() == 0 ? DifferenceNature.Insertion : (addedCode.length() == 0 ? DifferenceNature.Deletion : DifferenceNature.Replacement));
        StringBuilder builder = new StringBuilder();
        builder.append(nature);
        builder.append('#');
        builder.append(deletedCode);
        builder.append('#');
        builder.append(addedCode);
        computedHashCode = "" + builder.toString().hashCode();
        return computedHashCode;
    }

    private String removeSpacesBeetwenWords(String code) {
        if (code == null) {
            return null;
        }
        int firstSpaceIndex = this.getNextSpaceIndexAfter(0, code, '\"');
        if (firstSpaceIndex == -1) {
            return this.removeQuoteDelim(code, '\"');
        }
        StringBuilder sb = new StringBuilder();
        sb.append(code.substring(0, firstSpaceIndex));
        int spaceIndex = firstSpaceIndex;
        int nextSpaceIndex = this.getNextSpaceIndexAfter(spaceIndex + 1, code, '\"');
        while (nextSpaceIndex != -1) {
            sb.append(code.substring(spaceIndex + 1, nextSpaceIndex));
            spaceIndex = nextSpaceIndex;
            nextSpaceIndex = this.getNextSpaceIndexAfter(nextSpaceIndex + 1, code, '\"');
        }
        sb.append(code.substring(spaceIndex + 1));
        return this.removeQuoteDelim(sb.toString(), '\"');
    }

    private String removeQuoteDelim(String code, char quoteDelim) {
        return code.replaceAll("" + quoteDelim, "");
    }

    private int getNextSpaceIndexAfter(int beginingIndex, String code, char quoteDelim) {
        int quoteDelimIndex = code.indexOf(quoteDelim);
        if (quoteDelimIndex == -1) {
            return code.indexOf(32, beginingIndex);
        }
        int count = 0;
        while (quoteDelimIndex != -1) {
            ++count;
            quoteDelimIndex = code.indexOf(quoteDelim, quoteDelimIndex + 1);
        }
        int[] quoteDelimIndexes = new int[count];
        quoteDelimIndexes[0] = code.indexOf(quoteDelim);
        int i = 1;
        while (i < count) {
            quoteDelimIndexes[i] = code.indexOf(quoteDelim, quoteDelimIndexes[i - 1] + 1);
            ++i;
        }
        int candidate = code.indexOf(32, beginingIndex);
        while (candidate != -1 && !this.isValidCandidate(candidate, quoteDelimIndexes)) {
            candidate = code.indexOf(32, candidate + 1);
        }
        return candidate;
    }

    private boolean isValidCandidate(int candidate, int[] quoteDelimIndexes) {
        if (quoteDelimIndexes.length == 1) {
            return true;
        }
        int first = 0;
        int second = 1;
        while (first < quoteDelimIndexes.length - 1) {
            int start = quoteDelimIndexes[first];
            int end = quoteDelimIndexes[second];
            if (candidate > start && candidate < end) {
                return false;
            }
            first += 2;
            second += 2;
        }
        return true;
    }
}

