/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import java.util.ArrayList;

public class ValidationType {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int KEEP_LOCAL_GENERATED_CODE = 0;
    public static final int KEEP_PACBASE_GENERATED_CODE = 1;
    private String name;
    private boolean isWarningVisible;
    private int migrationChoice;
    private String lineNumber;
    private ValidationTypeScope conditionScope;
    private ArrayList<ValidationTypeTemplateSelection> templatesSelection;
    private ArrayList<ValidationTypeConditionRegex> regexList;

    public String getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }

    public ValidationType(String name, boolean isWarningVisible, int migrationChoice) {
        this.name = name;
        this.isWarningVisible = isWarningVisible;
        this.migrationChoice = migrationChoice;
    }

    public void copyFrom(ValidationType val) {
        this.name = val.name;
        this.isWarningVisible = val.isWarningVisible;
        this.migrationChoice = val.migrationChoice;
        this.conditionScope = val.conditionScope;
        this.lineNumber = val.lineNumber;
        this.getTemplatesSelection().clear();
        for (ValidationTypeTemplateSelection vtts : val.getTemplatesSelection()) {
            ValidationTypeTemplateSelection newVtts = vtts.getCopyFrom();
            this.getTemplatesSelection().add(newVtts);
        }
        this.getRegexList().clear();
        for (ValidationTypeConditionRegex validationTypeConditionRegex : val.getRegexList()) {
            ValidationTypeConditionRegex newValidationRegex = new ValidationTypeConditionRegex(validationTypeConditionRegex.getRegexForPacbaseCode(), validationTypeConditionRegex.getRegexForRPPCode());
            this.getRegexList().add(newValidationRegex);
        }
    }

    public ValidationType duplicate() {
        ValidationType result = new ValidationType(this.name, this.isWarningVisible, this.migrationChoice);
        result.setLineNumber(this.getLineNumber());
        result.setConditionScope(this.getConditionScope());
        ArrayList<ValidationTypeTemplateSelection> templates = result.getTemplatesSelection();
        for (ValidationTypeTemplateSelection vtts : this.getTemplatesSelection()) {
            ValidationTypeTemplateSelection newVtts = vtts.getCopyFrom();
            templates.add(newVtts);
        }
        ArrayList<ValidationTypeConditionRegex> regexes = result.getRegexList();
        for (ValidationTypeConditionRegex validationTypeConditionRegex : this.getRegexList()) {
            ValidationTypeConditionRegex newValidationRegex = new ValidationTypeConditionRegex(validationTypeConditionRegex.getRegexForPacbaseCode(), validationTypeConditionRegex.getRegexForRPPCode());
            regexes.add(newValidationRegex);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWarningVisible() {
        return this.isWarningVisible;
    }

    public void setWarningVisible(boolean isWarningVisible) {
        this.isWarningVisible = isWarningVisible;
    }

    public int getMigrationChoice() {
        return this.migrationChoice;
    }

    public void setMigrationChoice(int migrationChoice) {
        this.migrationChoice = migrationChoice;
    }

    public ValidationTypeScope getConditionScope() {
        return this.conditionScope;
    }

    public void setConditionScope(ValidationTypeScope conditionScope) {
        this.conditionScope = conditionScope;
    }

    public ArrayList<ValidationTypeTemplateSelection> getTemplatesSelection() {
        if (this.templatesSelection == null) {
            this.templatesSelection = new ArrayList();
        }
        return this.templatesSelection;
    }

    public ArrayList<ValidationTypeConditionRegex> getRegexList() {
        if (this.regexList == null) {
            this.regexList = new ArrayList();
        }
        return this.regexList;
    }

    public boolean isEqualsTo(ValidationType other) {
        if (this.conditionScope != other.conditionScope) {
            return false;
        }
        if (this.isWarningVisible != other.isWarningVisible) {
            return false;
        }
        if (this.migrationChoice != other.getMigrationChoice()) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        ArrayList<ValidationTypeTemplateSelection> templates = this.getTemplatesSelection();
        ArrayList<ValidationTypeTemplateSelection> otherTemplates = other.getTemplatesSelection();
        if (templates.size() != otherTemplates.size()) {
            return false;
        }
        int i = 0;
        while (i < templates.size()) {
            if (!templates.get(i).equals(otherTemplates.get(i))) {
                return false;
            }
            ++i;
        }
        ArrayList<ValidationTypeConditionRegex> regexes = this.getRegexList();
        ArrayList<ValidationTypeConditionRegex> otherRegexes = other.getRegexList();
        int i2 = 0;
        while (i2 < regexes.size()) {
            if (!regexes.get(i2).isEqualTo(otherRegexes.get(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean isEqualsForRebuildMarkers(ValidationType other) {
        if (this.conditionScope != other.conditionScope) {
            return false;
        }
        if (this.isWarningVisible != other.isWarningVisible) {
            return false;
        }
        ArrayList<ValidationTypeTemplateSelection> templates = this.getTemplatesSelection();
        ArrayList<ValidationTypeTemplateSelection> otherTemplates = other.getTemplatesSelection();
        if (templates.size() != otherTemplates.size()) {
            return false;
        }
        int i = 0;
        while (i < templates.size()) {
            if (!templates.get(i).equals(otherTemplates.get(i))) {
                return false;
            }
            ++i;
        }
        ArrayList<ValidationTypeConditionRegex> regexes = this.getRegexList();
        ArrayList<ValidationTypeConditionRegex> otherRegexes = other.getRegexList();
        int i2 = 0;
        while (i2 < regexes.size()) {
            if (!regexes.get(i2).isEqualTo(otherRegexes.get(i2))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean equals(Object otherOb) {
        if (!(otherOb instanceof ValidationType)) {
            return false;
        }
        ValidationType other = (ValidationType)otherOb;
        if (other.conditionScope != this.conditionScope) {
            return false;
        }
        if (other.isWarningVisible != this.isWarningVisible) {
            return false;
        }
        if (other.migrationChoice != this.migrationChoice) {
            return false;
        }
        if (!other.name.equals(this.name)) {
            return false;
        }
        if (other.regexList == null && this.regexList != null && this.regexList.size() != 0) {
            return false;
        }
        if (other.regexList != null && !other.regexList.equals(this.regexList)) {
            return false;
        }
        if (other.templatesSelection == null && this.templatesSelection != null && this.templatesSelection.size() != 0) {
            return false;
        }
        return other.templatesSelection == null || other.templatesSelection.equals(this.templatesSelection);
    }

    public boolean containsSelectedTemplate(String templateHashCode) {
        for (ValidationTypeTemplateSelection vtts : this.getTemplatesSelection()) {
            String storedHashCode;
            String computedHashCode;
            if (!(vtts.getAddedCode() != null && vtts.getAddedCode().trim().length() != 0 || vtts.getDeletedCode() != null && vtts.getDeletedCode().trim().length() != 0 ? templateHashCode.equals(computedHashCode = vtts.computeHashCodeFromFields()) : templateHashCode.equals(storedHashCode = vtts.getHashcode()))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

