/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.cobolcompare.serialization.DifferenceBankDeserializer;
import com.ibm.pdp.cobolcompare.tools.model.Report;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializer;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationSerializer;
import com.ibm.pdp.util.containers.HashedMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ValidationPatternImport {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.print("ValidationPatternImport PatternPathName(pattern.txt) DifferenceBankFullPathName(DifferenceBank.xml) ValidationOutputFileName (validation.xml)");
            System.exit(-1);
        }
        ValidationPatternImport vpi = new ValidationPatternImport();
        String diffBankFileName = args[1];
        Validation val = vpi.importPattern(args[0], diffBankFileName);
        vpi.writeXML(val, args[2]);
    }

    public void writeXML(Validation val, String xmlFileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(xmlFileName);
            ValidationSerializer x = new ValidationSerializer();
            ByteArrayOutputStream baos = x.serialize(val);
            baos.writeTo(outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + xmlFileName + " could not be saved. Error mess : " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("File " + xmlFileName + " could not be saved. Error mess : " + e.getMessage());
        }
        Validation val2 = new Validation();
        FileInputStream inputStream = null;
        File file = new File(xmlFileName);
        try {
            try {
                inputStream = new FileInputStream(file);
                ValidationDeserializer valDeser = new ValidationDeserializer();
                valDeser.deserialize(val2, inputStream);
            }
            catch (FileNotFoundException e) {
                System.out.println("File D:/validation.xml could not be read. Error mess : " + e.getMessage());
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Validation importPattern(String patternFileName, String diffBankFileName) {
        HashedMap<String, WordDifference> templateMap = this.getTemplateMap(diffBankFileName);
        Validation val = new Validation();
        ArrayList<ValidationType> result = val.getValidationTypes();
        String content = ValidationPatternImport.readFileContentsQuickly(patternFileName);
        StringTokenizer tokenizer = new StringTokenizer(content, "\n\r", false);
        HashMap<String, ValidationType> validationTypesMap = new HashMap<String, ValidationType>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
            int end = line.indexOf("#");
            String patternName = line.substring(0, end);
            int start = end;
            end = line.indexOf("#", start + 1);
            String deleted = Report.decodeRegex((String)line.substring(start + 1, end));
            start = end + 1;
            end = line.indexOf("#", start);
            String added = null;
            added = end > 0 ? Report.decodeRegex((String)line.substring(start, end)) : Report.decodeRegex((String)line.substring(start));
            String groupPatternName = "";
            if (end > 0) {
                start = end + 1;
                if ((end = line.indexOf("#", start)) > 0) {
                    groupPatternName = line.substring(start, end);
                    start = end + 1;
                } else {
                    groupPatternName = line.substring(start);
                }
            }
            if (!(groupPatternName = groupPatternName.trim()).equals("WONTDO") && !groupPatternName.equals("BUGPAC")) continue;
            ValidationType vt = (ValidationType)validationTypesMap.get(patternName);
            if (vt == null) {
                boolean isDiffPattern;
                boolean hasValidationParam;
                int start2;
                vt = new ValidationType(patternName, false, 0);
                result.add(vt);
                validationTypesMap.put(patternName, vt);
                if (deleted.indexOf("hC(") >= 0 && (start2 = deleted.indexOf("hC(")) >= 0) {
                    int end2 = deleted.indexOf(")");
                    if (end2 > 0) {
                        String hashCodes = deleted.substring(start2 + 3, end2);
                        StringTokenizer tokenizer2 = new StringTokenizer(hashCodes.toString(), ",");
                        while (tokenizer2.hasMoreTokens()) {
                            String hashCode = tokenizer2.nextToken().trim();
                            ValidationTypeTemplateSelection templateSelection = new ValidationTypeTemplateSelection(hashCode);
                            this.modifyTemplateSelection(templateSelection, templateMap);
                            vt.getTemplatesSelection().add(templateSelection);
                        }
                    }
                    vt.setConditionScope(ValidationTypeScope.SELECTED_TEMPLATES);
                    continue;
                }
                boolean bl = hasValidationParam = patternName.indexOf("(VALIDATION") >= 0;
                if (hasValidationParam) {
                    StringTokenizer stringTokenizer;
                    int idx = patternName.indexOf("(VALIDATION");
                    String valString = patternName.substring(idx + "(VALIDATION".length());
                    if ((idx = valString.indexOf(41)) > 0 && (stringTokenizer = new StringTokenizer(valString = valString.substring(0, idx).trim(), ":")).countTokens() == 2) {
                        String visibility = stringTokenizer.nextToken();
                        String choice = stringTokenizer.nextToken();
                        vt.setWarningVisible("true".equals(visibility));
                        if ("pac".equals(choice)) {
                            vt.setMigrationChoice(1);
                        } else {
                            vt.setMigrationChoice(0);
                        }
                    }
                }
                boolean bl2 = isDiffPattern = patternName.indexOf("(DIFF)") >= 0;
                if (isDiffPattern) {
                    if (patternName.indexOf("(TMPLHC") > 0) {
                        int idx = patternName.indexOf("(TMPLHC");
                        String hCs = patternName.substring(idx + "(TMPLHC".length());
                        if ((idx = hCs.indexOf(41)) > 0) {
                            hCs = hCs.substring(0, idx);
                            StringTokenizer stringTokenizer = new StringTokenizer(hCs, ",");
                            while (stringTokenizer.hasMoreTokens()) {
                                String hashCode = stringTokenizer.nextToken().trim();
                                ValidationTypeTemplateSelection templateSelection = new ValidationTypeTemplateSelection(hashCode);
                                this.modifyTemplateSelection(templateSelection, templateMap);
                                vt.getTemplatesSelection().add(templateSelection);
                            }
                        }
                        vt.setConditionScope(ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX);
                    } else {
                        vt.setConditionScope(ValidationTypeScope.ALL_DIFF_WITH_REGEX);
                    }
                } else {
                    vt.setConditionScope(ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX);
                }
            }
            String[] detetedPatterns = null;
            String[] addedPatterns = null;
            if (deleted.indexOf("%") > 0) {
                StringTokenizer tokenizer2 = new StringTokenizer(deleted, "%");
                int nbTokens = tokenizer2.countTokens();
                detetedPatterns = new String[nbTokens];
                int i = 0;
                while (i < nbTokens) {
                    detetedPatterns[i] = tokenizer2.nextToken();
                    ++i;
                }
                tokenizer2 = new StringTokenizer(added, "%");
                nbTokens = tokenizer2.countTokens();
                addedPatterns = new String[nbTokens];
                i = 0;
                while (i < nbTokens) {
                    addedPatterns[i] = tokenizer2.nextToken();
                    ++i;
                }
            } else {
                detetedPatterns = new String[]{deleted};
                addedPatterns = new String[]{added};
            }
            int i = 0;
            while (i < detetedPatterns.length) {
                if (detetedPatterns[i] != null) {
                    ValidationTypeConditionRegex vtcr = new ValidationTypeConditionRegex(detetedPatterns[i], addedPatterns[i].contains("deleted") ? detetedPatterns[i] : addedPatterns[i]);
                    vt.getRegexList().add(vtcr);
                }
                ++i;
            }
        }
        this.modifyLabels(val);
        return val;
    }

    private void modifyLabels(Validation val) {
        for (ValidationType validationType : val.getValidationTypes()) {
            int endValIndex;
            int valIndex;
            int endTmplhcIndex;
            int tmplhcIndex;
            String patternName = validationType.getName();
            int diffIndex = patternName.indexOf("(DIFF)");
            if (diffIndex != -1) {
                patternName = String.valueOf(patternName.substring(0, diffIndex)) + patternName.substring(diffIndex + "(DIFF)".length());
            }
            if ((tmplhcIndex = patternName.indexOf("(TMPLHC")) != -1 && (endTmplhcIndex = patternName.indexOf(")", tmplhcIndex)) != -1) {
                patternName = String.valueOf(patternName.substring(0, tmplhcIndex)) + patternName.substring(endTmplhcIndex + 1);
            }
            if ((valIndex = patternName.indexOf("(VALIDATION")) != -1 && (endValIndex = patternName.indexOf(")", valIndex)) != -1) {
                patternName = String.valueOf(patternName.substring(0, valIndex)) + patternName.substring(endValIndex + 1);
            }
            validationType.setName(patternName.trim());
        }
    }

    private void modifyTemplateSelection(ValidationTypeTemplateSelection templateSelection, HashedMap<String, WordDifference> map) {
        if (map == null) {
            this.modifyTemplateIdentifiedSelection(templateSelection);
            return;
        }
        String hash = templateSelection.getHashcode();
        WordDifference wd = (WordDifference)map.get((Object)hash);
        if (wd == null) {
            System.out.println("Template not found for hashcode " + hash);
            this.modifyTemplateIdentifiedSelection(templateSelection);
            return;
        }
        String hash2 = "" + wd.getHashCode();
        System.out.println("hash2:" + hash2);
        StringBuilder added = new StringBuilder();
        Word[] addedWords = wd.addedWords();
        int i = 0;
        while (i < addedWords.length) {
            Word w = addedWords[i];
            if (w.quoted()) {
                added.append('\"');
                added.append(w);
                added.append('\"');
            } else {
                added.append(w);
            }
            if (i < addedWords.length - 1) {
                added.append(' ');
            }
            ++i;
        }
        StringBuilder deleted = new StringBuilder();
        Word[] deletedWords = wd.deletedWords();
        int i2 = 0;
        while (i2 < deletedWords.length) {
            Word w = deletedWords[i2];
            if (w.quoted()) {
                deleted.append('\"');
                deleted.append(w);
                deleted.append('\"');
            } else {
                deleted.append(w);
            }
            if (i2 < deletedWords.length - 1) {
                deleted.append(' ');
            }
            ++i2;
        }
        String allAddedWords = added.toString();
        String allDeletedWords = deleted.toString();
        templateSelection.setAddedCode(allAddedWords);
        templateSelection.setDeletedCode(allDeletedWords);
        this.compareHashcodes(templateSelection);
        if (allDeletedWords != null && allDeletedWords.trim().length() != 0 || allAddedWords != null && allAddedWords.trim().length() != 0) {
            templateSelection.setHashcode(null);
        }
    }

    private void modifyTemplateIdentifiedSelection(ValidationTypeTemplateSelection templateSelection) {
        if ("1543437023".equals(templateSelection.getHashcode())) {
            templateSelection.setAddedCode(".");
            templateSelection.setHashcode(null);
        }
    }

    private void compareHashcodes(ValidationTypeTemplateSelection templateSelection) {
        if (templateSelection == null) {
            return;
        }
        String storedHascode = templateSelection.getHashcode();
        String computedHashCode = templateSelection.computeHashCodeFromFields();
        if (!computedHashCode.equals(storedHascode)) {
            System.out.println("Different hashCodes : Stored:" + storedHascode + "  Computed:" + computedHashCode + " Deleted:" + templateSelection.getDeletedCode() + " inserted:" + templateSelection.getAddedCode());
        } else {
            System.out.println("Same Hashcode for Deleted:" + templateSelection.getDeletedCode() + " inserted:" + templateSelection.getAddedCode());
        }
    }

    public HashedMap<String, WordDifference> getTemplateMap(String diffBankFileName) {
        if (diffBankFileName == null) {
            return null;
        }
        DifferenceBank db = null;
        File file = new File(diffBankFileName);
        if (file.exists()) {
            DifferenceBankDeserializer difBankDeserializer = new DifferenceBankDeserializer();
            try {
                db = difBankDeserializer.deserialize((InputStream)new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (db == null) {
            return null;
        }
        WordDifference[] differences = new WordDifference[db.size()];
        db.copyDifferencesTo(differences, false);
        HashedMap result = new HashedMap();
        WordDifference[] wordDifferenceArray = differences;
        int n = differences.length;
        int n2 = 0;
        while (n2 < n) {
            WordDifference diff = wordDifferenceArray[n2];
            result.put((Object)("" + diff.getHashCode()), (Object)diff);
            ++n2;
        }
        return result;
    }

    private static String readFileContentsQuickly(String fileName) {
        try {
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            long length = raf.length();
            if (length > Integer.MAX_VALUE) {
                throw new RuntimeException("File too big: " + fileName);
            }
            byte[] buffer = new byte[(int)length];
            raf.readFully(buffer);
            raf.close();
            return new String(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

