/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.cobolcompare.tools.model.Report;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeTemplateSelection;
import com.ibm.pdp.pac.migration.help.validation.serialization.IValidationTag;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializer;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class ValidationPatternExport
implements IValidationTag {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EOL = "\n";

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.print("ValidationPatternImport PatternPathName(pattern.txt) ValidationInputFileName (validation.xml)");
            System.exit(-1);
        }
        ValidationPatternExport vpe = new ValidationPatternExport();
        try {
            vpe.exportPattern(args[0], args[1]);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Validation loadValidation(String validationFileName) {
        Validation validation = new Validation();
        FileInputStream inputStream = null;
        File file = new File(validationFileName);
        if (!file.exists()) {
            return null;
        }
        try {
            try {
                inputStream = new FileInputStream(file);
                ValidationDeserializer valDeser = new ValidationDeserializer();
                valDeser.deserialize(validation, inputStream);
            }
            catch (FileNotFoundException e) {
                System.out.println("File D:/validation.xml could not be read. Error mess : " + e.getMessage());
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    return null;
                }
                return null;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return validation;
    }

    public void exportPattern(String patternFileName, String validationFileName) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(patternFileName);
        this.serialize(ValidationPatternExport.loadValidation(validationFileName), printWriter);
        printWriter.flush();
        printWriter.close();
    }

    public void serialize(Validation val, PrintWriter printWriter) {
        try {
            ArrayList<ValidationType> vals = val.getValidationTypes();
            if (vals != null) {
                for (ValidationType valType : vals) {
                    this.serialize(printWriter, valType);
                }
            }
            printWriter.write(EOL);
        }
        catch (XMLStreamException e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void serialize(PrintWriter printWriter, ValidationType valType) throws XMLStreamException {
        printWriter.write(valType.getName());
        printWriter.write(" (VALIDATION " + valType.isWarningVisible());
        printWriter.write(":" + (valType.getMigrationChoice() == 0 ? "rpp" : "pac"));
        printWriter.write(")");
        if (valType.getConditionScope() == ValidationTypeScope.ALL_DIFF_WITH_REGEX || valType.getConditionScope() == ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX) {
            printWriter.write("(DIFF)");
        }
        ArrayList<ValidationTypeConditionRegex> regexes = valType.getRegexList();
        ArrayList<ValidationTypeTemplateSelection> templates = valType.getTemplatesSelection();
        if (templates != null) {
            ArrayList<String> hc = new ArrayList<String>();
            ArrayList<String> added = new ArrayList<String>();
            ArrayList<String> deleted = new ArrayList<String>();
            for (ValidationTypeTemplateSelection templateSelection : templates) {
                if (templateSelection.getHashcode() != null) {
                    hc.add(templateSelection.getHashcode());
                }
                if (templateSelection.getAddedCode() != null) {
                    added.add(templateSelection.getAddedCode());
                }
                if (templateSelection.getDeletedCode() == null) continue;
                deleted.add(templateSelection.getDeletedCode());
            }
        }
        if (regexes != null && !regexes.isEmpty()) {
            printWriter.write("#");
            boolean isFirst = true;
            for (ValidationTypeConditionRegex regex : regexes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    printWriter.write("%");
                }
                if (regex.getRegexForPacbaseCode().length() != 0) {
                    printWriter.write(Report.encodeRegex((String)regex.getRegexForPacbaseCode()));
                    continue;
                }
                printWriter.write("^$");
            }
            isFirst = true;
            printWriter.write("#");
            for (ValidationTypeConditionRegex regex : regexes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    printWriter.write("%");
                }
                if (regex.getRegexForRPPCode().length() != 0) {
                    printWriter.write(Report.encodeRegex((String)regex.getRegexForRPPCode()));
                    continue;
                }
                printWriter.write("^$");
            }
        }
        printWriter.write("#WONTDO");
        printWriter.write(EOL);
    }

    private void transformToCommaSeparatedList(PrintWriter printWriter, List<String> list, String sep, boolean quote) {
        boolean isFirst = true;
        for (String item : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                printWriter.write(sep);
            }
            if (quote) {
                printWriter.write("'" + item + "'");
                continue;
            }
            printWriter.write(item);
        }
    }
}

