/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.cobolcompare.tools.model.Report;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.EditorLink;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pac.migration.help.MigrationControlExtension;
import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.DifferenceBankException;
import com.ibm.pdp.pac.migration.help.validation.Messages;
import com.ibm.pdp.pac.migration.help.validation.MigrationHelpValidationTool;
import com.ibm.pdp.pac.migration.help.validation.RppFormatter;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifference;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifferences;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeScope;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationDeserializer;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationSerializer;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.migration.modeltrans.ModelTransformation2;
import com.ibm.pdp.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

public class ValidationContoler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static Validation validation;
    public static final String VALIDATION_FOLDER = ".metadata/.plugins/com.ibm.pdp.migration.help/";
    public static final String VALIDATION_FILE_NAME = "validation_types.xml";
    private static final String LOG_FILE = ".pacvalidation.log";
    private static final String FOLDER_LOG_FILE = "/.metadata/";
    public static final String PLUGIN_ID = "com.ibm.pdp.pac.migration.help";
    private static Logger _logger;
    public static String reportFilePath;

    static {
        _logger = null;
        reportFilePath = null;
    }

    public static Validation getValidation() {
        if (validation == null) {
            ValidationContoler.loadValidation();
        }
        if (validation == null) {
            validation = new Validation();
        }
        return validation;
    }

    public static void setValidation(Validation _validation) {
        validation = _validation;
    }

    public static void loadValidation() {
        validation = new Validation();
        String validationFileName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + VALIDATION_FOLDER + VALIDATION_FILE_NAME;
        ValidationContoler.loadValidation(validationFileName);
    }

    public static void loadValidation(String validationFileName) {
        validation = new Validation();
        FileInputStream inputStream = null;
        File file = new File(validationFileName);
        if (!file.exists()) {
            return;
        }
        try {
            try {
                inputStream = new FileInputStream(file);
                ValidationDeserializer valDeser = new ValidationDeserializer();
                valDeser.deserialize(validation, inputStream);
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + validationFileName + " could not be read. Error mess : " + e.getMessage());
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveValidationOnDisk() {
        if (validation == null) {
            return;
        }
        String validationFolderName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + VALIDATION_FOLDER;
        File folder = new File(validationFolderName);
        if (!folder.exists()) {
            folder.mkdir();
        }
        Validation val = ValidationContoler.getValidation();
        FileOutputStream outputStream = null;
        String xmlFileName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + VALIDATION_FOLDER + VALIDATION_FILE_NAME;
        try {
            outputStream = new FileOutputStream(xmlFileName);
            ValidationSerializer x = new ValidationSerializer();
            ByteArrayOutputStream baos = x.serialize(val);
            baos.writeTo(outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + xmlFileName + " could not be saved. Error mess : " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("File " + xmlFileName + " could not be saved. Error mess : " + e.getMessage());
        }
    }

    public void createValidationCacheFromWorkspace(IProgressMonitor monitor) {
        ValidationCache vc = ValidationCache.getCache();
        vc.setState(3);
        vc.getPdpFilesToValidate().clear();
        vc.getValidatedPDPFiles().clear();
        vc.initializeTemplates();
        if (monitor != null) {
            monitor.setTaskName(Messages.ValidationContoler_TASK_FINDING_PDP);
        }
        List pdpFiles = PdpTool.findAllPDPFiles((IProgressMonitor)monitor);
        if (monitor != null && monitor.isCanceled()) {
            vc.setState(2);
            return;
        }
        int size = pdpFiles.size();
        if (monitor != null) {
            monitor.beginTask("", size);
            monitor.setTaskName(Messages.ValidationContoler_TASK_FILTERING_WARNING);
        }
        int i = 0;
        int step = size / 100;
        if (step == 0) {
            step = size / 10;
        }
        if (step == 0) {
            step = 2;
        }
        for (IFile iFile : pdpFiles) {
            String pdpFileLocatioon = iFile.getFullPath().toString();
            ValidationContoler.updateMarkersAndCache(pdpFileLocatioon);
            if (monitor != null && ++i % step == 0) {
                monitor.worked(step);
            }
            if (!monitor.isCanceled()) continue;
            vc.setState(2);
            return;
        }
        vc.setState(1);
    }

    public static synchronized void updateMarkersAndCache(String pdpFileLocation) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pdpFileLocation));
        if (!file.exists()) {
            return;
        }
        ValidationCache vc = ValidationCache.getCache();
        String sourceFileLocation = PdpTool.computeSourceFileLocationFromPdpFileLocation((String)pdpFileLocation);
        IController controler = ControllerFactory.getInstance().getController(sourceFileLocation);
        MigrationWarnings mws = ((Controller)controler).getMigrationWarnings();
        if (mws == null) {
            vc.getValidatedPDPFiles().add((Object)pdpFileLocation);
            if (vc.getPdpFilesToValidate().get(pdpFileLocation) != null) {
                if (vc.getState() != 3) {
                    vc.setState(0);
                }
                IFile file1 = PdpTool.getFile((String)sourceFileLocation);
                try {
                    file1.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
                }
                catch (CoreException coreException) {
                    return;
                }
                vc.getPdpFilesToValidate().remove(pdpFileLocation);
                if (vc.getState() != 3) {
                    vc.setState(1);
                }
            }
        } else {
            if (vc.getState() != 3) {
                vc.setState(0);
            }
            SourceCodeMigrationDifferences sourceDifferences = new SourceCodeMigrationDifferences((Controller)controler);
            ValidationContoler.applyMigrationType(sourceDifferences, vc, sourceFileLocation, pdpFileLocation, controler.getDesignLink().getFileId(), false);
            if (vc.getState() != 3) {
                vc.setState(1);
            }
        }
        ControllerFactory.getInstance().dispose(controler);
    }

    public static CacheData applyMigrationType(SourceCodeMigrationDifferences sourceCodeDifferences, ValidationCache vc, String sourceFileLocation, String pdpFileLocation, String designID, boolean automaticValidationContext) {
        SourceCodeMigrationDifference[] warnings = sourceCodeDifferences.getSourceCodeDifferences();
        if (warnings == null || warnings.length == 0) {
            return null;
        }
        ArrayList<SourceCodeMigrationDifference> currentsdifferences = new ArrayList<SourceCodeMigrationDifference>();
        SourceCodeMigrationDifference[] sourceCodeMigrationDifferenceArray = warnings;
        int n = warnings.length;
        int n2 = 0;
        while (n2 < n) {
            SourceCodeMigrationDifference sourceCodeMigrationDifference = sourceCodeMigrationDifferenceArray[n2];
            currentsdifferences.add(sourceCodeMigrationDifference);
            ++n2;
        }
        ArrayList<Integer> metaTemplatesIndexes = ValidationContoler.applyMigrationTypeFilter(currentsdifferences);
        int differencesNumber = warnings.length;
        int filteredDifferencesNumber = currentsdifferences.size();
        int[] filteredValidationTypes = new int[metaTemplatesIndexes.size()];
        int i = 0;
        while (i < metaTemplatesIndexes.size()) {
            filteredValidationTypes[i] = metaTemplatesIndexes.get(i);
            ++i;
        }
        CacheData cd = new CacheData();
        cd.setDesignName(designID);
        cd.setFilteredMigrationWarningNumber(filteredDifferencesNumber);
        cd.setFilteredValidationTypes(filteredValidationTypes);
        cd.setGeneratedProductFullName(sourceFileLocation);
        cd.setMigrationWarningNumber(differencesNumber);
        CacheData previousCacheData = vc.getPdpFilesToValidate().get(pdpFileLocation);
        if (previousCacheData == null) {
            vc.getPdpFilesToValidate().put(pdpFileLocation, cd);
        } else if (!cd.equals(previousCacheData)) {
            vc.getPdpFilesToValidate().remove(pdpFileLocation);
            vc.getPdpFilesToValidate().put(pdpFileLocation, cd);
        }
        if (automaticValidationContext && cd.getFilteredMigrationWarningNumber() == 0) {
            return cd;
        }
        if (warnings.length <= 500) {
            ValidationContoler.createMigrationMarkersFromController(sourceCodeDifferences.getController(), warnings);
        } else {
            try {
                IFile resource = PdpTool.getFile((String)sourceCodeDifferences.getController().getResourceName());
                try {
                    resource.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
                }
                catch (CoreException e1) {
                    Util.rethrow((Throwable)e1);
                }
                IMarker marker = resource.createMarker("com.ibm.pdp.pac.migration.marker");
                if (marker.exists()) {
                    Object[] markersValue = new Object[]{NLS.bind((String)Messages.ValidationContoler_TooManyDifferences, (Object[])new String[]{String.valueOf(warnings.length)}), 1, 1, 1, 0, 0, 0, 0, 0, 0, ""};
                    marker.setAttributes(MigrationHelpTool.markersAttrs, markersValue);
                }
            }
            catch (CoreException e) {
                Util.rethrow((Throwable)e);
            }
        }
        return cd;
    }

    public static ArrayList<Integer> applyMigrationTypeFilter(SourceCodeMigrationDifferences sourceCodeDifferences) {
        SourceCodeMigrationDifference[] warnings = sourceCodeDifferences.getSourceCodeDifferences();
        if (warnings == null || warnings.length == 0) {
            return null;
        }
        ArrayList<SourceCodeMigrationDifference> currentsdifferences = new ArrayList<SourceCodeMigrationDifference>();
        SourceCodeMigrationDifference[] sourceCodeMigrationDifferenceArray = warnings;
        int n = warnings.length;
        int n2 = 0;
        while (n2 < n) {
            SourceCodeMigrationDifference sourceCodeMigrationDifference = sourceCodeMigrationDifferenceArray[n2];
            currentsdifferences.add(sourceCodeMigrationDifference);
            ++n2;
        }
        return ValidationContoler.applyMigrationTypeFilter(currentsdifferences);
    }

    private static ArrayList<Integer> applyMigrationTypeFilter(ArrayList<SourceCodeMigrationDifference> currentsdifferences) {
        boolean differenceBankValid = ValidationCache.getCache().checkDifferenceBank();
        if (!differenceBankValid) {
            ValidationCache.getCache().initializeTemplates();
        }
        ArrayList<Integer> metaTemplatesIndexes = new ArrayList<Integer>();
        ArrayList<ValidationType> metaTemplates = ValidationContoler.getValidation().getValidationTypes();
        int i = 0;
        while (i < metaTemplates.size()) {
            if (currentsdifferences.size() == 0) {
                return metaTemplatesIndexes;
            }
            boolean metaTemplateIndexAdded = false;
            ValidationType validationType = metaTemplates.get(i);
            ValidationTypeScope scope = validationType.getConditionScope();
            if (scope.equals((Object)ValidationTypeScope.SELECTED_TEMPLATES)) {
                for (SourceCodeMigrationDifference sourceCodeMigrationDifference : new ArrayList<SourceCodeMigrationDifference>(currentsdifferences)) {
                    if (!validationType.containsSelectedTemplate(sourceCodeMigrationDifference.getMigrationWarningIndexes().patternHashCode)) continue;
                    metaTemplateIndexAdded = ValidationContoler.updateSourceCodeMigrationDifference(currentsdifferences, metaTemplatesIndexes, i, metaTemplateIndexAdded, validationType, sourceCodeMigrationDifference);
                }
            } else if (scope.equals((Object)ValidationTypeScope.All_DIFF_ON_SELECTED_TEMPLATES_WITH_REGEX)) {
                ArrayList<SourceCodeMigrationDifference> differenceOnSelectedTemplates = new ArrayList<SourceCodeMigrationDifference>();
                for (SourceCodeMigrationDifference sourceCodeMigrationDifference : currentsdifferences) {
                    if (!validationType.containsSelectedTemplate(sourceCodeMigrationDifference.getMigrationWarningIndexes().patternHashCode)) continue;
                    differenceOnSelectedTemplates.add(sourceCodeMigrationDifference);
                }
                if (differenceOnSelectedTemplates.size() != 0) {
                    for (SourceCodeMigrationDifference sourceCodeMigrationDifference : differenceOnSelectedTemplates) {
                        boolean found = ValidationContoler.searchRegexForSelectedDifference(sourceCodeMigrationDifference, validationType);
                        if (!found) continue;
                        metaTemplateIndexAdded = ValidationContoler.updateSourceCodeMigrationDifference(currentsdifferences, metaTemplatesIndexes, i, metaTemplateIndexAdded, validationType, sourceCodeMigrationDifference);
                    }
                }
            } else if (scope.equals((Object)ValidationTypeScope.ALL_DIFF_WITH_REGEX)) {
                for (SourceCodeMigrationDifference sourceCodeMigrationDifference : new ArrayList<SourceCodeMigrationDifference>(currentsdifferences)) {
                    boolean found = ValidationContoler.searchRegexForSelectedDifference(sourceCodeMigrationDifference, validationType);
                    if (!found) continue;
                    metaTemplateIndexAdded = ValidationContoler.updateSourceCodeMigrationDifference(currentsdifferences, metaTemplatesIndexes, i, metaTemplateIndexAdded, validationType, sourceCodeMigrationDifference);
                }
            } else if (scope.equals((Object)ValidationTypeScope.ALL_TEMPLATES_WITH_REGEX)) {
                ArrayList<WordDifference> allUsedTemplates = new ArrayList<WordDifference>();
                for (SourceCodeMigrationDifference sourceCodeMigrationDifference : currentsdifferences) {
                    String templateID = sourceCodeMigrationDifference.getMigrationWarningIndexes().patternHashCode;
                    WordDifference template = (WordDifference)ValidationCache.getCache().getTemplates().get((Object)templateID);
                    if (template == null && (MigrationControlExtension.getDiffBank() == null || MigrationControlExtension.getDiffBank().size() == 0)) {
                        throw new DifferenceBankException(Messages.ValidationContoler_Template_file_empty);
                    }
                    if (ValidationCache.getCache().getTemplates().size() != 0 && template == null) {
                        throw new DifferenceBankException(Messages.ValidationContoler_Template_file_not_complete);
                    }
                    if (allUsedTemplates.contains(template)) continue;
                    allUsedTemplates.add(template);
                }
                ArrayList<String> filteredTemplateHash = new ArrayList<String>();
                for (WordDifference template : allUsedTemplates) {
                    if (!ValidationContoler.searchRegexForSelectedTemplate(template, validationType)) continue;
                    filteredTemplateHash.add("" + template.getHashCode());
                }
                if (filteredTemplateHash.size() != 0) {
                    for (SourceCodeMigrationDifference sourceCodeMigrationDifference : new ArrayList<SourceCodeMigrationDifference>(currentsdifferences)) {
                        if (!filteredTemplateHash.contains(sourceCodeMigrationDifference.getMigrationWarningIndexes().patternHashCode)) continue;
                        metaTemplateIndexAdded = ValidationContoler.updateSourceCodeMigrationDifference(currentsdifferences, metaTemplatesIndexes, i, metaTemplateIndexAdded, validationType, sourceCodeMigrationDifference);
                    }
                }
            }
            ++i;
        }
        return metaTemplatesIndexes;
    }

    private static boolean updateSourceCodeMigrationDifference(ArrayList<SourceCodeMigrationDifference> currentsdifferences, ArrayList<Integer> metaTemplatesIndexes, int metaTemplateCurrentIndex, boolean metaTemplateIndexAdded, ValidationType validationType, SourceCodeMigrationDifference sourceCodeMigrationDifference) {
        boolean result = metaTemplateIndexAdded;
        sourceCodeMigrationDifference.setVisible(validationType.isWarningVisible());
        sourceCodeMigrationDifference.setFilteredMetaTemplateID(metaTemplateCurrentIndex);
        if (!metaTemplateIndexAdded) {
            metaTemplatesIndexes.add(metaTemplateCurrentIndex);
            result = true;
        }
        currentsdifferences.remove(sourceCodeMigrationDifference);
        return result;
    }

    private static boolean searchRegexForSelectedDifference(SourceCodeMigrationDifference sourceCodeMigrationDifference, ValidationType validationType) {
        String pacbaseCode = sourceCodeMigrationDifference.getCodeFromPacbase();
        String rppCode = ValidationContoler.modifyRightColumn(sourceCodeMigrationDifference.getLocalCode());
        boolean cropEndOfLine = PacTool.markAtEndOfLine();
        if (cropEndOfLine) {
            pacbaseCode = ValidationContoler.modifyRightColumn(pacbaseCode);
            rppCode = ValidationContoler.modifyRightColumn(rppCode);
        }
        if (rppCode != null && rppCode.indexOf("id=") > 0) {
            rppCode = rppCode.replaceAll(" id=[0-9]*", "");
        }
        ArrayList<ValidationTypeConditionRegex> regexes = validationType.getRegexList();
        for (ValidationTypeConditionRegex regex : regexes) {
            boolean mach;
            String pacbaseRegex = regex.getRegexForPacbaseCode();
            String rppRegex = regex.getRegexForRPPCode();
            if (pacbaseRegex.length() == 0) {
                pacbaseRegex = "^$";
            }
            if (rppRegex.length() == 0) {
                pacbaseRegex = "^$";
            }
            Pattern pacPattern = null;
            Pattern rppPattern = null;
            try {
                pacPattern = Pattern.compile(pacbaseRegex);
                rppPattern = Pattern.compile(rppRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
            if (rppPattern == null || !(mach = Report.findPatterns((String)ValidationContoler.stripCode(pacbaseCode), (String)ValidationContoler.stripCode(rppCode), (Pattern)pacPattern, (Pattern)rppPattern, (String)pacbaseRegex, (String)rppRegex, (boolean)false))) continue;
            return true;
        }
        return false;
    }

    private static boolean searchRegexForSelectedTemplate(WordDifference template, ValidationType validationType) {
        if (template == null) {
            return false;
        }
        ArrayList<ValidationTypeConditionRegex> regexes = validationType.getRegexList();
        for (ValidationTypeConditionRegex regex : regexes) {
            String pacbaseRegex = regex.getRegexForPacbaseCode();
            String rppRegex = regex.getRegexForRPPCode();
            if (pacbaseRegex.length() == 0) {
                pacbaseRegex = "^$";
            }
            if (rppRegex.length() == 0) {
                rppRegex = "^$";
            }
            Pattern pacPattern = null;
            Pattern rppPattern = null;
            try {
                pacPattern = Pattern.compile(pacbaseRegex);
                rppPattern = Pattern.compile(rppRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {}
            if (rppPattern == null) continue;
            String templatePacCode = ValidationContoler.stripCode(ValidationContoler.catenateWords(template.deletedWords()));
            boolean mach = Report.findPatterns((String)(templatePacCode = ValidationContoler.removeLineFeed(templatePacCode)), (String)ValidationContoler.stripCode(ValidationContoler.catenateWords(template.addedWords())), (Pattern)pacPattern, (Pattern)rppPattern, (String)pacbaseRegex, (String)rppRegex, (boolean)false);
            if (!mach) continue;
            return true;
        }
        return false;
    }

    public static String removeLineFeed(String st) {
        int newLineIndex;
        while (st.contains("\r\n")) {
            newLineIndex = st.indexOf("\r\n");
            st = String.valueOf(st.substring(0, newLineIndex)) + st.substring(newLineIndex + 2);
        }
        while (st.contains("\n")) {
            newLineIndex = st.indexOf("\n");
            st = String.valueOf(st.substring(0, newLineIndex)) + st.substring(newLineIndex + 1);
        }
        return st;
    }

    static String stripCode(String code) {
        if (code != null) {
            int idx = code.indexOf("|");
            if (idx >= 0) {
                code = code.substring(idx + 1);
            }
            if ((idx = code.indexOf("|")) > 0) {
                code = code.substring(0, idx);
            }
            return code;
        }
        return null;
    }

    private static String modifyRightColumn(String code) {
        StringTokenizer tokenizer = new StringTokenizer(code, "\r\n");
        StringBuilder builder = new StringBuilder(code.length());
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.length() <= 72) {
                builder.append(line);
            } else {
                String rightMargin = line.substring(72);
                if (rightMargin.equals("DOT") || rightMargin.length() == 4 && rightMargin.startsWith("lv") && Character.isDigit(rightMargin.charAt(2)) && Character.isDigit(rightMargin.charAt(3))) {
                    builder.append(line);
                } else if (line.charAt(72) != ' ' && rightMargin.length() <= 6) {
                    line = line.substring(0, 72);
                    line = ModelTransformation2.trimRight((String)line);
                    builder.append(line);
                } else {
                    builder.append(line);
                }
            }
            if (!tokenizer.hasMoreTokens()) continue;
            builder.append("\n");
        }
        String result = builder.toString();
        return result;
    }

    protected static String catenateWords(Word[] words) {
        int i;
        if (words.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        int leftCut = 0;
        int nbChars = 0;
        while (leftCut < words.length) {
            if ((nbChars += 1 + words[leftCut++].length()) >= 80) break;
        }
        int rightCut = leftCut;
        nbChars = 0;
        int wordCount = leftCut;
        while (wordCount < words.length) {
            nbChars += 1 + words[wordCount].length();
            while (nbChars >= 80) {
                nbChars -= 1 + words[rightCut++].length();
            }
            ++wordCount;
        }
        result.append('|');
        if (leftCut + 1 >= words.length) {
            i = 0;
            while (i < words.length - 1) {
                ValidationContoler.appendWord(result, words[i]);
                result.append(' ');
                ++i;
            }
        } else {
            i = 0;
            while (i < leftCut) {
                ValidationContoler.appendWord(result, words[i]);
                result.append(' ');
                ++i;
            }
            result.append(" ...\n... ");
            i = rightCut;
            while (i < words.length - 1) {
                ValidationContoler.appendWord(result, words[i]);
                result.append(' ');
                ++i;
            }
        }
        ValidationContoler.appendWord(result, words[words.length - 1]);
        result.append('|');
        return result.toString();
    }

    protected static void appendWord(StringBuilder sb, Word word) {
        switch (word.length()) {
            case 1: {
                if (!word.quoted()) {
                    sb.append(word.firstChar());
                    return;
                }
                sb.append('\'');
                sb.append(word.firstChar());
                sb.append('\'');
                return;
            }
            case 2: {
                if (!word.quoted()) {
                    sb.append(word.firstChar());
                    sb.append(word.lastChar());
                    return;
                }
                sb.append('\'');
                sb.append(word.firstChar());
                sb.append(word.lastChar());
                sb.append('\'');
                return;
            }
        }
        if (!word.quoted()) {
            sb.append(word.chars());
            return;
        }
        sb.append('\'');
        sb.append(word.chars());
        sb.append('\'');
    }

    public static void applyMigrationType(Controller controler) {
        if (controler == null) {
            return;
        }
        MigrationWarnings migrationWarnings = controler.getMigrationWarnings();
        if (migrationWarnings == null) {
            return;
        }
        SourceCodeMigrationDifferences differences = new SourceCodeMigrationDifferences(controler);
        SourceCodeMigrationDifference[] warnings = differences.getSourceCodeDifferences();
        if (warnings == null) {
            return;
        }
        ArrayList<SourceCodeMigrationDifference> currentsdifferences = new ArrayList<SourceCodeMigrationDifference>();
        SourceCodeMigrationDifference[] sourceCodeMigrationDifferenceArray = warnings;
        int n = warnings.length;
        int n2 = 0;
        while (n2 < n) {
            SourceCodeMigrationDifference sourceCodeMigrationDifference = sourceCodeMigrationDifferenceArray[n2];
            currentsdifferences.add(sourceCodeMigrationDifference);
            ++n2;
        }
        ValidationContoler.applyMigrationTypeFilter(currentsdifferences);
        ValidationContoler.createMigrationMarkersFromController(controler, differences.getSourceCodeDifferences());
    }

    public static void createMigrationMarkersFromController(Controller controler, SourceCodeMigrationDifference[] scmd) {
        block21: {
            if (controler == null) {
                return;
            }
            MigrationWarnings warnings = controler.getMigrationWarnings();
            IFile resource = PdpTool.getFile((String)controler.getResourceName());
            try {
                resource.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            if (warnings == null) {
                return;
            }
            if (scmd.length == 0) {
                try {
                    IMarker marker = resource.createMarker("com.ibm.pdp.pac.migration.marker");
                    if (marker.exists()) {
                        Object[] markersValue = new Object[]{Messages.MigrationHelpTool_No_difference_found, 0, 1, 1, 0, 0, 0, 0, 0, 0, ""};
                        marker.setAttributes(MigrationHelpTool.markersAttrs, markersValue);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return;
            }
            try {
                boolean markerCreated = false;
                SourceCodeMigrationDifference[] sourceCodeMigrationDifferenceArray = scmd;
                int n = scmd.length;
                int n2 = 0;
                while (n2 < n) {
                    block20: {
                        SourceCodeMigrationDifference sourceCodeMigrationDifference = sourceCodeMigrationDifferenceArray[n2];
                        if (sourceCodeMigrationDifference.getFilteredMetaTemplateID() == -1 || sourceCodeMigrationDifference.isVisible()) {
                            MigrationWarningIndexes mwi = sourceCodeMigrationDifference.getMigrationWarningIndexes();
                            try {
                                IMarker marker = resource.createMarker("com.ibm.pdp.pac.migration.marker");
                                if (!marker.exists()) break block20;
                                Object[] markersValue = new Object[11];
                                String patternDetail = mwi.patternID;
                                patternDetail = patternDetail != null && patternDetail.length() != 0 ? " : Template : " + patternDetail : null;
                                markersValue[0] = patternDetail == null ? Messages.MigrationHelpTool_Difference_detected : String.valueOf(Messages.MigrationHelpTool_Difference_detected) + patternDetail;
                                markersValue[1] = 1;
                                markersValue[2] = 1;
                                EditorLink editorLink = (EditorLink)controler.getEditorLink();
                                IDocument doc = editorLink.getDocument();
                                if (doc != null) {
                                    try {
                                        int line = doc.getLineOfOffset(mwi.controlBeginIndex);
                                        markersValue[3] = line;
                                    }
                                    catch (BadLocationException e) {
                                        e.printStackTrace();
                                    }
                                }
                                markersValue[4] = mwi.controlBeginIndex;
                                markersValue[5] = mwi.controlEndIndex;
                                markersValue[6] = mwi.generatedBeginIndex;
                                markersValue[7] = mwi.generatedEndIndex;
                                markersValue[8] = mwi.controlBeginIndex;
                                markersValue[9] = mwi.controlEndIndex;
                                markersValue[10] = mwi.patternID;
                                marker.setAttributes(MigrationHelpTool.markersAttrs, markersValue);
                                markerCreated = true;
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
                if (markerCreated) break block21;
                try {
                    IMarker marker = resource.createMarker("com.ibm.pdp.pac.migration.marker");
                    if (marker.exists()) {
                        Object[] markersValue = new Object[]{Messages.ValidationContoler_INFO_FILTERED_DIFF, 0, 1, 1, 0, 0, 0, 0, 0, 0, ""};
                        marker.setAttributes(MigrationHelpTool.markersAttrs, markersValue);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
            }
        }
    }

    public static boolean refreshMigrationMarkers(IController controler, IResource resource) {
        String controlCobol;
        Controller contr;
        MigrationWarnings warnings;
        if (controler instanceof Controller && (warnings = (contr = (Controller)controler).getMigrationWarnings()) != null && (controlCobol = warnings.getGeneratedControlText()) != null && controlCobol.length() != 0) {
            try {
                if (resource != null) {
                    resource.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
                    ValidationContoler.applyMigrationType(contr);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void validAll(List<?> list, IProgressMonitor monitor) throws Exception {
        List<?> listToValid = list;
        List<CacheData> excludedElements = null;
        if (PlatformUI.isWorkbenchRunning()) {
            ArrayList list2 = new ArrayList(list.size());
            for (Object element : list) {
                list2.add((CacheData)element);
            }
            excludedElements = ValidationContoler.excludeCacheDataOpenedInEditor(list2);
            listToValid = list2;
        }
        class ValidAll
        extends WorkspaceModifyOperation {
            List<?> myList;

            ValidAll(List<?> list) {
                this.myList = list;
            }

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ((ControllerFactory)ControllerFactory.getInstance()).retain();
                boolean isRPPBuildEnv = Util.isRPPBuildEnv();
                Iterator<?> iter = this.myList.iterator();
                monitor.beginTask(Messages.ValidationContoler_TASK_MULTIPLE_VALIDATION, this.myList.size());
                try {
                    while (iter.hasNext()) {
                        String generatedControlCode;
                        Controller contr;
                        MigrationWarnings warnings;
                        IController controler;
                        if (monitor.isCanceled()) {
                            return;
                        }
                        CacheData cd = (CacheData)iter.next();
                        String generatedFile = cd.getGeneratedProductFullName();
                        if (isRPPBuildEnv) {
                            monitor.beginTask("MigrationHelpTool>>reGenerate", -1);
                        }
                        if ((controler = MigrationHelpTool.reGenerate((String)generatedFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null || !(controler instanceof Controller) || (warnings = (contr = (Controller)controler).getMigrationWarnings()) == null || (generatedControlCode = warnings.getGeneratedControlText()) == null) continue;
                        ITextProcessor tp = controler.getTextProcessor();
                        CharSequence specificCode = tp.getText();
                        if (isRPPBuildEnv) {
                            monitor.beginTask("MigrationHelpValidationTool>>automaticallyReportMigrationChoices", -1);
                        }
                        generatedControlCode = MigrationHelpValidationTool.automaticallyReportMigrationChoices(generatedControlCode, specificCode, (Controller)controler).toString();
                        if (isRPPBuildEnv) {
                            monitor.beginTask("TextProcessor>>initialize", -1);
                        }
                        if (((Controller)controler).getGenInfoForMigration() != null) {
                            contr.getTextProcessor().initialize(((Controller)controler).getGenInfoForMigration());
                        }
                        contr.getTextProcessor().setText((CharSequence)generatedControlCode);
                        contr.setMigrationWarnings(null);
                        contr.setGenInfoForMigration(null);
                        GenerationManager.removeReconciliationProblems((ITextProcessor)contr.getTextProcessor());
                        IFile file = PdpTool.getFile((String)generatedFile);
                        if (PlatformUI.isWorkbenchRunning() && MigrationHelpValidationTool.isDirtyEditorOpenedFor(file)) continue;
                        if (isRPPBuildEnv) {
                            monitor.beginTask("GenerationManager>>saveSrcResource", -1);
                        }
                        GenerationManager.saveSrcResource((IController)controler);
                        if (isRPPBuildEnv) {
                            monitor.beginTask("Controler>>getResourceLink", -1);
                        }
                        controler.getResourceLink().saveResource();
                    }
                }
                finally {
                    ((ControllerFactory)ControllerFactory.getInstance()).release();
                }
            }
        }
        ValidAll va = new ValidAll(listToValid);
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile((IRunnableWithProgress)va);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            va.execute(monitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (excludedElements != null && excludedElements.size() != 0) {
            class ValidExcludedElements
            implements IRunnableWithProgress {
                List<CacheData> cacheDatas;

                ValidExcludedElements(List<CacheData> list) {
                    this.cacheDatas = list;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ((ControllerFactory)ControllerFactory.getInstance()).retain();
                    boolean isRPPBuildEnv = Util.isRPPBuildEnv();
                    Iterator<CacheData> iter = this.cacheDatas.iterator();
                    monitor.beginTask(Messages.ValidationContoler_TASK_MULTIPLE_VALIDATION, this.cacheDatas.size());
                    try {
                        while (iter.hasNext()) {
                            String generatedControlCode;
                            Controller contr;
                            MigrationWarnings warnings;
                            if (monitor.isCanceled()) {
                                return;
                            }
                            CacheData cd = iter.next();
                            String generatedFile = cd.getGeneratedProductFullName();
                            if (isRPPBuildEnv) {
                                monitor.beginTask("MigrationHelpTool>>reGenerate", -1);
                            }
                            ControllerFactory.getInstance().removeResourceChangeListener();
                            IController controler = null;
                            try {
                                controler = MigrationHelpTool.reGenerate((String)generatedFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            finally {
                                ControllerFactory.getInstance().addResourceChangeListener();
                            }
                            if (controler == null || !(controler instanceof Controller) || (warnings = (contr = (Controller)controler).getMigrationWarnings()) == null || (generatedControlCode = warnings.getGeneratedControlText()) == null) continue;
                            ITextProcessor tp = controler.getTextProcessor();
                            CharSequence specificCode = tp.getText();
                            if (isRPPBuildEnv) {
                                monitor.beginTask("MigrationHelpValidationTool>>automaticallyReportMigrationChoices", -1);
                            }
                            generatedControlCode = MigrationHelpValidationTool.automaticallyReportMigrationChoices(generatedControlCode, specificCode, (Controller)controler).toString();
                            if (isRPPBuildEnv) {
                                monitor.beginTask("TextProcessor>>initialize", -1);
                            }
                            contr.getTextProcessor().initialize(((Controller)controler).getGenInfoForMigration());
                            contr.getTextProcessor().setText((CharSequence)generatedControlCode);
                            contr.setMigrationWarnings(null);
                            contr.setGenInfoForMigration(null);
                        }
                    }
                    finally {
                        ((ControllerFactory)ControllerFactory.getInstance()).release();
                    }
                }
            }
            ValidExcludedElements vee = new ValidExcludedElements(excludedElements);
            if (PlatformUI.isWorkbenchRunning()) {
                IWorkbench wb = PlatformUI.getWorkbench();
                IProgressService ps = wb.getProgressService();
                try {
                    ps.busyCursorWhile((IRunnableWithProgress)vee);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                vee.run(monitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static List<CacheData> excludeCacheDataOpenedInEditor(List<?> list) {
        ArrayList<CacheData> excludedElements = new ArrayList<CacheData>();
        if (list.size() == 0) {
            return excludedElements;
        }
        ArrayList<IFile> openedFiles = ValidationContoler.getAllOpenedIFiles();
        int i = 0;
        while (i < list.size()) {
            CacheData cd = (CacheData)list.get(i);
            String generatedFile = cd.getGeneratedProductFullName();
            IFile file = PdpTool.getFile((String)generatedFile);
            for (IFile iFile : openedFiles) {
                if (!iFile.equals((Object)file)) continue;
                excludedElements.add(cd);
                list.remove(i);
                --i;
                break;
            }
            ++i;
        }
        return excludedElements;
    }

    private static ArrayList<IFile> getAllOpenedIFiles() {
        IEditorReference[] refs;
        ArrayList<IFile> result = new ArrayList<IFile>();
        IEditorReference[] iEditorReferenceArray = refs = PdpTool.findAllOpenedEditors();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            IEditorInput editorInput = null;
            try {
                editorInput = iEditorReference.getEditorInput();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (editorInput instanceof FileEditorInput) {
                IFile editorFile = ((FileEditorInput)editorInput).getFile();
                result.add(editorFile);
            }
            ++n2;
        }
        return result;
    }

    public static void closeLog() {
        if (_logger != null) {
            if (_logger.getHandlers() != null && _logger.getHandlers().length > 0) {
                Handler handler = _logger.getHandlers()[0];
                if (handler instanceof FileHandler) {
                    FileHandler fileHandler = (FileHandler)handler;
                    fileHandler.close();
                }
                _logger.removeHandler(handler);
            }
            _logger = null;
        }
    }

    public static String getWorkspaceFolder() {
        return PdpTool.getWorkspaceFolder();
    }

    public static synchronized Logger getLogger() throws Exception {
        if (_logger != null) {
            return _logger;
        }
        _logger = Logger.getLogger(ValidationContoler.class.getName());
        reportFilePath = LOG_FILE;
        reportFilePath = System.getProperty("pacvalidationfile") != null ? System.getProperty("pacvalidationfile") : String.valueOf(ValidationContoler.getWorkspaceFolder()) + FOLDER_LOG_FILE + reportFilePath;
        FileHandler handler = new FileHandler(reportFilePath, false);
        _logger.setUseParentHandlers(false);
        _logger.addHandler(handler);
        _logger.setLevel(Level.FINEST);
        handler.setFormatter(new RppFormatter());
        return _logger;
    }

    public static void log(int statusGravity, String message) {
        try {
            if (statusGravity == 4) {
                ValidationContoler.getLogger().log(Level.SEVERE, message);
            } else if (statusGravity == 2) {
                ValidationContoler.getLogger().log(Level.WARNING, message);
            } else {
                ValidationContoler.getLogger().log(Level.INFO, message);
            }
        }
        catch (Exception ex) {
            ILog statusLog = MigrationHelpPlugin.getDefault().getLog();
            Status status = new Status(statusGravity, PLUGIN_ID, 0, message, (Throwable)ex);
            statusLog.log((IStatus)status);
        }
    }

    public static void log(int statusGravity, String message, Throwable e) {
        try {
            ValidationContoler.getLogger().log(Level.SEVERE, message, e);
        }
        catch (Exception exception) {
            ILog statusLog = MigrationHelpPlugin.getDefault().getLog();
            Status status = new Status(statusGravity, PLUGIN_ID, 0, message, e);
            statusLog.log((IStatus)status);
        }
    }
}

