/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.pac.migration.help.MigrationControlExtension;
import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.DifferenceBankException;
import com.ibm.pdp.pac.migration.help.validation.Messages;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.pac.migration.help.validation.serialization.ValidationCacheDeserializer;
import com.ibm.pdp.util.containers.ActiveHashedMap;
import com.ibm.pdp.util.containers.HashedMap;
import com.ibm.pdp.util.containers.HashedSet;
import com.ibm.pdp.util.events.MapChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidationCache
implements PropertyChangeListener {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int ASC = 1;
    private static int DSC = -1;
    public static final String VALIDATION_CACHE_FOLDER = ".metadata/.plugins/com.ibm.pdp.migration.help/";
    public static final String VALIDATION_CACHE_FILE_NAME = "validationCache.xml";
    public static final int DIRTY = 0;
    public static final int READY = 1;
    public static final int CANCELED = 2;
    public static final int NOT_INITIALIZED = -1;
    public static final int BATCH_MODE = 3;
    public static boolean refreshInProgress = false;
    public static Job job;
    private transient List<CacheData> sortedData;
    private transient boolean sortAscending = true;
    private transient int sortColumnID = 1;
    private static ValidationCacheDataComparator vcdc;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static ValidationCache cache;
    private HashedSet<String> validatedPDPFiles = new HashedSet();
    private Map<String, CacheData> pdpFilesToValidate = new ActiveHashedMap();
    private HashedMap<String, WordDifference> templates = new HashedMap();
    private int state = -1;

    static {
        vcdc = null;
    }

    public HashedMap<String, WordDifference> getTemplates() {
        return this.templates;
    }

    public static synchronized ValidationCache getCache() {
        if (cache == null) {
            cache = new ValidationCache();
            cache.initializeTemplates();
            ValidationCache.loadValidationCache(cache);
        }
        return cache;
    }

    private static void loadValidationCache(ValidationCache vc) {
        ValidationCacheDeserializer vcd = new ValidationCacheDeserializer();
        String validationCacheFileName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + VALIDATION_CACHE_FOLDER + VALIDATION_CACHE_FILE_NAME;
        FileInputStream inputStream = null;
        File file = new File(validationCacheFileName);
        if (!file.exists()) {
            return;
        }
        try {
            inputStream = new FileInputStream(file);
            vcd.deserialize(vc, inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public HashedSet<String> getValidatedPDPFiles() {
        return this.validatedPDPFiles;
    }

    public Map<String, CacheData> getPdpFilesToValidate() {
        return this.pdpFilesToValidate;
    }

    public synchronized void initializeTemplates() {
        this.templates.clear();
        if (MigrationControlExtension.getDiffBank() == null) {
            MigrationControlExtension.loadDifferenceBankFromDisk();
        }
        if (MigrationControlExtension.getDiffBank() != null) {
            DifferenceBank diffBank = MigrationControlExtension.getDiffBank();
            WordDifference[] differences = new WordDifference[diffBank.size()];
            diffBank.copyDifferencesTo(differences, false);
            WordDifference[] wordDifferenceArray = differences;
            int n = differences.length;
            int n2 = 0;
            while (n2 < n) {
                WordDifference diff = wordDifferenceArray[n2];
                this.templates.put((Object)("" + diff.getHashCode()), (Object)diff);
                ++n2;
            }
        }
    }

    public boolean checkDifferenceBank() {
        DifferenceBank diffBank = MigrationControlExtension.getDiffBank();
        if (diffBank == null) {
            diffBank = MigrationControlExtension.loadDifferenceBankFromDisk();
        }
        if (this.templates == null) {
            return false;
        }
        return diffBank.size() == this.templates.size();
    }

    public void setState(int state) {
        int oldValue = this.state;
        this.state = state;
        this.pcs.firePropertyChange("state", oldValue, state);
    }

    public int getState() {
        return this.state;
    }

    public String getStateLabel() {
        switch (this.getState()) {
            case 0: {
                return Messages.ValidationCache_Rebuild_requiered;
            }
            case 1: {
                return Messages.ValidationCache_Build_finished;
            }
            case 2: {
                return Messages.ValidationCache_Build_canceled;
            }
            case 3: {
                return Messages.ValidationCache_Build_in_progress;
            }
        }
        return "" + this.getState();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static void rebuildCache() {
        if (refreshInProgress) {
            Job oldJob = job;
            oldJob.cancel();
        }
        Job job = new Job(Messages.ValidationCache_Job_Filtering){

            public IStatus run(IProgressMonitor monitor) {
                job = this;
                refreshInProgress = true;
                ValidationContoler valControler = new ValidationContoler();
                boolean diffBankError = false;
                try {
                    valControler.createValidationCacheFromWorkspace(monitor);
                }
                catch (DifferenceBankException dbe) {
                    ValidationCache.showDiffBankMessage(dbe.getMessage());
                    diffBankError = true;
                }
                if (job == this) {
                    job = null;
                    refreshInProgress = false;
                }
                if (diffBankError) {
                    ValidationCache.getCache().setState(0);
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void showDiffBankMessage(String message) {
        class MyRun
        implements Runnable {
            String message;

            MyRun(String mess) {
                this.message = mess;
            }

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openInformation((Shell)shell, (String)"Rebuild failed", (String)this.message);
            }
        }
        Display.getDefault().asyncExec((Runnable)new MyRun(message));
    }

    public List<CacheData> getSortedData() {
        if (this.sortedData == null) {
            this.sortedData = new ArrayList<CacheData>(this.pdpFilesToValidate.size());
            this.sortedData.addAll(this.pdpFilesToValidate.values());
            this.sortData(this.sortColumnID, this.sortAscending);
            ((ActiveHashedMap)this.pdpFilesToValidate).addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.sortedData;
    }

    public void sortData(int columnID, boolean direction) {
        this.sortAscending = direction;
        this.sortColumnID = columnID;
        if (this.sortedData == null) {
            return;
        }
        if (vcdc == null) {
            vcdc = new ValidationCacheDataComparator();
        }
        vcdc.setDirection(direction);
        vcdc.setFieldToCompare(columnID);
        Collections.sort(this.sortedData, vcdc);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.sortedData == null) {
            return;
        }
        if (evt instanceof MapChangeEvent) {
            Map removed;
            int gap;
            MapChangeEvent mce = (MapChangeEvent)evt;
            Map addedElement = mce.getAddedElements();
            Map removedElement = mce.getRemovedElements();
            int n = gap = addedElement == null ? 0 : addedElement.size();
            if (removedElement != null) {
                gap -= removedElement.size();
            }
            if (this.pdpFilesToValidate.size() != this.sortedData.size() + gap) {
                this.sortedData = null;
                this.getSortedData();
                return;
            }
            boolean sortAgain = false;
            Map added = mce.getAddedElements();
            if (added != null && added.size() != 0) {
                for (Object obj : added.values()) {
                    if (!(obj instanceof CacheData)) continue;
                    CacheData cd = (CacheData)obj;
                    this.sortedData.add(cd);
                    sortAgain = true;
                }
            }
            if ((removed = mce.getRemovedElements()) != null && removed.size() != 0) {
                for (Object obj : removed.values()) {
                    if (!(obj instanceof CacheData)) continue;
                    CacheData cd = (CacheData)obj;
                    this.sortedData.remove(cd);
                }
            }
            if (sortAgain) {
                this.sortData(this.sortColumnID, this.sortAscending);
            }
        }
    }

    class ValidationCacheDataComparator
    implements Comparator<CacheData> {
        int _direction = ValidationCache.access$0();
        int _comparisonType = 1;

        ValidationCacheDataComparator() {
        }

        @Override
        public int compare(CacheData o1, CacheData o2) {
            int result = 0;
            if (this._comparisonType == 1) {
                result = o1.getDesignName().compareTo(o2.getDesignName());
            }
            if (this._comparisonType == 2) {
                result = o1.getGeneratedProductFullName().compareTo(o2.getGeneratedProductFullName());
            }
            if (this._comparisonType == 3) {
                result = o1.getMigrationWarningNumber() - o2.getMigrationWarningNumber();
            }
            if (this._comparisonType == 4) {
                result = o1.getFilteredMigrationWarningNumber() - o2.getFilteredMigrationWarningNumber();
            }
            if (this._comparisonType == 5) {
                int[] tab1 = o1.getFilteredValidationTypes();
                int[] tab2 = o2.getFilteredValidationTypes();
                if (tab1 == null && tab2 == null) {
                    return 0;
                }
                if (tab1 == null) {
                    return 1;
                }
                if (tab2 == null) {
                    return -1;
                }
                if (tab1.length != tab2.length) {
                    return (tab1.length - tab2.length) * this._direction;
                }
                int i = 0;
                while (i < tab1.length) {
                    if (tab1[i] != tab2[i]) {
                        return (tab1[i] - tab2[i]) * this._direction;
                    }
                    ++i;
                }
                return 0;
            }
            return result * this._direction;
        }

        public void setDirection(boolean ascending) {
            this._direction = ascending ? ASC : DSC;
        }

        public void setFieldToCompare(int comparisonType) {
            this._comparisonType = comparisonType;
        }
    }
}

