/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.pac.migration.help.validation.Messages;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.pac.migration.help.validation.ValidationTypeConditionRegex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.osgi.util.NLS;

public class Validation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String templatesFilesPath;
    private ArrayList<ValidationType> validationTypes;

    public String getTemplatesFilesPath() {
        return this.templatesFilesPath;
    }

    public void setTemplatesFilesPath(String templatesFilesPath) {
        this.templatesFilesPath = templatesFilesPath;
    }

    public ArrayList<ValidationType> getValidationTypes() {
        if (this.validationTypes == null) {
            this.validationTypes = new ArrayList();
        }
        return this.validationTypes;
    }

    public Validation duplicate() {
        Validation result = new Validation();
        result.templatesFilesPath = this.templatesFilesPath;
        ArrayList<ValidationType> resultValTypes = result.getValidationTypes();
        Iterator<ValidationType> valTypeIter = this.getValidationTypes().iterator();
        while (valTypeIter.hasNext()) {
            resultValTypes.add(valTypeIter.next().duplicate());
        }
        return result;
    }

    public boolean isEqualsTo(Validation other) {
        if (this.templatesFilesPath == null && other.templatesFilesPath != null || this.templatesFilesPath != null && other.templatesFilesPath == null) {
            return false;
        }
        if (this.templatesFilesPath != null && !this.templatesFilesPath.equals(other.templatesFilesPath)) {
            return false;
        }
        ArrayList<ValidationType> valTypes = this.getValidationTypes();
        ArrayList<ValidationType> otherValTypes = other.getValidationTypes();
        if (valTypes.size() != otherValTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < valTypes.size()) {
            if (!valTypes.get(i).isEqualsTo(otherValTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualsForRebuildMarkers(Validation other) {
        if (this.templatesFilesPath == null && other.templatesFilesPath != null || this.templatesFilesPath != null && other.templatesFilesPath == null) {
            return false;
        }
        if (this.templatesFilesPath != null && !this.templatesFilesPath.equals(other.templatesFilesPath)) {
            return false;
        }
        ArrayList<ValidationType> valTypes = this.getValidationTypes();
        ArrayList<ValidationType> otherValTypes = other.getValidationTypes();
        if (valTypes.size() != otherValTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < valTypes.size()) {
            if (!valTypes.get(i).isEqualsForRebuildMarkers(otherValTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String checkAllRegex() {
        ArrayList<ValidationType> valTypes = this.getValidationTypes();
        for (ValidationType validationType : valTypes) {
            ArrayList<ValidationTypeConditionRegex> regexes = validationType.getRegexList();
            for (ValidationTypeConditionRegex validationTypeConditionRegex : regexes) {
                String pacbaseRegex = validationTypeConditionRegex.getRegexForPacbaseCode();
                String rppRegex = validationTypeConditionRegex.getRegexForRPPCode();
                try {
                    Pattern.compile(pacbaseRegex);
                }
                catch (PatternSyntaxException pse) {
                    return NLS.bind((String)(String.valueOf(Messages.Validation_pac_regex_error) + pse.getMessage()), (Object[])new String[]{validationType.getName()});
                }
                try {
                    Pattern.compile(rppRegex);
                }
                catch (PatternSyntaxException pse) {
                    return NLS.bind((String)(String.valueOf(Messages.Validation_rpp_regex_error) + pse.getMessage()), (Object[])new String[]{validationType.getName()});
                }
            }
        }
        return "";
    }
}

