/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifference;
import java.util.List;

public class SourceCodeMigrationDifferences {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Controller controler;
    private SourceCodeMigrationDifference[] sourceCodeDifferences;

    public Controller getController() {
        return this.controler;
    }

    public SourceCodeMigrationDifferences(Controller controler) {
        this.controler = controler;
        MigrationWarnings mws = controler.getMigrationWarnings();
        List list = mws.getWarningsList();
        if (list == null || list.size() == 0) {
            return;
        }
        this.sourceCodeDifferences = new SourceCodeMigrationDifference[list.size()];
        int i = 0;
        while (i < list.size()) {
            this.sourceCodeDifferences[i] = new SourceCodeMigrationDifference((MigrationWarningIndexes)list.get(i), this);
            ++i;
        }
    }

    String getLocalCodeFor(SourceCodeMigrationDifference difference) {
        String generatedControlCode = this.controler.getMigrationWarnings().getGeneratedControlText();
        String result = generatedControlCode.substring(difference.getMigrationWarningIndexes().generatedBeginIndex, difference.getMigrationWarningIndexes().generatedEndIndex);
        return result;
    }

    String getCodeFromPacbaseFor(SourceCodeMigrationDifference difference) {
        ITextProcessor tp = this.controler.getTextProcessor();
        String result = tp.getText().subSequence(difference.getMigrationWarningIndexes().controlBeginIndex, difference.getMigrationWarningIndexes().controlEndIndex).toString();
        return result;
    }

    public SourceCodeMigrationDifference[] getSourceCodeDifferences() {
        return this.sourceCodeDifferences;
    }
}

