/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifference;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifferences;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.pac.migration.help.validation.ValidationType;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.containers.ArraySortedSet;
import com.ibm.pdp.util.iterators.TwoWayIterator;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class MigrationHelpValidationTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static CharSequence automaticallyReportMigrationChoices(CharSequence newGeneratedCode, CharSequence pacCode, Controller controler) {
        boolean reportToDo = false;
        Validation val = ValidationContoler.getValidation();
        ArrayList<ValidationType> validationTypes = val.getValidationTypes();
        for (ValidationType validationType : validationTypes) {
            if (validationType.getMigrationChoice() != 1) continue;
            reportToDo = true;
            break;
        }
        if (!reportToDo) {
            return newGeneratedCode;
        }
        MigrationWarnings mws = controler.getMigrationWarnings();
        if (mws != null) {
            SourceCodeMigrationDifferences differences = new SourceCodeMigrationDifferences(controler);
            ValidationContoler.applyMigrationTypeFilter(differences);
            SourceCodeMigrationDifference[] sourceDifferences = differences.getSourceCodeDifferences();
            ArraySortedSet sortedWarnings = new ArraySortedSet((Comparator)new Comparator<MigrationWarningIndexes>(){

                @Override
                public int compare(MigrationWarningIndexes mwi0, MigrationWarningIndexes mwi1) {
                    return mwi1.controlBeginIndex - mwi0.controlBeginIndex;
                }
            });
            int i = 0;
            while (i < sourceDifferences.length) {
                SourceCodeMigrationDifference sourceCodeMigrationDifference = sourceDifferences[i];
                if (sourceCodeMigrationDifference.getFilteredMetaTemplateID() != -1 && validationTypes.get(sourceCodeMigrationDifference.getFilteredMetaTemplateID()).getMigrationChoice() == 1) {
                    sortedWarnings.add((Object)((MigrationWarningIndexes)controler.getMigrationWarnings().getWarningsList().get(i)));
                }
                ++i;
            }
            if (sortedWarnings.size() != 0) {
                MigrationHelpValidationTool.modifySortedWarningIndexes((ArraySortedSet<MigrationWarningIndexes>)sortedWarnings);
            }
            if (sortedWarnings.size() != 0) {
                for (MigrationWarningIndexes warningIndexes : sortedWarnings) {
                    String cobolFromPAC = pacCode.subSequence(warningIndexes.controlBeginIndex, warningIndexes.controlEndIndex).toString();
                    newGeneratedCode = newGeneratedCode.subSequence(0, warningIndexes.generatedBeginIndex) + cobolFromPAC + newGeneratedCode.subSequence(warningIndexes.generatedEndIndex, newGeneratedCode.length());
                }
            }
        }
        return newGeneratedCode;
    }

    private static void modifySortedWarningIndexes(ArraySortedSet<MigrationWarningIndexes> sortedWarnings) {
        for (MigrationWarningIndexes currentMWI : sortedWarnings) {
            TwoWayIterator itmw2 = sortedWarnings.iteratorFrom((Object)currentMWI, false);
            while (itmw2.hasNext()) {
                MigrationWarningIndexes currentMWI2 = (MigrationWarningIndexes)itmw2.next();
                if (currentMWI.generatedBeginIndex < currentMWI2.generatedBeginIndex) {
                    if (currentMWI.generatedEndIndex > currentMWI2.generatedBeginIndex) {
                        currentMWI.generatedEndIndex = currentMWI2.generatedBeginIndex - Util.EOL.length();
                    }
                } else if (currentMWI2.generatedEndIndex > currentMWI.generatedBeginIndex) {
                    currentMWI2.generatedEndIndex = currentMWI.generatedBeginIndex - Util.EOL.length();
                }
                if (currentMWI.controlBeginIndex < currentMWI2.controlBeginIndex) {
                    if (currentMWI.controlEndIndex <= currentMWI2.controlBeginIndex) continue;
                    currentMWI.controlEndIndex = currentMWI2.controlBeginIndex - Util.EOL.length();
                    continue;
                }
                if (currentMWI2.controlEndIndex <= currentMWI.controlBeginIndex) continue;
                currentMWI2.controlEndIndex = currentMWI.controlBeginIndex - Util.EOL.length();
            }
        }
    }

    public static boolean isDirtyEditorOpenedFor(IFile file) {
        IEditorPart[] dirtyEditors = PdpTool.findAllDirtyEditors();
        int i = 0;
        while (i < dirtyEditors.length) {
            IEditorInput editorInput = dirtyEditors[i].getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                IFile editorFile = ((FileEditorInput)editorInput).getFile();
                return editorFile.equals((Object)file);
            }
            ++i;
        }
        return false;
    }
}

