/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.validation;

import com.ibm.pdp.framework.Messages;
import com.ibm.pdp.framework.interfaces.IPdpResourceChangedExtension;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class MigrationHelpPdpChangedExtension
implements IPdpResourceChangedExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void processPDPFiles(Set<IPath> additionQueue, Set<IPath> changedQueue, Set<IPath> removedQueue, Set<IProject> projectsRemovedQueue, IProgressMonitor monitor) {
        Object[] array;
        String pdpFileLocatioon;
        int worked = 0;
        int totalWork = 0;
        if (additionQueue != null) {
            totalWork += additionQueue.size();
        }
        if (changedQueue != null) {
            totalWork += changedQueue.size();
        }
        if (removedQueue != null) {
            totalWork += removedQueue.size();
        }
        monitor.beginTask(Messages.Finalize_Indexing_Task, totalWork);
        if (additionQueue != null && additionQueue.size() > 0) {
            for (IPath iPath : additionQueue) {
                pdpFileLocatioon = iPath.toString();
                ValidationContoler.updateMarkersAndCache(pdpFileLocatioon);
                array = new String[]{Integer.toString(++worked), Integer.toString(totalWork)};
                monitor.subTask(NLS.bind((String)Messages.Indexing_Subtask, (Object[])array));
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        if (changedQueue != null && changedQueue.size() > 0) {
            for (IPath iPath : changedQueue) {
                pdpFileLocatioon = iPath.toString();
                ValidationContoler.updateMarkersAndCache(pdpFileLocatioon);
                array = new String[]{Integer.toString(++worked), Integer.toString(totalWork)};
                monitor.subTask(NLS.bind((String)Messages.Indexing_Subtask, (Object[])array));
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        if (removedQueue != null && removedQueue.size() > 0) {
            Iterator<IPath> removedPdp = removedQueue.iterator();
            ValidationCache vc = ValidationCache.getCache();
            boolean dirty = false;
            while (removedPdp.hasNext()) {
                IPath iPath = removedPdp.next();
                String pdpFileLocatioon2 = iPath.toString();
                if (vc.getValidatedPDPFiles().get((Object)pdpFileLocatioon2) != null) {
                    vc.getValidatedPDPFiles().remove((Object)pdpFileLocatioon2);
                }
                if (vc.getPdpFilesToValidate().get(pdpFileLocatioon2) != null) {
                    vc.getPdpFilesToValidate().remove(pdpFileLocatioon2);
                    if (vc.getState() != 3) {
                        vc.setState(0);
                    }
                    dirty = true;
                }
                Object[] array2 = new String[]{Integer.toString(++worked), Integer.toString(totalWork)};
                monitor.subTask(NLS.bind((String)Messages.Indexing_Subtask, (Object[])array2));
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return;
            }
            if (dirty && vc.getState() != 3) {
                vc.setState(1);
            }
        }
    }
}

