/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pac.migration.help.quickfix.Messages;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationCompareEditorInput;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationQuickFixAction;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.ICompareUIConstants;

public class ShowAllDifferencesQuickFixAction
extends MigrationQuickFixAction {
    private String resourceFileName;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ShowAllDifferencesQuickFixAction(String mess, String[] params, String resourceFileName) {
        super(mess, params);
        this.resourceFileName = resourceFileName;
    }

    @Override
    public boolean doIt() {
        IController controler = ControllerFactory.getInstance().getController(this.resourceFileName);
        try {
            ITextProcessor tp = controler.getTextProcessor();
            CharSequence specificCode = tp.getText();
            CompareConfiguration compConf = new CompareConfiguration(){

                public String getLeftLabel(Object element) {
                    return Messages.ShowDifferenceQuickFixAction_Generated_code;
                }

                public String getRightLabel(Object element) {
                    return Messages.ShowDifferenceQuickFixAction_Local_generated;
                }

                public boolean isRightEditable() {
                    return false;
                }

                public boolean isLeftEditable() {
                    return false;
                }
            };
            compConf.setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)new Boolean(true));
            if (!(controler instanceof Controller)) {
                return false;
            }
            MigrationWarnings warnings = ((Controller)controler).getMigrationWarnings();
            if (warnings == null) {
                return false;
            }
            String generatedControlCode = warnings.getGeneratedControlText();
            if (generatedControlCode == null) {
                return false;
            }
            MigrationCompareEditorInput mcei = new MigrationCompareEditorInput(compConf, generatedControlCode, specificCode);
            CompareUI.openCompareDialog((CompareEditorInput)mcei);
        }
        finally {
            ControllerFactory.getInstance().dispose(controler);
        }
        return false;
    }
}

