/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationQuickFixAction;
import com.ibm.pdp.pac.migration.help.validation.MigrationHelpValidationTool;
import com.ibm.pdp.util.Interval;
import org.eclipse.core.resources.IFile;

public class RestoreMigrationQuickFixAction
extends MigrationQuickFixAction {
    private String resourceFileName;
    private int startGeneratedIndex;
    private int endGeneratedIndex;
    private int startControlGeneratedIndex;
    private int endControlGeneratedIndex;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public RestoreMigrationQuickFixAction(String mess, String[] params, String resourceFileName, int startGeneratedIndex, int endGeneratedIndex, int startControlGeneratedIndex, int endControlGeneratedIndex) {
        super(mess, params);
        this.resourceFileName = resourceFileName;
        this.startGeneratedIndex = startGeneratedIndex;
        this.endGeneratedIndex = endGeneratedIndex;
        this.startControlGeneratedIndex = startControlGeneratedIndex;
        this.endControlGeneratedIndex = endControlGeneratedIndex;
    }

    @Override
    public boolean doIt() {
        IController controler = ControllerFactory.getInstance().getController(this.resourceFileName);
        try {
            IFile file;
            if (controler instanceof Controller) {
                Controller contr = (Controller)controler;
                MigrationWarnings warnings = contr.getMigrationWarnings();
                this.removeMigrationWarning(warnings, this.startGeneratedIndex, this.endGeneratedIndex, this.startControlGeneratedIndex, this.endControlGeneratedIndex);
            }
            ITextProcessor tp = controler.getTextProcessor();
            IEditTree editTree = tp.getEditTree();
            Interval interval = MigrationHelpTool.convertGeneratedIntervalToInterval((int)this.startGeneratedIndex, (int)this.endGeneratedIndex, (IEditTree)editTree);
            int beginIndex = interval.begin;
            int endIndex = interval.end;
            if (beginIndex > 0 && endIndex > 0 && endIndex >= beginIndex) {
                controler.getTextProcessor().restoreGeneratedCode(beginIndex, endIndex);
            }
            if (MigrationHelpValidationTool.isDirtyEditorOpenedFor(file = PdpTool.getFile((String)this.resourceFileName))) {
                return true;
            }
            controler.getResourceLink().saveResource();
        }
        finally {
            ControllerFactory.getInstance().dispose(controler);
        }
        return true;
    }
}

