/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.pac.migration.help.quickfix.Messages;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationCompareEditorInput;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationQuickFixAction;
import com.ibm.pdp.pac.migration.help.validation.MigrationHelpValidationTool;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class RemoveMigrationControlQuickFixAction
extends MigrationQuickFixAction {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String resourceFileName;

    public RemoveMigrationControlQuickFixAction(String mess, String[] params, String resourceFileName) {
        super(mess, params);
        this.resourceFileName = resourceFileName;
    }

    @Override
    public boolean doIt() {
        IController controler = MigrationHelpTool.reGenerate((String)this.resourceFileName, null);
        if (controler == null) {
            return false;
        }
        try {
            if (!(controler instanceof Controller)) {
                return false;
            }
            CompareConfiguration compConf = new CompareConfiguration(){

                public String getLeftLabel(Object element) {
                    return Messages.ShowDifferenceQuickFixAction_Generated_code;
                }

                public String getRightLabel(Object element) {
                    return Messages.ShowDifferenceQuickFixAction_Local_generated;
                }

                public boolean isRightEditable() {
                    return true;
                }

                public boolean isLeftEditable() {
                    return false;
                }
            };
            compConf.setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, (Object)new Boolean(true));
            Controller contr = (Controller)controler;
            MigrationWarnings warnings = contr.getMigrationWarnings();
            if (warnings == null) {
                return true;
            }
            String generatedControlCode = warnings.getGeneratedControlText();
            if (generatedControlCode == null) {
                return false;
            }
            ITextProcessor tp = controler.getTextProcessor();
            CharSequence specificCode = tp.getText();
            generatedControlCode = MigrationHelpValidationTool.automaticallyReportMigrationChoices(generatedControlCode, specificCode, (Controller)controler).toString();
            MigrationCompareEditorInput mcei = new MigrationCompareEditorInput(compConf, generatedControlCode, specificCode, true);
            CompareUI.openCompareDialog((CompareEditorInput)mcei);
            if (!mcei.isValidatedByUser) {
                return false;
            }
            if (((Controller)controler).getGenInfoForMigration() != null) {
                contr.getTextProcessor().initialize(((Controller)controler).getGenInfoForMigration());
            }
            contr.getTextProcessor().setText(mcei.getPacGeneratedCode());
            contr.setMigrationWarnings(null);
            contr.setGenInfoForMigration(null);
            GenerationManager.removeReconciliationProblems((ITextProcessor)contr.getTextProcessor());
            IFile file = PdpTool.getFile((String)this.resourceFileName);
            if (MigrationHelpValidationTool.isDirtyEditorOpenedFor(file)) {
                try {
                    file.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
                }
                catch (CoreException coreException) {
                    ControllerFactory.getInstance().dispose(controler);
                    return false;
                }
                return true;
            }
            controler.getResourceLink().saveResource();
            GenerationManager.saveSrcResource((IController)controler);
        }
        finally {
            ControllerFactory.getInstance().dispose(controler);
        }
        return true;
    }
}

