/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.quickfix.PDPCanvas;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolMergeViewer;
import com.ibm.pdp.pac.migration.help.quickfix.PDPRangeDifference;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PDPSideCanvas
extends PDPCanvas {
    private boolean isAncestor;
    private boolean isRight;
    private boolean fShowCurrentOnly2 = false;
    private boolean fHighlightRanges = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPSideCanvas(Composite parent, int flags, PDPCobolMergeViewer pdpcmv, boolean ancestor, boolean right) {
        super(parent, flags | 0x40000, pdpcmv);
        this.isAncestor = ancestor;
        this.isRight = right;
    }

    @Override
    public void doPaint(GC gc) {
        this.paintSides(gc, this, this.sourceViewer, this.isRight);
    }

    private void paintSides(GC g, Canvas canvas, SourceViewer tp, boolean right) {
        Display display = canvas.getDisplay();
        tp.getTextWidget().getLineHeight();
        int lineHeight = PDPCobolMergeViewer.getLineHeight(tp);
        int visibleHeight = PDPCobolMergeViewer.getViewportHeight(tp);
        Point size = canvas.getSize();
        int x = 0;
        int w = this.pdpcmv.fMarginWidth;
        int w2 = w / 2;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x, 0, w, size.y);
        g.setBackground(display.getSystemColor(18));
        if (right) {
            g.fillRectangle(0, 0, 1, size.y);
        } else {
            g.fillRectangle(size.x - 1, 0, 1, size.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.pdpcmv.hasChanges()) {
            int shift = this.pdpcmv.getVerticalScrollOffset(tp) + 1;
            Point region = new Point(0, 0);
            char leg = this.pdpcmv.getLeg(tp);
            PDPCobolMergeViewer.PDPDifferencesIterator iterator = this.pdpcmv.allChangesIterator();
            while (iterator.hasNext()) {
                PDPRangeDifference diff = iterator.next();
                if (diff.kind() == 0) continue;
                PDPCobolMergeViewer.getLineRange(tp, diff, leg, region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                g.setBackground(new Color((Device)display, this.RGBfillColor));
                if (right) {
                    g.fillRectangle(x, y, w2, h);
                } else {
                    g.fillRectangle(x + w2, y, w2, h);
                }
                g.setLineWidth(0);
                g.setForeground(new Color((Device)display, this.RGBstrokeColor));
                if (right) {
                    g.drawRectangle(x - 1, y - 1, w2, h);
                    continue;
                }
                g.drawRectangle(x + w2, y - 1, w2, h);
            }
        }
    }
}

