/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolLineComparator;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolTokenComparator;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCompareConstants;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;

public class PDPRangeDifference
extends RangeDifference
implements PDPCompareConstants {
    private PDPCobolLineComparator leftComparator;
    private PDPCobolLineComparator rightComparator;
    private int leftTokensStartOffset;
    private int leftTokensLength;
    private int rightTokensStartOffset;
    private int rightTokensLength;
    private boolean checkReformatted;
    private int typeOfReformat;
    private RangeDifference[] secondLevelDifferences;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPRangeDifference(RangeDifference rd) {
        super(rd.kind());
        this.leftStart = rd.leftStart();
        this.leftLength = rd.leftLength();
        this.rightStart = rd.rightStart();
        this.rightLength = rd.rightLength();
        this.ancestorStart = rd.ancestorStart();
        this.ancestorLength = rd.ancestorLength();
        this.secondLevelDifferences = null;
    }

    public PDPRangeDifference(RangeDifference rd, RangeDifference rd1, PDPCobolLineComparator left, PDPCobolLineComparator right) {
        super(rd.kind());
        int nextRight;
        int nextLeft;
        this.leftStart = rd.leftStart();
        this.leftLength = rd.leftLength();
        this.rightStart = rd.rightStart();
        this.rightLength = rd.rightLength();
        this.ancestorStart = rd.ancestorStart();
        this.ancestorLength = rd.ancestorLength();
        this.secondLevelDifferences = null;
        boolean bl = this.checkReformatted = rd.leftLength() != 0 && rd.rightLength() != 0 && (rd.leftLength() != rd.rightLength() || this.kind() != 0);
        if (this.checkReformatted) {
            this.leftComparator = left;
            this.rightComparator = right;
        } else {
            this.leftComparator = null;
            this.rightComparator = null;
        }
        this.leftTokensStartOffset = left.getTokenStart(rd.leftStart());
        this.rightTokensStartOffset = right.getTokenStart(rd.rightStart());
        if (rd1 != null) {
            nextLeft = rd1.leftStart();
            nextRight = rd1.rightStart();
        } else {
            nextLeft = left.getRangeCount();
            nextRight = right.getRangeCount();
        }
        this.leftTokensLength = rd.leftLength() != 0 ? left.getTokenStart(nextLeft - 1) + left.getTokenLength(nextLeft - 1) - this.leftTokensStartOffset : 0;
        this.rightTokensLength = rd.rightLength() != 0 ? right.getTokenStart(nextRight - 1) + right.getTokenLength(nextRight - 1) - this.rightTokensStartOffset : 0;
    }

    public int leftTokensStartOffset() {
        return this.leftTokensStartOffset;
    }

    public int leftTokensLength() {
        return this.leftTokensLength;
    }

    public int rightTokensStartOffset() {
        return this.rightTokensStartOffset;
    }

    public int rightTokensLength() {
        return this.rightTokensLength;
    }

    public String getLeftText() {
        if (this.checkReformatted && this.leftComparator != null) {
            return this.getText(this.leftComparator, this.leftStart, this.leftLength);
        }
        return "";
    }

    public String getRightText() {
        if (this.checkReformatted && this.rightComparator != null) {
            return this.getText(this.rightComparator, this.rightStart, this.rightLength);
        }
        return "";
    }

    private String getText(PDPCobolLineComparator left, int start, int len) {
        StringBuffer total = new StringBuffer();
        int l = start;
        while (l < start + len) {
            int startLine = left.getTokenStart(l);
            int lenLine = left.getTokenLength(l);
            String line = left.getText().substring(startLine, startLine + lenLine);
            total.append(line);
            ++l;
        }
        return total.toString();
    }

    public int reformat() {
        return this.typeOfReformat;
    }

    public boolean ReformattedAndEqual() {
        return this.typeOfReformat == 2 || this.typeOfReformat == 3;
    }

    public int testReformatted() {
        if (this.checkReformatted) {
            PDPCobolTokenComparator left = new PDPCobolTokenComparator(this.getLeftText());
            PDPCobolTokenComparator right = new PDPCobolTokenComparator(this.getRightText());
            this.secondLevelDifferences = RangeDifferencer.findRanges((IRangeComparator)left, (IRangeComparator)right);
            int sld = 0;
            while (sld < this.secondLevelDifferences.length) {
                if (this.secondLevelDifferences[sld].kind() != 0) {
                    this.typeOfReformat = 4;
                    return 4;
                }
                ++sld;
            }
            int n = this.typeOfReformat = this.leftLength == this.rightLength ? 2 : 3;
            if (this.leftLength == this.rightLength) {
                this.kind = 0;
            }
            return this.typeOfReformat;
        }
        this.typeOfReformat = 1;
        return 1;
    }
}

