/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.util.Strings;
import java.util.StringTokenizer;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;

public class PDPCobolTokenComparator
implements ITokenComparator {
    private String fText;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;
    private static String Sep;
    private static int SepLen;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPCobolTokenComparator(String text) {
        Sep = Strings.getLineSeparator();
        SepLen = Strings.getLineSeparator().length();
        Assert.isNotNull((Object)text);
        this.fText = text;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fCount = 0;
        StringTokenizer tokens = new StringTokenizer(this.fText, " " + Strings.getLineSeparator());
        int index = -1;
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            index = this.fText.indexOf(tok, index + 1);
            this.fLengths[this.fCount] = tok.charAt(0) == '*' ? (index == 0 ? this.fText.indexOf(Sep) + SepLen : (1 < index && this.fText.substring(index - 2, index).equals(Sep) ? this.fText.indexOf(Sep) + SepLen - index : tok.length())) : tok.length();
            this.fStarts[this.fCount] = index;
            ++this.fCount;
        }
    }

    private static boolean hasTwoPoints(String str) {
        int index = str.indexOf(".");
        if (index == -1) {
            return false;
        }
        return (index = str.indexOf(str, index + 1)) != -1;
    }

    private static boolean isDigit(String str) {
        int nbSigns = 0;
        boolean begSign = false;
        int c = 0;
        while (c < str.length()) {
            char cc = str.charAt(c);
            if (cc == '+' || cc == '-') {
                nbSigns = 1;
                if (c == 0) {
                    begSign = true;
                }
            } else if (Character.isDigit(cc) || cc == '.') {
                // empty if block
            }
            ++c;
        }
        return nbSigns == 2 && begSign || nbSigns <= 1;
    }

    private static boolean isPointString(String str) {
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == '.';
    }

    private static boolean isStringPoint(String str) {
        if (str.length() < 2) {
            return false;
        }
        int len = str.length();
        return str.charAt(len - 1) == '.';
    }

    private static boolean isPointStringPoint(String str) {
        if (str.length() < 3) {
            return false;
        }
        if (str.charAt(0) != '.') {
            return false;
        }
        int len = str.length();
        return str.charAt(len - 1) == '.';
    }

    private static boolean onlyPoints(String str) {
        int c = 0;
        while (c < str.length()) {
            if (str.charAt(c) != '.') {
                return false;
            }
            ++c;
        }
        return true;
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public String getText() {
        return this.fText;
    }

    public int getTokenStart(int index) {
        if (index < this.fCount) {
            return this.fStarts[index];
        }
        return this.fText.length();
    }

    public int getTokenLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            PDPCobolTokenComparator tc = (PDPCobolTokenComparator)other;
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = tc.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), tc.fText, tc.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (max < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (max > 800) {
            return true;
        }
        return length >= max / 4;
    }
}

