/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.MigrationHelpPlugin;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationCompareEditorInput;
import com.ibm.pdp.pac.migration.help.quickfix.PDPBirdEyesCanvas;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCenterCanvas;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolLineComparator;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCompareConstants;
import com.ibm.pdp.pac.migration.help.quickfix.PDPRangeDifference;
import com.ibm.pdp.pac.migration.help.quickfix.PDPSideCanvas;
import java.net.URL;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.osgi.framework.Bundle;

public class PDPCobolMergeViewer
extends ContentMergeViewer
implements PDPCompareConstants {
    protected int fMarginWidth = 6;
    private RGB strokeColor = new RGB(255, 0, 0);
    private String fSymbolicFontName = this.getSymbolicFontName();
    private CLabel pdpAncestorLabel;
    private CLabel pdpLeftLabel;
    private CLabel pdpDirectionLabel;
    private CLabel pdpRightLabel;
    private SourceViewer pdpAncestor;
    private SourceViewer pdpLeft;
    private SourceViewer pdpRight;
    private Canvas pdpAncestorCanvas;
    private PDPSideCanvas pdpLeftCanvas;
    private PDPCenterCanvas pdpCenter;
    private PDPSideCanvas pdpRightCanvas;
    private Canvas fScrollCanvas;
    private PDPBirdEyesCanvas pdpBirdsEyeCanvas;
    private ScrollBar fVScrollBar;
    private boolean pdpAncestorVisible;
    private boolean fInScrolling;
    private boolean fUseSingleLine = true;
    private int isRefreshing = 0;
    private int fSynchronizedScrollPosition;
    private int fTopInset;
    private Document ancestorDocument;
    private Document referenceDocument;
    private Document RPPDocument;
    private int nbLinesOfReference;
    private int nbLinesOfRPP;
    private ActionContributionItem pdpAncestorItem;
    private ActionContributionItem pdpNextDiff;
    private ActionContributionItem pdpPrevDiff;
    private ActionContributionItem pdpNextChange;
    private ActionContributionItem pdpPrevChange;
    private PDPRangeDifference[] linesDifferences;
    private PDPRangeDifference[] linesWithSecondLevelDifferences;
    protected Cursor pdpBirdsEyeCursor;
    private double pdpHSplit = -1.0;
    private double pdpVSplit = 0.3;
    private Cursor pdpNormalCursor;
    private Cursor pdpHSashCursor;
    private Cursor pdpVSashCursor;
    private Cursor pdpHVSashCursor;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected PDPCobolMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(style, ResourceBundle.getBundle("com.ibm.pdp.pac.migration.help.quickfix.PDPCobolMergeViewerResources"), configuration);
        Object doc = null;
        if (doc instanceof Document) {
            this.RPPDocument = doc;
        }
        if ((doc = null) instanceof Document) {
            this.ancestorDocument = doc;
        }
        this.referenceDocument = null;
        this.nbLinesOfReference = 0;
        this.nbLinesOfRPP = 0;
        this.buildControl(parent);
        Control[] children = ((Composite)this.getControl()).getChildren();
        int c = 0;
        while (c < children.length) {
            if (children[c] instanceof CLabel && c == 0) {
                this.pdpAncestorLabel = (CLabel)children[c];
            } else if (children[c] instanceof CLabel && c == 1) {
                this.pdpLeftLabel = (CLabel)children[c];
                new PDPResizer((Control)this.pdpLeftLabel, 2);
            } else if (children[c] instanceof CLabel && c == 2) {
                this.pdpDirectionLabel = (CLabel)children[c];
                new PDPResizer((Control)this.pdpDirectionLabel, 3);
            } else if (children[c] instanceof CLabel && c == 3) {
                this.pdpRightLabel = (CLabel)children[c];
                new PDPResizer((Control)this.pdpRightLabel, 2);
            }
            ++c;
        }
        this.fInScrolling = false;
        this.updateFont();
        this.pdpBirdsEyeCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.linesDifferences = null;
    }

    protected void copy(boolean leftToRight) {
    }

    protected void createControls(Composite parent) {
        this.pdpAncestorCanvas = new Canvas(parent, 0);
        this.pdpAncestor = this.createPart(parent);
        this.pdpLeftCanvas = new PDPSideCanvas(parent, 0, this, false, true);
        this.pdpLeft = this.createPart(parent);
        this.pdpLeftCanvas.setSourceViewer(this.pdpLeft);
        this.pdpLeft.setDocument((IDocument)this.RPPDocument);
        this.pdpLeft.getTextWidget().getVerticalBar().setVisible(false);
        this.pdpRightCanvas = new PDPSideCanvas(parent, 0, this, false, true);
        this.pdpRight = this.createPart(parent);
        this.pdpRightCanvas.setSourceViewer(this.pdpRight);
        this.pdpRight.setDocument((IDocument)this.referenceDocument);
        this.pdpRight.getTextWidget().getVerticalBar().setVisible(false);
        this.fScrollCanvas = new Canvas(parent, 512);
        Rectangle trim = this.pdpLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = trim.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vpos = ((ScrollBar)e.widget).getSelection();
                PDPCobolMergeViewer.this.synchronizedScrollVertical(vpos);
            }
        });
        this.pdpBirdsEyeCanvas = new PDPBirdEyesCanvas(parent, 0, this);
    }

    protected SourceViewer getLeftSourceViewer() {
        return this.pdpLeft;
    }

    protected SourceViewer getRightSourceViewer() {
        return this.pdpRight;
    }

    protected char getLeg(SourceViewer sv) {
        if (sv == this.pdpLeft) {
            return '\u0002';
        }
        if (sv == this.pdpRight) {
            return '\u0003';
        }
        if (sv == this.pdpAncestor) {
            return '\u0001';
        }
        return '\u0001';
    }

    private SourceViewer getSourceViewer(char contributor) {
        if (contributor == '\u0002') {
            return this.pdpLeft;
        }
        if (contributor == '\u0003') {
            return this.pdpRight;
        }
        return this.pdpAncestor;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        return new SourceViewer(parent, (IVerticalRuler)new CompositeRuler(), textOrientation | 0x100 | 0x200);
    }

    private SourceViewer createPart(Composite parent) {
        final SourceViewer sv = this.createSourceViewer(parent, 0);
        StyledText te = sv.getTextWidget();
        te.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PDPCobolMergeViewer.this.paint(e, sv);
            }
        });
        sv.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalPosition) {
                PDPCobolMergeViewer.this.syncViewport(sv);
            }
        });
        return sv;
    }

    protected void createToolItems(ToolBarManager tbm) {
        int modes = tbm.indexOf("modes");
        int merge = tbm.indexOf("merge");
        int navig = tbm.indexOf("navigation");
        int i = modes + 1;
        if (i < merge) {
            this.pdpAncestorItem = (ActionContributionItem)tbm.getItems()[i];
        }
        if (-1 < merge && -1 < navig && merge < navig) {
            int ici = navig - 1;
            while (merge < ici) {
                IContributionItem iciCurr = tbm.getItems()[ici];
                tbm.remove(iciCurr);
                --ici;
            }
        }
        Action a = new Action(){

            public void run() {
            }
        };
        PDPCobolMergeViewer.initAction((IAction)a, this.getResourceBundle(), "action.NextDiff.");
        this.pdpNextDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.pdpNextDiff);
        a = new Action(){

            public void run() {
            }
        };
        PDPCobolMergeViewer.initAction((IAction)a, this.getResourceBundle(), "action.PrevDiff.");
        this.pdpPrevDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.pdpPrevDiff);
        a = new Action(){

            public void run() {
            }
        };
        PDPCobolMergeViewer.initAction((IAction)a, this.getResourceBundle(), "action.NextChange.");
        this.pdpNextChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.pdpNextChange);
        a = new Action(){

            public void run() {
            }
        };
        PDPCobolMergeViewer.initAction((IAction)a, this.getResourceBundle(), "action.PrevChange.");
        this.pdpPrevChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.pdpPrevChange);
    }

    protected void updateToolItems() {
    }

    private static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(PDPCobolMergeViewer.getString(bundle, labelKey, labelKey));
        a.setToolTipText(PDPCobolMergeViewer.getString(bundle, tooltipKey, null));
        a.setDescription(PDPCobolMergeViewer.getString(bundle, descriptionKey, null));
        String relPath = PDPCobolMergeViewer.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = PDPCobolMergeViewer.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = PDPCobolMergeViewer.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    private static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    private static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        MigrationHelpPlugin plugin = MigrationHelpPlugin.getDefault();
        plugin.getBundle();
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        if (url == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private void paint(PaintEvent event, SourceViewer tp) {
        Control canvas = (Control)event.widget;
        GC g = event.gc;
        Display display = canvas.getDisplay();
        int lineHeight = PDPCobolMergeViewer.getLineHeight(tp);
        int w = canvas.getSize().x;
        int shift = this.getVerticalScrollOffset(tp) + 1;
        int cfr_ignored_0 = event.y;
        int cfr_ignored_1 = event.height;
        shift += this.fTopInset;
        Point range = new Point(0, 0);
        char leg = this.getLeg(tp);
        PDPDifferencesIterator iterator = this.allChangesIterator();
        while (iterator.hasNext()) {
            PDPRangeDifference diff = iterator.next();
            if (diff.kind() == 0) continue;
            PDPCobolMergeViewer.getLineRange(tp, diff, leg, range);
            int y = range.x * lineHeight + shift;
            int h = range.y * lineHeight;
            g.setBackground(new Color((Device)display, this.strokeColor));
            g.fillRectangle(0, y - 1, w, 1);
            g.fillRectangle(0, y + h - 1, w, 1);
        }
    }

    private String getSymbolicFontName() {
        Class<?> clazz = this.getClass();
        do {
            String fontName = clazz.getName();
            if (!JFaceResources.getFontRegistry().hasValueFor(fontName)) continue;
            return fontName;
        } while ((clazz = clazz.getSuperclass()) != null);
        return this.getClass().getName();
    }

    private void updateFont() {
        Font f = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (f != null) {
            if (this.pdpAncestor != null) {
                this.setFont(this.pdpAncestor, f);
            }
            if (this.pdpLeft != null) {
                this.setFont(this.pdpLeft, f);
            }
            if (this.pdpRight != null) {
                this.setFont(this.pdpRight, f);
            }
        }
    }

    public void setFont(SourceViewer sv, Font font) {
        StyledText te = sv.getTextWidget();
        if (te != null) {
            te.setFont(font);
        }
    }

    protected final int getCenterWidth() {
        return 34;
    }

    protected Control getCenterControl() {
        return this.pdpCenter;
    }

    protected Canvas createCenterControl(Composite parent) {
        PDPCenterCanvas center = new PDPCenterCanvas(parent, 512, this);
        center.getVerticalBar().setVisible(false);
        this.pdpCenter = center;
        new PDPResizer((Control)center, 1);
        return center;
    }

    protected byte[] getContents(boolean left) {
        String contents;
        IDocument d;
        IDocument iDocument = d = left ? this.pdpLeft.getDocument() : this.pdpRight.getDocument();
        if (d != null && (contents = d.get()) != null) {
            return contents.getBytes();
        }
        return null;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.pdpAncestorLabel = null;
        this.pdpLeftLabel = null;
        this.pdpDirectionLabel = null;
        this.pdpRightLabel = null;
        this.pdpCenter = null;
        this.pdpLeftCanvas = null;
        this.pdpRightCanvas = null;
        this.fVScrollBar = null;
        this.pdpBirdsEyeCanvas = null;
        if (this.pdpBirdsEyeCursor != null) {
            this.pdpBirdsEyeCursor.dispose();
            this.pdpBirdsEyeCursor = null;
        }
        if (this.pdpNormalCursor != null) {
            this.pdpNormalCursor.dispose();
            this.pdpNormalCursor = null;
        }
        if (this.pdpHSashCursor != null) {
            this.pdpHSashCursor.dispose();
            this.pdpHSashCursor = null;
        }
        if (this.pdpVSashCursor != null) {
            this.pdpVSashCursor.dispose();
            this.pdpVSashCursor = null;
        }
        if (this.pdpHVSashCursor != null) {
            this.pdpHVSashCursor.dispose();
            this.pdpHVSashCursor = null;
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        boolean vis;
        String key = event.getProperty();
        if (-1 < key.indexOf("AncestorVisible") && this.pdpAncestorVisible != (vis = ((Boolean)event.getNewValue()).booleanValue())) {
            this.pdpAncestorVisible = vis;
        }
        super.handlePropertyChangeEvent(event);
    }

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            Rectangle trim = this.pdpLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            this.pdpAncestorCanvas.setVisible(true);
            this.pdpAncestor.getTextWidget().setVisible(true);
            if (this.pdpAncestorCanvas != null) {
                this.pdpAncestorCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
                width -= this.fMarginWidth;
            }
            PDPCobolMergeViewer.setBounds(this.pdpAncestor, x, y, width, height);
        } else {
            this.pdpAncestorCanvas.setVisible(false);
            StyledText t = this.pdpAncestor.getTextWidget();
            t.setVisible(false);
            PDPCobolMergeViewer.setBounds(this.pdpAncestor, 0, 0, 0, 0);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        if (this.pdpBirdsEyeCanvas != null) {
            width2 -= 12;
        }
        Rectangle trim = this.pdpLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        int scrollbarHeight = trim.height + trim.x;
        Composite cfr_ignored_0 = (Composite)this.getControl();
        int leftTextWidth = width1;
        if (this.pdpLeftCanvas != null) {
            this.pdpLeftCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
            leftTextWidth -= this.fMarginWidth;
        }
        PDPCobolMergeViewer.setBounds(this.pdpLeft, x, y, leftTextWidth, height);
        x += leftTextWidth;
        if (this.pdpCenter != null) {
            this.pdpCenter.setBounds(x, y, centerWidth, height - scrollbarHeight);
        }
        x += centerWidth;
        int scrollbarWidth = 0;
        trim = this.pdpLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        scrollbarWidth = trim.width + 2 * trim.x + 1;
        int rightTextWidth = width2 - scrollbarWidth;
        if (this.pdpRightCanvas != null) {
            rightTextWidth -= this.fMarginWidth;
        }
        PDPCobolMergeViewer.setBounds(this.pdpRight, x, y, rightTextWidth, height);
        x += rightTextWidth;
        if (this.pdpRightCanvas != null) {
            this.pdpRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
        }
        if (this.fScrollCanvas != null) {
            this.fScrollCanvas.setBounds(x, y, scrollbarWidth, height - scrollbarHeight);
        }
        if (this.pdpBirdsEyeCanvas != null) {
            int verticalScrollbarButtonHeight = scrollbarWidth;
            int horizontalScrollbarButtonHeight = scrollbarHeight;
            this.pdpBirdsEyeCanvas.setBounds(x + scrollbarWidth, y += verticalScrollbarButtonHeight, 12, height - (2 * verticalScrollbarButtonHeight + horizontalScrollbarButtonHeight));
        }
        this.updateVScrollBar();
    }

    protected boolean hasChanges() {
        return this.linesDifferences != null && this.linesDifferences.length > 0;
    }

    protected PDPDifferencesIterator changesIterator() {
        return new PDPDifferencesIterator();
    }

    protected PDPDifferencesIterator allChangesIterator() {
        return new PDPDifferencesIterator(true);
    }

    private void doDiff() {
        new PDPRangeFactory(0);
        PDPCobolLineComparator left = new PDPCobolLineComparator(this.pdpLeft.getDocument().get());
        PDPCobolLineComparator right = new PDPCobolLineComparator(this.pdpRight.getDocument().get());
        RangeDifference[] work = RangeDifferencer.findRanges((IRangeComparator)left, (IRangeComparator)right);
        this.linesDifferences = new PDPRangeDifference[work.length];
        int d = 0;
        while (d < work.length) {
            PDPRangeDifference dif;
            this.linesDifferences[d] = dif = new PDPRangeDifference(work[d]);
            ++d;
        }
        this.linesWithSecondLevelDifferences = new PDPRangeDifference[work.length];
        d = 0;
        while (d < work.length) {
            RangeDifference diff = work[d];
            RangeDifference diff1 = d + 1 < work.length ? work[d + 1] : null;
            PDPRangeDifference pdpRD = new PDPRangeDifference(diff, diff1, left, right);
            pdpRD.testReformatted();
            this.linesWithSecondLevelDifferences[d] = pdpRD;
            ++d;
        }
        d = 0;
        while (d < this.linesWithSecondLevelDifferences.length) {
            PDPRangeDifference pdpRD = this.linesWithSecondLevelDifferences[d];
            int leftLine = pdpRD.leftStart();
            int leftNbLines = pdpRD.leftLength();
            int leftSO = pdpRD.leftTokensStartOffset();
            int leftLen = pdpRD.leftTokensLength();
            pdpRD.reformat();
            int rightLine = pdpRD.rightStart();
            int rightNbLines = pdpRD.rightLength();
            int rightSO = pdpRD.rightTokensStartOffset();
            int rightLen = pdpRD.rightTokensLength();
            try {
                String cfr_ignored_0 = "===>diff=" + d + ",Left Line=" + leftLine + ",number of Lines=" + leftNbLines;
                this.pdpLeft.getDocument().get(leftSO, leftLen);
                String cfr_ignored_1 = "===>diff=" + d + ",Right Line=" + rightLine + ",number of Lines=" + rightNbLines;
                this.pdpRight.getDocument().get(rightSO, rightLen);
            }
            catch (Exception exception) {}
            ++d;
        }
    }

    protected PDPRangeDifference findDiff(int viewportHeight, Point size, int my) {
        int virtualHeight = this.getMergerVirtualHeight();
        if (virtualHeight < viewportHeight) {
            return null;
        }
        int y = 0;
        if (this.hasChanges()) {
            PDPDifferencesIterator e = this.allChangesIterator();
            while (e.hasNext()) {
                PDPRangeDifference diff = e.next();
                int h = diff.maxLength();
                if (diff.kind() != 0 || diff.ReformattedAndEqual()) {
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if (my >= yy && my < yy + hh) {
                        return diff;
                    }
                }
                y += h;
            }
        }
        return null;
    }

    protected void setCurrentDiff(PDPRangeDifference diff, boolean revealAndSelect) {
        this.pdpLeft.setSelectedRange(diff.leftTokensStartOffset(), diff.leftTokensLength());
        this.pdpRight.setSelectedRange(diff.rightTokensStartOffset(), diff.rightTokensLength());
        this.revealDiff(diff);
    }

    private void revealDiff(PDPRangeDifference d) {
        boolean ancestorIsVisible = false;
        boolean leftIsVisible = false;
        boolean rightIsVisible = false;
        if (!leftIsVisible || !rightIsVisible) {
            int avpos = 0;
            int lvpos = 0;
            int rvpos = 0;
            SourceViewer allButThis = null;
            if (leftIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('\u0002', this.pdpLeft.getTopIndex());
                avpos = rvpos;
                allButThis = this.pdpLeft;
            } else if (rightIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('\u0003', this.pdpRight.getTopIndex());
                avpos = rvpos;
                allButThis = this.pdpRight;
            } else if (ancestorIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('\u0001', this.pdpAncestor.getTopIndex());
                avpos = rvpos;
                allButThis = this.pdpAncestor;
            } else {
                int vpos = 0;
                PDPDifferencesIterator iterator = this.allChangesIterator();
                while (iterator.hasNext()) {
                    PDPRangeDifference diff = iterator.next();
                    if (diff == d) break;
                    vpos += diff.maxLength();
                }
                lvpos = rvpos = vpos;
                avpos = rvpos;
                int delta = PDPCobolMergeViewer.getViewportLines(this.pdpRight) / 4;
                if ((avpos -= delta) < 0) {
                    avpos = 0;
                }
                if ((lvpos -= delta) < 0) {
                    lvpos = 0;
                }
                if ((rvpos -= delta) < 0) {
                    rvpos = 0;
                }
            }
            this.scrollVertical(avpos, lvpos, rvpos, allButThis);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(avpos);
            }
        }
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        MigrationCompareEditorInput.StringInput leftSi = (MigrationCompareEditorInput.StringInput)left;
        MigrationCompareEditorInput.StringInput rightSi = (MigrationCompareEditorInput.StringInput)right;
        if (this.pdpAncestor.getDocument() == null) {
            this.pdpAncestor.setDocument((IDocument)this.ancestorDocument);
        }
        if (this.pdpLeft.getDocument() == null) {
            this.pdpLeft.setDocument((IDocument)this.RPPDocument);
        }
        this.pdpLeft.getDocument().set(leftSi != null ? leftSi.getString() : "");
        this.nbLinesOfRPP = this.pdpLeft.getDocument().getNumberOfLines();
        if (this.pdpRight.getDocument() == null) {
            this.referenceDocument = new Document(right != null ? rightSi.getString() : "");
            this.pdpRight.setDocument((IDocument)this.referenceDocument);
        } else {
            this.pdpRight.getDocument().set(right != null ? rightSi.getString() : "");
        }
        this.nbLinesOfReference = this.pdpRight.getDocument().getNumberOfLines();
        this.updateVScrollBar();
        this.doDiff();
    }

    protected int getMergerVirtualHeight() {
        return Math.max(this.nbLinesOfRPP, this.nbLinesOfReference);
    }

    protected int getLeftNumberOfLines() {
        return this.nbLinesOfRPP;
    }

    protected int getRightNumberOfLines() {
        return this.nbLinesOfReference;
    }

    private void updateVScrollBar() {
        int virtualHeight = this.getMergerVirtualHeight();
        int viewPortHeight = this.getViewportHeight();
        int pageIncrement = viewPortHeight - 1;
        int thumb = viewPortHeight > virtualHeight ? virtualHeight : viewPortHeight;
        this.fVScrollBar.setPageIncrement(pageIncrement);
        this.fVScrollBar.setMaximum(virtualHeight);
        this.fVScrollBar.setThumb(thumb);
    }

    private void synchronizedScrollVertical(int vpos) {
        this.scrollVertical(vpos, vpos, vpos, null);
    }

    private void syncViewport(SourceViewer sv) {
        if (this.fInScrolling) {
            return;
        }
        int ix = sv.getTopIndex();
        int ix2 = PDPCobolMergeViewer.getDocumentRegionOffset(sv);
        int viewPosition = this.realToVirtualPosition(this.getLeg(sv), ix - ix2);
        this.scrollVertical(viewPosition, viewPosition, viewPosition, sv);
        if (this.fVScrollBar != null) {
            int value = Math.max(0, Math.min(viewPosition, this.getMergerVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(value);
        }
    }

    private void scrollVertical(int avpos, int lvpos, int rvpos, SourceViewer allBut) {
        int y;
        int s = 0;
        s = this.getMergerVirtualHeight() - rvpos;
        int height = PDPCobolMergeViewer.getViewportLines(this.pdpRight) / 4;
        if (s < 0) {
            s = 0;
        }
        if (s > height) {
            s = height;
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && allBut != this.pdpAncestor && allBut == null) {
            y = this.virtualToRealPosition('\u0001', avpos + s) - s;
            this.vscroll(this.pdpAncestor, y);
        }
        if (allBut != this.pdpLeft && allBut == null) {
            y = this.virtualToRealPosition('\u0002', lvpos + s) - s;
            this.vscroll(this.pdpLeft, y);
        }
        if (allBut != this.pdpRight && allBut == null) {
            y = this.virtualToRealPosition('\u0003', rvpos + s) - s;
            this.vscroll(this.pdpRight, y);
        }
        this.fInScrolling = false;
        if (this.isThreeWay()) {
            // empty if block
        }
        if (this.pdpLeftCanvas != null) {
            this.pdpLeftCanvas.repaint();
        }
        Rectangle rect = this.getControl().getBounds();
        ++rect.height;
        this.getControl().setBounds(rect);
        --rect.height;
        this.getControl().setBounds(rect);
        if (this.pdpCenter != null) {
            this.pdpCenter.repaint();
        }
        if (this.pdpRightCanvas != null) {
            this.pdpRightCanvas.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int realToVirtualPosition(char contributor, int vpos) {
        viewPos = 0;
        virtualPos = 0;
        region = new Point(0, 0);
        e = this.allChangesIterator();
        if (e.hasNext()) ** GOTO lbl18
        return vpos;
lbl-1000:
        // 1 sources

        {
            diff = e.next();
            PDPCobolMergeViewer.getLineRange(this.getSourceViewer(contributor), diff, contributor, region);
            realHeight = region.y;
            virtualHeight = diff.maxLength();
            if (vpos <= viewPos + realHeight) {
                vpos -= viewPos;
                vpos = realHeight <= 0 ? 0 : vpos * virtualHeight / realHeight;
                return virtualPos + vpos;
            }
            viewPos += realHeight;
            virtualPos += virtualHeight;
lbl18:
            // 2 sources

            ** while (e.hasNext())
        }
lbl19:
        // 1 sources

        return virtualPos;
    }

    /*
     * Unable to fully structure code
     */
    private int virtualToRealPosition(char contributor, int v) {
        virtualPos = 0;
        viewPos = 0;
        region = new Point(0, 0);
        e = this.allChangesIterator();
        if (e.hasNext()) ** GOTO lbl18
        return v;
lbl-1000:
        // 1 sources

        {
            diff = e.next();
            PDPCobolMergeViewer.getLineRange(this.getSourceViewer(contributor), diff, contributor, region);
            viewHeight = region.y;
            virtualHeight = diff.maxLength();
            if (v < virtualPos + virtualHeight) {
                v -= virtualPos;
                v = viewHeight <= 0 ? 0 : (int)((double)v * ((double)viewHeight / (double)virtualHeight));
                return viewPos + v;
            }
            virtualPos += virtualHeight;
            viewPos += viewHeight;
lbl18:
            // 2 sources

            ** while (e.hasNext())
        }
lbl19:
        // 1 sources

        return viewPos;
    }

    private void vscroll(SourceViewer sv, int line) {
        int srcExtentSize;
        int srcViewSize = PDPCobolMergeViewer.getLineCount(sv);
        if (srcViewSize > (srcExtentSize = PDPCobolMergeViewer.getViewportLines(sv))) {
            int cp;
            if (line < 0) {
                line = 0;
            }
            if ((cp = sv.getTopIndex()) != line) {
                sv.setTopIndex(line + PDPCobolMergeViewer.getDocumentRegionOffset(sv));
            }
        }
    }

    private static int getDocumentRegionOffset(SourceViewer sv) {
        int start = sv.getVisibleRegion().getOffset();
        IDocument doc = sv.getDocument();
        if (doc != null) {
            try {
                return doc.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    private static int getLineCount(SourceViewer sv) {
        IRegion region = sv.getVisibleRegion();
        int length = region.getLength();
        if (length == 0) {
            return 0;
        }
        IDocument doc = sv.getDocument();
        int startLine = 0;
        int endLine = 0;
        int start = region.getOffset();
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        try {
            endLine = doc.getLineOfOffset(start + length);
        }
        catch (BadLocationException badLocationException) {}
        return endLine - startLine + 1;
    }

    private static int getViewportLines(SourceViewer sv) {
        StyledText te = sv.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / te.getLineHeight();
        }
        return 0;
    }

    protected static void setSelection(SourceViewer sv, Position position) {
        if (position != null) {
            sv.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    protected static int getLineHeight(SourceViewer sv) {
        return sv.getTextWidget().getLineHeight();
    }

    protected int getVerticalScrollOffset(SourceViewer sv) {
        StyledText st = sv.getTextWidget();
        int lineHeight = st.getLineHeight();
        return sv.getTopInset() - (PDPCobolMergeViewer.getDocumentRegionOffset(sv) * lineHeight + st.getTopPixel());
    }

    protected int getViewportHeight() {
        StyledText te = this.pdpLeft.getTextWidget();
        int vh = te.getClientArea().height;
        if (vh == 0) {
            Rectangle trim = te.computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            int headerHeight = this.getPDPHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle r = composite.getClientArea();
            vh = r.height - headerHeight - scrollbarHeight;
        }
        return vh / te.getLineHeight();
    }

    protected static int getViewportHeight(SourceViewer sv) {
        StyledText te = sv.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height;
        }
        return 0;
    }

    protected static Point getLineRange(SourceViewer sv, PDPRangeDifference rd, char contributor, Point region) {
        int start;
        IDocument doc = sv.getDocument();
        if (rd == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int n = contributor == '\u0002' ? rd.leftStart() : (start = contributor == '\u0003' ? rd.rightStart() : rd.ancestorStart());
        int length = contributor == '\u0002' ? rd.leftLength() : (contributor == '\u0003' ? rd.rightLength() : rd.ancestorLength());
        region.x = start;
        region.y = length;
        return region;
    }

    private int getPDPHeaderHeight() {
        return 19;
    }

    private static void setBounds(SourceViewer sw, int x, int y, int width, int height) {
        if (sw.getControl() instanceof Composite) {
            ((Composite)sw.getControl()).setBounds(x, y, width, height);
        } else {
            sw.getTextWidget().setBounds(x, y, width, height);
        }
    }

    private void pdpLayout() {
        int headerHeight = this.pdpLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
        Rectangle r = ((Composite)this.getControl()).getClientArea();
        int centerWidth = this.getCenterWidth();
        int width1 = (int)((double)(r.width - centerWidth) * this.getHorizontalSplitRatio());
        int width2 = r.width - width1 - centerWidth;
        int height1 = 0;
        int height2 = 0;
        if (this.pdpAncestorVisible) {
            height1 = (int)((double)(r.height - 2 * headerHeight) * this.pdpVSplit);
            height2 = r.height - 2 * headerHeight - height1;
        } else {
            height1 = 0;
            height2 = r.height - headerHeight;
        }
        int y = 0;
        if (this.pdpAncestorVisible) {
            this.pdpAncestorLabel.setBounds(0, y, r.width, headerHeight);
            this.pdpAncestorLabel.setVisible(true);
            this.handleResizeAncestor(0, y += headerHeight, r.width, height1);
            y += height1;
        } else {
            this.pdpAncestorLabel.setVisible(false);
            this.handleResizeAncestor(0, 0, 0, 0);
        }
        this.pdpLeftLabel.getSize();
        if (centerWidth > 3) {
            this.pdpLeftLabel.setBounds(0, y, width1 + 1, headerHeight);
            this.pdpDirectionLabel.setVisible(true);
            this.pdpDirectionLabel.setBounds(width1 + 1, y, centerWidth - 1, headerHeight);
            this.pdpRightLabel.setBounds(width1 + centerWidth, y, width2, headerHeight);
        } else {
            this.pdpLeftLabel.setBounds(0, y, width1, headerHeight);
            this.pdpDirectionLabel.setVisible(false);
            this.pdpRightLabel.setBounds(width1, y, r.width - width1, headerHeight);
        }
        y += headerHeight;
        if (this.pdpCenter != null && !this.pdpCenter.isDisposed()) {
            this.pdpCenter.setBounds(width1, y, centerWidth, height2);
        }
        this.handleResizeLeftRight(0, y, width1, centerWidth, width2, height2);
    }

    private double getHorizontalSplitRatio() {
        if (this.pdpHSplit < 0.0) {
            Object input = this.getInput();
            if (input instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)input;
                if (ci.getLeft() == null) {
                    return 0.1;
                }
                if (ci.getRight() == null) {
                    return 0.9;
                }
            }
            return 0.5;
        }
        return this.pdpHSplit;
    }

    private void updatePdpCursor(Control c, int dir) {
        if (!(c instanceof Sash)) {
            Cursor cursor = null;
            switch (dir) {
                case 2: {
                    if (this.pdpAncestorItem.isEnabled()) {
                        if (this.pdpVSashCursor == null) {
                            this.pdpVSashCursor = new Cursor((Device)c.getDisplay(), 7);
                        }
                        cursor = this.pdpVSashCursor;
                        break;
                    }
                    if (this.pdpNormalCursor == null) {
                        this.pdpNormalCursor = new Cursor((Device)c.getDisplay(), 0);
                    }
                    cursor = this.pdpNormalCursor;
                    break;
                }
                case 1: {
                    if (this.pdpHSashCursor == null) {
                        this.pdpHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.pdpHSashCursor;
                    break;
                }
                case 3: {
                    if (this.pdpAncestorItem.isEnabled()) {
                        if (this.pdpHVSashCursor == null) {
                            this.pdpHVSashCursor = new Cursor((Device)c.getDisplay(), 5);
                        }
                        cursor = this.pdpHVSashCursor;
                        break;
                    }
                    if (this.pdpHSashCursor == null) {
                        this.pdpHSashCursor = new Cursor((Device)c.getDisplay(), 9);
                    }
                    cursor = this.pdpHSashCursor;
                }
            }
            if (cursor != null) {
                c.setCursor(cursor);
            }
        }
    }

    protected class PDPDifferencesIterator
    implements Iterator<PDPRangeDifference> {
        int rank;
        boolean onlyLines;

        public PDPDifferencesIterator() {
            this.onlyLines = true;
            this.rank = 0;
        }

        public PDPDifferencesIterator(boolean secondLevel) {
            this.onlyLines = !secondLevel;
            this.rank = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.onlyLines) {
                return PDPCobolMergeViewer.this.linesDifferences != null && this.rank < PDPCobolMergeViewer.this.linesDifferences.length;
            }
            return PDPCobolMergeViewer.this.linesWithSecondLevelDifferences != null && this.rank < PDPCobolMergeViewer.this.linesWithSecondLevelDifferences.length;
        }

        @Override
        public PDPRangeDifference next() {
            int curr = this.rank++;
            if (this.onlyLines) {
                return PDPCobolMergeViewer.this.linesDifferences[curr];
            }
            return PDPCobolMergeViewer.this.linesWithSecondLevelDifferences[curr];
        }

        @Override
        public void remove() {
        }
    }

    private class PDPRangeFactory
    extends RangeDifference {
        public PDPRangeFactory(int i) {
            super(i);
        }
    }

    private class PDPResizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public PDPResizer(Control c, int dir) {
            Listener[] mm;
            this.fDirection = dir;
            this.fControl = c;
            this.fLiveResize = !(this.fControl instanceof Sash);
            PDPCobolMergeViewer.this.updatePdpCursor(c, dir);
            Listener[] md = this.fControl.getListeners(3);
            if (md.length == 1) {
                this.fControl.removeListener(3, md[0]);
            }
            if ((mm = this.fControl.getListeners(5)).length == 1) {
                this.fControl.removeListener(5, md[0]);
            }
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PDPResizer.this.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
            if ((this.fDirection & 1) != 0) {
                PDPCobolMergeViewer.this.pdpHSplit = -1.0;
            }
            if ((this.fDirection & 2) != 0) {
                PDPCobolMergeViewer.this.pdpVSplit = 0.3;
            }
            ((Composite)PDPCobolMergeViewer.this.getControl()).layout(true);
        }

        public void mouseDown(MouseEvent e) {
            Composite parent = this.fControl.getParent();
            Point s = parent.getSize();
            Point as = PDPCobolMergeViewer.this.pdpAncestorLabel.getSize();
            Point ys = PDPCobolMergeViewer.this.pdpLeftLabel.getSize();
            Point ms = PDPCobolMergeViewer.this.pdpRightLabel.getSize();
            this.fWidth1 = ys.x;
            this.fWidth2 = ms.x;
            this.fHeight1 = ((PDPCobolMergeViewer)PDPCobolMergeViewer.this).pdpLeftLabel.getLocation().y - as.y;
            this.fHeight2 = s.y - (((PDPCobolMergeViewer)PDPCobolMergeViewer.this).pdpLeftLabel.getLocation().y + ys.y);
            this.fX = e.x;
            this.fY = e.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent e) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(e);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(e);
            }
        }

        private void resize(MouseEvent e) {
            int dx = e.x - this.fX;
            int dy = e.y - this.fY;
            int centerWidth = ((PDPCobolMergeViewer)PDPCobolMergeViewer.this).pdpCenter.getSize().x;
            if (this.fWidth1 + dx > centerWidth && this.fWidth2 - dx > centerWidth) {
                this.fWidth1 += dx;
                this.fWidth2 -= dx;
                if ((this.fDirection & 1) != 0) {
                    PDPCobolMergeViewer.this.pdpHSplit = (double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2);
                }
            }
            if (this.fHeight1 + dy > centerWidth && this.fHeight2 - dy > centerWidth) {
                this.fHeight1 += dy;
                this.fHeight2 -= dy;
                if ((this.fDirection & 2) != 0) {
                    PDPCobolMergeViewer.this.pdpVSplit = (double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2);
                }
            }
            PDPCobolMergeViewer.this.pdpLayout();
            this.fControl.getDisplay().update();
        }
    }
}

