/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.runtime.Assert;

public class PDPCobolLineComparator
implements ITokenComparator {
    private String fText;
    private int fCount;
    private int[] fStarts;
    private int[] fLengths;
    private boolean[] fComments;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPCobolLineComparator(String text) {
        Assert.isNotNull((Object)text);
        this.fText = text;
        int length = this.fText.length();
        this.fStarts = new int[length];
        this.fLengths = new int[length];
        this.fComments = new boolean[length];
        this.fCount = 0;
        int startOfLine = 0;
        boolean noSignificantZone = false;
        int i = 0;
        while (i < length) {
            char c = this.fText.charAt(i);
            if (i - startOfLine == 6 && c == '*') {
                this.fStarts[this.fCount] = i;
                this.fComments[this.fCount] = true;
                int n = this.fCount;
                this.fLengths[n] = this.fLengths[n] + 1;
            } else if (i - startOfLine == 6 && c != '*') {
                this.fStarts[this.fCount] = i;
                this.fComments[this.fCount] = false;
                int n = this.fCount;
                this.fLengths[n] = this.fLengths[n] + 1;
            }
            if (i - startOfLine < 7 || i - startOfLine > 72) {
                noSignificantZone = true;
            } else {
                noSignificantZone = false;
                if (Character.isWhitespace(c) || Character.isDigit(c) || Character.isLetter(c) || c == '\"' || c == '\'') {
                    // empty if block
                }
            }
            if (c == '\n') {
                ++this.fCount;
                startOfLine = i + 1;
            }
            if (!noSignificantZone) {
                int n = this.fCount;
                this.fLengths[n] = this.fLengths[n] + 1;
            }
            ++i;
        }
    }

    public int getRangeCount() {
        return this.fCount;
    }

    public String getText() {
        return this.fText;
    }

    public int getTokenStart(int index) {
        if (index < this.fCount) {
            return this.fStarts[index];
        }
        return this.fText.length();
    }

    public int getTokenLength(int index) {
        if (index < this.fCount) {
            return this.fLengths[index];
        }
        return 0;
    }

    public boolean isComment(int index) {
        if (index < this.fCount) {
            return this.fComments[index];
        }
        return false;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && this.getClass() == other.getClass()) {
            int otherLen;
            PDPCobolLineComparator lc = (PDPCobolLineComparator)other;
            int thisLen = this.getTokenLength(thisIndex);
            if (thisLen == (otherLen = lc.getTokenLength(otherIndex))) {
                return this.fText.regionMatches(false, this.getTokenStart(thisIndex), lc.fText, lc.getTokenStart(otherIndex), thisLen);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        if (this.getRangeCount() < 50 || other.getRangeCount() < 50) {
            return false;
        }
        if (max < 100) {
            return false;
        }
        if (length < 100) {
            return false;
        }
        if (max > 800) {
            return true;
        }
        return length >= max / 4;
    }
}

