/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.quickfix.PDPCanvas;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolMergeViewer;
import com.ibm.pdp.pac.migration.help.quickfix.PDPRangeDifference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PDPCenterCanvas
extends PDPCanvas {
    private static final int RESOLVE_SIZE = 5;
    private int[] fPts = new int[8];
    private double[] fBasicCenterCurve;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPCenterCanvas(Composite parent, int flags, PDPCobolMergeViewer pdpcmv) {
        super(parent, flags | 0x40000, pdpcmv);
    }

    @Override
    public void doPaint(GC gc) {
        this.paintCenter(gc, this);
    }

    private void paintCenter(GC g, Canvas canvas) {
        Display display = canvas.getDisplay();
        int lineHeightLeft = this.pdpcmv.getLeftSourceViewer().getTextWidget().getLineHeight();
        int lineHeightRight = this.pdpcmv.getRightSourceViewer().getTextWidget().getLineHeight();
        int visibleHeight = PDPCobolMergeViewer.getViewportHeight(this.pdpcmv.getRightSourceViewer());
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        g.setBackground(display.getSystemColor(18));
        g.fillRectangle(0, 0, 1, size.y);
        g.fillRectangle(w - 1, 0, 1, size.y);
        if (this.pdpcmv.hasChanges()) {
            int lshift = this.pdpcmv.getVerticalScrollOffset(this.pdpcmv.getLeftSourceViewer());
            int rshift = this.pdpcmv.getVerticalScrollOffset(this.pdpcmv.getRightSourceViewer());
            Point region = new Point(0, 0);
            PDPCobolMergeViewer.PDPDifferencesIterator iterator = this.pdpcmv.allChangesIterator();
            while (iterator.hasNext()) {
                int i;
                PDPRangeDifference diff = iterator.next();
                if (diff.kind() == 0) continue;
                PDPCobolMergeViewer.getLineRange(this.pdpcmv.getLeftSourceViewer(), diff, '\u0002', region);
                int ly = region.x * lineHeightLeft + lshift;
                int lh = region.y * lineHeightLeft;
                PDPCobolMergeViewer.getLineRange(this.pdpcmv.getRightSourceViewer(), diff, '\u0003', region);
                int ry = region.x * lineHeightRight + rshift;
                int rh = region.y * lineHeightRight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                this.fPts[0] = x;
                this.fPts[1] = ly;
                this.fPts[2] = w;
                this.fPts[3] = ry;
                this.fPts[6] = x;
                this.fPts[7] = ly + lh;
                this.fPts[4] = w;
                this.fPts[5] = ry + rh;
                Color fillColor = new Color((Device)display, this.RGBfillColor);
                Color strokeColor = new Color((Device)display, this.RGBstrokeColor);
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh);
                    g.drawRectangle(w - w2, ry, w2, rh);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(this.fPts);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    g.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine) continue;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                g.setBackground(fillColor);
                g.fillRectangle(cx, cy, 5, 5);
                g.setForeground(strokeColor);
                g.drawRectangle(cx, cy, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.pdpcmv.getCenterWidth()];
        int i = 0;
        while (i < this.pdpcmv.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }
}

