/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolMergeViewer;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCompareConstants;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class PDPCanvas
extends Canvas
implements PDPCompareConstants {
    protected RGB RGBstrokeColor = new RGB(255, 0, 0);
    protected RGB RGBfillColor = new RGB(0, 0, 255);
    private Image fBuffer;
    protected SourceViewer sourceViewer;
    protected PDPCobolMergeViewer pdpcmv;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPCanvas(Composite parent, int flags, PDPCobolMergeViewer mw) {
        super(parent, flags | 0x40000);
        this.pdpcmv = mw;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                PDPCanvas.this.doubleBufferPaint(event.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PDPCanvas.this.fBuffer != null) {
                    PDPCanvas.this.fBuffer.dispose();
                    PDPCanvas.this.fBuffer = null;
                }
            }
        });
    }

    public void setSourceViewer(SourceViewer sv) {
        this.sourceViewer = sv;
    }

    public void repaint() {
        if (!this.isDisposed()) {
            GC gc = new GC((Drawable)this);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    void doubleBufferPaint(GC dest) {
        Point size = this.getSize();
        if (size.x <= 1 || size.y <= 1) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    public abstract void doPaint(GC var1);
}

