/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.pac.migration.help.quickfix.PDPCanvas;
import com.ibm.pdp.pac.migration.help.quickfix.PDPCobolMergeViewer;
import com.ibm.pdp.pac.migration.help.quickfix.PDPRangeDifference;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PDPBirdEyesCanvas
extends PDPCanvas {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPBirdEyesCanvas(Composite parent, int flags, PDPCobolMergeViewer pdpcmv) {
        super(parent, flags | 0x40000, pdpcmv);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PDPBirdEyesCanvas bird = PDPBirdEyesCanvas.this;
                PDPCobolMergeViewer cmv = bird.pdpcmv;
                int height = cmv.getViewportHeight();
                PDPRangeDifference diff = cmv.findDiff(height, bird.getSize(), e.y);
                if (diff == null || diff.kind() == 0 && !diff.ReformattedAndEqual()) {
                    return;
                }
                cmv.setCurrentDiff(diff, true);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent e) {
                Cursor cursor = null;
                PDPBirdEyesCanvas bird = PDPBirdEyesCanvas.this;
                PDPCobolMergeViewer cmv = bird.pdpcmv;
                int height = cmv.getViewportHeight();
                PDPRangeDifference diff = cmv.findDiff(height, bird.getSize(), e.y);
                if (diff != null && diff.kind() != 0) {
                    cursor = cmv.pdpBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    bird.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
    }

    @Override
    public void doPaint(GC gc) {
        this.paintBirdsEyeView(gc, this);
    }

    private void paintBirdsEyeView(GC gc, Canvas canvas) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Point size = canvas.getSize();
        int virtualHeight = this.pdpcmv.getMergerVirtualHeight();
        if (virtualHeight < this.pdpcmv.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int y = 0;
        PDPCobolMergeViewer.PDPDifferencesIterator iterator = this.pdpcmv.allChangesIterator();
        while (iterator.hasNext()) {
            PDPRangeDifference diff = iterator.next();
            int h = diff.maxLength();
            if (diff.kind() != 0) {
                Color c;
                int yy = y * size.y / virtualHeight;
                int hh = h * size.y / virtualHeight;
                if (hh < 3) {
                    hh = 3;
                }
                if ((c = new Color((Device)display, this.RGBfillColor)) != null) {
                    gc.setBackground(c);
                    gc.fillRectangle(2, yy, size.x - 4, hh);
                }
                if ((c = new Color((Device)display, this.RGBstrokeColor)) != null) {
                    gc.setForeground(c);
                    r.x = 2;
                    r.y = yy;
                    r.width = size.x - 4 - 1;
                    r.height = hh;
                    gc.setLineWidth(2);
                    ++r.x;
                    ++r.y;
                    --r.width;
                    --r.height;
                    gc.drawRectangle(r);
                }
            }
            y += h;
        }
    }
}

