/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.pac.migration.help.quickfix.Messages;
import com.ibm.pdp.pac.migration.help.quickfix.MigrationMarkerResolution;
import com.ibm.pdp.pac.migration.help.quickfix.RemoveMigrationControlQuickFixAction;
import com.ibm.pdp.pac.migration.help.quickfix.RemoveMigrationWarningQuickFixAction;
import com.ibm.pdp.pac.migration.help.quickfix.ShowAllDifferencesQuickFixAction;
import com.ibm.pdp.pac.migration.help.quickfix.ShowDifferenceQuickFixAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MigrationMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static IMarkerResolution[] EMPTY_ARRAY = new IMarkerResolution[0];
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            int severity = marker.getAttribute("severity", 0);
            if (severity == 0) {
                String fileName = marker.getResource().getFullPath().toString();
                IMarkerResolution[] markerResolutions = new IMarkerResolution[]{new MigrationMarkerResolution(new RemoveMigrationControlQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Remove_migration_control, null, fileName)), new MigrationMarkerResolution(new ShowAllDifferencesQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Show_all_differences, null, fileName))};
                return markerResolutions;
            }
            IMarkerResolution[] markerResolutions = new IMarkerResolution[4];
            int startGeneratedCode = marker.getAttribute("START_GENERATED_INDEX_ATTRIBUTE", 0);
            int stopGeneratedCode = marker.getAttribute("STOP_GENERATED_INDEX_ATTRIBUTE", 0);
            int startControlCode = marker.getAttribute("START_CONTROL_INDEX_ATTRIBUTE", 0);
            int stopControlCode = marker.getAttribute("STOP_CONTROL_INDEX_ATTRIBUTE", 0);
            String fileName = marker.getResource().getFullPath().toString();
            RemoveMigrationWarningQuickFixAction mqfa = new RemoveMigrationWarningQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Remove_warning, null, fileName, startGeneratedCode, stopGeneratedCode, startControlCode, stopControlCode);
            markerResolutions[1] = new MigrationMarkerResolution(mqfa);
            String fileLocation = marker.getResource().getLocation().toString();
            ControllerFactory.getInstance().getController(fileName);
            int extensionIndex = fileLocation.lastIndexOf(".");
            String cblLighGeneratedFileName = String.valueOf(fileLocation.substring(0, extensionIndex)) + "_control" + fileLocation.substring(extensionIndex);
            markerResolutions[0] = new MigrationMarkerResolution(new ShowDifferenceQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Show_differences, null, fileName, cblLighGeneratedFileName, startGeneratedCode, stopGeneratedCode, startControlCode, stopControlCode));
            markerResolutions[2] = new MigrationMarkerResolution(new RemoveMigrationControlQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Remove_all, null, fileName));
            markerResolutions[3] = new MigrationMarkerResolution(new ShowAllDifferencesQuickFixAction(Messages.MigrationMarkerResolutionGenerator_Show_all_differences, null, fileName));
            return markerResolutions;
        }
        catch (NullPointerException nullPointerException) {
            return EMPTY_ARRAY;
        }
    }
}

