/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.quickfix;

import com.ibm.pdp.framework.util.CharsetUtil;
import com.ibm.pdp.pac.migration.help.quickfix.Messages;
import com.ibm.pdp.pacbase.PdpPacbasePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;

public class MigrationCompareEditorInput
extends CompareEditorInput {
    private CharSequence pacGeneratedCode;
    private CharSequence localGeneratedCode;
    private boolean validation = false;
    boolean ignoreComment = true;
    boolean ignoreEND_EXEC_Format = true;
    boolean isValidatedByUser = false;
    private IAction actionIgnoreComments = null;
    private IAction actionIgnoreFormatForEND_EXEC = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public CharSequence getPacGeneratedCode() {
        return this.pacGeneratedCode;
    }

    public CharSequence getLocalGeneratedCode() {
        return this.localGeneratedCode;
    }

    public MigrationCompareEditorInput(CompareConfiguration configuration, CharSequence pacGeneratedCode, CharSequence localGeneratedCode, boolean validation) {
        super(configuration);
        this.pacGeneratedCode = pacGeneratedCode;
        this.localGeneratedCode = localGeneratedCode;
        this.validation = validation;
    }

    public MigrationCompareEditorInput(CompareConfiguration configuration, CharSequence pacGeneratedCode, CharSequence localGeneratedCode) {
        super(configuration);
        this.pacGeneratedCode = pacGeneratedCode;
        this.localGeneratedCode = localGeneratedCode;
    }

    protected Object prepareInput(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
        Differencer d = new Differencer(){

            protected boolean contentsEqual(Object o1, Object o2) {
                return super.contentsEqual(o1, o2);
            }
        };
        String ignoreCommentString = "true";
        IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
        if (store.contains("com.ibm.pdpd.pacbase.preferences.compareignorecomment")) {
            ignoreCommentString = store.getString("com.ibm.pdpd.pacbase.preferences.compareignorecomment");
        }
        this.ignoreComment = ignoreCommentString.equals("true");
        String left = this.noCropText(this.localGeneratedCode);
        String right = this.noCropText(this.pacGeneratedCode);
        if (this.ignoreComment && !this.validation) {
            left = this.filteredCommentsText(left);
            right = this.filteredCommentsText(right);
        }
        String ignoreEndExec = "true";
        if (store.contains("com.ibm.pdpd.pacbase.preferences.compareignoreendexec")) {
            ignoreEndExec = store.getString("com.ibm.pdpd.pacbase.preferences.compareignoreendexec");
        }
        this.ignoreEND_EXEC_Format = ignoreEndExec.equals("true");
        if (this.ignoreEND_EXEC_Format) {
            left = this.filteredEND_EXEC(left);
            right = this.filteredEND_EXEC(right);
        }
        Object diff = d.findDifferences(false, (IProgressMonitor)new NullProgressMonitor(), null, null, (Object)new StringInput(left), (Object)new StringInput(right));
        return diff;
    }

    private String noCropText(CharSequence s) {
        return s.toString();
    }

    public String getOKButtonLabel() {
        return IDialogConstants.OK_LABEL;
    }

    public boolean isDirty() {
        return true;
    }

    public boolean okPressed() {
        this.isValidatedByUser = true;
        return super.okPressed();
    }

    public void cancelPressed() {
        this.isValidatedByUser = false;
    }

    private String filteredCommentsText(CharSequence s) {
        StringBuilder filteredText = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(s.toString(), "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.startsWith("      *")) continue;
            filteredText.append(String.valueOf(line) + "\r\n");
        }
        return filteredText.toString();
    }

    private String filteredEND_EXEC(CharSequence s) {
        StringBuilder filteredText = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(s.toString(), "\r\n");
        String line = null;
        String nextLine = null;
        while (nextLine != null || tokenizer.hasMoreTokens()) {
            int indexOfEND_EXEC;
            if (nextLine == null) {
                nextLine = tokenizer.nextToken();
            }
            if ((indexOfEND_EXEC = nextLine.indexOf("END-EXEC")) != -1) {
                boolean atTheBeginning;
                String nextLineWithoutRightMargin = nextLine;
                if (nextLineWithoutRightMargin.length() > 72) {
                    nextLineWithoutRightMargin = nextLineWithoutRightMargin.substring(0, 72);
                }
                String prefix = nextLineWithoutRightMargin.substring(0, indexOfEND_EXEC);
                String postfix = nextLineWithoutRightMargin.substring(indexOfEND_EXEC + "END-EXEC".length()).trim();
                boolean bl = atTheBeginning = prefix.trim().length() == 0;
                if (atTheBeginning) {
                    if (line != null) {
                        if (line.length() > 72) {
                            line = line.substring(0, 72);
                        }
                        filteredText.append(String.valueOf(line) + "\r\n");
                    }
                    line = nextLineWithoutRightMargin;
                    nextLine = null;
                    continue;
                }
                if (line != null) {
                    filteredText.append(String.valueOf(line) + "\r\n");
                }
                line = prefix;
                nextLine = "           END-EXEC" + postfix;
                continue;
            }
            if (line != null) {
                filteredText.append(String.valueOf(line) + "\r\n");
            }
            line = nextLine;
            nextLine = null;
        }
        if (line != null) {
            filteredText.append(line);
        }
        return filteredText.toString();
    }

    public void registerContextMenu(MenuManager menu, ISelectionProvider selectionProvider) {
        super.registerContextMenu(menu, selectionProvider);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MigrationCompareEditorInput.this.handleMenuAboutToShow(manager);
            }
        });
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        if (this.validation) {
            return;
        }
        if (this.actionIgnoreComments == null) {
            this.actionIgnoreComments = new Action(Messages.MigrationCompareEditorInput_Ignore_comments){

                public void run() {
                    if (MigrationCompareEditorInput.this.ignoreComment) {
                        MigrationCompareEditorInput.this.ignoreComment = false;
                        super.setChecked(false);
                    } else {
                        MigrationCompareEditorInput.this.ignoreComment = true;
                        super.setChecked(true);
                    }
                    IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
                    store.setValue("com.ibm.pdpd.pacbase.preferences.compareignorecomment", MigrationCompareEditorInput.this.ignoreComment ? "true" : "false");
                    MessageDialog.openInformation(null, (String)Messages.MigrationCompareEditorInput_Comparison_with_comments, (String)Messages.MigrationCompareEditorInput_comparison_comments_reopen);
                }
            };
            this.actionIgnoreComments.setChecked(this.ignoreComment);
        }
        manager.add(this.actionIgnoreComments);
        if (this.actionIgnoreFormatForEND_EXEC == null) {
            this.actionIgnoreFormatForEND_EXEC = new Action(Messages.MigrationCompareEditorInput_Ignore_END_EXEC){

                public void run() {
                    if (MigrationCompareEditorInput.this.ignoreEND_EXEC_Format) {
                        MigrationCompareEditorInput.this.ignoreEND_EXEC_Format = false;
                        super.setChecked(false);
                    } else {
                        MigrationCompareEditorInput.this.ignoreEND_EXEC_Format = true;
                        super.setChecked(true);
                    }
                    IPreferenceStore store = PdpPacbasePlugin.getDefault().getPreferenceStore();
                    store.setValue("com.ibm.pdpd.pacbase.preferences.compareignoreendexec", MigrationCompareEditorInput.this.ignoreEND_EXEC_Format ? "true" : "false");
                    MessageDialog.openInformation(null, (String)Messages.MigrationCompareEditorInput_END_EXEC_comparison, (String)Messages.MigrationCompareEditorInput_apply_END_EXEC);
                }
            };
            this.actionIgnoreFormatForEND_EXEC.setChecked(this.ignoreEND_EXEC_Format);
        }
        manager.add(this.actionIgnoreFormatForEND_EXEC);
    }

    public class StringInput
    implements ITypedElement,
    IStreamContentAccessor,
    IEditableContent {
        private String content;

        public String getString() {
            return this.content;
        }

        public StringInput(String s) {
            this.content = s;
        }

        public String getName() {
            return "cobol.cbl";
        }

        public String getType() {
            return "cbl";
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.content.getBytes(CharsetUtil.getWorkspaceCharset()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.content.getBytes());
            }
        }

        public Image getImage() {
            return null;
        }

        public boolean isEditable() {
            return true;
        }

        public void setContent(byte[] newContent) {
            MigrationCompareEditorInput.this.pacGeneratedCode = new String(newContent);
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }
    }
}

