/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.pac.migration.help.mia.MIAfile;
import com.ibm.pdp.pac.migration.help.mia.MIAinfoType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class MIAinfo {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final MIAinfo CLOSE_TAG = new MIAinfo(MIAinfoType.CLOSE_TAG, "");
    private MIAinfoType type;
    private String textOrTagName;
    private Properties properties;

    public static List<MIAinfo> CreateATag(String tagName, MIAfile miaFile) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (miaFile.isInBuffer()) {
            return result;
        }
        MIAinfo miaInfo = new MIAinfo(MIAinfoType.CREATE_TAG, tagName);
        result.add(miaInfo);
        return result;
    }

    public static List<MIAinfo> CreateAShadowTag(String tagName, MIAfile miaFile) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        MIAinfo miaInfo = new MIAinfo(MIAinfoType.CREATE_SHADOW_TAG, tagName);
        result.add(miaInfo);
        return result;
    }

    private static List<MIAinfo> CreateATagBeforeBuffer(String tagName, MIAfile miaFile) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (miaFile.isInBuffer()) {
            return result;
        }
        MIAinfo miaInfo = new MIAinfo(MIAinfoType.CREATE_TAG_IN_BUFFER, tagName);
        result.add(miaInfo);
        return result;
    }

    public static List<MIAinfo> CreateATag(String tagName, Properties properties, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATag(tagName, miaFile);
        if (!result.isEmpty()) {
            result.get(0).addProperties(properties);
        }
        return result;
    }

    private static List<MIAinfo> CreateATagBeforeBuffer(String tagName, Properties properties, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATagBeforeBuffer(tagName, miaFile);
        if (!result.isEmpty()) {
            result.get(0).addProperties(properties);
        }
        return result;
    }

    public static List<MIAinfo> CreateATagWithTextAndProperty(String tagName, String text, Properties properties, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATag(tagName, properties, miaFile);
        result.addAll(MIAinfo.InsertText(text, miaFile));
        return result;
    }

    public static List<MIAinfo> CreateATagBeforeBufferWithTextAndProperty(String tagName, String text, Properties properties, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATagBeforeBuffer(tagName, properties, miaFile);
        result.addAll(MIAinfo.InsertText(text, miaFile));
        return result;
    }

    public static List<MIAinfo> CreateOneTagWithText(String tagName, String text, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATagWithTextAndProperty(tagName, text, null, miaFile);
        if (!result.isEmpty()) {
            result.add(CLOSE_TAG);
        }
        return result;
    }

    public static List<MIAinfo> CreateOneTagWithTextAndProperty(String tagName, String text, Properties properties, MIAfile miaFile) {
        List<MIAinfo> result = MIAinfo.CreateATagWithTextAndProperty(tagName, text, properties, miaFile);
        if (!result.isEmpty()) {
            result.add(CLOSE_TAG);
        }
        return result;
    }

    public static List<MIAinfo> InsertText(String textToInsert, MIAfile miaFile) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (miaFile.isBufferBeginning(textToInsert)) {
            miaFile.bufferBegin();
            MIAinfo miaInfo = new MIAinfo(MIAinfoType.WRITE_IN_BUFFER, textToInsert);
            result.add(miaInfo);
        } else if (miaFile.isInBuffer()) {
            MIAinfo miaInfo = new MIAinfo(MIAinfoType.WRITE_IN_BUFFER, textToInsert);
            result.add(miaInfo);
            if (miaFile.isBufferEnding(textToInsert)) {
                miaFile.bufferEnd();
                miaInfo = new MIAinfo(MIAinfoType.MODIFY_BUFFER, "");
                result.add(miaInfo);
                miaInfo = new MIAinfo(MIAinfoType.INSERT_BUFFER_IN_TEXT, "");
                result.add(miaInfo);
            }
        } else {
            result.add(new MIAinfo(MIAinfoType.INSERT_TEXT, textToInsert));
        }
        return result;
    }

    public static Properties DuplicateProperties(Properties p) {
        Properties res = new Properties();
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            res.setProperty(key, p.getProperty(key));
        }
        return res;
    }

    protected MIAinfo(MIAinfoType type, String textOrTagName) {
        this.type = type;
        this.textOrTagName = type == MIAinfoType.CREATE_TAG || type == MIAinfoType.CREATE_TAG_IN_BUFFER ? MIAinfo.TransformTagName(textOrTagName) : textOrTagName;
    }

    public MIAinfoType getType() {
        return this.type;
    }

    public void setType(MIAinfoType type) {
        this.type = type;
    }

    public String getTextOrTagName() {
        return this.textOrTagName;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void addProperty(String propertyName, String value) {
        this.getProperties().setProperty(propertyName, value);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<Object> en = properties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.getProperties().setProperty(key, properties.getProperty(key));
        }
    }

    public static String TransformTagName(String textOrTagName) {
        return textOrTagName.replaceAll(" ", "");
    }

    public void modifyTextOrTagName(String newText) {
        this.textOrTagName = newText;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getTextOrTagName();
    }
}

