/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.pac.migration.help.mia.MIA2LineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIAConstants;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIALineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIAinfo;
import com.ibm.pdp.pac.migration.help.mia.MIAinfoType;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.migration.plugin.ImportMigration2;
import com.ibm.pdp.pacbase.migration.plugin.NameSubstitution;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public abstract class MIAfile
implements MIAConstants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int TraceLevel = 0;
    protected StringBuilder buffer;
    private List<MIAinfo> miaInfosInBuffer = new Stack<MIAinfo>();
    protected ArrayList<MIALineImpl> allLines;
    private MIALineImpl nextLine = null;
    protected MIALineImpl previousLine_ReadFile = null;
    protected String ffToAdd = null;
    protected String ffToAddBefore = null;
    protected String ffnnToAdd = null;
    protected String ffnnToAddBefore = null;
    protected String lastEtiquetteFound = null;
    private GenInfoFactory giFactory;
    private Stack<MIAinfo> tags;
    private boolean isInBuffer = false;
    private boolean inProcedure = false;
    private int compteurMP = 1;
    protected RadicalEntity entity = null;
    private String entityName = null;
    private String programID = null;
    protected List<NameSubstitution> lns = null;
    private Map<String, String> allSubstitutions = null;
    private Map<String, Boolean> allLabelsAndEXIT = null;
    protected List<String> allIndices = new ArrayList<String>();
    protected MIALineImpl lastArtificialCreateFound = null;
    Set<String> allSUPFunctions = new HashSet<String>();
    protected String lastMPtagCreated = null;

    protected MIAfile() {
        this.tags = new Stack();
        this.allLines = new ArrayList();
        this.buffer = new StringBuilder();
        this.allLabelsAndEXIT = Collections.emptyMap();
    }

    public MIAfile(RadicalEntity entity, Map<String, Boolean> labelsAndEXIT) {
        this();
        this.entity = entity;
        this.allLabelsAndEXIT = labelsAndEXIT;
    }

    public void clean() {
        this.tags.clear();
        this.isInBuffer = false;
        this.inProcedure = false;
        this.buffer.delete(0, this.buffer.length());
        this.compteurMP = 1;
        this.nextLine = null;
        this.miaInfosInBuffer.clear();
        this.allLines.clear();
        this.allIndices.clear();
        this.allLabelsAndEXIT.clear();
    }

    protected void organizeLines() {
    }

    public IGeneratedInfo transformToGeneratedInfo() {
        this.organizeLines();
        this.giFactory = new GenInfoFactory();
        this.allLines.trimToSize();
        this.giFactory.setProperty("pattern", this.getPatternName());
        int index = 0;
        int all = this.allLines.size();
        if (all < 1) {
            this.giFactory.beginTag("ENTITY_" + this.getEntityName());
            this.giFactory.endTag();
            return this.endGeneratedInfo();
        }
        MIALineImpl firstMIAline = this.allLines.get(index++);
        this.miaInfoTreatment(this.analyseFirstMIAline(firstMIAline));
        MIALineImpl secondMIAline = null;
        while (index < all) {
            secondMIAline = this.allLines.get(index++);
            if (index < all) {
                this.nextLine = this.allLines.get(index);
            }
            this.miaInfoTreatment(this.compareMIAlines(firstMIAline, secondMIAline));
            firstMIAline.clean();
            firstMIAline = secondMIAline;
        }
        MIALineImpl lastMIAline = this.allLines.get(--all);
        this.miaInfoTreatment(this.analyseLastMIAline(lastMIAline));
        IGeneratedInfo gi = this.endGeneratedInfo();
        gi = this.modifyGeneratedInfoAtEnd(gi);
        this.clean();
        return gi;
    }

    protected IGeneratedInfo modifyGeneratedInfoAtEnd(IGeneratedInfo gi) {
        return gi;
    }

    private void miaInfoTreatment(Iterator<MIAinfo> miaInfos) {
        if (miaInfos == null) {
            return;
        }
        MIAinfo currentInfo = null;
        while (miaInfos.hasNext()) {
            currentInfo = miaInfos.next();
            this.expandMIAinfo(currentInfo);
        }
    }

    protected void expandMIAinfo(MIAinfo currentInfo) {
        switch (currentInfo.getType()) {
            case CREATE_TAG: {
                this.giFactory.beginTag(currentInfo.getTextOrTagName());
                this.tags.push(currentInfo);
                this.giFactory.setProperties(currentInfo.getProperties());
                break;
            }
            case CLOSE_TAG: {
                if (this.containsTag("PROCEDURE") && this.getNextLine() != null && this.getTagsStack().size() <= 2) {
                    return;
                }
                this.giFactory.endTag();
                this.tags.pop();
                break;
            }
            case INSERT_TEXT: {
                this.giFactory.appendText((CharSequence)MIAfile.TrimRightWithNewLine(currentInfo.getTextOrTagName()));
                break;
            }
            case CREATE_TAG_IN_BUFFER: {
                currentInfo.setType(MIAinfoType.CREATE_TAG);
                this.miaInfosInBuffer.add(currentInfo);
                break;
            }
            case INSERT_BUFFER_IN_TEXT: {
                this.insertBufferInText();
                break;
            }
            case MODIFY_BUFFER: {
                this.modifyBuffer();
                break;
            }
            case WRITE_IN_BUFFER: {
                this.storeInBuffer(currentInfo.getTextOrTagName());
                break;
            }
            case CREATE_SHADOW_TAG: {
                if (this.miaInfosInBuffer.contains(currentInfo)) break;
                this.miaInfosInBuffer.add(currentInfo);
                break;
            }
        }
    }

    public abstract Iterator<MIAinfo> analyseFirstMIAline(MIALineImpl var1);

    public abstract Iterator<MIAinfo> analyseLastMIAline(MIALineImpl var1);

    public abstract Iterator<MIAinfo> compareMIAlines(MIALineImpl var1, MIALineImpl var2);

    public abstract int getMinimumLineLength();

    public abstract MIALineImpl instanciateMIAline(String var1);

    public abstract boolean isMicroPatternAnnotationsToKeep(String var1);

    public abstract String getPatternName();

    public boolean isLineOk(String lineContent) {
        return lineContent != null && lineContent.length() >= this.getMinimumLineLength();
    }

    public boolean isMPoverrideGenerated() {
        return this.containsTag("PROCEDURE");
    }

    protected IGeneratedInfo endGeneratedInfo() {
        while (!this.tags.isEmpty() && this.tags.pop() != null) {
            this.giFactory.endTag();
        }
        return this.giFactory.createGeneratedInfo();
    }

    protected ArrayList<String> readFile(String fileName) {
        BufferedReader reader = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        ArrayList<String> inputList = new ArrayList<String>();
        try {
            try {
                fis = new FileInputStream(fileName);
                isr = new InputStreamReader(fis);
                reader = new BufferedReader(isr);
                String line = reader.readLine();
                if (line != null) {
                    do {
                        inputList.add(line);
                    } while ((line = reader.readLine()) != null);
                }
            }
            catch (FileNotFoundException e) {
                this.traceMessage("ERROR in class MIAFile : " + fileName);
                Util.rethrow((Throwable)e);
                try {
                    if (reader != null) {
                        reader.close();
                        isr.close();
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    Util.rethrow((Throwable)ioe);
                }
            }
            catch (IOException e) {
                Util.rethrow((Throwable)e);
                try {
                    if (reader != null) {
                        reader.close();
                        isr.close();
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    Util.rethrow((Throwable)ioe);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                    isr.close();
                    fis.close();
                }
            }
            catch (IOException ioe) {
                Util.rethrow((Throwable)ioe);
            }
        }
        return inputList;
    }

    protected List<MIALineImpl> addMissingLines(MIALineImpl line) {
        ArrayList<MIALineImpl> res = new ArrayList<MIALineImpl>();
        if (this.previousLine_ReadFile != null && this.isBufferBeginning(this.previousLine_ReadFile.getCOBOLcontent()) && this.isBufferBeginning(line.getCOBOLcontent())) {
            String currentLine = line.lineContent;
            StringBuilder newLine = new StringBuilder(currentLine.substring(0, line.getIndexForCobolContentBegin()));
            newLine.append("      *\u00ee");
            int end = Math.min(currentLine.length(), line.getIndexForCobolContentEnd());
            int index = newLine.length();
            while (index++ < end) {
                newLine.append(" ");
            }
            newLine.append(currentLine.substring(line.getIndexForCobolContentEnd()));
            res.add(this.instanciateMIAline(newLine.toString()));
        }
        List<MIALineImpl> res2 = this.fnLinesOrganization(line);
        res.addAll(res2);
        this.artificialCreateModification(line);
        return res;
    }

    protected void artificialCreateModification(MIALineImpl line) {
        if (line instanceof MIALineProcedure) {
            if (line.isFromMacro() && this.lastArtificialCreateFound != null) {
                this.lastArtificialCreateFound.set_AC_NewLineNumber(line.getLineNumber());
                this.lastArtificialCreateFound.set_AC_CurrentFunction(line.getCurrentFunction());
                this.lastArtificialCreateFound.set_AC_Condition(((MIALineProcedure)((Object)line)).getConditionOrTreatment() == 'C');
                this.lastArtificialCreateFound = null;
            }
            if (line.isArtificialCreate()) {
                this.lastArtificialCreateFound = line;
            }
        }
    }

    protected String createArtificialCreateSubTag(MIALineImpl line) {
        StringBuilder sb = new StringBuilder();
        sb.append("F");
        sb.append(line.get_AC_CurrentFunction());
        sb.append(line.get_AC_LineNumber());
        if (line.is_AC_Condition()) {
            sb.append("_Label");
        }
        return sb.toString();
    }

    protected void createArtificialCreateTagAndTextIfNeeded(MIALineImpl line, List<MIAinfo> result) {
        boolean closeAfter = false;
        if (line.isArtificialCreate()) {
            String tagName = this.createArtificialCreateSubTag(line);
            result.addAll(MIAinfo.CreateATag(tagName, this));
            closeAfter = true;
        }
        result.addAll(MIAinfo.InsertText(line.getCOBOLcontent(), this));
        if (closeAfter) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    protected List<MIALineImpl> fnLinesOrganization(MIALineImpl line) {
        if (line instanceof MIALineProcedure) {
            MIALineImpl newLine;
            String current;
            StringBuilder endEtiquette;
            ArrayList<MIALineImpl> res = new ArrayList<MIALineImpl>();
            MIALineProcedure lineProc = (MIALineProcedure)((Object)line);
            if (this.ffnnToAddBefore != null) {
                endEtiquette = new StringBuilder("       F").append(this.ffnnToAddBefore).append("-FN.");
                if (this.previousLine_ReadFile.getCOBOLcontent().startsWith(endEtiquette.toString())) {
                    this.ffnnToAddBefore = null;
                } else {
                    current = lineProc.getCurrentFunction();
                    if (!this.ffnnToAddBefore.equals(current)) {
                        newLine = this.instanciateMIAline(this.getFnLineToAdd(line.getIndexForCobolContentBegin(), this.ffnnToAddBefore).toString());
                        newLine.clearMacroLineNumber();
                        res.add(newLine);
                        this.ffnnToAddBefore = null;
                    }
                }
            }
            if (this.ffnnToAdd != null) {
                endEtiquette = new StringBuilder("       F").append(this.ffnnToAdd).append("-FN.");
                if (this.previousLine_ReadFile.getCOBOLcontent().startsWith(endEtiquette.toString())) {
                    this.ffnnToAdd = null;
                } else {
                    current = lineProc.getCurrentFunction();
                    if (!this.ffnnToAdd.equals(current)) {
                        newLine = this.instanciateMIAline(this.getFnLineToAdd(line.getIndexForCobolContentBegin(), this.ffnnToAdd).toString());
                        newLine.clearMacroLineNumber();
                        res.add(newLine);
                        this.ffnnToAdd = null;
                    } else if (lineProc.getCOBOLcontent().startsWith(endEtiquette.toString())) {
                        this.ffnnToAdd = null;
                    }
                }
            }
            if (this.ffToAddBefore != null) {
                endEtiquette = new StringBuilder("       F").append(this.ffToAddBefore).append("-FN.");
                if (this.previousLine_ReadFile.getCOBOLcontent().startsWith(endEtiquette.toString())) {
                    this.ffToAddBefore = null;
                } else {
                    current = lineProc.getCurrentFunction();
                    if (current.length() > 2) {
                        current = current.substring(0, 2);
                    }
                    if (!this.ffToAddBefore.equals(current)) {
                        newLine = this.instanciateMIAline(this.getFnLineToAdd(line.getIndexForCobolContentBegin(), this.ffToAddBefore).toString());
                        newLine.clearMacroLineNumber();
                        newLine.clearSubFunctionCode();
                        res.add(newLine);
                        this.ffToAddBefore = null;
                    }
                }
            }
            if (this.ffToAdd != null) {
                endEtiquette = new StringBuilder("       F").append(this.ffToAdd).append("-FN.");
                if (this.previousLine_ReadFile.getCOBOLcontent().startsWith(endEtiquette.toString())) {
                    this.ffToAdd = null;
                } else {
                    current = lineProc.getCurrentFunction();
                    if (current.length() > 2) {
                        current = current.substring(0, 2);
                    }
                    if (!this.ffToAdd.equals(current) || this.closeFunctionEvenIfSubFunction((MIALineImpl)((Object)lineProc))) {
                        newLine = this.instanciateMIAline(this.getFnLineToAdd(line.getIndexForCobolContentBegin(), this.ffToAdd).toString());
                        newLine.clearMacroLineNumber();
                        newLine.clearSubFunctionCode();
                        res.add(newLine);
                        this.ffToAdd = null;
                    }
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    protected boolean closeFunctionEvenIfSubFunction(MIALineImpl line) {
        return false;
    }

    protected StringBuilder getFnLineToAdd(int beginIndex, String fn) {
        StringBuilder endEtiquette = new StringBuilder("       F").append(fn).append("-FN.");
        StringBuilder newLine = new StringBuilder(this.previousLine_ReadFile.lineContent.substring(0, beginIndex));
        newLine.append((CharSequence)endEtiquette);
        int index = newLine.length() - beginIndex;
        while (index++ < 17) {
            newLine.append(" ");
        }
        newLine.append("EXIT.");
        index = newLine.length() - beginIndex;
        while (index++ < 80) {
            newLine.append(" ");
        }
        index = beginIndex + 80;
        if (this.previousLine_ReadFile.lineContent.length() > index) {
            newLine.append(this.previousLine_ReadFile.lineContent.substring(index));
        }
        return newLine;
    }

    protected List<MIALineImpl> initializeMIALine(String currentLine) {
        MIALineImpl line = this.instanciateMIAline(currentLine);
        if (line == null) {
            return Collections.emptyList();
        }
        this.storeLineIfNeeded(line);
        ArrayList<MIALineImpl> res = new ArrayList<MIALineImpl>();
        res.addAll(this.addMissingLines(line));
        this.previousLine_ReadFile = line;
        res.add(line);
        return res;
    }

    protected void storeLineIfNeeded(MIALineImpl line) {
        if (!line.isFromMacro()) {
            return;
        }
    }

    protected void specialTreatmentForSup(MIALineProcedure line) {
        if (line.isSUP()) {
            String currentFct = line.getCurrentFunction();
            if (currentFct.length() == 2) {
                if (!currentFct.equals(this.ffToAdd) && !currentFct.equals(this.ffToAddBefore)) {
                    if (this.ffToAdd != null) {
                        this.ffToAddBefore = this.ffToAdd;
                    }
                    this.ffToAdd = currentFct;
                    if (this.ffToAdd.equals(this.ffToAddBefore)) {
                        this.ffToAddBefore = null;
                    }
                }
            } else if (!(currentFct.equals(this.ffnnToAdd) || currentFct.equals(this.ffnnToAddBefore) || currentFct.equals(this.lastEtiquetteFound) || line.getCOBOLcontent().startsWith("       F9099-ITER-FN.  GO TO F05."))) {
                if (this.ffnnToAdd != null) {
                    this.ffnnToAddBefore = this.ffnnToAdd;
                }
                this.ffnnToAdd = currentFct;
                if (this.ffnnToAdd.equals(this.ffnnToAddBefore)) {
                    this.ffnnToAddBefore = null;
                }
            }
        }
        if (line.getCOBOLcontent().charAt(6) != '*' && line.getCOBOLcontent().charAt(7) == 'F' && !line.getCOA().equals("COA")) {
            this.lastEtiquetteFound = line.getCOBOLcontent().charAt(10) != '.' ? line.getCOBOLcontent().substring(8, 12) : line.getCOBOLcontent().substring(8, 10);
        }
    }

    protected String getFName(MIALineProcedure currentLine) {
        String firstToken = currentLine.getCOBOLcontent();
        if (firstToken.charAt(6) != '*' && firstToken.charAt(7) != ' ') {
            int index = (firstToken = firstToken.trim()).indexOf(32);
            if (index != -1) {
                firstToken = firstToken.substring(0, index);
            }
            if ((index = firstToken.indexOf(46)) != -1) {
                firstToken = firstToken.substring(0, index);
            }
            return firstToken;
        }
        return null;
    }

    protected String getFNLine(MIALineProcedure currentLine) {
        String firstToken = this.getFName(currentLine);
        if (firstToken != null && firstToken.endsWith("-FN")) {
            firstToken = firstToken.substring(0, firstToken.length() - 3);
            return firstToken;
        }
        return null;
    }

    public void setFileToAnalyse(String anotatedFileName, String cobolFileName, List<NameSubstitution> lns) {
        this.lns = lns;
        ArrayList<String> allFileLines = this.readFile(anotatedFileName);
        this.allLines = new ArrayList();
        Iterator<String> it = allFileLines.iterator();
        List<MIALineImpl> currentLines = null;
        if (it.hasNext()) {
            MIALineImpl line;
            currentLines = this.initializeMIALine(it.next());
            while (it.hasNext()) {
                if (currentLines != null) {
                    this.allLines.addAll(currentLines);
                }
                currentLines = this.initializeMIALine(it.next());
            }
            if (currentLines != null) {
                this.allLines.addAll(currentLines);
            }
            if (this.ffnnToAdd != null) {
                line = this.instanciateMIAline(this.getFnLineToAdd(this.allLines.get(0).getIndexForCobolContentBegin(), this.ffnnToAdd).toString());
                line.clearMacroLineNumber();
                this.allLines.add(line);
            }
            if (this.ffToAdd != null) {
                line = this.instanciateMIAline(this.getFnLineToAdd(this.allLines.get(0).getIndexForCobolContentBegin(), this.ffToAdd).toString());
                line.clearMacroLineNumber();
                line.clearSubFunctionCode();
                this.allLines.add(line);
            }
        }
    }

    protected void sortLinesAfterRead() {
        int currentIndex = 0;
        while (!this.allLines.get(currentIndex++).isProcedureLine()) {
        }
        boolean continu = true;
        while (continu) {
            MIALineProcedure line;
            if ((line = (MIALineProcedure)((Object)this.allLines.get(currentIndex++))).isSUP()) {
                currentIndex = this.moveFN_LinesBefore(currentIndex - 1);
                this.allSUPFunctions.add(line.getCurrentFunction());
            }
            boolean bl = continu = currentIndex < this.allLines.size();
        }
    }

    protected int moveFN_LinesBefore(int index) {
        if (this.allLines.get(index - 1).isProcedureLine() && this.isFNline(index - 1)) {
            this.moveLineFrom(index - 1);
            return index - 1;
        }
        return index + 1;
    }

    protected boolean isFNline(int index) {
        int blank;
        MIALineProcedure line = (MIALineProcedure)((Object)this.allLines.get(index));
        String toAnalyse = line.getCOBOLcontent();
        if (line.getCOA().trim().length() == 0 && toAnalyse.charAt(7) != ' ' && toAnalyse.charAt(7) != '*' && toAnalyse.substring(7, blank = toAnalyse.indexOf(" ", 7)).endsWith("-FN.")) {
            String func;
            String newFunc = toAnalyse = toAnalyse.substring(8, blank - 4);
            if (newFunc.length() > 2) {
                newFunc = newFunc.substring(0, 2);
            }
            if ((func = (line = (MIALineProcedure)((Object)this.allLines.get(index + 1))).getCurrentFunction()).length() > 2) {
                func = func.substring(0, 2);
            }
            if (!newFunc.equals(func)) {
                return false;
            }
            return !this.allSUPFunctions.contains(toAnalyse);
        }
        return false;
    }

    protected void moveLineFrom(int index) {
        MIALineImpl line = this.allLines.get(index);
        if (line instanceof MIALineProcedure) {
            String currentFunction = ((MIALineProcedure)((Object)this.allLines.get(index + 1))).getCurrentFunction();
            while (currentFunction.equals(((MIALineProcedure)((Object)this.allLines.get(index + 1))).getCurrentFunction())) {
                this.allLines.set(index, this.allLines.get(index + 1));
                ++index;
            }
            this.allLines.set(index, line);
        }
    }

    public void insertBufferInText() {
        this.miaInfoTreatment(this.miaInfosInBuffer.iterator());
        this.miaInfosInBuffer.clear();
        this.buffer.delete(0, this.buffer.length());
    }

    public void storeInBuffer(String temporaryText) {
        this.buffer.append(temporaryText);
    }

    public List<MIAinfo> fromStringToMiaInfos(String mpContent) {
        if (mpContent.length() == 0) {
            return Collections.emptyList();
        }
        String[] textToInsert = PdpTool.splitTextIntoArrayLines((String)mpContent);
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>(textToInsert.length);
        int i = 0;
        while (i < textToInsert.length) {
            String string = String.valueOf(textToInsert[i]) + "\r\n";
            result.add(new MIAinfo(MIAinfoType.INSERT_TEXT, string));
            ++i;
        }
        return result;
    }

    protected boolean isSpecialMicroPatternNotTogenerate(String microPatternID) {
        return false;
    }

    public void modifyBuffer() {
        String toAnalyse;
        boolean mpMacroOverrideBySpecif = false;
        if (this.isBufferBeginning(this.getNextLine().getCOBOLcontent())) {
            MIAinfo mi;
            boolean inMacro;
            boolean bl = inMacro = !this.miaInfosInBuffer.isEmpty() && this.miaInfosInBuffer.get(this.miaInfosInBuffer.size() - 1).getProperties().getProperty("msp") != null;
            if (inMacro && (mi = this.miaInfosInBuffer.get(this.miaInfosInBuffer.size() - 1)).getTextOrTagName().equals(this.getNextLine().getSupposedTagName())) {
                String[] res = this.transformMicroPattern(this.buffer, this.substituteCharacterIfNeeded(mi.getProperties().getProperty("msp")), this.getEntityName());
                if (res[0].startsWith("      *\u00f4")) {
                    this.buffer.replace(0, this.buffer.length(), String.valueOf(res[0].replaceFirst("!", String.valueOf('\u00f4'))) + "      *\u00ee" + "\r\n");
                }
                mpMacroOverrideBySpecif = true;
            }
        }
        if (this.isBufferBeginning(toAnalyse = this.buffer.toString())) {
            boolean inMacro = !this.miaInfosInBuffer.isEmpty() && this.miaInfosInBuffer.get(this.miaInfosInBuffer.size() - 1).getProperties().getProperty("msp") != null;
            String microPatternID = toAnalyse.substring(8, toAnalyse.indexOf(" ", 8));
            if (inMacro) {
                MIAinfo mi = this.miaInfosInBuffer.get(this.miaInfosInBuffer.size() - 1);
                boolean tagAlreadyExists = this.tagAlreadyCreated(mi.getTextOrTagName(), this.getTagsStack().iterator());
                if (tagAlreadyExists) {
                    this.miaInfosInBuffer.remove(mi);
                }
                String[] res = this.transformMicroPattern(this.buffer, this.substituteCharacterIfNeeded(mi.getProperties().getProperty("mp")), this.getEntityName());
                this.miaInfosInBuffer.addAll(0, this.beforeMicroPatternInsertion(microPatternID, res));
                if (this.isMicroPatternAnnotationsToKeep(microPatternID)) {
                    this.miaInfosInBuffer.addAll(this.fromStringToMiaInfos(res[0]));
                } else {
                    if (mpMacroOverrideBySpecif) {
                        this.miaInfosInBuffer.remove(mi);
                        return;
                    }
                    String entityName = this.substituteCharacterIfNeeded(mi.getProperties().getProperty("mp"));
                    res = this.transformMicroPattern(this.buffer, entityName, entityName);
                    this.miaInfosInBuffer.addAll(this.fromStringToMiaInfos(res[1]));
                    res[1] = "";
                }
                if (res[1].trim().length() == 0) {
                    if ("SQL".equals(microPatternID) && this.getNextLine() instanceof MIA2LineProcedure) {
                        MIA2LineProcedure line = (MIA2LineProcedure)this.getNextLine();
                        String tag = "F" + line.getG4() + line.getCOFSO() + line.getLineNumber();
                        if (mi.getTextOrTagName().startsWith(tag)) {
                            return;
                        }
                    }
                    this.miaInfosInBuffer.add(MIAinfo.CLOSE_TAG);
                    return;
                }
                this.miaInfosInBuffer.add(MIAinfo.CLOSE_TAG);
                if (!mpMacroOverrideBySpecif) {
                    Properties p = new Properties();
                    String tagName = String.valueOf(mi.getTextOrTagName()) + "_" + microPatternID;
                    this.keepTagNameForSpecialMP(microPatternID, tagName);
                    p.put("mp", tagName);
                    this.miaInfosInBuffer.add(MIAinfo.CreateATag(tagName, p, this).get(0));
                    this.miaInfosInBuffer.addAll(this.fromStringToMiaInfos(res[1]));
                    this.miaInfosInBuffer.add(MIAinfo.CLOSE_TAG);
                }
                return;
            }
            if (this.isSpecialMicroPatternNotTogenerate(microPatternID)) {
                this.miaInfosInBuffer.clear();
                return;
            }
            String[] res = this.transformMicroPattern(this.buffer, null, this.completeMarkWithZero(this.compteurMP));
            this.miaInfosInBuffer.addAll(0, this.beforeMicroPatternInsertion(microPatternID, res));
            if (res[1].trim().length() == 0) {
                return;
            }
            String tagName = this.calculateTagNameFromMP(microPatternID);
            Properties p = new Properties();
            p.put("mp", tagName);
            this.keepTagNameForSpecialMP(microPatternID, tagName);
            this.miaInfosInBuffer.add(MIAinfo.CreateATag(tagName, p, this).get(0));
            this.miaInfosInBuffer.addAll(this.fromStringToMiaInfos(res[1]));
            this.miaInfosInBuffer.add(MIAinfo.CLOSE_TAG);
        }
    }

    protected void keepTagNameForSpecialMP(String id, String name) {
        if ("DIF".equals(id) || "DVF".equals(id) || "DCF".equals(id)) {
            this.lastMPtagCreated = name;
        }
    }

    protected String writeTextAndTagForSpecialMP(String tagName, MIALineImpl line, boolean forTest) {
        if (this.lastMPtagCreated != null && line.getCOBOLcontent().trim().startsWith("NEXT SENTENCE")) {
            tagName = String.valueOf(this.lastMPtagCreated) + "_Next";
            if (!forTest) {
                this.lastMPtagCreated = null;
                Properties p = line.getProperties();
                p.remove("msp");
                p.put("mp", tagName);
                line.cobolContent = null;
            }
        }
        return tagName;
    }

    private String completeMarkWithZero(int n) {
        StringBuilder sb = new StringBuilder("00000");
        sb.append(n);
        int l = sb.length();
        return sb.substring(l - 6, l);
    }

    private String calculateTagNameFromMP(String microPatternID) {
        return String.valueOf(microPatternID) + "_" + this.compteurMP++;
    }

    protected List<MIAinfo> beforeMicroPatternInsertion(String microPatternID, String[] content) {
        return new ArrayList<MIAinfo>(1);
    }

    public void traceMessage(String message) {
        if (TraceLevel > 0) {
            PTTraceManager.getInstance().trace(this.getClass(), "com.ibm.pdp.pac", 1, message);
        }
    }

    protected List<MIAinfo> createOneTagFromMIAline(MIALineImpl line) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        result.addAll(MIAinfo.CreateOneTagWithTextAndProperty(line.getTagName(), line.getCOBOLcontent(), line.getProperties(), this));
        return result;
    }

    protected boolean isBufferBeginning(String text) {
        return text.startsWith("      *\u00f4");
    }

    protected boolean isBufferEnding(String text) {
        return text.startsWith("      *\u00ee");
    }

    protected boolean isInBuffer() {
        return this.isInBuffer;
    }

    protected void bufferBegin() {
        this.isInBuffer = true;
    }

    protected void bufferEnd() {
        this.isInBuffer = false;
    }

    protected boolean containsTag(String tagName) {
        if (tagName == null) {
            return false;
        }
        String realTagName = tagName.replaceAll(" ", "");
        Iterator<Object> it = this.tags.iterator();
        MIAinfo currentInfo2 = null;
        while (it.hasNext()) {
            currentInfo2 = (MIAinfo)it.next();
            if (currentInfo2.getType() != MIAinfoType.CREATE_TAG || !realTagName.equals(currentInfo2.getTextOrTagName())) continue;
            return true;
        }
        for (MIAinfo currentInfo2 : this.miaInfosInBuffer) {
            if (currentInfo2.getType() != MIAinfoType.CREATE_TAG || !realTagName.equals(currentInfo2.getTextOrTagName())) continue;
            return true;
        }
        return false;
    }

    protected boolean tagAlreadyCreated(String tagName, Iterator<MIAinfo> it) {
        if (tagName == null) {
            return false;
        }
        String realTagName = tagName.replaceAll(" ", "");
        MIAinfo currentInfo = null;
        while (it.hasNext()) {
            currentInfo = it.next();
            if (currentInfo.getType() != MIAinfoType.CREATE_TAG || !realTagName.equals(currentInfo.getTextOrTagName())) continue;
            return true;
        }
        return false;
    }

    protected MIAinfo lastTagCreated() {
        if (!this.miaInfosInBuffer.isEmpty()) {
            ListIterator<MIAinfo> itm = this.miaInfosInBuffer.listIterator(this.miaInfosInBuffer.size());
            while (itm.hasPrevious()) {
                MIAinfo mi = itm.previous();
                MIAinfoType mit = mi.getType();
                if (mit != MIAinfoType.CREATE_SHADOW_TAG && mit != MIAinfoType.CREATE_TAG && mit != MIAinfoType.CREATE_TAG_IN_BUFFER) continue;
                return mi;
            }
        }
        return this.tags.peek();
    }

    protected Stack<MIAinfo> getTagsStack() {
        return this.tags;
    }

    protected List<MIAinfo> createATagFromMIAline(MIALineImpl line) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (line.tagName == null) {
            result.addAll(MIAinfo.InsertText(line.getCOBOLcontent(), this));
        } else {
            if (this.isBufferBeginning(line.getCOBOLcontent())) {
                return this.createATagBeforeBufferFromMIAline(line);
            }
            result.addAll(MIAinfo.CreateATagWithTextAndProperty(line.getTagName(), line.getCOBOLcontent(), line.getProperties(), this));
        }
        return result;
    }

    protected List<MIAinfo> createATagBeforeBufferFromMIAline(MIALineImpl line) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (line.isFromMacro()) {
            result.addAll(MIAinfo.CreateATagBeforeBufferWithTextAndProperty(line.getTagName(), line.getCOBOLcontent(), line.getProperties(), this));
        } else {
            result.addAll(MIAinfo.InsertText(line.getCOBOLcontent(), this));
        }
        return result;
    }

    public List<MIAinfo> closeTagsUntil(int numberOfTagsToKeep) {
        int nbTagsToClose = this.tags.size() - numberOfTagsToKeep;
        if (nbTagsToClose <= 0) {
            return Collections.emptyList();
        }
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>(nbTagsToClose);
        while (nbTagsToClose-- > 0) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        return result;
    }

    public static int TransformStringToInt(String s) {
        int res = -1;
        try {
            res = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            Util.rethrow((Throwable)nfe);
        }
        return res;
    }

    public static String TrimRightWithNewLine(String name) {
        boolean withNewLine = name.endsWith("\r\n");
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        String result = new String(value, 0, end + 1);
        if (withNewLine) {
            result = String.valueOf(result) + "\r\n";
        }
        return result;
    }

    private String modifyMicroPatternHeader(String mpHeader) {
        if (mpHeader.startsWith("      *\u00f4")) {
            return mpHeader.replaceFirst(String.valueOf('\u00f4'), "!");
        }
        return mpHeader;
    }

    /*
     * Unable to fully structure code
     */
    private String[] transformMicroPattern(StringBuilder mpContent, String markForHeader, String markForContent) {
        tab = PdpTool.splitTextIntoArrayLines((String)mpContent.toString());
        sb0 = new StringBuilder();
        sb1 = new StringBuilder();
        sb0.append(this.modifyMicroPatternHeader(tab[0]));
        sb0.append("\r\n");
        inHeader = true;
        i = 1;
        while (i < tab.length - 1) {
            block4: {
                block3: {
                    string = tab[i];
                    if (!inHeader) ** GOTO lbl28
                    if (string.charAt(6) != '*' || sb0.toString().contains("*!WF") && string.substring(6).startsWith("*BEGIN DB2")) break block3;
                    if (string.charAt(7) == '\u00ee') ** GOTO lbl-1000
                    sb0.append(string);
                    sb0.append("\r\n");
                    break block4;
                }
                if (i == 1 && (sb0.toString().contains("*!WI") || sb0.toString().contains("*!WE") || sb0.toString().contains("*!WS"))) {
                    sb0.append(string);
                    sb0.append("\r\n");
                } else lbl-1000:
                // 2 sources

                {
                    inHeader = false;
lbl28:
                    // 2 sources

                    sb1.append(string);
                    sb1.append("\r\n");
                }
            }
            ++i;
        }
        res = new String[]{this.appendMark(sb0.toString(), markForHeader), res[0].startsWith("      *!Y ") != false ? sb1.toString() : this.appendMark(sb1.toString(), markForContent)};
        return res;
    }

    private String appendMark(String originalText, String markToAppend) {
        if (!PacTool.markAtEndOfLine()) {
            return originalText;
        }
        if (markToAppend == null || originalText.trim().length() == 0) {
            return originalText;
        }
        String[] tab = PdpTool.splitTextIntoArrayLines((String)originalText.toString());
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < tab.length) {
            StringBuilder line = null;
            line = tab[i].length() > 72 ? new StringBuilder(tab[i].substring(0, 72)) : new StringBuilder(tab[i]);
            while (line.length() < 72) {
                line.append(" ");
            }
            line.append(markToAppend);
            result.append((CharSequence)line);
            result.append("\r\n");
            ++i;
        }
        if (!originalText.endsWith("\r\n")) {
            int length = result.length();
            result.replace(length - "\r\n".length(), length, "");
        }
        return result.toString();
    }

    public String substituteCharacterIfNeeded(String entityName) {
        if (this.lns != null && entityName != null) {
            if (this.allSubstitutions == null) {
                this.allSubstitutions = new HashMap<String, String>();
            }
            if (!this.allSubstitutions.containsKey(entityName)) {
                this.allSubstitutions.put(entityName, ImportMigration2.defineRealNameForEntity((String)entityName, this.lns));
            }
            return this.allSubstitutions.get(entityName);
        }
        return entityName;
    }

    public String getEntityName() {
        if (this.entity != null) {
            return this.entity.getName();
        }
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public MIALineImpl getNextLine() {
        return this.nextLine;
    }

    public String getProgramID() {
        return this.programID;
    }

    public void setProgramID(String programID) {
        this.programID = programID;
    }

    public boolean isInProcedure() {
        return this.inProcedure;
    }

    public void setInProcedure(boolean inProcedure) {
        this.inProcedure = inProcedure;
    }

    public Map<String, Boolean> getAllLabelsAndEXIT() {
        return this.allLabelsAndEXIT;
    }
}

