/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.pac.migration.help.mia.IMIALine;
import com.ibm.pdp.pac.migration.help.mia.MIALineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIAfile;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.util.Util;
import java.util.Properties;

public abstract class MIALineImpl
implements IMIALine {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public String lineContent;
    protected String cobolContent = null;
    protected String tagName = null;
    private MIAfile miaFile = null;
    private Properties properties = null;
    protected Troolean artificialCreate = Troolean.UNINITIALIZED;
    private String ac_lineNumber = null;
    private String ac_currentFunction = null;
    private boolean condition = false;

    public MIALineImpl(MIAfile file) {
        this.miaFile = file;
        this.properties = new Properties();
    }

    public MIALineImpl(MIAfile file, String line) {
        this(file);
        this.lineContent = line;
        this.initialize();
    }

    public abstract boolean isProcedureLine();

    public abstract int getIndexForCobolContentBegin();

    public abstract int getIndexForCobolContentEnd();

    public abstract int getIndexForMacroCodeBegin();

    public abstract int getIndexForMacroCodeEnd();

    public abstract int getIndexForMacroLineNumberBeginIndex();

    public abstract int getIndexForSubFunctionCodeBegin();

    public void addProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getSupposedTagName() {
        if (this.tagName != null) {
            return this.tagName;
        }
        if (this instanceof MIALineProcedure) {
            return "F" + this.getCurrentFunction() + this.getLineNumber() + this.getLineNumber();
        }
        return null;
    }

    public String getCurrentFunction() {
        return null;
    }

    private String initializeCobolContentFromLineContent() {
        if (this.lineContent.length() < this.getIndexForCobolContentEnd()) {
            return this.lineContent.substring(this.getIndexForCobolContentBegin());
        }
        return this.lineContent.substring(this.getIndexForCobolContentBegin(), this.getIndexForCobolContentEnd());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getCOBOLcontent() {
        block15: {
            block13: {
                block14: {
                    if (this.cobolContent != null) {
                        return this.cobolContent;
                    }
                    this.cobolContent = this.initializeCobolContentFromLineContent();
                    if (this.isEtiquette()) {
                        tmpS = MIAfile.TrimRightWithNewLine(this.cobolContent);
                        if (tmpS.length() > 72 && !(tmp = tmpS.substring(72)).startsWith("lv") && !tmp.startsWith("COA")) {
                            tmpS = tmpS.substring(0, 72);
                            this.cobolContent = MIAfile.TrimRightWithNewLine(tmpS);
                        }
                        this.modifyLineForEXIT();
                        tmp = this.cobolContent.trim();
                        if (this.getMiaFile().getPatternName() == "com.ibm.pdp.pacbase.dialog" && (tmp.startsWith("F25-FN.") || tmp.startsWith("F35-FN.") || tmp.startsWith("F60-FN.") || tmp.startsWith("F65-FN.")) && !this.isFromMacro()) {
                            content = new StringBuilder();
                            if (this.cobolContent.length() > 72) {
                                content.append(this.cobolContent.substring(0, 72));
                            } else {
                                content.append(this.cobolContent);
                            }
                            while (content.length() < 72) {
                                content.append(" ");
                            }
                            content.append(this.getMiaFile().substituteCharacterIfNeeded(this.getMiaFile().getEntityName()));
                            this.cobolContent = content.toString();
                        }
                        this.cobolContent = String.valueOf(this.cobolContent) + "\r\n";
                        return this.cobolContent;
                    }
                    if (!PacTool.markAtEndOfLine()) break block13;
                    content = new StringBuilder(MIAfile.TrimRightWithNewLine(this.cobolContent));
                    if (content.length() <= 72) ** GOTO lbl38
                    tmp = content.substring(72);
                    if (tmp.startsWith(this.getMiaFile().getProgramID()) || tmp.startsWith(this.getMiaFile().getEntityName()) || tmp.equals("DOT") || tmp.equals("dot") || tmp.startsWith("lv") || tmp.equals("COA")) break block14;
                    Util.rethrow((Throwable)new Exception("line too long"));
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        content.append(" ");
lbl38:
                        // 2 sources

                        ** while (content.length() < 72)
                    }
lbl39:
                    // 1 sources

                    if (this.isFromMacro()) {
                        content.append(this.getMiaFile().substituteCharacterIfNeeded(this.getProperties().get("msp").toString()));
                    } else {
                        content.append(this.getMiaFile().substituteCharacterIfNeeded(this.getMiaFile().getEntityName()));
                    }
                }
                content.append("\r\n");
                this.cobolContent = content.toString();
                break block15;
            }
            this.cobolContent = String.valueOf(this.cobolContent) + "\r\n";
        }
        return this.cobolContent;
    }

    public void setCOBOLContent(String s) {
        this.cobolContent = s;
    }

    private void modifyLineForEXIT() {
        StringTokenizer st = new StringTokenizer(this.cobolContent);
        String etiq = st.nextToken();
        Boolean currentValue = this.miaFile.getAllLabelsAndEXIT().get(etiq);
        if (currentValue == null) {
            etiq = String.valueOf(etiq) + "-duplicate";
            currentValue = this.miaFile.getAllLabelsAndEXIT().get(etiq);
            if (currentValue == null) {
                return;
            }
        }
        this.miaFile.getAllLabelsAndEXIT().remove(etiq);
        boolean isEXIT = currentValue;
        String nextWord = null;
        if (st.hasMoreTokens()) {
            nextWord = st.nextToken();
        }
        if (isEXIT) {
            if (nextWord == null || !"EXIT.".equals(nextWord)) {
                StringBuilder result = new StringBuilder(this.lineContent.substring(0, this.getIndexForCobolContentBegin()));
                int index = this.cobolContent.indexOf(etiq);
                if ((index += etiq.length() + 1) > this.cobolContent.length()) {
                    result.append(this.cobolContent);
                    this.cobolContent = "";
                } else {
                    result.append(this.cobolContent.substring(0, index));
                    this.cobolContent = this.cobolContent.substring(index);
                }
                result.append(" EXIT. ");
                index += 7;
                index = 81 - index;
                while (this.cobolContent.length() >= index) {
                    this.cobolContent = this.cobolContent.replaceFirst("  ", " ");
                }
                result.append(this.cobolContent);
                if (this.lineContent.length() > this.getIndexForCobolContentEnd()) {
                    while (result.length() < this.getIndexForCobolContentEnd()) {
                        result.append(" ");
                    }
                    result.append(this.lineContent.substring(this.getIndexForCobolContentEnd()));
                }
                this.lineContent = result.toString();
                this.cobolContent = this.initializeCobolContentFromLineContent();
            }
        } else if (nextWord != null && "EXIT.".equals(nextWord)) {
            StringBuilder result = new StringBuilder(this.lineContent.substring(0, this.getIndexForCobolContentBegin()));
            result.append(this.cobolContent.replaceFirst("EXIT.", "     "));
            if (this.lineContent.length() > this.getIndexForCobolContentEnd()) {
                result.append(this.lineContent.substring(this.getIndexForCobolContentEnd()));
            }
            this.lineContent = result.toString();
            this.cobolContent = this.initializeCobolContentFromLineContent();
        }
    }

    public void initialize() {
        if (this.lineContent.length() > this.getIndexForMacroCodeBegin()) {
            String macroCode = this.lineContent.substring(this.getIndexForMacroCodeBegin()).trim();
            if (this.lineContent.length() >= this.getIndexForMacroCodeEnd()) {
                macroCode = this.lineContent.substring(this.getIndexForMacroCodeBegin(), this.getIndexForMacroCodeEnd()).trim();
            }
            if (macroCode.length() > 0) {
                this.setMacroCode(this.getMiaFile().substituteCharacterIfNeeded(macroCode));
            }
        }
    }

    public boolean isArtificialCreate() {
        return this.artificialCreate == Troolean.TRUE;
    }

    public void setArtificialCreate(boolean b) {
        if (this.artificialCreate == Troolean.UNINITIALIZED) {
            this.artificialCreate = b ? Troolean.TRUE : Troolean.FALSE;
        }
    }

    public boolean isEtiquette() {
        return this.isProcedureLine() && this.getCOBOLcontent().length() > 8 && this.getCOBOLcontent().substring(0, 7).trim().length() == 0 && this.getCOBOLcontent().charAt(7) != ' ' && !this.getCOBOLcontent().substring(7).startsWith("PROCEDURE");
    }

    public void clean() {
        this.lineContent = null;
        this.cobolContent = null;
        this.tagName = null;
    }

    public void clearSubFunctionCode() {
        if (this.isProcedureLine()) {
            String lineC = this.lineContent;
            this.clean();
            if (lineC.length() > this.getIndexForSubFunctionCodeBegin()) {
                StringBuilder sb = new StringBuilder(lineC.substring(0, this.getIndexForSubFunctionCodeBegin()));
                sb.append("  ");
                sb.append(lineC.substring(this.getIndexForSubFunctionCodeBegin() + 2));
                this.lineContent = sb.toString();
            } else {
                this.lineContent = lineC;
            }
        }
    }

    public void clearMacroLineNumber() {
        if (this.isProcedureLine() && this.isFromMacro()) {
            String lineC = this.lineContent;
            this.clean();
            if (lineC.length() > this.getIndexForMacroLineNumberBeginIndex()) {
                StringBuilder sb = new StringBuilder(lineC.substring(0, this.getIndexForMacroLineNumberBeginIndex()));
                sb.append("   ");
                sb.append(lineC.substring(this.getIndexForMacroLineNumberBeginIndex() + 3));
                this.lineContent = sb.toString();
            } else {
                this.lineContent = lineC;
            }
        }
    }

    public String getLineNumber() {
        String lineC = this.lineContent;
        if (lineC.length() > this.getIndexForMacroLineNumberBeginIndex()) {
            int end = Math.min(this.getIndexForMacroLineNumberBeginIndex() + 3, lineC.length());
            return lineC.substring(this.getIndexForMacroLineNumberBeginIndex(), end);
        }
        return "   ";
    }

    public void set_AC_NewLineNumber(String number) {
        this.ac_lineNumber = number;
    }

    public String get_AC_LineNumber() {
        return this.ac_lineNumber;
    }

    public void set_AC_CurrentFunction(String currentFct) {
        this.ac_currentFunction = currentFct;
    }

    public String get_AC_CurrentFunction() {
        return this.ac_currentFunction;
    }

    public boolean is_AC_Condition() {
        return this.condition;
    }

    public void set_AC_Condition(boolean b) {
        this.condition = b;
    }

    public boolean isFromMacro() {
        return this.getProperties().get("msp") != null;
    }

    public String getMacroCode() {
        return (String)this.getProperties().get("msp");
    }

    public void setMacroCode(String macroCode) {
        this.getProperties().put("msp", macroCode.trim());
    }

    public String toString() {
        return this.lineContent;
    }

    public MIAfile getMiaFile() {
        return this.miaFile;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public static enum Troolean {
        UNINITIALIZED,
        FALSE,
        TRUE;

    }
}

