/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialogServerTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pac.migration.help.mia.MIA2File;
import com.ibm.pdp.pac.migration.help.mia.MIA2LineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIA2LineWorking;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIAinfo;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class MIA4File
extends MIA2File {
    private ArrayList<String> alCommentsF53BB = new ArrayList(10);
    private ArrayList<String> allYmp = new ArrayList(10);
    private int itcom = 0;
    private int itirer = 0;
    private boolean wTopEtiq3 = false;
    private boolean TopFN = false;
    private String wFL74 = null;
    private StringBuilder wEtiqX40 = new StringBuilder(40);
    private StringBuilder wEtiqFN = new StringBuilder(40);
    private StringBuilder wDtagX40 = new StringBuilder(40);
    private boolean wTopProc = false;
    private int nivelProc = 0;
    private TreeMap<String, ArrayList<MIALineImpl>> tmMemoSQL = new TreeMap();
    private ArrayList<MIALineImpl> memoSQL = new ArrayList();
    private int indexF80 = 0;
    private boolean isTotalStarR = false;
    private String memoLastReference = null;
    private boolean inF80 = false;
    Map<String, List<String>> allKeysInF80 = new HashMap<String, List<String>>();
    String currentKey = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MIA4File(RadicalEntity entity) {
        super(entity, new HashMap<String, Boolean>());
    }

    public MIA4File(RadicalEntity entity, Map<String, Boolean> labelsAndEXIT) {
        super(entity, labelsAndEXIT);
    }

    @Override
    public void clean() {
        super.clean();
        this.allYmp.clear();
    }

    @Override
    public Iterator<MIAinfo> compareMIAlines(MIALineImpl firstLine, MIALineImpl secondLine) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (!this.onlyWorking && this.isInProcedure()) {
            if ("S".equals(this.screenType) || "E".equals(this.screenType) || "IT".equals(this.screenType)) {
                this.compareMIA4LinesProcedure((MIA2LineProcedure)firstLine, (MIA2LineProcedure)secondLine, result);
            } else {
                this.compareMIA2LinesProcedure((MIA2LineProcedure)firstLine, (MIA2LineProcedure)secondLine, result);
            }
        } else if (secondLine instanceof MIA2LineWorking) {
            MIA2LineWorking mia2First = (MIA2LineWorking)firstLine;
            MIA2LineWorking mia2Second = (MIA2LineWorking)secondLine;
            if (!mia2Second.getG3().equals("C") || mia2Second.getG4().trim().length() != 0 || this.isBreakOnG9B(mia2First, mia2Second)) {
                this.compareMIA2LinesWorking(mia2First, mia2Second, result);
            }
        } else if (!this.onlyWorking) {
            this.setInProcedure(true);
            this.firstMIA2LineProcedure((MIA2LineWorking)firstLine, (MIA2LineProcedure)secondLine, result);
        }
        return result.iterator();
    }

    @Override
    protected List<MIAinfo> beforeMicroPatternInsertion(String microPatternID, String[] content) {
        List<MIAinfo> result = super.beforeMicroPatternInsertion(microPatternID, content);
        if ("Y".equals(microPatternID)) {
            String yLine = content[1].toString();
            if (yLine.length() > 72) {
                yLine = yLine.substring(0, 72);
            }
            if ((yLine = yLine.trim()).endsWith(".")) {
                yLine = "       " + yLine.substring(0, yLine.length() - 1) + "-FN";
            }
            this.allYmp.add(yLine);
        }
        return result;
    }

    @Override
    public boolean isMicroPatternAnnotationsToKeep(String mpID) {
        if (mpID.equals("Y") || mpID.equals("XT")) {
            return true;
        }
        if (mpID.charAt(0) == 'X') {
            return false;
        }
        return super.isMicroPatternAnnotationsToKeep(mpID);
    }

    public List<MIAinfo> compareMIA4LinesProcedure(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        String references;
        if (!firstLine.getCOFON().equals(secondLine.getCOFON()) || !firstLine.getCOFSO().equals(secondLine.getCOFSO())) {
            this.memoNbLine = null;
        }
        if ((references = secondLine.getReferences()) != null && references.trim().length() > 0) {
            this.memoLastReference = secondLine.getReferences();
        }
        if (!this.allYmp.isEmpty()) {
            String cob = secondLine.getCOBOLcontent();
            if (cob.contains("-FN")) {
                String yMP2 = null;
                for (String yMP2 : this.allYmp) {
                    if (!cob.startsWith(yMP2)) continue;
                    Properties p = new Properties();
                    p.put("mp", yMP2.trim());
                    result.addAll(MIAinfo.CreateOneTagWithTextAndProperty(yMP2.trim(), secondLine.getCOBOLcontent(), p, this));
                }
                if (!result.isEmpty()) {
                    this.allYmp.remove(yMP2);
                    return result;
                }
            } else if (!this.isBreakOnG5(firstLine, secondLine) && this.isBreakOnG6(firstLine, secondLine) && firstLine.getLEVEL() >= secondLine.getLEVEL()) {
                result.add(MIAinfo.CLOSE_TAG);
                this.allYmp = new ArrayList();
            }
        }
        if (!firstLine.getG3().equals(secondLine.getG3())) {
            this.setWTopProc(false);
        }
        if (this.nivelProc > 0 && secondLine.getLEVEL() <= this.nivelProc && this.isBreakOnG9B(firstLine, secondLine)) {
            if (secondLine.getMacroCode() != null && !this.isEndEtiquetteLine(firstLine)) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.nivelProc = 0;
        }
        if (this.isBufferBeginning(secondLine.getCOBOLcontent())) {
            StringBuilder sb;
            String tn = null;
            if (secondLine.getG4().equals("80")) {
                sb = new StringBuilder(11);
                sb.append("F");
                sb.append(secondLine.getG4());
                sb.append(secondLine.getCOFSO());
                if (secondLine.getCOBOLcontent().indexOf("\u00f4SQL") != -1) {
                    sb.append(secondLine.getnbLineMsp());
                    sb.append(secondLine.getnbLineMsp());
                    tn = sb.toString();
                } else if (firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0) {
                    sb.append(this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()));
                    tn = sb.toString();
                } else {
                    sb.append(this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()));
                    tn = sb.toString();
                }
            } else {
                sb = new StringBuilder(11);
                sb.append("F");
                sb.append(secondLine.getCOFON());
                sb.append(secondLine.getCOFSO());
                if (firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0) {
                    sb.append(this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()));
                    tn = sb.toString();
                } else {
                    sb.append(this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()));
                    tn = sb.toString();
                }
            }
            secondLine.tagName = tn;
            result.addAll(this.createATagBeforeBufferFromMIAline(secondLine));
            return result;
        }
        if (this.isBufferEnding(secondLine.getCOBOLcontent())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if ((secondLine.getMacroCode() != null || secondLine.getnbLineMsp() != null) && secondLine.getnbLineMsp() != null && secondLine.getnbLineMsp().trim().length() > 0 && this.isBeginEtiquetteLine(secondLine)) {
            StringBuilder sb = new StringBuilder();
            int id = secondLine.getFL11().indexOf(".");
            sb.append(secondLine.getFL11().substring(0, id));
            this.alFunctionsSubfunctionsInMacro.add(sb.toString());
        }
        if (this.isSpecificLine(secondLine) && !this.isBeginEtiquetteLine(secondLine)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"G") > 0) {
            this.setEndEtiquetteForMacro(secondLine);
            this.setLine900ForMacro(secondLine);
            if (secondLine.getMacroCode() != null || secondLine.getnbLineMsp() != null && secondLine.getnbLineMsp().equals("AAA") || this.isEndEtiquetteForMacro()) {
                if (secondLine.getG4().equals("80")) {
                    this.procedure_specialServer_ForMacro_ForF80(firstLine, secondLine, result);
                } else {
                    this.procedure_specialServer_ForMacro(firstLine, secondLine, result);
                }
                return result;
            }
            if (secondLine.getCOBOLcontent().indexOf("-PROC") != -1) {
                this.nivelProc = secondLine.getLEVEL();
            }
            if (secondLine.getCol7() == '*' && !secondLine.getFL11().substring(0, 6).equals("----->")) {
                this.procedure_F53BB(firstLine, secondLine, result);
                return null;
            }
            if (!((!secondLine.getFL74().substring(0, 2).equals(" F") || secondLine.getFL74().substring(16, 19).equals("-A.") || secondLine.getFL74().substring(22, 27).equals("REPET") || secondLine.getFL74().substring(21, 24).equals("-A.") || secondLine.getFL74().substring(21, 24).equals("-B.") || secondLine.getFL74().substring(11, 17).equals("-CATR-") && secondLine.getFL74().substring(17, 21).equals(secondLine.getFL74().substring(26, 30)) || secondLine.getFL74().substring(0, 8).equals(" F81CA-A") || secondLine.getFL74().substring(0, 7).equals(" F81HE-") || secondLine.getFL74().substring(0, 7).equals(" F81CM-") || secondLine.getFL74().substring(0, 7).equals(" F8120-") || secondLine.getFL74().substring(0, 7).equals(" F8155-") || secondLine.getFL74().substring(9, 13).equals("-P1.") || secondLine.getFL74().substring(0, 8).equals(" F80-KO.")) && !secondLine.getFL74().substring(0, 10).equals(" F8120-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F8155-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F81CM-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F81HE-FN."))) {
                this.procedure_F53CC(firstLine, secondLine, result);
            }
            if (!secondLine.getFL74().substring(0, 10).equals(" F8120-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F8155-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F81CM-FN.") && !secondLine.getFL74().substring(0, 10).equals(" F81HE-FN.") && (!secondLine.getFL74().substring(0, 2).equals(" F") || secondLine.getFL74().substring(22, 27).equals("REPET") || secondLine.getFL74().substring(0, 7).equals(" F8155-") || secondLine.getFL74().substring(11, 17).equals("-CATR-") && secondLine.getFL74().substring(17, 21).equals(secondLine.getFL74().substring(26, 30)) || secondLine.getFL74().substring(0, 7).equals(" F81CM-") || secondLine.getFL74().substring(0, 7).equals(" F8120-") || secondLine.getFL74().substring(0, 7).equals(" F81HE-") || secondLine.getFL74().substring(0, 8).equals(" F81CA-A") || secondLine.getFL74().substring(9, 13).equals("-P1.") || secondLine.getFL74().substring(0, 8).equals(" F80-KO.")) || secondLine.getFL74().substring(21, 24).equals("-A.") || secondLine.getFL74().substring(21, 24).equals("-B.") || secondLine.getFL74().substring(16, 19).equals("-A.")) {
                this.procedure_F53HH(firstLine, secondLine, result);
            }
        }
        return null;
    }

    @Override
    public String getPatternName() {
        if (this.entity instanceof PacFolder) {
            return "com.ibm.pdp.pacbase.folder";
        }
        if (this.entity instanceof PacCommunicationMonitor) {
            return "com.ibm.pdp.pacbase.communicationmonitor";
        }
        if (this.entity instanceof PacServer && ((PacServer)this.entity).getDialogType() == PacDialogServerTypeValues._IT_LITERAL) {
            return "com.ibm.pdp.pacbase.server.it";
        }
        return "com.ibm.pdp.pacbase.csserver";
    }

    private boolean getWTopEtiq3() {
        return this.wTopEtiq3;
    }

    private boolean getWTopProc() {
        return this.wTopProc;
    }

    @Override
    public MIALineImpl instanciateMIAline(String lineContent) {
        if (lineContent.substring(11, 17).equals("B     ")) {
            this.screenType = lineContent.substring(17, 20).trim();
        }
        if (("F".equals(this.screenType) || "FM".equals(this.screenType)) && lineContent.charAt(11) == 'U' && lineContent.trim().length() > 137 && lineContent.substring(135, 138).equals("AAA")) {
            StringBuilder sb = new StringBuilder(lineContent.length());
            sb.append(lineContent.substring(0, 135));
            sb.append("   ");
            sb.append(lineContent.substring(138));
            lineContent = sb.toString();
        }
        if ("F".equals(this.screenType) || "FM".equals(this.screenType) || "IT".equals(this.screenType) || "S".equals(this.screenType)) {
            if (lineContent.substring(38).trim().startsWith("F80.")) {
                this.inF80 = true;
                this.indexF80 = this.allLines.size() + 1;
            }
            if (lineContent.substring(38).trim().startsWith("F80-FN.")) {
                this.inF80 = false;
                for (ArrayList<MIALineImpl> al : this.tmMemoSQL.values()) {
                    Iterator<MIALineImpl> it1 = al.iterator();
                    while (it1.hasNext()) {
                        this.memoSQL.add(it1.next());
                    }
                }
                this.allLines.addAll(this.indexF80, this.memoSQL);
            }
            if (lineContent.substring(11, 14).equals("U80") && lineContent.substring(18, 20).trim().length() > 0 && lineContent.substring(20, 21).equals(" ") && (lineContent.substring(38, 40).equals("*\u00f4") || lineContent.substring(38, 40).equals("*\u00ee"))) {
                MIALineImpl line;
                ArrayList<MIALineImpl> al = this.tmMemoSQL.get(lineContent.substring(115, 117));
                if (al == null) {
                    al = new ArrayList();
                    this.tmMemoSQL.put(lineContent.substring(115, 117), al);
                }
                if ((line = super.instanciateMIAline(lineContent)) != null) {
                    al.add(line);
                }
                lineContent = null;
            }
        }
        return super.instanciateMIAline(lineContent);
    }

    @Override
    public boolean isLineOk(String lineContent) {
        if (lineContent == null || !this.inF80) {
            return super.isLineOk(lineContent);
        }
        if (this.inF80 && ("F".equals(this.screenType) || "FM".equals(this.screenType) || "IT".equals(this.screenType) || "S".equals(this.screenType))) {
            String tmpKey;
            String key = String.valueOf(lineContent.substring(14, 20)) + lineContent.substring(21, 30);
            boolean isFNline = false;
            if (this.currentKey != null && !(tmpKey = lineContent.substring(15, 24)).equals(this.currentKey)) {
                this.currentKey = null;
            }
            if (lineContent.charAt(39) == 'F' || "*\u00f4SQL".equals(lineContent.substring(38, 43))) {
                this.currentKey = null;
                isFNline = lineContent.substring(44, 48).equals("-FN.");
                if (!isFNline && lineContent.charAt(39) == 'F') {
                    String currentAccess = lineContent.substring(39, lineContent.indexOf(" ", 40));
                    List<String> previousAccess = this.allKeysInF80.get(key);
                    if (previousAccess == null) {
                        previousAccess = new ArrayList<String>();
                        this.allKeysInF80.put(key, previousAccess);
                    }
                    if (previousAccess.contains(currentAccess)) {
                        this.currentKey = lineContent.substring(15, 24);
                    }
                    previousAccess.add(currentAccess);
                }
            }
            if (this.currentKey != null) {
                return false;
            }
        }
        return super.isLineOk(lineContent);
    }

    private boolean isEndEtiquetteLine(MIA2LineProcedure line) {
        return line.getCol7() != '*' && line.getFL11().charAt(0) == 'F' && !line.isCOA() && line.getFL74().indexOf("-FN.") != -1;
    }

    private boolean isComment(MIA2LineProcedure line) {
        return line.getCol7() == '*' && line.getFL11().charAt(0) != 'N';
    }

    private void procedure_F53BB(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG9B(firstLine, secondLine)) {
            this.alCommentsF53BB = new ArrayList(10);
            this.itcom = 0;
        }
        ++this.itcom;
        this.alCommentsF53BB.add(secondLine.getCOBOLcontent());
    }

    private void procedure_F53CC(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        this.itirer = 0;
        this.setWTopEtiq3(false);
        this.TopFN = false;
        this.wFL74 = secondLine.getFL74();
        this.wEtiqX40 = new StringBuilder(40);
        this.procedure_F53CK(firstLine, secondLine, result);
        if ("S".equals(this.screenType) && secondLine.getG4().equals("80") && secondLine.getG5().trim().length() > 0 && !secondLine.getG5().trim().equals("99")) {
            this.procedure_F53CC_F80(firstLine, secondLine, result);
        } else if (!this.TopFN) {
            this.procedure_F53DD(firstLine, secondLine, result);
        } else {
            this.procedure_F53GM(firstLine, secondLine, result);
        }
    }

    private void procedure_F53CC_F80(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        String[] string;
        this.wDtagX40 = this.wEtiqX40;
        Properties properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
        StringBuilder sb = new StringBuilder(2);
        if (secondLine.getLEVEL() < 10) {
            sb.append("0");
        }
        sb.append(secondLine.getLEVEL());
        if (this.isBreakOnG9A(firstLine, secondLine) && firstLine.getCol7() == '*' || this.isBreakOnG7(firstLine, secondLine)) {
            properties.setProperty("level", "09.5");
            result.addAll(MIAinfo.CreateATag(this.wDtagX40.substring(0, 8), properties, this));
        }
        if ((string = this.wDtagX40.toString().split("-"))[2].equals("DC") && (string.length == 3 || string.length == 4 && !string[3].equals("ALL"))) {
            int index = this.wDtagX40.indexOf("-DC-");
            this.wDtagX40.replace(index + 1, index + 3, "EX");
        }
        if (this.wDtagX40.indexOf("-CL-") == -1 && this.wDtagX40.indexOf("-P-") == -1 && this.wDtagX40.indexOf("-RN-") == -1 || this.wDtagX40.toString().endsWith("-ALL")) {
            properties.setProperty("level", sb.toString());
            result.addAll(MIAinfo.CreateATag(this.wDtagX40.toString(), properties, this));
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    private void procedure_F53CK(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        this.wEtiqFN = new StringBuilder(40);
        int i = 0;
        while (i < this.wFL74.length()) {
            if (this.wFL74.substring(i, i + 4).equals("-FN.")) {
                this.TopFN = true;
                this.wEtiqFN.append((CharSequence)this.wEtiqX40);
            }
            if (this.wFL74.charAt(i) != ' ' && this.wFL74.charAt(i) != '.') {
                this.wEtiqX40.append(this.wFL74.charAt(i));
            }
            if (this.wFL74.charAt(i) == '-' && !this.wFL74.substring(i, i + 4).equals("-FN.")) {
                ++this.itirer;
            }
            if (this.wFL74.charAt(i) == '.') break;
            ++i;
        }
    }

    private void procedure_F53DD(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        this.wDtagX40 = this.wEtiqX40;
        Properties properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
        StringBuilder sb = null;
        if (secondLine.getCOBOLcontent().indexOf("FSERVER-STRVIEW.") != -1) {
            properties.setProperty("level", "10");
        } else {
            String[] chkdErr = secondLine.getCOBOLcontent().trim().split("-");
            if (chkdErr.length == 5 && chkdErr[1].equals("CHKD") && chkdErr[4].equals("ERR.")) {
                properties.setProperty("level", "25");
            } else {
                sb = new StringBuilder(2);
                if (secondLine.getLEVEL() < 10) {
                    sb.append("0");
                }
                sb.append(secondLine.getLEVEL());
                properties.setProperty("level", sb.toString());
            }
        }
        result.addAll(MIAinfo.CreateATag(this.wDtagX40.toString(), properties, this));
        if ((String.valueOf(secondLine.getG3()) + secondLine.getG4() + secondLine.getG5()).trim().equals("U8099")) {
            sb = new StringBuilder(3);
            sb.append(secondLine.getG5().substring(0, 2));
            sb.append(" ");
            secondLine.setG5(sb.toString());
            secondLine.setG6(" ");
            secondLine.setG7("  ");
            secondLine.setG8(" ");
            secondLine.setG9("   ");
            secondLine.setG0(" ");
            secondLine.setGA(" ");
            secondLine.setGB("   ");
        }
        this.procedure_F53DT(firstLine, secondLine, result);
        if (this.itcom == 0) {
            this.procedure_F53EE(firstLine, secondLine, result);
        }
        if (this.itcom > 0) {
            this.procedure_F53ET(firstLine, secondLine, result);
        }
    }

    private void procedure_F53DT(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getG4().equals("80") && secondLine.getG5().trim().length() > 0 && this.itirer == 3) {
            this.setWTopEtiq3(true);
        }
        if ((this.itirer == 2 || this.itirer == 3 || this.itirer == 4) && this.wEtiqX40.length() > 19 && this.wEtiqX40.substring(16, 20).equals("PROC")) {
            this.setWTopProc(true);
        }
    }

    private void procedure_F53EE(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            String tn;
            secondLine.tagName = tn = String.valueOf(this.wDtagX40.toString()) + "-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
            if (!(!this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getCol7() != '*' || this.getNextProcedureLine().getFL74().substring(22, 27).equals("REPET") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8155-") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F81CA-A") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8120-") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F81HE-") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F80-KO."))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.wDtagX40.toString().equals("FEND-PGM") || secondLine.getG4().equals("80") && this.isBeginEtiquetteLine(secondLine) && secondLine.getG5().trim().length() > 0 && !this.isBreakOnG5(firstLine, secondLine) && !this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") && !this.getNextProcedureLine().getFL74().substring(9, 13).equals("-RN.") && !this.getNextProcedureLine().getFL74().substring(12, 16).equals("ALIM") && !this.getNextProcedureLine().getFL74().substring(4, 8).equals("-KO.")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.wTopProc && this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getFL74().substring(16, 20).equals("-FN.")) {
            this.setWTopProc(false);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F53ET(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.CreateATag("N" + this.wDtagX40.toString().substring(1), this));
        int i = 0;
        while (i < this.itcom) {
            result.addAll(MIAinfo.InsertText(this.alCommentsF53BB.get(i), this));
            ++i;
        }
        result.add(MIAinfo.CLOSE_TAG);
        this.alCommentsF53BB = new ArrayList(10);
        this.itcom = 0;
        if (!this.forMigration) {
            String tn;
            secondLine.tagName = tn = String.valueOf(this.wDtagX40.toString()) + "-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
            if (!(!this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getCol7() != '*' || this.getNextProcedureLine().getFL74().substring(22, 27).equals("REPET") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F81CA-A") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8120-") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F81HE-") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8155-") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F80-KO."))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.wTopProc && this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getFL74().substring(16, 20).equals("-FN.")) {
            this.setWTopProc(false);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F53GM(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            String tn;
            secondLine.tagName = tn = this.wEtiqX40.toString();
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        result.add(MIAinfo.CLOSE_TAG);
        if (this.wEtiqFN.toString().equals("FSERVER-BEG")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.getNextProcedureLine() == null) {
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F53HH(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        if (!(this.forMigration || (!this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getCol7() != '*' || this.getNextProcedureLine().getFL74().substring(22, 27).equals("REPET") || this.getNextProcedureLine().getFL74().substring(11, 17).equals("-CATR-") && this.getNextProcedureLine().getFL74().substring(17, 21).equals(this.getNextProcedureLine().getFL74().substring(26, 30)) || this.getNextProcedureLine().getFL74().substring(22, 27).equals("REPET") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8155-") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F81CA-A") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F8120-") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F81HE-") || this.getNextProcedureLine().getFL74().substring(0, 7).equals(" F81CM-") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") || this.getNextProcedureLine().getFL74().substring(0, 8).equals(" F80-KO.") || this.getNextProcedureLine().getFL74().substring(21, 24).equals("-A.") || this.getNextProcedureLine().getFL74().substring(21, 24).equals("-B.") || this.getNextProcedureLine().getFL74().substring(16, 19).equals("-A.")) && !this.getNextProcedureLine().getFL74().substring(0, 10).equals(" F8120-FN.") && !this.getNextProcedureLine().getFL74().substring(0, 10).equals(" F8155-FN.") && !this.getNextProcedureLine().getFL74().substring(0, 10).equals(" F81CM-FN.") && !this.getNextProcedureLine().getFL74().substring(0, 10).equals(" F81HE-FN."))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (!(!this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") || !secondLine.getG4().equals("80") || secondLine.getG5().trim().length() <= 0 || ((this.getNextProcedureLine().getFL74().substring(9, 13).equals("-CL-") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-RN-")) && !this.getNextProcedureLine().getFL74().substring(13, 16).equals("ALL") || this.getNextProcedureLine().getFL74().substring(9, 12).equals("-P-") && !this.getNextProcedureLine().getFL74().substring(12, 15).equals("ALL")) && this.screenType.equals("S") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") || this.getNextProcedureLine().getFL74().substring(4, 8).equals("-KO.") || this.wTopEtiq3)) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (!(!this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") || !secondLine.getG4().equals("80") || secondLine.getG5().trim().length() <= 0 || ((this.getNextProcedureLine().getFL74().substring(9, 13).equals("-CL-") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-RN-")) && !this.getNextProcedureLine().getFL74().substring(13, 16).equals("ALL") || this.getNextProcedureLine().getFL74().substring(9, 12).equals("-P-") && !this.getNextProcedureLine().getFL74().substring(12, 15).equals("ALL")) && this.screenType.equals("S") || this.getNextProcedureLine().getFL74().substring(9, 13).equals("-P1.") || this.getNextProcedureLine().getFL74().substring(4, 8).equals("-KO.") || !this.wTopEtiq3 || this.getNextProcedureLine().getFL74().substring(12, 16).equals("ALIM") || this.getNextProcedureLine().getFL74().substring(12, 16).equals("CALL") || this.getNextProcedureLine().getFL74().substring(12, 16).equals("RETC"))) {
            result.add(MIAinfo.CLOSE_TAG);
            if (this.isBreakOnG7(secondLine, this.getNextProcedureLine()) && secondLine.getCORUB().trim().length() > 0) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.setWTopEtiq3(false);
        }
        if (this.isBreakOnG7(secondLine, this.getNextProcedureLine()) && secondLine.getG4().equals("80") && secondLine.getG5().trim().length() > 0 && this.screenType.equals("S")) {
            if (secondLine.getG9B().equals("E") && secondLine.getG0().equals("G")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.getNextProcedureLine().getFL74().substring(0, 2).equals("*N") && this.itirer == 2 && this.getNextProcedureLine().getMacroCode() == null) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if (this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) && this.getNextProcedureLine().getG4().equals("80")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.wTopProc && !this.getNextProcedureLine().getTYPST().equals("*P") && this.getNextProcedureLine().getFL74().substring(0, 2).equals(" F") && this.getNextProcedureLine().getFL74().substring(16, 20).equals("-FN.")) {
            this.setWTopProc(false);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_specialServer_ForMacro(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.wTopProc && secondLine.getTYPST().equals("*P") && secondLine.getLEVEL() > 20 && this.getNextProcedureLine().getReferences() != null && this.getNextProcedureLine().getReferences().split("-").length < 4) {
            result.add(MIAinfo.CLOSE_TAG);
            this.setWTopProc(false);
        }
        if (secondLine.getFL11().charAt(0) == 'N' && secondLine.getFL74().indexOf("*.") != -1 && (this.isBeginEtiquetteLine(this.getNextProcedureLine()) || this.getNextProcedureLine().getCol7() == '*')) {
            Properties properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
            StringBuilder sb = new StringBuilder(2);
            if (secondLine.getLEVEL() < 10) {
                sb.append("0");
            }
            sb.append(secondLine.getLEVEL());
            properties.setProperty("level", String.valueOf(sb.toString()));
            String references = this.getNextProcedureLine().getReferences();
            if (references != null) {
                properties.setProperty("refMIA", references);
            }
            result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), properties, this));
            secondLine.tagName = "N" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim();
            result.addAll(this.createATagFromMIAline(secondLine));
            if (this.getNextProcedureLine().getCol7() == ' ' || secondLine.getnbLineMsp() != null && !secondLine.getnbLineMsp().equals(this.getNextProcedureLine().getnbLineMsp())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else if (this.isBeginEtiquetteLine(secondLine)) {
            if (this.isEndEtiquetteLine(firstLine) || this.isBeginEtiquetteLine(firstLine) && this.isBreakOnG5(firstLine, secondLine) || secondLine.getnbLineMsp().equals("AAA") || Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"U") < 0 && this.isBreakOnGB1(firstLine, secondLine) || Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"U") > 0 && this.isBreakOnG9B(firstLine, secondLine)) {
                Properties properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
                StringBuilder sb = new StringBuilder(2);
                if (secondLine.getLEVEL() < 10) {
                    sb.append("0");
                }
                sb.append(secondLine.getLEVEL());
                properties.setProperty("level", String.valueOf(sb.toString()));
                result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), properties, this));
                if (secondLine.getnbLineMsp().equals("AAA")) {
                    this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                }
            }
            if (!secondLine.getnbLineMsp().equals("AAA")) {
                secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim() : "F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim();
                result.addAll(this.createATagFromMIAline(secondLine));
                if (this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isBreakOnGB1(secondLine, this.getNextProcedureLine()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isComment(this.getNextProcedureLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else if (this.isLine900(secondLine)) {
            String tn;
            secondLine.tagName = tn = secondLine.getFL11().trim().substring(0, secondLine.getFL11().trim().indexOf("."));
            if (firstLine.getMacroCode() != null) {
                secondLine.setMacroCode(firstLine.getMacroCode());
            }
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else if (this.isEndEtiquetteLine(secondLine)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            boolean closeTag = true;
            if (this.isBreakOnG3(secondLine, this.getNextProcedureLine()) && Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"U") < 0 && this.memoLastReference != null) {
                int i = this.memoLastReference.split("-").length;
                int i1 = i * 5;
                if (this.getNextProcedureLine().getLEVEL() > i1 && secondLine.getCOBOLcontent().indexOf(this.lastTagCreated().getTextOrTagName()) == -1) {
                    closeTag = false;
                }
            }
            if (closeTag) {
                result.add(MIAinfo.CLOSE_TAG);
            } else if (this.nivelProc > 0 && secondLine.getLEVEL() <= this.nivelProc && this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                this.nivelProc = 0;
            }
        } else if (firstLine.getnbLineMsp() != null && (!firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || secondLine.getCOFSO().trim().length() == 0 && secondLine.getTYPST().equals("*C"))) {
            if (secondLine.getTYPST().equals("*C") && (Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"U") < 0 && this.isBreakOnGB1(firstLine, secondLine) || Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"U") > 0 && this.isBreakOnG9B(firstLine, secondLine))) {
                Properties properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
                StringBuilder sb = new StringBuilder(2);
                if (secondLine.getLEVEL() < 10) {
                    sb.append("0");
                }
                sb.append(secondLine.getLEVEL());
                properties.setProperty("level", String.valueOf(sb.toString()));
                result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), properties, this));
            }
            secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 && !this.isBreakOnG7(firstLine, secondLine) ? "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()).trim() : "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()).trim();
            result.addAll(this.createATagFromMIAline(secondLine));
            if (this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isBreakOnGB1(secondLine, this.getNextProcedureLine()) || this.isBreakOnGC(secondLine, this.getNextProcedureLine()) && this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || !secondLine.isEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || secondLine.isSpecialEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isLine900(this.getNextProcedureLine()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            if (secondLine.getConditionOrTreatment() != firstLine.getConditionOrTreatment()) {
                secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()).trim() : "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()).trim();
                if (this.lastTagCreated().getTextOrTagName().equals(secondLine.tagName)) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                } else {
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isBreakOnGB1(secondLine, this.getNextProcedureLine()) || this.isBreakOnGC(secondLine, this.getNextProcedureLine()) && this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || !secondLine.isEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || secondLine.isSpecialEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isLine900(this.getNextProcedureLine()) || secondLine.getCol7() == '*' && secondLine.getLEVEL() == 5 && this.isBeginEtiquetteLine(this.getNextProcedureLine()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void procedure_specialServer_ForMacro_ForF80(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        Properties properties;
        if (firstLine.getMacroCode() == null && firstLine.getG5().trim().length() > 0 && !this.isBufferEnding(firstLine.getCOBOLcontent()) && secondLine.getMacroCode() != null) {
            if (this.isBreakOnG8(firstLine, secondLine) || secondLine.getMacroCode() != null) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isBreakOnG7(firstLine, secondLine)) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if (secondLine.getG7().equals("80") && secondLine.getTYPST().equals("*C") && this.isBreakOnG5(firstLine, secondLine) && (secondLine.getFL74().substring(0, 2).equals(" F") || secondLine.getFL74().substring(0, 1).equals("*") && secondLine.getString122().equals("*"))) {
            properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
            StringBuilder sb = new StringBuilder(2);
            if (secondLine.getLEVEL() < 10) {
                sb.append("0");
            }
            sb.append(secondLine.getLEVEL());
            properties.setProperty("level", sb.toString());
            sb = new StringBuilder(5);
            sb.append("F");
            sb.append(secondLine.getG4());
            sb.append(secondLine.getG5().trim());
            result.addAll(MIAinfo.CreateATag(sb.toString(), properties, this));
            String tagName = String.valueOf(sb.toString()) + secondLine.getnbLineMsp();
            result.addAll(MIAinfo.CreateATag(tagName, secondLine.getProperties(), this));
            result.addAll(MIAinfo.InsertText("       " + sb.toString() + "." + "\r\n", this));
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (secondLine.getG4().equals("80") && this.getNextProcedureLine().getF80Info().trim().length() > 0 && secondLine.getTYPST().equals("*R")) {
            if (this.isBreakOnG7(firstLine, secondLine)) {
                StringBuilder sb = new StringBuilder(5);
                sb.append("F80-");
                sb.append(this.getNextProcedureLine().getF80Info());
                result.addAll(MIAinfo.CreateATag(sb.toString(), null, this));
            }
            if (this.isBreakOnG9B(firstLine, secondLine)) {
                if (this.getNextProcedureLine().getFullF80Info().trim().length() > 8) {
                    properties = MIAinfo.DuplicateProperties(secondLine.getProperties());
                    properties.setProperty("level", "09.5");
                    result.addAll(MIAinfo.CreateATag(this.getNextProcedureLine().getFullF80Info(), properties, this));
                } else {
                    this.isTotalStarR = true;
                }
            }
        }
        this.procedure_specialServer_ForMacro(firstLine, secondLine, result);
        if (secondLine.getG4().equals("80") && secondLine.getG5().charAt(0) != ' ') {
            if (this.isBreakOnG7(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isBreakOnG9B(secondLine, this.getNextProcedureLine())) {
                if (!this.isTotalStarR) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.isTotalStarR = false;
            }
        }
    }

    private void setWTopEtiq3(Boolean b) {
        this.wTopEtiq3 = b;
    }

    private void setWTopProc(Boolean b) {
        this.wTopProc = b;
    }

    @Override
    protected void working_F50II(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("0".equals(secondLine.getG0()) && "0".equals(secondLine.getGA())) {
            secondLine.tagName = "CONSTANTS";
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if ("2".equals(this.getNextWorkingLine().getG0()) && "0".equals(this.getNextWorkingLine().getGA())) {
            if (System.getProperty("JUNIT_IN_PROGRESS") != null) {
                secondLine.setCOBOLContent("CONSTANTES ECRASEES POUR TEST JUNIT\r\n");
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        if ("2".equals(secondLine.getG0()) && "0".equals(secondLine.getGA())) {
            secondLine.tagName = "WSS-CONTINUATION";
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if (System.getProperty("JUNIT_IN_PROGRESS") != null && !secondLine.getCOBOLcontent().contains(" PICTURE ")) {
            secondLine.setCOBOLContent("CONSTANTES ECRASEES POUR TEST JUNIT\r\n");
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    @Override
    protected void working_F50IP(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("G".equals(secondLine.getG3()) && secondLine.get7c().trim().length() == 0 && ("D".equals(secondLine.getG8()) || "E".equals(secondLine.getG8()) || "F".equals(secondLine.getG8()) || "G".equals(secondLine.getG8()) || "C".equals(secondLine.getG8()))) {
            super.working_F50IP(firstLine, secondLine, result);
        }
    }

    @Override
    protected void working_F50KM(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (!this.isInBuffer()) {
            secondLine.tagName = "SQL-9999";
            result.addAll(this.createATagFromMIAline(secondLine));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && "LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    @Override
    protected void moveSQLlinesInF80() {
    }

    @Override
    protected IGeneratedInfo modifyGeneratedInfoAtEnd(IGeneratedInfo gi) {
        return gi;
    }
}

