/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.pac.migration.help.mia.MIA2File;
import com.ibm.pdp.pac.migration.help.mia.MIA2Line;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIALineProcedure;
import java.util.StringTokenizer;

public class MIA2LineProcedure
extends MIA2Line
implements MIALineProcedure {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MIA2LineProcedure(MIA2File file) {
        super(file);
    }

    public MIA2LineProcedure(MIA2File file, String lineContent) {
        super(file, lineContent);
    }

    @Override
    public boolean isProcedureLine() {
        return true;
    }

    @Override
    public String getCOA() {
        if (this.lineContent.length() >= 142) {
            return this.lineContent.substring(138, 141);
        }
        return "";
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.lineContent.length() > 155 && this.isFromMacro() && this.isEtiquette() && this.getConditionOrTreatment() == 'T' && this.getCOBOLcontent().length() > 72 && this.getCOBOLcontent().charAt(72) == 'l' && this.getCOBOLcontent().charAt(73) == 'v') {
            StringBuilder res = new StringBuilder(this.lineContent);
            res.replace(156, 157, " ");
            this.lineContent = res.toString();
        }
    }

    @Override
    public String getCurrentFunction() {
        return String.valueOf(this.getCOFON()) + this.getCOFSO().trim();
    }

    @Override
    public boolean isSUP() {
        return this.lineContent.length() > 152 && "SUP".equals(this.lineContent.substring(150, 153));
    }

    @Override
    public char getConditionOrTreatment() {
        if (this.lineContent.length() > 156) {
            return this.lineContent.charAt(156);
        }
        return ' ';
    }

    @Override
    public void clearMacroLineNumber() {
        super.clearMacroLineNumber();
        if (this.getConditionOrTreatment() != ' ') {
            char[] tab = this.lineContent.toCharArray();
            tab[156] = 32;
            this.lineContent = new String(tab);
        }
    }

    public boolean isSpecialEtiquette() {
        StringTokenizer st;
        String tok;
        if (this.isEtiquette() && ((tok = (st = new StringTokenizer(this.getCOBOLcontent())).nextToken()).endsWith("-A.") || tok.endsWith("-B."))) {
            tok = tok.substring(0, tok.length() - 3);
            return this.getMiaFile().containsTag(tok);
        }
        return false;
    }

    @Override
    public boolean isArtificialCreate() {
        if (this.artificialCreate == MIALineImpl.Troolean.UNINITIALIZED) {
            if (this.getMiaFile().getFNLine(this) == null) {
                this.setArtificialCreate(this.getnbLineMsp() != null && "AAA".equals(this.getnbLineMsp().trim()));
            }
            this.setArtificialCreate(false);
        }
        return super.isArtificialCreate();
    }
}

