/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.pac.migration.help.mia.MIA2File;
import com.ibm.pdp.pac.migration.help.mia.MIA4File;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIALineProcedure;

public abstract class MIA2Line
extends MIALineImpl {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int MINIMUM_LINE_LENGTH = 32;
    private String G3 = null;
    private String G4A5 = null;
    private String G4 = null;
    private String G5 = null;
    private String G5B = null;
    private String G6 = null;
    private String G7 = null;
    private String G7A = null;
    private String G7B = null;
    private String G8 = null;
    private String G9 = null;
    private String G9A = null;
    private String G9A1 = null;
    private String G9A2 = null;
    private String G9B = null;
    private String G0 = null;
    private String GA = null;
    private String GB = null;
    private String GB1 = null;
    private String GC = null;
    private String FL74 = null;
    private String LICOB = null;
    private String FL11 = null;
    private String CORUB = null;
    private String nbLineMsp = null;
    private String MacroCode = null;
    private String COFON = null;
    private String COFSO = null;
    private String TYPST = null;
    private String nulim = null;
    private int level = 0;
    private String levelAsString = null;
    private String F80Info = null;
    private String fullF80Info = null;
    private String String122 = null;
    private String String18C = null;

    public MIA2Line(MIA2File file) {
        super(file);
    }

    public MIA2Line(MIA2File file, String lineContent) {
        super(file, lineContent);
    }

    @Override
    public void clean() {
        super.clean();
        this.G3 = null;
        this.G4A5 = null;
        this.G4 = null;
        this.G5 = null;
        this.G5B = null;
        this.G6 = null;
        this.G7 = null;
        this.G7A = null;
        this.G7B = null;
        this.G8 = null;
        this.G9 = null;
        this.G9A = null;
        this.G9A1 = null;
        this.G9A2 = null;
        this.G9B = null;
        this.G0 = null;
        this.GA = null;
        this.GB = null;
        this.GB1 = null;
        this.GC = null;
        this.FL74 = null;
        this.LICOB = null;
        this.FL11 = null;
        this.CORUB = null;
        this.String18C = null;
        this.String122 = null;
        this.COFON = null;
        this.COFSO = null;
        this.TYPST = null;
        this.nulim = null;
        this.level = 0;
        this.F80Info = null;
        this.fullF80Info = null;
    }

    @Override
    public int getIndexForMacroLineNumberBeginIndex() {
        return 135;
    }

    @Override
    public int getIndexForCobolContentBegin() {
        return 32;
    }

    @Override
    public int getIndexForCobolContentEnd() {
        return 112;
    }

    @Override
    public int getIndexForMacroCodeBegin() {
        return 127;
    }

    @Override
    public int getIndexForMacroCodeEnd() {
        return 135;
    }

    @Override
    public int getIndexForSubFunctionCodeBegin() {
        return 115;
    }

    public String getG3() {
        if (this.G3 == null) {
            this.G3 = this.lineContent.substring(11, 12);
        }
        return this.G3;
    }

    public String getG4A5() {
        if (this.G4A5 == null) {
            this.G4A5 = this.lineContent.substring(12, 17);
        }
        return this.G4A5;
    }

    public String getG4() {
        if (this.G4 == null) {
            this.G4 = this.lineContent.substring(12, 14);
        }
        return this.G4;
    }

    public String getG5() {
        if (this.G5 == null) {
            this.G5 = this.lineContent.substring(14, 17);
        }
        return this.G5;
    }

    public String getG5B() {
        if (this.G5B == null) {
            this.G5B = this.lineContent.substring(15, 17);
        }
        return this.G5B;
    }

    public String getG6() {
        if (this.G6 == null) {
            this.G6 = this.lineContent.substring(17, 18);
        }
        return this.G6;
    }

    public String getG7() {
        if (this.G7 == null) {
            this.G7 = this.lineContent.substring(18, 20);
        }
        return this.G7;
    }

    public String getG7A() {
        if (this.G7A == null) {
            this.G7A = this.lineContent.substring(18, 19);
        }
        return this.G7A;
    }

    public String getG7B() {
        if (this.G7B == null) {
            this.G7B = this.lineContent.substring(19, 20);
        }
        return this.G7B;
    }

    public String getG8() {
        if (this.G8 == null) {
            this.G8 = this.lineContent.substring(20, 21);
        }
        return this.G8;
    }

    public String getG9() {
        if (this.G9 == null) {
            this.G9 = this.lineContent.substring(21, 24);
        }
        return this.G9;
    }

    public String getG9A() {
        if (this.G9A == null) {
            this.G9A = this.lineContent.substring(21, 23);
        }
        return this.G9A;
    }

    public String getG9A1() {
        if (this.G9A1 == null) {
            this.G9A1 = this.lineContent.substring(21, 22);
        }
        return this.G9A1;
    }

    public String getG9A2() {
        if (this.G9A2 == null) {
            this.G9A2 = this.lineContent.substring(22, 23);
        }
        return this.G9A2;
    }

    public String getG9B() {
        if (this.G9B == null) {
            this.G9B = this.lineContent.substring(23, 24);
        }
        return this.G9B;
    }

    public String getG0() {
        if (this.G0 == null) {
            this.G0 = this.lineContent.substring(24, 25);
        }
        return this.G0;
    }

    public String getGA() {
        if (this.GA == null) {
            this.GA = this.lineContent.substring(25, 26);
        }
        return this.GA;
    }

    public String getGB() {
        if (this.GB == null) {
            this.GB = this.lineContent.substring(26, 29);
        }
        return this.GB;
    }

    public String getGB1() {
        if (this.GB1 == null) {
            this.GB1 = this.lineContent.substring(26, 27);
        }
        return this.GB1;
    }

    public String getGC() {
        if (this.GC == null) {
            this.GC = this.lineContent.substring(29, 30);
        }
        return this.GC;
    }

    public String getFL74() {
        if (this.FL74 == null) {
            this.FL74 = this.lineContent.length() >= 38 ? this.lineContent.substring(38, 112) : "";
        }
        return this.FL74;
    }

    public String getFL11() {
        if (this.FL11 == null) {
            this.FL11 = this.lineContent.length() >= 39 ? this.lineContent.substring(39, 50) : "";
        }
        return this.FL11;
    }

    public String getLICOB() {
        if (this.LICOB == null) {
            this.LICOB = this.lineContent.length() >= 39 ? this.lineContent.substring(39, 104) : "";
        }
        return this.LICOB;
    }

    public String getF80Info() {
        if (this.F80Info == null) {
            this.F80Info = this.lineContent.length() >= 142 ? this.lineContent.substring(142, 146) : "";
        }
        return this.F80Info;
    }

    public String getFullF80Info() {
        if (this.fullF80Info == null) {
            if (this.lineContent.length() >= 138) {
                int end = 138;
                while (this.lineContent.charAt(end++) != ' ') {
                }
                this.fullF80Info = this.lineContent.substring(138, end - 1);
            } else {
                this.fullF80Info = "";
            }
        }
        return this.fullF80Info;
    }

    public char getCol7() {
        if (this.lineContent.length() >= 38) {
            return this.lineContent.charAt(38);
        }
        return ' ';
    }

    public String getCORUB() {
        if (this.CORUB == null) {
            this.CORUB = this.lineContent.length() >= 121 ? (this.lineContent.length() >= 127 ? this.lineContent.substring(121, 127) : this.lineContent.substring(121)) : "";
        }
        return this.CORUB;
    }

    public String get18c() {
        if (this.String18C == null) {
            this.String18C = this.lineContent.substring(12, 30);
        }
        return this.String18C;
    }

    public String get7c() {
        return String.valueOf(this.getG4()) + this.getG5() + this.getG6() + this.getG7();
    }

    public String getnbLineMsp() {
        if (this.nbLineMsp == null) {
            this.nbLineMsp = this.lineContent.length() >= 135 ? (this.lineContent.length() >= 138 ? this.lineContent.substring(135, 138) : this.lineContent.substring(135)) : null;
        }
        return this.nbLineMsp;
    }

    public boolean isCOA() {
        return this.lineContent.length() > 138 && this.lineContent.substring(138, 141).equals("COA");
    }

    @Override
    public String getMacroCode() {
        if (this.MacroCode == null) {
            String s;
            this.MacroCode = this.lineContent.length() > this.getIndexForMacroCodeBegin() ? (this.lineContent.length() >= this.getIndexForMacroCodeEnd() ? ((s = this.lineContent.substring(this.getIndexForMacroCodeBegin(), this.getIndexForMacroCodeEnd())).trim().length() > 0 ? s : null) : this.lineContent.substring(this.getIndexForMacroCodeBegin())) : null;
        }
        return this.MacroCode;
    }

    public String getReferences() {
        if (this.lineContent.length() > 159) {
            return this.lineContent.substring(159);
        }
        return null;
    }

    public String getCOFON() {
        if (this.COFON == null) {
            this.COFON = this.lineContent.substring(113, 115);
        }
        return this.COFON;
    }

    public String getLevelValue(String key) {
        if (this.levelAsString == null) {
            String etiqu;
            String firstToken;
            if (key != null && ((MIA2File)this.getMiaFile()).fctAndLevels.containsKey(key)) {
                this.levelAsString = ((MIA2File)this.getMiaFile()).fctAndLevels.get(key);
                return this.levelAsString;
            }
            if (this.getMiaFile() instanceof MIA4File) {
                key = this.lineContent.substring(113, 117).trim();
                if (((MIA2File)this.getMiaFile()).fctAndLevels.containsKey(key)) {
                    this.levelAsString = ((MIA2File)this.getMiaFile()).fctAndLevels.get(key);
                } else {
                    if (!this.isFromMacro()) {
                        key = String.valueOf(key) + "__G";
                    }
                    this.levelAsString = ((MIA2File)this.getMiaFile()).fctAndLevels.containsKey(key) ? ((MIA2File)this.getMiaFile()).fctAndLevels.get(key) : this.lineContent.substring(117, 119);
                }
                return this.levelAsString;
            }
            key = firstToken = this.lineContent.substring(113, 117).trim();
            if (!this.isFromMacro()) {
                key = String.valueOf(key) + "__G";
            }
            if (((MIA2File)this.getMiaFile()).fctAndLevels.containsKey(key)) {
                this.levelAsString = ((MIA2File)this.getMiaFile()).fctAndLevels.get(key);
                return this.levelAsString;
            }
            if (!firstToken.startsWith("0A") && (etiqu = this.getMiaFile().getFName((MIALineProcedure)((Object)this))) != null) {
                firstToken = etiqu.substring(1);
            }
            this.levelAsString = firstToken.length() == 2 ? "05" : (firstToken.startsWith("20") || firstToken.startsWith("25") || firstToken.startsWith("35") || firstToken.startsWith("60") ? this.lineContent.substring(117, 119) : "10");
        }
        return this.levelAsString;
    }

    public int getLEVEL() {
        if (this.level == 0) {
            this.level = Integer.parseInt(this.getLevelValue(null));
        }
        return this.level;
    }

    public String getCOFSO() {
        if (this.COFSO == null) {
            this.COFSO = this.lineContent.substring(115, 117);
        }
        return this.COFSO;
    }

    public String getTYPST() {
        if (this.TYPST == null) {
            this.TYPST = this.lineContent.substring(119, 121);
        }
        return this.TYPST;
    }

    public String getString122() {
        if (this.String122 == null) {
            this.String122 = this.lineContent.substring(122, 123);
        }
        return this.String122;
    }

    public String getNulim() {
        if (this.nulim == null) {
            this.nulim = this.lineContent.substring(30, 32);
        }
        return this.nulim;
    }

    public boolean isHelp() {
        return this.lineContent.substring(7, 11).equals("HELP");
    }

    public void setG5(String s) {
        this.G5 = s;
    }

    public void setG6(String s) {
        this.G6 = s;
    }

    public void setG7(String s) {
        this.G7 = s;
    }

    public void setG8(String s) {
        this.G8 = s;
    }

    public void setG9(String s) {
        this.G9 = s;
    }

    public void setG0(String s) {
        this.G0 = s;
    }

    public void setGA(String s) {
        this.GA = s;
    }

    public void setGB(String s) {
        this.GB = s;
    }
}

