/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.pac.migration.help.mia.MIA2Constants;
import com.ibm.pdp.pac.migration.help.mia.MIA2Line;
import com.ibm.pdp.pac.migration.help.mia.MIA2LineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIA2LineWorking;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIAfile;
import com.ibm.pdp.pac.migration.help.mia.MIAinfo;
import com.ibm.pdp.pac.migration.help.mia.MIAinfoType;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class MIA2File
extends MIAfile
implements MIA2Constants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public boolean onlyWorking = false;
    boolean isProcedureDivisionUsing = false;
    protected boolean forMigration = true;
    protected boolean topF34 = false;
    private boolean topSQL = false;
    protected boolean topAVIND = false;
    protected boolean topAPIND = false;
    private boolean topNIV01 = false;
    private int carTop = 0;
    private int topF71 = 0;
    private int topF94 = 0;
    private int topF96 = 0;
    private int topLINK = 0;
    private boolean topALCARE = false;
    private HashMap<String, String> hmMemo = new HashMap();
    private String SaveCorub = null;
    private boolean topCommonArea = false;
    protected List<String> alFunctionsSubfunctionsInMacro = new ArrayList<String>();
    protected List<String> alFunctionsSubfunctionsInSpecific = new ArrayList<String>();
    protected List<String> allTagF60 = new ArrayList<String>();
    protected String memoNbLine = null;
    boolean endEtiquetteForMacro = false;
    boolean line900ForMacro = false;
    String screenType = "D";
    String AA200ForDialog = "200 E  35 ";
    String AA200ForClient = "200 E  ";
    String AA200ForServer = "200  D ";
    boolean topCloseTagAfterMP = false;
    boolean isNewSegmentOnF80 = false;
    boolean topFunction = false;
    ArrayList<String> alForTypeF = null;
    ArrayList<String> memoDO = new ArrayList();
    ArrayList<String> memoDW = new ArrayList();
    boolean topIndiceMsp = false;
    private boolean isF25generated = false;
    private boolean isF35generated = false;
    private boolean isF60generated = false;
    protected HashMap<String, String> fctAndLevels = new HashMap();

    public MIA2File(RadicalEntity entity) {
        super(entity, new HashMap<String, Boolean>());
    }

    public MIA2File(RadicalEntity entity, Map<String, Boolean> labelsAndEXIT) {
        super(entity, labelsAndEXIT);
    }

    @Override
    public Iterator<MIAinfo> analyseFirstMIAline(MIALineImpl currentMIAline) {
        List<MIAinfo> result = MIAinfo.CreateATag("ENTITY_" + this.getEntityName(), this);
        result.addAll(this.createATagFromMIAline(currentMIAline));
        if (currentMIAline instanceof MIA2LineWorking) {
            MIA2LineWorking line = (MIA2LineWorking)currentMIAline;
            this.screenType = (String.valueOf(line.getG6()) + line.getG7A()).trim();
        }
        return result.iterator();
    }

    @Override
    public Iterator<MIAinfo> analyseLastMIAline(MIALineImpl currentMIAline) {
        return null;
    }

    @Override
    public void clean() {
        super.clean();
        this.onlyWorking = false;
        this.isProcedureDivisionUsing = false;
        this.forMigration = true;
        this.topF34 = false;
        this.topSQL = false;
        this.topAVIND = false;
        this.topAPIND = false;
        this.topNIV01 = false;
        this.carTop = 0;
        this.topF71 = 0;
        this.topF94 = 0;
        this.topF96 = 0;
        this.topLINK = 0;
        this.topALCARE = false;
        this.hmMemo = new HashMap();
        this.SaveCorub = null;
        this.topCommonArea = false;
        this.alFunctionsSubfunctionsInMacro = new ArrayList<String>();
        this.alFunctionsSubfunctionsInSpecific = new ArrayList<String>();
        this.memoNbLine = null;
        this.endEtiquetteForMacro = false;
        this.line900ForMacro = false;
        this.topCloseTagAfterMP = false;
        this.isNewSegmentOnF80 = false;
        this.topIndiceMsp = false;
    }

    private void closeTagsIfNeeded(MIALineImpl firstLine, MIALineImpl secondLine, List<MIAinfo> result) {
        if (this.getNextWorkingLine() == null || "C0020 ".compareTo(String.valueOf(this.getNextWorkingLine().getG3()) + this.getNextWorkingLine().getG4() + this.getNextWorkingLine().getG5()) < 0 && this.containsTag("CONFIGURATION")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.getNextWorkingLine() == null || "60".compareTo(this.getNextWorkingLine().getG4()) <= 0 && this.containsTag("ENVIRONMENT")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    protected boolean containsTagCategory() {
        Stack<MIAinfo> mis = this.getTagsStack();
        Iterator it = mis.iterator();
        MIAinfo currentInfo = null;
        while (it.hasNext()) {
            currentInfo = (MIAinfo)it.next();
            if (currentInfo.getType() != MIAinfoType.CREATE_TAG || currentInfo.getTextOrTagName().length() != 4) continue;
            return true;
        }
        return false;
    }

    protected boolean containsTagBody() {
        Stack<MIAinfo> mis = this.getTagsStack();
        Iterator it = mis.iterator();
        MIAinfo currentInfo = null;
        while (it.hasNext()) {
            currentInfo = (MIAinfo)it.next();
            if (currentInfo.getType() != MIAinfoType.CREATE_TAG || currentInfo.getTextOrTagName().indexOf("-BODY") == -1) continue;
            return true;
        }
        return false;
    }

    protected List<MIAinfo> closeTagsUntilBODY() {
        Stack<MIAinfo> mis = this.getTagsStack();
        Iterator it = mis.iterator();
        MIAinfo currentInfo = null;
        int index = -1;
        while (it.hasNext()) {
            currentInfo = (MIAinfo)it.next();
            if (currentInfo.getType() != MIAinfoType.CREATE_TAG || currentInfo.getTextOrTagName().indexOf("-BODY") == -1) continue;
            index = this.getTagsStack().indexOf(currentInfo);
        }
        if (index != -1) {
            ArrayList<MIAinfo> l = new ArrayList<MIAinfo>();
            index = this.getTagsStack().size() - index;
            while (index-- > 0) {
                l.add(MIAinfo.CLOSE_TAG);
            }
            return l;
        }
        return Collections.emptyList();
    }

    protected Properties getLevelFrom(MIA2LineProcedure line, String key) {
        Properties p = new Properties();
        p.setProperty("level", line.getLevelValue(key));
        return p;
    }

    protected Properties getLevelFrom(String specialLevel) {
        Properties p = new Properties();
        p.setProperty("level", specialLevel);
        return p;
    }

    @Override
    public Iterator<MIAinfo> compareMIAlines(MIALineImpl firstLine, MIALineImpl secondLine) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (!this.onlyWorking && this.isInProcedure()) {
            if (this.isProcedureDivisionUsing) {
                if (this.isBreakOnG3((MIA2LineProcedure)secondLine, this.getNextProcedureLine())) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    result.addAll(this.closeTagsUntil(2));
                    this.isProcedureDivisionUsing = false;
                } else {
                    this.compareMIA2LinesProcedure((MIA2LineProcedure)firstLine, (MIA2LineProcedure)secondLine, result);
                }
            } else {
                this.compareMIA2LinesProcedure((MIA2LineProcedure)firstLine, (MIA2LineProcedure)secondLine, result);
            }
        } else if (secondLine instanceof MIA2LineWorking) {
            if (((MIA2LineWorking)secondLine).getCol7() != '*' && secondLine.getCOBOLcontent().indexOf("PROCEDURE DIVISION") != -1) {
                this.isProcedureDivisionUsing = true;
                this.topLINK = 0;
                result.addAll(this.closeTagsUntil(1));
                result.addAll(MIAinfo.CreateATag("PROCEDURE", this));
                result.addAll(MIAinfo.CreateATag("PROCEDURE-DIVISION", this));
                this.compareMIA2LinesWorking((MIA2LineWorking)firstLine, (MIA2LineWorking)secondLine, result);
            } else {
                this.compareMIA2LinesWorking((MIA2LineWorking)firstLine, (MIA2LineWorking)secondLine, result);
            }
        } else if (!this.onlyWorking) {
            if (!this.isProcedureDivisionUsing) {
                this.setInProcedure(true);
                this.firstMIA2LineProcedure((MIA2LineWorking)firstLine, (MIA2LineProcedure)secondLine, result);
            } else {
                if (secondLine.lineContent.substring(11, 120).trim().equals("G99999            U00      *") && this.getNextProcedureLine() != null && this.getNextProcedureLine().lineContent.substring(11, 32).trim().equals("G99999            U00")) {
                    return result.iterator();
                }
                this.setInProcedure(true);
                String G4 = ((MIA2LineProcedure)secondLine).getG4();
                String G5 = ((MIA2LineProcedure)secondLine).getG5();
                secondLine.tagName = "W-" + G4 + G5;
                if (this.getNextProcedureLine().getG5().equals("999")) {
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                }
                if (this.isBreakOnG3((MIA2LineProcedure)secondLine, this.getNextProcedureLine())) {
                    this.isProcedureDivisionUsing = false;
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
        return result.iterator();
    }

    protected void insertSpecialTagsForDialogFunction(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG4(firstLine, secondLine)) {
            result.addAll(this.closeTagsUntil(2));
        }
        String previousFNline = this.getFNLine(firstLine);
        if (secondLine.getG4().equals("25") && !this.containsTag("F25") && !this.isF25generated) {
            if (previousFNline != null && "F25".equals(previousFNline)) {
                this.isF25generated = true;
                return;
            }
            result.addAll(MIAinfo.CreateATag("F25", this.getLevelFrom("05"), this));
        }
        if (secondLine.getG4().equals("35") && !this.containsTag("F35") && !this.isF35generated) {
            if (previousFNline != null && "F35".equals(previousFNline)) {
                this.isF35generated = true;
                return;
            }
            result.addAll(MIAinfo.CreateATag("F35", this.getLevelFrom("05"), this));
        }
        if (secondLine.getG4().equals("60") && !this.containsTag("F60") && !this.isF60generated) {
            if (previousFNline != null && "F60".equals(previousFNline)) {
                this.isF60generated = true;
                return;
            }
            result.addAll(MIAinfo.CreateATag("F60", this.getLevelFrom("05"), this));
        }
        if (!this.isBufferBeginning(secondLine.getCOBOLcontent()) && secondLine.getG4().equals("65") && (this.lastTagCreated().getTextOrTagName().equals("F65A") || this.lastTagCreated().getTextOrTagName().equals("F65R") || this.lastTagCreated().getTextOrTagName().equals("F65Z")) && this.isBreakOnG7(firstLine, secondLine)) {
            result.addAll(this.closeTagsUntil(3));
        }
    }

    public List<MIAinfo> compareMIA2LinesProcedure(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!firstLine.getG4().equals(secondLine.getG4()) || !firstLine.getG5B().equals(secondLine.getG5B()) || !secondLine.getG4().equals("80") && !(String.valueOf(firstLine.getG0()) + firstLine.getGA()).equals(String.valueOf(secondLine.getG0()) + secondLine.getGA()) || secondLine.getG4().equals("80") && !(String.valueOf(firstLine.getGA()) + firstLine.getGB1()).equals(String.valueOf(secondLine.getGA()) + secondLine.getGB1())) {
            this.memoNbLine = null;
        }
        if (this.isBreakOnGA(firstLine, secondLine)) {
            this.topCloseTagAfterMP = false;
        }
        if (this.isBreakOnG6(firstLine, secondLine)) {
            this.topFunction = false;
        }
        if (this.isBufferEnding(secondLine.getCOBOLcontent())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (this.isSpecificLine(secondLine) && this.isBreakOnGA(secondLine, this.getNextProcedureLine()) && this.topCloseTagAfterMP && this.containsTagBody() && secondLine.getLEVEL() <= this.getNextProcedureLine().getLEVEL()) {
                result.add(MIAinfo.CLOSE_TAG);
                this.topCloseTagAfterMP = false;
            } else if (this.isSpecificLine(secondLine) && this.isBreakOnG4(secondLine, this.getNextProcedureLine()) && this.isDialogFunction(secondLine)) {
                result.addAll(this.closeTagsUntil(2));
            }
            return result;
        }
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (this.isBufferBeginning(secondLine.getCOBOLcontent())) {
            this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
            String secondSubFunction = this.computeSubFunction(secondLine);
            String tn = null;
            if (secondLine.getG4().equals("80")) {
                StringBuilder sb = new StringBuilder(11);
                sb.append("F");
                sb.append(secondLine.getG4());
                sb.append(secondLine.getCOFSO());
                if (secondLine.getCOBOLcontent().indexOf("\u00f4SQL") != -1) {
                    sb.append(secondLine.getnbLineMsp());
                    sb.append(secondLine.getnbLineMsp());
                    tn = sb.toString();
                } else if (!this.isBreakOnG5(firstLine, secondLine) && firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0) {
                    sb.append(this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()));
                    tn = sb.toString();
                } else {
                    sb.append(this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()));
                    tn = sb.toString();
                }
            } else {
                tn = !this.isBreakOnG5(firstLine, secondLine) && firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getG4() + secondSubFunction.trim() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "F" + secondLine.getG4() + secondSubFunction.trim() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
            }
            secondLine.tagName = tn;
            result.addAll(this.createATagBeforeBufferFromMIAline(secondLine));
            if (this.isSpecificLine(secondLine) && !this.isBufferEnding(firstLine.getCOBOLcontent()) && !this.isEndEtiquetteLine(firstLine) && (String.valueOf(firstLine.getCOFON()) + firstLine.getCOFSO()).trim().equals((String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim())) {
                this.topCloseTagAfterMP = true;
            }
            return result;
        }
        if (secondLine.getMacroCode() != null && secondLine.getnbLineMsp() != null && secondLine.getnbLineMsp().trim().length() > 0 && this.isBeginEtiquetteLine(secondLine)) {
            StringBuilder sb = new StringBuilder();
            int id = secondLine.getFL11().indexOf(".");
            sb.append(secondLine.getFL11().substring(0, id));
            if (secondLine.getMacroCode() != null) {
                this.alFunctionsSubfunctionsInMacro.add(sb.toString());
            } else {
                this.alFunctionsSubfunctionsInSpecific.add(sb.toString());
            }
        }
        if (this.isSpecificLine(secondLine)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (!firstLine.getG4().equals(secondLine.getG4())) {
            this.hmMemo = new HashMap();
        }
        if (secondLine.getG3().equals("G")) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (this.isBreakOnG3(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                return result;
            }
        }
        if (secondLine.getG3().equals("J") && ("IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
            this.procedureSpecialSQL(firstLine, secondLine, result);
            return result;
        }
        if (Ebcdic.stringCompare((String)String.valueOf(secondLine.getG3()), (String)"G") > 0) {
            if (this.isBreakOnG4(firstLine, secondLine)) {
                this.topF94 = 0;
            }
            if (this.isBreakOnG5(firstLine, secondLine)) {
                this.topF96 = 0;
            }
            this.setEndEtiquetteForMacro(secondLine);
            this.setLine900ForMacro(secondLine);
            if (secondLine.getCol7() == '*') {
                if ((secondLine.getMacroCode() != null || this.isEndEtiquetteForMacro()) && this.isDialogFunction(secondLine) && (secondLine.getG9B().trim().length() > 0 || secondLine.getMacroCode().trim().equals("\u00a3\u00a380EX"))) {
                    if (secondLine.getG4().equals("80")) {
                        this.procedure_specialDialog_ForMacro_ForF80(firstLine, secondLine, result);
                    } else {
                        this.procedure_specialDialog_ForMacro(firstLine, secondLine, result);
                    }
                } else if (secondLine.getG5().equals("G  ") && (String.valueOf(secondLine.getG0()) + secondLine.getGA()).trim().length() == 0 || "F".equals(this.screenType) && secondLine.getG5().equals("   ") && secondLine.getG6().equals("A")) {
                    this.procedure_F51AV(firstLine, secondLine, result);
                } else {
                    this.procedure_F51BE(firstLine, secondLine, result);
                }
            }
            if (!(secondLine.getG4().trim().length() <= 0 || secondLine.getCol7() == '*' || (secondLine.getG4().equals("20") || secondLine.getG4().equals("35") || secondLine.getG4().equals("80") || secondLine.getG4().equals("30") && "G  ".equals(secondLine.getG5())) && !"IT".equals(this.screenType) && !"F".equals(this.screenType) && !"FM".equals(this.screenType))) {
                if ("80".equals(secondLine.getG4()) && ("IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
                    this.procedure_F55(firstLine, secondLine, result);
                } else if (this.isDialogFunction(secondLine) && secondLine.getMacroCode() == null || !this.isDialogFunction(secondLine)) {
                    this.procedure_F51FC(firstLine, secondLine, result);
                }
            }
            if (secondLine.getG4().trim().length() == 0) {
                this.procedure_F51TM(firstLine, secondLine, result);
            }
            if (secondLine.getCol7() != '*' && this.isDialogFunction(secondLine) && !"IT".equals(this.screenType) && !"F".equals(this.screenType) && !"FM".equals(this.screenType)) {
                if ((secondLine.getMacroCode() != null || this.isEndEtiquetteForMacro()) && this.isDialogFunction(secondLine)) {
                    if (secondLine.getG4().equals("80")) {
                        this.procedure_specialDialog_ForMacro_ForF80(firstLine, secondLine, result);
                    } else {
                        this.procedure_specialDialog_ForMacro(firstLine, secondLine, result);
                    }
                } else {
                    if (secondLine.getG7().trim().length() == 0 && "G  ".equals(secondLine.getG5())) {
                        this.procedure_F52FF(firstLine, secondLine, result);
                    }
                    if (this.isBreakOnG7(firstLine, secondLine) && secondLine.getG7().trim().length() > 0 && "B".equals(secondLine.getG8()) && !"30".equals(secondLine.getG4()) && !"65".equals(secondLine.getG4()) && !"80".equals(secondLine.getG4())) {
                        this.procedure_F52GC(firstLine, secondLine, result);
                    }
                    if (this.isBreakOnG7(firstLine, secondLine) && secondLine.getG7().trim().length() > 0 && ("30".equals(secondLine.getG4()) || "65".equals(secondLine.getG4()))) {
                        this.procedure_F52GD(firstLine, secondLine, result);
                    }
                    if (this.isBreakOnG7(secondLine, this.getNextProcedureLine()) && secondLine.getG7().trim().length() > 0 && "Z".equals(secondLine.getG8()) && !"80".equals(secondLine.getG4())) {
                        this.procedure_F52GE(firstLine, secondLine, result);
                    }
                    if (secondLine.getG7().trim().length() > 0 && "X".equals(secondLine.getG8()) && "35".equals(secondLine.getG4())) {
                        this.procedure_F52GK(firstLine, secondLine, result);
                    }
                    if (!this.isBreakOnG7(firstLine, secondLine) && !this.isBreakOnG7(secondLine, this.getNextProcedureLine()) && secondLine.getG7().trim().length() > 0 && "B".equals(secondLine.getG8())) {
                        this.procedure_F52GM(firstLine, secondLine, result);
                    }
                    if (secondLine.getG7().trim().length() > 0 && "I".equals(secondLine.getG8()) && ("20".equals(secondLine.getG4()) || "35".equals(secondLine.getG4()))) {
                        this.procedure_F52GO(firstLine, secondLine, result);
                    }
                    if (!this.isBreakOnG7(firstLine, secondLine) && "I".equals(secondLine.getG8()) && ("30".equals(secondLine.getG4()) || "65".equals(secondLine.getG4()))) {
                        this.procedure_F52GZ(firstLine, secondLine, result);
                    } else {
                        if ("80".equals(secondLine.getG4()) && !"K".equals(secondLine.getG8()) && ("D".equals(this.screenType) && secondLine.getG5B().trim().length() == 0 && "C ".equals(secondLine.getG7()) || !"D".equals(this.screenType) && !"C ".equals(secondLine.getG7()) && secondLine.getG7().trim().length() > 0)) {
                            this.procedure_F52ID(firstLine, secondLine, result);
                        }
                        if ("80".equals(secondLine.getG4()) && secondLine.getG5B().trim().length() > 0 && ("C ".equals(secondLine.getG7()) || "MC".equals(this.screenType) && secondLine.getG7().trim().length() == 0)) {
                            this.procedure_F52KD(firstLine, secondLine, result);
                        }
                        if ("80".equals(secondLine.getG4()) && "G  ".equals(secondLine.getG5()) && "C ".equals(secondLine.getG7()) && "K".equals(secondLine.getG8())) {
                            this.procedure_F52LD(firstLine, secondLine, result);
                        }
                    }
                    if (secondLine.getG7().trim().length() > 0 && "I".equals(secondLine.getG8()) && ("25".equals(secondLine.getG4()) || "60".equals(secondLine.getG4()))) {
                        boolean topF60Spe = "C".equals(this.screenType) && "60".equals(secondLine.getG4()) && this.getNextProcedureLine().cobolContent.contains("-OPER NOT =");
                        this.procedure_F52MD(firstLine, secondLine, result, topF60Spe);
                    }
                    if (secondLine.isHelp() && ("60".equals(secondLine.getG4()) || "65".equals(secondLine.getG4())) && secondLine.getG5B().trim().length() > 0) {
                        this.procedure_ForHelp(firstLine, secondLine, result);
                    }
                }
            }
            if (result.isEmpty() && this.isEndEtiquetteLine(secondLine)) {
                if (!this.forMigration) {
                    String tn;
                    secondLine.tagName = tn = String.valueOf(this.lastTagCreated().getTextOrTagName()) + "-FN";
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        return null;
    }

    public List<MIAinfo> compareMIA2LinesWorking(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBufferBeginning(secondLine.getCOBOLcontent())) {
            if (this.topSQL) {
                this.topSQL = false;
                result.add(MIAinfo.CLOSE_TAG);
            } else if (this.containsTag("WSS-CONTINUATION") && !this.lastTagCreated().getTextOrTagName().equals("WSS-CONTINUATION")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.addAll(this.createATagBeforeBufferFromMIAline(secondLine));
            return result;
        }
        if (this.isBufferEnding(secondLine.getCOBOLcontent())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        if (!(this.isInBuffer() || !secondLine.isFromMacro() || "C".equals(secondLine.getG3()) || "E".equals(secondLine.getG3()) || "LINKAGE SECTION.".equals(secondLine.getLICOB().trim()))) {
            if (secondLine.getG4().equals("AA") && secondLine.getG5().equals("200")) {
                String tn;
                if ("D".equals(this.screenType) || ("C".equals(this.screenType) || "MC".equals(this.screenType)) && "E".equals(secondLine.getG7A())) {
                    secondLine.tagName = tn = secondLine.getFL74().trim().substring(3, 9).trim();
                }
                if ("E".equals(this.screenType) || "S".equals(this.screenType) || "MS".equals(this.screenType) || "MV".equals(this.screenType) || "IT".equals(this.screenType) || "FM".equals(this.screenType) || "F".equals(this.screenType)) {
                    if ("D".equals(secondLine.getG7B())) {
                        secondLine.tagName = tn = secondLine.getFL74().trim().substring(6, 12).trim();
                    }
                    if ("E".equals(secondLine.getG7B())) {
                        secondLine.tagName = tn = secondLine.getFL74().trim().substring(3, 9).trim();
                    }
                }
                if (("IT".equals(this.screenType) || "FM".equals(this.screenType) || "F".equals(this.screenType)) && this.isBreakOnG7(firstLine, secondLine) && !"D".equals(firstLine.getG7B()) && !"E".equals(secondLine.getG7B())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.topIndiceMsp = true;
            } else if (!(this.topAPIND || this.topAVIND || this.topF71 != 0 || this.lastTagCreated().getTextOrTagName().equals("WSS-CONTINUATION"))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.addAll(this.createOneTagFromMIAline(secondLine));
            if (secondLine.getG4A5().equals("AA200") && !secondLine.getG4A5().equals(this.getNextWorkingLine().getG4A5())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return result;
        }
        if ("C".equals(secondLine.getG3()) && secondLine.getG4().trim().length() == 0) {
            this.working_F50CB(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && "00".equals(secondLine.getG4()) && secondLine.getG5().trim().length() == 0) {
            this.working_F50DF(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && "00".equals(secondLine.getG4()) && "00 ".equals(secondLine.getG5())) {
            this.working_F50DI(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && "00".equals(secondLine.getG4()) && "10 ".equals(secondLine.getG5())) {
            this.working_F50DO(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && "00".equals(secondLine.getG4()) && "20 ".equals(secondLine.getG5())) {
            this.working_F50DS(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && "01".equals(secondLine.getG4())) {
            this.working_F50EE(firstLine, secondLine, result);
        }
        if ("C".equals(secondLine.getG3()) && result.isEmpty() && secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
        if ("E".equals(secondLine.getG3()) && "60".equals(secondLine.getG4()) && secondLine.getG5().trim().length() == 0) {
            this.working_F50FF(firstLine, secondLine, result);
        }
        if ("E".equals(secondLine.getG3()) && "99".equals(secondLine.getG4()) && "99".equals(secondLine.getG5().substring(0, 2))) {
            this.working_F50GF(firstLine, secondLine, result);
        }
        if ("F".equals(secondLine.getG3())) {
            this.working_F50GK(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && secondLine.get18c().trim().length() == 0) {
            this.working_F50IB(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && secondLine.get7c().trim().length() == 0 && ("1".equals(secondLine.getG0()) && secondLine.getG8().trim().length() == 0 || "A".equals(secondLine.getG8()))) {
            this.working_F50IE(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && secondLine.get7c().trim().length() == 0 && "B".equals(secondLine.getG8())) {
            if ("D".equals(this.screenType) || "E".equals(this.screenType) || "S".equals(this.screenType) || "MS".equals(this.screenType) || "MV".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType) || "IT".equals(this.screenType)) {
                if ("1".equals(secondLine.getG9B())) {
                    this.working_F50II(firstLine, secondLine, result);
                }
            } else {
                this.working_F50IL(firstLine, secondLine, result);
            }
        }
        if ("G".equals(secondLine.getG3()) && secondLine.get7c().trim().length() == 0 && ("D".equals(secondLine.getG8()) || "E".equals(secondLine.getG8()) || "F".equals(secondLine.getG8()) || "G".equals(secondLine.getG8()) || "C".equals(secondLine.getG8()) || "D".equals(this.screenType) && "B".equals(secondLine.getG8()) && "0".compareTo(secondLine.getG0()) < 0 && !"AA".equals(this.getNextWorkingLine().getG4()))) {
            this.working_F50IP(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && secondLine.getG4().trim().length() == 0 && secondLine.getG5().trim().length() == 0 && secondLine.getG6().trim().length() > 0 && !"C".equals(secondLine.getG6())) {
            this.working_F50IT(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && secondLine.getG4().trim().length() == 0 && "000".equals(secondLine.getG5())) {
            if (secondLine.getG6().trim().length() == 0) {
                this.working_F50IZ(firstLine, secondLine, result);
            } else {
                this.working_F50JA(firstLine, secondLine, result);
            }
        }
        String nextFL74 = secondLine.getFL74();
        if (!(!"G".equals(secondLine.getG3()) || secondLine.getG4().trim().length() != 0 || "000".equals(secondLine.getG5()) || secondLine.getG5().trim().length() <= 0 && !"C".equals(secondLine.getG6()) || nextFL74.length() > 23 && "EXEC SQL INCLUDE".equals(nextFL74.substring(8, 24)) && "S".equals(this.screenType))) {
            this.working_F50JD(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && ("AA".equals(secondLine.getG4()) && !"200".equals(secondLine.getG5()) || "00".equals(secondLine.getG4()) && this.topLINK == 0 && !"LINKAGE SECTION.".equals(secondLine.getLICOB().trim()) || EBCDICCompare.stringCompare((String)"AA", (String)secondLine.getG4()) < 0 && EBCDICCompare.stringCompare((String)"00", (String)secondLine.getG4()) > 0 && !"EXEC SQL".equals(nextFL74.substring(8, 16)) && !this.topSQL && !"LINKAGE SECTION.".equals(secondLine.getLICOB().trim())) && this.topLINK == 0) {
            this.working_F50KA(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && !"AA".equals(secondLine.getG4()) && secondLine.getG4().trim().length() != 0 && "00".compareTo(secondLine.getG4()) < 0 && ("EXEC SQL".equals(secondLine.getFL74().substring(8, 16)) || this.topSQL)) {
            this.working_F50KK(firstLine, secondLine, result);
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ("G".equals(secondLine.getG3()) && secondLine.getG4().trim().length() == 0 && "99999 ZD ".equals(String.valueOf(secondLine.getG8()) + secondLine.getG9() + secondLine.getG9B() + secondLine.getGA() + secondLine.getGB()) && "EXEC SQL INCLUDE".equals(secondLine.getFL74().substring(8, 24)) && "S".equals(this.screenType)) {
            this.working_F50KM(firstLine, secondLine, result);
        }
        if ("G".equals(secondLine.getG3()) && "AA".equals(secondLine.getG4()) && "200".equals(secondLine.getG5())) {
            this.working_F50KP(firstLine, secondLine, result);
        }
        if ("LINKAGE SECTION.".equals(secondLine.getLICOB().trim()) || this.topLINK == 1) {
            this.working_F50LS(firstLine, secondLine, result);
        }
        if (!secondLine.isFromMacro() && "G".equals(secondLine.getG3()) && "  ".compareTo(secondLine.getG4()) < 0 && "U".equals(secondLine.getGC()) || this.topLINK == 1 && !"99999".equals(secondLine.getG4A5()) && !"LINKAGE SECTION.".equals(secondLine.getLICOB().trim()) || this.topLINK == 2 && !"99999".equals(secondLine.getG4A5())) {
            this.working_F50ND(firstLine, secondLine, result);
        }
        return result;
    }

    public List<MIAinfo> firstMIA2LineProcedure(MIA2LineWorking firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        this.topLINK = 0;
        result.addAll(this.closeTagsUntil(1));
        result.addAll(MIAinfo.CreateATag("PROCEDURE", this));
        if (secondLine.getGB1().equals("A")) {
            secondLine.tagName = "PROCEDURE-DIVISION";
            if (this.isBreakOnG3(secondLine, this.getNextProcedureLine())) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(this.createATagFromMIAline(secondLine));
            }
        } else {
            result.addAll(MIAinfo.CreateATag("PROCEDURE-DIVISION", this));
            if (secondLine.lineContent.substring(11, 39).trim().equals("G99999            U00")) {
                secondLine.tagName = "W-" + secondLine.getG4A5();
                if (this.isBreakOnG3(secondLine, this.getNextProcedureLine())) {
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                } else {
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        return result;
    }

    @Override
    protected List<MIALineImpl> fnLinesOrganization(MIALineImpl line) {
        this.ffnnToAdd = null;
        this.ffnnToAddBefore = null;
        this.ffToAdd = null;
        this.ffToAddBefore = null;
        return Collections.emptyList();
    }

    @Override
    public int getMinimumLineLength() {
        return 32;
    }

    public MIA2LineProcedure getNextProcedureLine() {
        if (this.getNextLine() instanceof MIA2LineProcedure) {
            return (MIA2LineProcedure)this.getNextLine();
        }
        return null;
    }

    public MIA2LineWorking getNextWorkingLine() {
        if (this.getNextLine() instanceof MIA2LineWorking) {
            return (MIA2LineWorking)this.getNextLine();
        }
        return null;
    }

    @Override
    public String getPatternName() {
        return "com.ibm.pdp.pacbase.dialog";
    }

    protected String getSaveCorub() {
        return this.SaveCorub;
    }

    protected boolean isTopALCARE() {
        return this.topALCARE;
    }

    protected void setSaveCorub(String saveCorub) {
        this.SaveCorub = saveCorub;
    }

    protected void setTopALCARE(boolean topALCARE) {
        this.topALCARE = topALCARE;
    }

    @Override
    public MIALineImpl instanciateMIAline(String lineContent) {
        if (!this.isLineOk(lineContent)) {
            return null;
        }
        MIA2Line line = null;
        if (Ebcdic.stringCompare((String)lineContent.substring(11, 17), (String)"G99999") >= 0) {
            line = new MIA2LineProcedure(this, lineContent);
            this.modifyFNLine((MIA2LineProcedure)line);
            this.storeLevel((MIA2LineProcedure)line);
        } else {
            line = new MIA2LineWorking(this, lineContent);
            if (!this.isLineToKeep((MIA2LineWorking)line)) {
                return null;
            }
        }
        return line;
    }

    protected void modifyFNLine(MIA2LineProcedure line) {
        String firstToken;
        if (!("IT".equals(this.screenType) || "FM".equals(this.screenType) || "F".equals(this.screenType) || (firstToken = line.getCOBOLcontent()).charAt(6) == '*' || firstToken.charAt(7) == ' ')) {
            String fct;
            int index = (firstToken = firstToken.trim()).indexOf(32);
            if (index != -1) {
                firstToken = firstToken.substring(0, index);
            }
            if ((index = firstToken.indexOf(46)) != -1) {
                firstToken = firstToken.substring(0, index);
            }
            if (firstToken.endsWith("-FN") && (firstToken = firstToken.substring(1, firstToken.length() - 3)).length() == 4 && "25".equals(fct = firstToken.substring(0, 2).trim())) {
                String ssfct = firstToken.substring(2);
                String ref = line.lineContent.substring(15, 17).trim();
                if (ref.length() == 2 && !ref.equals(ssfct)) {
                    StringBuilder sb = new StringBuilder(line.lineContent);
                    sb.replace(15, 17, ssfct);
                    line.lineContent = sb.toString();
                }
            }
        }
    }

    protected void storeLevel(MIA2LineProcedure line) {
        String firstToken = this.getFName(line);
        if (firstToken != null && this.getFNLine(line) == null) {
            firstToken = firstToken.substring(1);
            String lv = "";
            if (line.lineContent.length() > 106 && line.lineContent.charAt(104) == 'l' && line.lineContent.charAt(105) == 'v') {
                lv = line.lineContent.substring(106, 108);
            } else if (!line.isFromMacro()) {
                if (line.isSUP()) {
                    lv = "10";
                }
                firstToken = String.valueOf(firstToken) + "__G";
            }
            if (lv.trim().length() > 0) {
                this.fctAndLevels.put(firstToken, lv);
            }
        }
    }

    protected boolean isLineToKeep(MIA2LineWorking line) {
        if (line.getG4().equals("AA") && line.getG5().equals("200")) {
            String futureTagName = null;
            if ("D".equals(this.screenType) && "E".equals(line.getG7A()) && "35".equals(line.getG9A())) {
                futureTagName = line.getFL74().trim().substring(3, 9);
            }
            if (("C".equals(this.screenType) || "MC".equals(this.screenType)) && "E".equals(line.getG7A()) && "WW".equals(line.getG9A())) {
                futureTagName = line.getFL74().trim().substring(3, 9);
            }
            if (("S".equals(this.screenType) || "MS".equals(this.screenType) || "MV".equals(this.screenType)) && "E".equals(line.getG7A()) && "W1".equals(line.getG9A())) {
                futureTagName = line.getFL74().trim().substring(3, 9);
            }
            if (futureTagName != null) {
                if (this.allIndices.contains(futureTagName)) {
                    return false;
                }
                this.allIndices.add(futureTagName);
            }
        }
        return true;
    }

    protected boolean isBreakOnG3(MIA2Line firstLine, MIA2Line secondLine) {
        return secondLine == null || !firstLine.getG3().equals(secondLine.getG3());
    }

    protected boolean isBreakOnG4(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG3(firstLine, secondLine) || !firstLine.getG4().equals(secondLine.getG4());
    }

    protected boolean isBreakOnG5(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG4(firstLine, secondLine) || !firstLine.getG5().equals(secondLine.getG5());
    }

    protected boolean isBreakOnG6(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG5(firstLine, secondLine) || !firstLine.getG6().equals(secondLine.getG6());
    }

    protected boolean isBreakOnG7(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG6(firstLine, secondLine) || !firstLine.getG7().equals(secondLine.getG7());
    }

    protected boolean isBreakOnG8(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG7(firstLine, secondLine) || !firstLine.getG8().equals(secondLine.getG8());
    }

    protected boolean isBreakOnG9A(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG8(firstLine, secondLine) || !firstLine.getG9A().equals(secondLine.getG9A());
    }

    protected boolean isBreakOnG9B(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG9A(firstLine, secondLine) || !firstLine.getG9B().equals(secondLine.getG9B());
    }

    private boolean isBreakOnG0(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG9B(firstLine, secondLine) || !firstLine.getG0().equals(secondLine.getG0());
    }

    protected boolean isBreakOnGA(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnG0(firstLine, secondLine) || !firstLine.getGA().equals(secondLine.getGA());
    }

    private boolean isBreakOnGB(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnGA(firstLine, secondLine) || !firstLine.getGB().equals(secondLine.getGB());
    }

    protected boolean isBreakOnGB1(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnGA(firstLine, secondLine) || !firstLine.getGB1().equals(secondLine.getGB1());
    }

    protected boolean isBreakOnGC(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnGB(firstLine, secondLine) || !firstLine.getGC().equals(secondLine.getGC());
    }

    private boolean isBreakOnNulim(MIA2Line firstLine, MIA2Line secondLine) {
        return this.isBreakOnGC(firstLine, secondLine) || !firstLine.getNulim().equals(secondLine.getNulim());
    }

    private boolean isBreakOnNumberLineOrCondition(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine) {
        return !firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || firstLine.getConditionOrTreatment() != secondLine.getConditionOrTreatment();
    }

    private boolean isDialogFunction(MIA2LineProcedure line) {
        return line.getG4().equals("20") || line.getG4().equals("25") && !line.getG5B().equals("99") || line.getG4().equals("30") || line.getG4().equals("35") || line.getG4().equals("60") || line.getG4().equals("65") || line.getG4().equals("80");
    }

    protected boolean isBeginEtiquetteLine(MIA2LineProcedure line) {
        return line.getCol7() != '*' && line.getFL11().charAt(0) == 'F' && !line.isCOA() && (line.getFL11().charAt(3) == '.' || line.getFL11().charAt(5) == '.');
    }

    protected void setEndEtiquetteForMacro(MIA2LineProcedure secondLine) {
        this.endEtiquetteForMacro = false;
        if (secondLine.getMacroCode() == null && this.isEndEtiquetteLine(secondLine)) {
            StringBuilder sb = new StringBuilder();
            int id = secondLine.getFL11().indexOf("-FN.");
            sb.append(secondLine.getFL11().substring(0, id));
            if (this.alFunctionsSubfunctionsInMacro.indexOf(sb.toString()) != -1 && this.containsTag(sb.toString())) {
                this.endEtiquetteForMacro = true;
            }
        }
    }

    protected void setLine900ForMacro(MIA2LineProcedure secondLine) {
        this.line900ForMacro = false;
        if (secondLine.getMacroCode() == null && this.isLine900(secondLine)) {
            StringBuilder sb = new StringBuilder();
            int id = secondLine.getFL11().indexOf("-900.");
            sb.append(secondLine.getFL11().substring(0, id));
            if (this.alFunctionsSubfunctionsInMacro.indexOf(sb.toString()) != -1) {
                this.line900ForMacro = true;
            }
        }
    }

    protected boolean isEndEtiquetteForMacro() {
        return this.endEtiquetteForMacro;
    }

    private boolean isline900ForMacro() {
        return this.line900ForMacro;
    }

    private boolean isEndEtiquetteLine(MIA2LineProcedure line) {
        return line.getCol7() != '*' && line.getFL11().charAt(0) == 'F' && !line.isCOA() && (line.getFL11().substring(3, 7).equals("-FN.") || line.getFL11().substring(4, 8).equals("-FN.") || line.getFL11().substring(5, 9).equals("-FN."));
    }

    private boolean isEndFunctionEtiquetteLine(MIA2LineProcedure line) {
        return line.getCol7() != '*' && line.getFL11().charAt(0) == 'F' && !line.isCOA() && line.getFL11().substring(3, 7).equals("-FN.");
    }

    protected boolean isLine900(MIA2LineProcedure line) {
        return line.getCol7() != '*' && line.getFL11().charAt(0) == 'F' && (line.getFL74().substring(4, 12).equals("-900.") || line.getFL74().substring(6, 14).equals("-900. GO"));
    }

    @Override
    public boolean isMicroPatternAnnotationsToKeep(String mpID) {
        return mpID.startsWith("AD") || "WI".equals(mpID) || "WE".equals(mpID) || "WS".equals(mpID) || "WF".equals(mpID) || "GF".equals(mpID) || "TIM".equals(mpID) || "TIF".equals(mpID) || "DAO".equals(mpID) || "DAD".equals(mpID) || "DCD".equals(mpID) || "DCF".equals(mpID) || "DID".equals(mpID) || "DIF".equals(mpID) || "DVD".equals(mpID) || "DVF".equals(mpID) || "PCB".equals(mpID) || "OSC".equals(mpID) || "OSD".equals(mpID) || "XR".equals(mpID) || "XP".equals(mpID) || "XP1".equals(mpID) || "XRN".equals(mpID) || "XD".equals(mpID) || "XRU".equals(mpID) || "XW".equals(mpID) || "XRW".equals(mpID) || "XUN".equals(mpID) || "MCI".equals(mpID) || "ERR".equals(mpID) || "ERU".equals(mpID) || "SQL".equals(mpID);
    }

    @Override
    protected boolean isSpecialMicroPatternNotTogenerate(String microPatternID) {
        if ("SQL".equals(microPatternID)) {
            for (MIAinfo mi : this.getTagsStack()) {
                if (!mi.getTextOrTagName().equals("F80")) continue;
                return true;
            }
        }
        return super.isSpecialMicroPatternNotTogenerate(microPatternID);
    }

    protected boolean isSpecificLine(MIA2LineProcedure secondLine) {
        if (secondLine.getMacroCode() == null && secondLine.getnbLineMsp() != null && secondLine.getnbLineMsp().trim().length() > 0 || this.isEndEtiquetteLine(secondLine)) {
            if (secondLine.getCol7() == '*') {
                return true;
            }
            if (this.isEndEtiquetteLine(secondLine)) {
                StringBuilder sb = new StringBuilder();
                int id = secondLine.getFL74().indexOf("-FN.");
                sb.append(secondLine.getFL74().substring(1, id));
                if (this.alFunctionsSubfunctionsInSpecific.indexOf(sb.toString()) != -1) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void initialize_specialMacroforF80(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        boolean specialFunctionAlreadyExists = false;
        if (secondLine.getG4().equals("80") && (this.getNextProcedureLine().getF80Info().trim().length() > 0 || secondLine.getF80Info().trim().length() > 0)) {
            String tagNameToCreate;
            int numberOfClosedTags = 0;
            if (this.isBreakOnG9A(firstLine, secondLine)) {
                numberOfClosedTags = this.getTagsStack().size();
                result.addAll(this.closeTagsUntil(3));
                numberOfClosedTags -= result.size();
                tagNameToCreate = "";
                if (this.getNextProcedureLine().getF80Info().trim().length() > 0) {
                    tagNameToCreate = "F80-" + this.getNextProcedureLine().getF80Info();
                } else if (secondLine.getF80Info().trim().length() > 0) {
                    tagNameToCreate = "F80-" + secondLine.getF80Info();
                }
                if (!this.containsTag(tagNameToCreate)) {
                    result.addAll(MIAinfo.CreateATag(tagNameToCreate, this.getLevelFrom("09.5"), this));
                }
            }
            tagNameToCreate = this.getNextProcedureLine().getFullF80Info();
            specialFunctionAlreadyExists = this.lastTagCreated().getTextOrTagName().equals(tagNameToCreate);
            if (!specialFunctionAlreadyExists && tagNameToCreate.indexOf(45) != tagNameToCreate.lastIndexOf(45)) {
                result.addAll(this.closeTagsUntil(4 + numberOfClosedTags));
                result.addAll(MIAinfo.CreateATag(this.getNextProcedureLine().getFullF80Info(), this));
            }
        } else if (secondLine.isArtificialCreate()) {
            String lv = secondLine.getLevelValue(null);
            if (secondLine.lineContent.length() > 118) {
                lv = secondLine.lineContent.substring(117, 119);
            }
            specialFunctionAlreadyExists = true;
            if (lv != null) {
                boolean bl = specialFunctionAlreadyExists = lv.compareTo("10") > 0;
            }
        }
        if (result.isEmpty() && !specialFunctionAlreadyExists) {
            int numberOfClosedTags = 0;
            if (this.lastTagCreated() != null && this.lastTagCreated().getTextOrTagName().startsWith("F80-")) {
                if (this.lastTagCreated().getTextOrTagName().indexOf("-") != this.lastTagCreated().getTextOrTagName().lastIndexOf("-")) {
                    result.add(MIAinfo.CLOSE_TAG);
                    ++numberOfClosedTags;
                }
                if (this.isBreakOnG9A(firstLine, secondLine)) {
                    result.addAll(this.closeTagsUntil(3 + numberOfClosedTags));
                }
            }
        }
    }

    private void procedureSpecialSQL(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG3(firstLine, secondLine)) {
            result.addAll(this.closeTagsUntil(2));
            result.addAll(MIAinfo.CreateATag("FSQL", this));
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return;
        }
        if (secondLine.getG4A5().trim().length() == 0) {
            if (this.isBreakOnG8(firstLine, secondLine)) {
                result.addAll(this.closeTagsUntil(3));
                result.addAll(MIAinfo.CreateATag("FSQL-WHENEVER", this));
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                return;
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (secondLine.getG8().trim().length() != 0 && this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            if (this.isBreakOnG5(firstLine, secondLine)) {
                result.addAll(this.closeTagsUntil(3));
                String segmentCode = secondLine.getG4A5().trim();
                String tagName = "SQL-CURSR-" + segmentCode;
                result.addAll(MIAinfo.CreateATag("F" + tagName, this));
                if (secondLine.getCol7() == '*') {
                    result.addAll(MIAinfo.CreateATag("N" + tagName, this));
                }
            }
            if (this.lastTagCreated().getTextOrTagName().charAt(0) == 'N' && secondLine.getCol7() != '*') {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG3(secondLine, this.getNextProcedureLine())) {
            result.addAll(MIAinfo.InsertText("       FSQL-FN. EXIT.\r\n", this));
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_specialDialog_ForMacro_ForF80(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getFL11().charAt(0) == 'N' && this.isBeginEtiquetteLine(this.getNextProcedureLine())) {
            this.initialize_specialMacroforF80(firstLine, secondLine, result);
            this.insertRefIfPossible(secondLine);
            secondLine.addProperty("level", secondLine.getLevelValue(null));
            result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), secondLine.getProperties(), this));
            secondLine.removeProperty("level");
            secondLine.tagName = "N" + secondLine.getCOFON() + secondLine.getCOFSO() + secondLine.getnbLineMsp();
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else if (this.isBeginEtiquetteLine(secondLine)) {
            if (this.isEndEtiquetteLine(firstLine) || !firstLine.getG5B().equals(secondLine.getG5B()) || !this.lastTagCreated().getTextOrTagName().equals("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim()) || !(String.valueOf(firstLine.getG0()) + firstLine.getGA()).equals(String.valueOf(secondLine.getG0()) + secondLine.getGA())) {
                this.initialize_specialMacroforF80(firstLine, secondLine, result);
                secondLine.addProperty("level", secondLine.getLevelValue(null));
                result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), secondLine.getProperties(), this));
                secondLine.removeProperty("level");
            }
            if (this.isBeginEtiquetteLine(secondLine) && secondLine.getG5B().trim().length() > 0 && (firstLine.getCol7() != '*' || firstLine.getFL11().charAt(0) != 'N')) {
                this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
            } else {
                secondLine.tagName = "F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim();
                if ("AAA".equals(secondLine.getnbLineMsp().trim())) {
                    this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                    return;
                }
                result.addAll(this.createATagFromMIAline(secondLine));
            }
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !(String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) && (!this.isBeginEtiquetteLine(secondLine) || secondLine.getG5B().trim().length() == 0 || firstLine.getCol7() == '*' && firstLine.getFL11().charAt(0) == 'N') || secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' && !"AAA".equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.getNextProcedureLine().getnbLineMsp() != null && this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) && this.getNextProcedureLine().getnbLineMsp().equals("000") && (!this.getNextProcedureLine().getCOFON().equals(secondLine.getCOFON()) || !this.getNextProcedureLine().getCOFSO().equals(secondLine.getCOFSO()))) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!(!this.isEndEtiquetteLine(this.getNextProcedureLine()) && secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && (secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) || secondLine.getLEVEL() < this.getNextProcedureLine().getLEVEL()) && (String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) || this.forMigration || secondLine.getG4().equals("30") || this.isBeginEtiquetteLine(secondLine))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else if (this.isLine900(secondLine)) {
            String tn;
            if (!this.getTagsStack().peek().getProperties().containsKey("level")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            secondLine.tagName = tn = secondLine.getFL11().trim().substring(0, secondLine.getFL11().trim().indexOf("."));
            if (firstLine.getMacroCode() != null) {
                secondLine.setMacroCode(firstLine.getMacroCode());
            }
            result.addAll(this.createATagFromMIAline(secondLine));
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !(String.valueOf(secondLine.getGA()) + secondLine.getGB1()).trim().equals((String.valueOf(this.getNextProcedureLine().getGA()) + this.getNextProcedureLine().getGB1()).trim()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else if (firstLine.getnbLineMsp() != null && this.isBreakOnNumberLineOrCondition(firstLine, secondLine) && !this.isEndEtiquetteLine(secondLine) && !this.isLine900(secondLine) || this.isBeginEtiquetteLine(secondLine)) {
            secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
            if (this.lastTagCreated().getTextOrTagName().equals(secondLine.tagName)) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            } else {
                result.addAll(this.createATagFromMIAline(secondLine));
            }
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !(String.valueOf(secondLine.getGA()) + secondLine.getGB1()).trim().equals((String.valueOf(this.getNextProcedureLine().getGA()) + this.getNextProcedureLine().getGB1()).trim()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isLine900(this.getNextProcedureLine()) || this.isEndEtiquetteLine(this.getNextProcedureLine()) || !this.getNextProcedureLine().isFromMacro() && this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!this.isEndEtiquetteLine(secondLine) && !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) && ("IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            boolean imbricFct;
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4())) {
                result.addAll(this.closeTagsUntil(2));
                return;
            }
            boolean bl = imbricFct = this.getNextProcedureLine().getLevelValue(null).compareTo(secondLine.getLevelValue(null)) > 0;
            if (!imbricFct && (!this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !(String.valueOf(secondLine.getGA()) + secondLine.getGB1()).trim().equals((String.valueOf(this.getNextProcedureLine().getGA()) + this.getNextProcedureLine().getGB1()).trim())) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isLine900(this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!imbricFct && this.isCloseTagNeeded(secondLine, result)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
    }

    private boolean isCloseTagNeeded(MIA2LineProcedure line, List<MIAinfo> result) {
        if (line.getMacroCode() != null && this.isBreakOnG9A(line, this.getNextProcedureLine())) {
            if (line.getMacroCode().trim().length() > 6 || this.getNextProcedureLine().getCOBOLcontent().startsWith("       F80-FN.")) {
                Iterator it = this.getTagsStack().iterator();
                it.next();
                if (it.hasNext() && ((MIAinfo)it.next()).getTextOrTagName().equals("PROCEDURE") && it.hasNext() && ((MIAinfo)it.next()).getTextOrTagName().equals("F80") && it.hasNext() && ((MIAinfo)it.next()).getTextOrTagName().startsWith("F80-")) {
                    return true;
                }
            } else if (!this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                String nextFctCode;
                String lastTagName = this.lastTagCreated().getTextOrTagName().substring(1);
                return EBCDICCompare.stringCompare((String)lastTagName, (String)(nextFctCode = (String.valueOf(this.getNextProcedureLine().getG4()) + this.getNextProcedureLine().getG5B()).trim())) > 0;
            }
            return false;
        }
        return false;
    }

    private boolean isSimulationLevel99(MIA2LineProcedure secondLine) {
        return this.isBeginEtiquetteLine(secondLine) && secondLine.getCOBOLcontent().indexOf(" IF ") != -1;
    }

    private void insertRefIfPossible(MIA2LineProcedure line) {
        MIA2LineProcedure realLine = line;
        if (line.getG4().equals("80")) {
            realLine = this.getNextProcedureLine();
        }
        if (this.isDialogFunction(realLine) && realLine.getTYPST().charAt(0) == '*') {
            if (realLine.getFullF80Info().trim().length() > 0) {
                line.addProperty("refMIA", realLine.getFullF80Info());
            } else {
                line.addProperty("refMIA", "ZZ");
            }
        }
    }

    private void procedure_specialDialog_ForMacro(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!result.isEmpty()) {
            return;
        }
        if (secondLine.getFL11().charAt(0) == 'N' && this.isBeginEtiquetteLine(this.getNextProcedureLine())) {
            this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
            if (this.containsTagBody()) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            secondLine.addProperty("level", secondLine.getLevelValue(null));
            this.insertRefIfPossible(secondLine);
            result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), secondLine.getProperties(), this));
            secondLine.removeProperty("level");
            secondLine.removeProperty("refMIA");
            secondLine.tagName = "N" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim();
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else if (this.isBeginEtiquetteLine(secondLine)) {
            String tagName;
            this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
            if (!(!this.isEndEtiquetteLine(firstLine) && firstLine.getG5B().equals(secondLine.getG5B()) && (String.valueOf(firstLine.getG0()) + firstLine.getGA()).equals(String.valueOf(secondLine.getG0()) + secondLine.getGA()) || this.tagAlreadyCreated(tagName = "F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim(), this.getTagsStack().iterator()) || this.tagAlreadyCreated(tagName, result.iterator()))) {
                secondLine.addProperty("level", secondLine.getLevelValue(null));
                result.addAll(MIAinfo.CreateATag(tagName, secondLine.getProperties(), this));
                secondLine.removeProperty("level");
            }
            if (!this.forMigration && !secondLine.getG4().equals("30")) {
                result.addAll(MIAinfo.CreateATag("F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim() + "-BODY", secondLine.getProperties(), this));
            }
            if (this.isBreakOnG5(firstLine, secondLine) && !this.isSimulationLevel99(secondLine) && !secondLine.getnbLineMsp().equals(this.getNextProcedureLine().getnbLineMsp())) {
                if ("AAA".equals(secondLine.getnbLineMsp().trim())) {
                    this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                    return;
                }
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            } else {
                secondLine.tagName = "F" + (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO() + secondLine.getnbLineMsp()).trim();
                if ("AAA".equals(secondLine.getnbLineMsp().trim())) {
                    this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                    return;
                }
                result.addAll(this.createATagFromMIAline(secondLine));
            }
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !(String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) && (!this.isBeginEtiquetteLine(secondLine) || secondLine.getG5B().trim().length() == 0 || firstLine.getCol7() == '*' && firstLine.getFL11().charAt(0) == 'N') || this.isEndEtiquetteLine(this.getNextProcedureLine()) || secondLine.getConditionOrTreatment() == ' ' && this.getNextProcedureLine().getConditionOrTreatment() == 'T' || this.getNextProcedureLine().getnbLineMsp() != null && this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) && this.getNextProcedureLine().getnbLineMsp().equals("000") && (!this.getNextProcedureLine().getCOFON().equals(secondLine.getCOFON()) || !this.getNextProcedureLine().getCOFSO().equals(secondLine.getCOFSO()))) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!(!this.isEndEtiquetteLine(this.getNextProcedureLine()) && secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) && (String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) || this.forMigration || secondLine.getG4().equals("30"))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else if (this.isEndEtiquetteLine(secondLine) || this.isLine900(secondLine)) {
            if (this.isEndEtiquetteLine(secondLine) && this.containsTagBody()) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (!secondLine.getG4().equals("30")) {
                String tn;
                secondLine.tagName = tn = secondLine.getFL11().trim().substring(0, secondLine.getFL11().trim().indexOf("."));
                if (this.isLine900(secondLine)) {
                    if (!this.forMigration) {
                        result.addAll(this.closeTagsUntilBODY());
                    } else if (!this.getTagsStack().peek().getProperties().containsKey("level")) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                } else {
                    if (!this.forMigration) {
                        result.addAll(this.createOneTagFromMIAline(secondLine));
                    } else {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                    this.closetagsBetweenFunction(secondLine, result);
                }
            } else if (secondLine.getG4().equals("30") && this.isLine900(secondLine)) {
                String tn;
                secondLine.tagName = tn = secondLine.getFL11().trim().substring(0, secondLine.getFL11().trim().indexOf("."));
                if (firstLine.getMacroCode() != null) {
                    secondLine.setMacroCode(firstLine.getMacroCode());
                }
                result.addAll(this.createATagFromMIAline(secondLine));
                if (this.isEndEtiquetteLine(this.getNextProcedureLine()) || !secondLine.getG4().equals(this.getNextProcedureLine().getG4()) || !secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) || !(String.valueOf(secondLine.getG9B()) + secondLine.getG0() + secondLine.getGA()).trim().equals((String.valueOf(this.getNextProcedureLine().getG9B()) + this.getNextProcedureLine().getG0() + this.getNextProcedureLine().getGA()).trim())) {
                    this.closetagsBetweenFunction(secondLine, result);
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else if (firstLine.getnbLineMsp() != null && (!firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || firstLine.getConditionOrTreatment() == 'C' && secondLine.getConditionOrTreatment() != 'C')) {
            secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()).trim() : "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp()).trim();
            result.addAll(this.createATagFromMIAline(secondLine));
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !this.getNextProcedureLine().getCurrentFunction().equals(secondLine.getCurrentFunction()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isLine900(this.getNextProcedureLine()) || this.isBeginEtiquetteLine(this.getNextProcedureLine()) || this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) && this.getNextProcedureLine().getMacroCode() == null) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!(!this.isEndEtiquetteLine(this.getNextProcedureLine()) && secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) && !this.isBeginEtiquetteLine(this.getNextProcedureLine()) && (String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) && (!this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || this.getNextProcedureLine().getMacroCode() != null || (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim().equals((String.valueOf(this.getNextProcedureLine().getCOFON()) + this.getNextProcedureLine().getCOFSO()).trim())) || this.forMigration || secondLine.getG4().equals("30"))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || !(String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine()) || !this.getNextProcedureLine().isFromMacro() && this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!(!this.isEndEtiquetteLine(this.getNextProcedureLine()) && secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) && (String.valueOf(secondLine.getG0()) + secondLine.getGA()).equals(String.valueOf(this.getNextProcedureLine().getG0()) + this.getNextProcedureLine().getGA()) && (!this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || this.getNextProcedureLine().getMacroCode() != null || (String.valueOf(secondLine.getCOFON()) + secondLine.getCOFSO()).trim().equals((String.valueOf(this.getNextProcedureLine().getCOFON()) + this.getNextProcedureLine().getCOFSO()).trim())) || this.forMigration || secondLine.getG4().equals("30"))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
    }

    private void closetagsBetweenFunction(MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!secondLine.getG4().equals(this.getNextProcedureLine().getG4())) {
            int nbClose = Collections.frequency(result, MIAinfo.CLOSE_TAG);
            result.addAll(this.closeTagsUntil(2 + nbClose));
        } else {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F51AV(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getMacroCode() == null) {
            if (this.isBreakOnG4(firstLine, secondLine)) {
                String tn;
                result.addAll(this.closeTagsUntil(2));
                if (secondLine.getG4().equals("25")) {
                    this.isF25generated = true;
                } else if (secondLine.getG4().equals("35")) {
                    this.isF35generated = true;
                } else if (secondLine.getG4().equals("60")) {
                    this.isF60generated = true;
                }
                result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4(), this.getLevelFrom("05"), this));
                secondLine.tagName = tn = "N" + secondLine.getG4();
                result.addAll(this.createATagFromMIAline(secondLine));
            } else if (this.getNextProcedureLine().getCol7() == '*') {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (this.getNextProcedureLine().getCol7() != '*') {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            boolean specialTreatmentForF05 = false;
            if (firstLine.getG4().equals("05") && !this.isBreakOnG4(firstLine, secondLine)) {
                boolean bl = specialTreatmentForF05 = !this.lastTagCreated().getProperties().containsKey("msp");
            }
            if (this.isBreakOnG4(firstLine, secondLine) || specialTreatmentForF05) {
                if (!specialTreatmentForF05) {
                    result.addAll(this.closeTagsUntil(2));
                    secondLine.addProperty("level", secondLine.getLevelValue((String.valueOf(secondLine.getG4()) + secondLine.getG5B()).trim()));
                    result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG5B(), secondLine.getProperties(), this));
                    secondLine.removeProperty("level");
                }
                secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 && !this.isBufferEnding(firstLine.getCOBOLcontent()) ? "N" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "N" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                if (firstLine.getCol7() != '*' && !firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) && secondLine.getG5B().trim().length() > 0) {
                    secondLine.tagName = firstLine.getG5B().equals(secondLine.getG5B()) ? "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                    return;
                }
                if (secondLine.getTYPST().equals("*A") && (firstLine.getCol7() == '*' && firstLine.getFL11().charAt(0) == '@' || this.isBreakOnGA(firstLine, secondLine))) {
                    String tn;
                    result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG0() + secondLine.getGA(), secondLine.getProperties(), this));
                    secondLine.tagName = tn = "N" + secondLine.getG4() + secondLine.getG0() + secondLine.getGA() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp());
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                    return;
                }
                if (!firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || firstLine.getConditionOrTreatment() != secondLine.getConditionOrTreatment()) {
                    String tn;
                    secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG0() + secondLine.getGA() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp());
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                    return;
                }
                if (this.getNextProcedureLine().getCol7() == '*') {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    if (!(secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && secondLine.getG5B().equals(this.getNextProcedureLine().getG5B()) && secondLine.getnbLineMsp().equals(this.getNextProcedureLine().getnbLineMsp()))) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                }
            }
            if (this.getNextProcedureLine().getCol7() != '*') {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void insertSpecialF80SubFunction(MIA2LineProcedure secondLine, List<MIAinfo> result) {
        Iterator<MIAinfo> itm = result.iterator();
        int nbClo = 0;
        while (itm.hasNext()) {
            if (!itm.next().equals(MIAinfo.CLOSE_TAG)) continue;
            ++nbClo;
        }
        nbClo = this.getTagsStack().size() - nbClo;
        if (nbClo != 3) {
            return;
        }
        String code = "F" + secondLine.getG4() + this.computeSubFunction(secondLine);
        Properties p = new Properties();
        p.setProperty("level", "09.5");
        if ("F8095".equals(code)) {
            p.setProperty("refMIA", "F80-HELP");
            result.addAll(MIAinfo.CreateATag("F80-HELP", p, this));
        } else if ("F8098".equals(code)) {
            p.setProperty("refMIA", "F80-LE00");
            result.addAll(MIAinfo.CreateATag("F80-LE00", p, this));
        } else if ("F8099".equals(code)) {
            p.setProperty("refMIA", "F80-OKKO");
            result.addAll(MIAinfo.CreateATag("F80-OKKO", p, this));
        }
    }

    private void insertCloseTagsBetweenTwoNlines(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (firstLine.getCOFON().equals(secondLine.getCOFON()) && !firstLine.getCurrentFunction().equals(secondLine.getCurrentFunction()) && !this.isEndEtiquetteLine(firstLine) && !this.isBufferEnding(firstLine.getCOBOLcontent()) && this.lastTagCreated().getTextOrTagName().contains(firstLine.getCurrentFunction()) && firstLine.lineContent.length() > 118 && secondLine.lineContent.length() > 118) {
            String firstLev = firstLine.lineContent.substring(117, 119);
            String secondLev = secondLine.lineContent.substring(117, 119);
            String lastLev = this.lastTagCreated().getProperties().getProperty("level");
            if (firstLev.compareTo(secondLev) >= 0 && lastLev.compareTo(secondLev) >= 0) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void procedure_F51BE(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getMacroCode() == null) {
            if (this.isBreakOnG5(firstLine, secondLine) || this.isBufferEnding(firstLine.getCOBOLcontent())) {
                String tn;
                this.insertCloseTagsBetweenTwoNlines(firstLine, secondLine, result);
                result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG5B(), this.getLevelFrom(secondLine, null), this));
                secondLine.tagName = tn = "N" + secondLine.getG4() + secondLine.getG5B();
                result.addAll(this.createATagFromMIAline(secondLine));
            } else if (this.getNextProcedureLine().getCol7() == '*') {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (this.getNextProcedureLine().getCol7() != '*') {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (this.lastTagCreated().getTextOrTagName().startsWith("N")) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else if (!this.isInBuffer()) {
            String secondSubFunction = this.computeSubFunction(secondLine);
            if (!secondLine.getG4().equals("80") && this.isBreakOnGA(firstLine, secondLine) || secondLine.getG4().equals("80") && this.isBreakOnGB1(firstLine, secondLine)) {
                if (secondLine.getG4().equals("80") && secondLine.getG9B().trim().length() == 0 && this.lastTagCreated().getTextOrTagName().startsWith("F80-")) {
                    result.addAll(this.closeTagsUntil(3));
                }
                if (this.isNewSegmentOnF80) {
                    result.addAll(MIAinfo.CreateATag("F80-" + firstLine.getCOBOLcontent().substring(20, 24), this));
                    this.isNewSegmentOnF80 = false;
                }
                this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
                result.addAll(this.closeTagsUntilBODY());
                this.insertRefIfPossible(secondLine);
                secondLine.addProperty("level", secondLine.getLevelValue((String.valueOf(secondLine.getG4()) + secondSubFunction).trim()));
                if ("80".equals(secondLine.getG4())) {
                    this.insertSpecialF80SubFunction(secondLine, result);
                }
                this.insertCloseTagsBetweenTwoNlines(firstLine, secondLine, result);
                result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondSubFunction, secondLine.getProperties(), this));
                secondLine.removeProperty("level");
                this.topFunction = true;
                secondLine.tagName = !this.isBreakOnG5(firstLine, secondLine) ? (firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "N" + secondLine.getG4() + secondSubFunction + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "N" + secondLine.getG4() + secondSubFunction + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp())) : "N" + secondLine.getG4() + secondSubFunction + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
                result.addAll(this.createATagFromMIAline(secondLine));
            } else if (this.isBreakOnGB(firstLine, secondLine) && (!secondLine.getG4().equals("80") || this.isBreakOnGB1(firstLine, secondLine))) {
                secondLine.tagName = !this.isBreakOnG5(firstLine, secondLine) ? "F" + secondLine.getG4() + secondSubFunction + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "F" + secondLine.getG4() + secondSubFunction + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                if ((!firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || firstLine.getConditionOrTreatment() != secondLine.getConditionOrTreatment()) && !this.isEndEtiquetteLine(secondLine) || this.isBeginEtiquetteLine(secondLine)) {
                    secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp()) : "F" + secondLine.getCOFON() + secondLine.getCOFSO() + this.computeLineNumberForMacro(secondLine, null, secondLine.getnbLineMsp());
                    result.addAll(this.createATagFromMIAline(secondLine));
                    if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !(String.valueOf(secondLine.getGA()) + secondLine.getGB1()).trim().equals((String.valueOf(this.getNextProcedureLine().getGA()) + this.getNextProcedureLine().getGB1()).trim()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                    return;
                }
                if (this.getNextProcedureLine().getCol7() == '*') {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
            }
            if (secondLine.getCOBOLcontent().startsWith("      *@SC")) {
                return;
            }
            if (this.getNextProcedureLine().getCol7() != '*') {
                if (!this.isBreakOnGB(firstLine, secondLine) && !this.isBeginEtiquetteLine(this.getNextProcedureLine())) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (!this.forMigration && this.isEndEtiquetteLine(this.getNextProcedureLine()) && this.isDialogFunction(secondLine) || this.getNextProcedureLine().getCol7() == '*' && this.isBreakOnNulim(secondLine, this.getNextProcedureLine()) || this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) && this.getNextProcedureLine().getMacroCode() == null || this.isBeginEtiquetteLine(this.getNextProcedureLine()) && this.isDialogFunction(secondLine) && this.isBreakOnG9B(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (!this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) && this.isDialogFunction(secondLine) && !this.forMigration && !secondLine.getG4().equals("30")) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    protected String computeSubFunction(MIA2LineProcedure secondLine) {
        if (secondLine.getG5B().trim().length() > 0) {
            return secondLine.getG5B();
        }
        if (secondLine.getG4().equals("80")) {
            return String.valueOf(secondLine.getGA()) + secondLine.getGB1();
        }
        return String.valueOf(secondLine.getG0()) + secondLine.getGA();
    }

    protected String computeLineNumberForMacro(MIA2LineProcedure currentLine, String nblFirst, String nblSecond) {
        String s = null;
        if (nblSecond != null && nblFirst != null && EBCDICCompare.stringCompare((String)nblSecond, (String)nblFirst) < 0 || this.memoNbLine != null && EBCDICCompare.stringCompare((String)nblSecond, (String)this.memoNbLine) <= 0) {
            if (this.memoNbLine == null) {
                s = String.valueOf(nblFirst) + nblSecond;
                this.memoNbLine = nblFirst;
            } else {
                s = String.valueOf(this.memoNbLine) + nblSecond;
            }
        } else {
            s = currentLine.getConditionOrTreatment() != ' ' ? (currentLine.getConditionOrTreatment() == 'C' ? nblSecond : String.valueOf(nblSecond) + nblSecond) : nblSecond;
            this.memoNbLine = null;
        }
        return s;
    }

    private void procedure_F51FC(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!(!"25".equals(secondLine.getG4()) || "G99".equals(secondLine.getG5()) || "MV".equals(this.screenType) || "IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
            return;
        }
        if (!(!"60".equals(secondLine.getG4()) && !"65".equals(secondLine.getG4()) || !"G  ".equals(secondLine.getG5()) && !secondLine.isHelp() || "IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
            return;
        }
        if (secondLine.getG5B().trim().length() == 0 && ("IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType) || !"25".equals(secondLine.getG4()) && !"60".equals(secondLine.getG4()) && !"65".equals(secondLine.getG4()))) {
            this.procedure_F51FF(firstLine, secondLine, result);
        } else if (secondLine.getG5B().trim().length() > 0) {
            this.procedure_F51HH(firstLine, secondLine, result);
        }
    }

    private void implement900(String function, String firstSF, String secondSF, List<MIAinfo> result, boolean isDO) {
        StringBuilder sb900 = new StringBuilder(30);
        sb900.append("       F");
        sb900.append(function);
        sb900.append(firstSF);
        sb900.append("-900. GO TO F");
        sb900.append(function);
        sb900.append(secondSF);
        if (isDO) {
            sb900.append("-A.");
        } else {
            sb900.append("-FN.");
        }
        sb900.append("\r\n");
        result.addAll(MIAinfo.InsertText(sb900.toString(), this));
    }

    private void addEndEtiquet(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result, boolean isLastLine) {
        if (secondLine.isEtiquette() && !this.isEndEtiquetteLine(firstLine) && (!firstLine.getCOFSO().equals(secondLine.getCOFSO()) || this.isEndEtiquetteLine(secondLine)) || isLastLine) {
            StringBuilder sb;
            if (secondLine.getTYPST().equals("DO")) {
                sb = new StringBuilder(4);
                sb.append(secondLine.getCOFON());
                sb.append(secondLine.getCOFSO());
                this.memoDO.add(sb.toString());
            }
            if (secondLine.getTYPST().equals("DW")) {
                sb = new StringBuilder(4);
                sb.append(secondLine.getCOFON());
                sb.append(secondLine.getCOFSO());
                this.memoDW.add(sb.toString());
            }
            if (firstLine.getCOFSO().trim().length() == 0) {
                this.alForTypeF = new ArrayList();
            } else if (secondLine.getLEVEL() == firstLine.getLEVEL() && !isLastLine) {
                if (secondLine.getTYPST().equals("EL")) {
                    this.implement900(firstLine.getCOFON(), firstLine.getCOFSO(), secondLine.getCOFSO(), result, false);
                }
                sb = new StringBuilder(4);
                sb.append(firstLine.getCOFON());
                sb.append(firstLine.getCOFSO());
                if (this.memoDO.indexOf(sb.toString()) != -1) {
                    this.implement900(firstLine.getCOFON(), firstLine.getCOFSO(), firstLine.getCOFSO(), result, true);
                }
                if (this.memoDW.indexOf(sb.toString()) != -1) {
                    this.implement900(firstLine.getCOFON(), firstLine.getCOFSO(), firstLine.getCOFSO(), result, false);
                }
                sb = new StringBuilder(30);
                sb.append("       F");
                sb.append(firstLine.getCOFON());
                sb.append(firstLine.getCOFSO());
                sb.append("-FN.      EXIT.");
                sb.append("\r\n");
                result.addAll(MIAinfo.InsertText(sb.toString(), this));
                if (this.isBeginEtiquetteLine(firstLine)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else if (secondLine.getLEVEL() < firstLine.getLEVEL() || isLastLine) {
                sb = new StringBuilder(4);
                sb.append(firstLine.getCOFON());
                sb.append(firstLine.getCOFSO());
                if (this.memoDO.indexOf(sb.toString()) != -1) {
                    this.implement900(firstLine.getCOFON(), firstLine.getCOFSO(), firstLine.getCOFSO(), result, true);
                }
                if (this.memoDW.indexOf(sb.toString()) != -1) {
                    this.implement900(firstLine.getCOFON(), firstLine.getCOFSO(), firstLine.getCOFSO(), result, false);
                }
                sb = new StringBuilder(30);
                sb.append("       F");
                sb.append(firstLine.getCOFON());
                sb.append(firstLine.getCOFSO());
                sb.append("-FN.      EXIT.");
                sb.append("\r\n");
                result.addAll(MIAinfo.InsertText(sb.toString(), this));
                ArrayList<String> alDelete = new ArrayList<String>(4);
                if (this.alForTypeF != null) {
                    int i = this.alForTypeF.size();
                    while (i > 0) {
                        String sf = this.alForTypeF.get(i - 1).substring(0, 2);
                        int level = Integer.parseInt(this.alForTypeF.get(i - 1).substring(2));
                        if (secondLine.getLEVEL() <= level || isLastLine) {
                            result.add(MIAinfo.CLOSE_TAG);
                            if (secondLine.getTYPST().equals("EL") && secondLine.getLEVEL() == level) {
                                this.implement900(firstLine.getCOFON(), sf, secondLine.getCOFSO(), result, false);
                            }
                            sb = new StringBuilder(4);
                            sb.append(firstLine.getCOFON());
                            sb.append(sf);
                            if (this.memoDO.indexOf(sb.toString()) != -1) {
                                this.implement900(firstLine.getCOFON(), sf, sf, result, true);
                            }
                            if (this.memoDW.indexOf(sb.toString()) != -1) {
                                this.implement900(firstLine.getCOFON(), sf, sf, result, false);
                            }
                            sb = new StringBuilder(30);
                            sb.append("       F");
                            sb.append(firstLine.getCOFON());
                            sb.append(sf);
                            sb.append("-FN.      EXIT.");
                            sb.append("\r\n");
                            result.addAll(MIAinfo.InsertText(sb.toString(), this));
                            alDelete.add(this.alForTypeF.get(i - 1));
                        }
                        --i;
                    }
                }
                if (this.isBeginEtiquetteLine(firstLine) && alDelete.size() > 0 || this.isEndEtiquetteLine(secondLine)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                for (String s : alDelete) {
                    this.alForTypeF.remove(s);
                }
            } else {
                sb = new StringBuilder(4);
                sb.append(firstLine.getCOFSO());
                sb.append(firstLine.getLEVEL());
                this.alForTypeF.add(sb.toString());
            }
        }
    }

    private void procedure_F51FF(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getMacroCode() == null && !this.isEndEtiquetteForMacro() && !this.isline900ForMacro()) {
            if (!this.isInBuffer()) {
                String tn;
                if (!this.isBreakOnG4(firstLine, secondLine)) {
                    if (this.topF94 == 1 && !this.isBreakOnG4(secondLine, this.getNextProcedureLine())) {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                        if (!this.forMigration) {
                            if (this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(3, 7))) {
                                result.add(MIAinfo.CLOSE_TAG);
                            }
                        } else if ("-FN.".equals(secondLine.getFL11().substring(3, 7))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else if (this.topF94 == 0) {
                        this.topF94 = 1;
                        if (!this.forMigration) {
                            secondLine.tagName = tn = "F" + secondLine.getG4() + "-BODY";
                            result.addAll(this.createATagFromMIAline(secondLine));
                            if (this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(3, 7))) {
                                result.add(MIAinfo.CLOSE_TAG);
                            }
                        } else {
                            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                        }
                    }
                } else {
                    this.topF94 = 1;
                    if (!this.forMigration) {
                        result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4(), this.getLevelFrom("05"), this));
                        secondLine.tagName = tn = "F" + secondLine.getG4() + "-BODY";
                        result.addAll(this.createATagFromMIAline(secondLine));
                        if (this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(3, 7))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else {
                        result.addAll(this.closeTagsUntil(2));
                        secondLine.tagName = tn = "F" + secondLine.getG4();
                        secondLine.addProperty("level", "05");
                        result.addAll(this.createATagFromMIAline(secondLine));
                    }
                }
                if (this.isBreakOnG4(secondLine, this.getNextProcedureLine())) {
                    result.addAll(this.closeTagsUntil(3));
                    if (!this.forMigration) {
                        secondLine.tagName = tn = "F" + secondLine.getG4() + "-FN";
                        result.addAll(this.createOneTagFromMIAline(secondLine));
                    } else {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else if (!this.isInBuffer()) {
            if (this.isBeginEtiquetteLine(secondLine) || secondLine.isCOA() || firstLine.getG4().equals(secondLine.getG4()) && firstLine.getG5B().equals(secondLine.getG5B()) && (!firstLine.getnbLineMsp().equals(secondLine.getnbLineMsp()) || firstLine.getConditionOrTreatment() != secondLine.getConditionOrTreatment()) && !this.isEndEtiquetteLine(secondLine)) {
                if (this.isBreakOnG4(firstLine, secondLine)) {
                    secondLine.tagName = "F" + secondLine.getG4();
                    secondLine.addProperty("level", "05");
                } else {
                    secondLine.tagName = "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, firstLine.getnbLineMsp(), secondLine.getnbLineMsp());
                }
                result.addAll(MIAinfo.CreateATag(secondLine.tagName, secondLine.getProperties(), this));
                this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                if (!this.isBreakOnG4(firstLine, secondLine) && (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !secondLine.isEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine()))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || !secondLine.isEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.getNextProcedureLine().getnbLineMsp() != null && !this.getNextProcedureLine().getnbLineMsp().equals(secondLine.getnbLineMsp()) || this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void procedure_F51HH(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (secondLine.getMacroCode() == null && !this.isEndEtiquetteForMacro() && !this.isline900ForMacro()) {
            String fn;
            String tn;
            if (!this.isBreakOnG5(firstLine, secondLine)) {
                if ("I".equals(secondLine.getG3()) && ("0A".equals(secondLine.getG4()) || "0C".equals(secondLine.getG4())) && secondLine.getG5().startsWith("G") && "G".equals(secondLine.getG6()) && secondLine.getG7().trim().length() > 0) {
                    if (this.isBreakOnG7(firstLine, secondLine)) {
                        secondLine.tagName = "F" + secondLine.getG4() + secondLine.getG5B() + secondLine.getG7();
                        result.addAll(this.createATagFromMIAline(secondLine));
                        return;
                    }
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    if (this.getNextProcedureLine() == null || this.isBreakOnG7(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                    return;
                }
                if (this.topF96 == 1 && !this.isBreakOnG5(secondLine, this.getNextProcedureLine())) {
                    if (secondLine.getG4().equals("40") && secondLine.getG5().equals("G40") && this.isBreakOnG9A(firstLine, secondLine) && secondLine.getG9A().trim().length() > 0 && secondLine.getG0().trim().length() > 0) {
                        secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG5B() + secondLine.getG9A();
                        result.addAll(this.createATagFromMIAline(secondLine));
                    } else if ("-900.".equals(secondLine.getFL11().substring(5, 10)) && "FM".equals(this.screenType)) {
                        secondLine.tagName = secondLine.getFL11().substring(0, 9);
                        result.addAll(this.createATagFromMIAline(secondLine));
                        result.add(MIAinfo.CLOSE_TAG);
                    } else {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                    if (secondLine.getG4().equals("40") && secondLine.getG5().equals("G40") && this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && secondLine.getG9A().trim().length() > 0 && secondLine.getG0().trim().length() > 0) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                    if (!this.forMigration || "25".equals(secondLine.getG4()) && "99".equals(secondLine.getG5B())) {
                        if (!this.forMigration && "-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                        if ("25".equals(secondLine.getG4()) && "99".equals(secondLine.getG5B()) && "-900.".equals(this.getNextProcedureLine().getFL11().substring(5, 10))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else if (this.getNextProcedureLine().getMacroCode() != null || !secondLine.getG4().equals("40") && this.isEndEtiquetteLine(secondLine) && this.isEndEtiquetteLine(this.getNextProcedureLine())) {
                        result.add(MIAinfo.CLOSE_TAG);
                    } else if (this.isEndEtiquetteLine(secondLine)) {
                        if (secondLine.getG4().equals("40")) {
                            fn = this.getFNLine(secondLine);
                            if (fn != null && this.lastTagCreated().getTextOrTagName().equals(fn)) {
                                result.add(MIAinfo.CLOSE_TAG);
                            }
                        } else {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    }
                } else if (this.topF96 == 0 && !this.isEndEtiquetteLine(secondLine)) {
                    this.topF96 = 1;
                    if (!this.forMigration) {
                        secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG5B() + "-BODY";
                        result.addAll(this.createATagFromMIAline(secondLine));
                        if ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else if ("-900.".equals(secondLine.getFL11().substring(5, 10)) && "FM".equals(this.screenType)) {
                        secondLine.tagName = secondLine.getFL11().substring(0, 9);
                        result.addAll(this.createATagFromMIAline(secondLine));
                        result.add(MIAinfo.CLOSE_TAG);
                    } else {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                }
            } else {
                this.topF96 = 1;
                if (("C".equals(this.screenType) || "MC".equals(this.screenType)) && "0C".equals(secondLine.getG4()) && "-DC.".equals(secondLine.getFL74().substring(9, 13))) {
                    this.procedure_F51HV(firstLine, secondLine, result);
                } else if (!this.forMigration || "25".equals(secondLine.getG4()) && "99".equals(secondLine.getG5B())) {
                    this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
                    result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG5B(), this.getLevelFrom(secondLine, null), this));
                    if (!this.forMigration) {
                        String tn2;
                        secondLine.tagName = tn2 = "F" + secondLine.getG4() + secondLine.getG5B() + "-BODY";
                        result.addAll(this.createATagFromMIAline(secondLine));
                        if ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                } else {
                    String tn3;
                    String secondLevel;
                    String firstLevel;
                    if (this.isEndEtiquetteLine(secondLine)) {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                        result.add(MIAinfo.CLOSE_TAG);
                        return;
                    }
                    if (this.isBreakOnG4(firstLine, secondLine)) {
                        result.addAll(this.closeTagsUntil(2));
                    } else if (!(secondLine.isSUP() || this.getFNLine(firstLine) != null || this.isBeginEtiquetteLine(firstLine) && this.isBeginEtiquetteLine(secondLine) || this.isBufferEnding(firstLine.getCOBOLcontent()) || (firstLevel = firstLine.lineContent.substring(117, 119)).compareTo(secondLevel = secondLine.lineContent.substring(117, 119)) < 0)) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                    secondLine.tagName = tn3 = "F" + secondLine.getG4() + secondLine.getG5B();
                    secondLine.addProperty("level", secondLine.getLevelValue((String.valueOf(secondLine.getG4()) + secondLine.getG5B()).trim()));
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
                return;
            }
            if (this.isBreakOnG5(secondLine, this.getNextProcedureLine())) {
                if (!this.forMigration) {
                    secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG5B() + "-FN";
                    result.addAll(this.createOneTagFromMIAline(secondLine));
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                if (this.isEndEtiquetteLine(secondLine)) {
                    if (secondLine.getG4().equals("40")) {
                        fn = this.getFNLine(secondLine);
                        if (fn != null && this.lastTagCreated().getTextOrTagName().equals(fn)) {
                            result.add(MIAinfo.CLOSE_TAG);
                        }
                    } else {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                }
            }
        } else {
            if (secondLine.isCOA()) {
                String subFunctionName = "F" + secondLine.getG4() + secondLine.getG5B();
                if (!this.lastTagCreated().getTextOrTagName().equals("PROCEDURE") && !this.lastTagCreated().getTextOrTagName().equals(subFunctionName)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (!this.containsTag(subFunctionName)) {
                    result.addAll(MIAinfo.CreateATag(subFunctionName, this));
                }
            }
            String nblFirst = firstLine.getnbLineMsp();
            String nblSecond = secondLine.getnbLineMsp();
            String nblNext = this.getNextProcedureLine().getnbLineMsp();
            if (!this.isEndEtiquetteLine(secondLine) && !this.isLine900(secondLine) && (this.isBreakOnNulim(firstLine, secondLine) || nblFirst != null && nblSecond != null && nblFirst.trim().length() > 0 && nblSecond.trim().length() > 0 && !nblFirst.equals(nblSecond))) {
                boolean nextTagNSforD_F;
                if (this.isBeginEtiquetteLine(secondLine) && !this.topFunction) {
                    secondLine.tagName = "F" + secondLine.getG4() + secondLine.getG5B();
                    secondLine.addProperty("level", secondLine.getLevelValue(null));
                } else {
                    secondLine.tagName = firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, nblFirst, nblSecond) : "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, null, nblSecond);
                }
                if (this.isBeginEtiquetteLine(secondLine) && nblSecond != null && nblNext != null && nblSecond.equals(nblNext) && (firstLine.getCol7() != '*' || firstLine.getFL11().charAt(0) != 'N')) {
                    result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
                    secondLine.tagName = !this.isBreakOnG5(firstLine, secondLine) && firstLine.getnbLineMsp() != null && firstLine.getnbLineMsp().trim().length() > 0 ? "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, nblFirst, nblSecond) : "F" + secondLine.getG4() + secondLine.getG5B() + this.computeLineNumberForMacro(secondLine, null, nblSecond);
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    String previousTagName;
                    String tmpTagName;
                    if (this.lastMPtagCreated != null && (tmpTagName = this.writeTextAndTagForSpecialMP(null, secondLine, false)) != null) {
                        secondLine.tagName = tmpTagName;
                    }
                    if ((previousTagName = this.lastTagCreated().getTextOrTagName()).equals(secondLine.tagName)) {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    } else {
                        if ("F25".equals(previousTagName) || "F35".equals(previousTagName) || "F60".equals(previousTagName)) {
                            this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
                        }
                        result.addAll(MIAinfo.CreateATag(secondLine.tagName, secondLine.getProperties(), this));
                        this.createArtificialCreateTagAndTextIfNeeded(secondLine, result);
                    }
                }
                boolean bl = nextTagNSforD_F = this.writeTextAndTagForSpecialMP(null, this.getNextProcedureLine(), true) != null;
                if (!this.getNextProcedureLine().getG4().equals(secondLine.getG4()) || nextTagNSforD_F || !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B()) || nblNext != null && (!nblNext.equals(nblSecond) || !secondLine.getMacroCode().equals(this.getNextProcedureLine().getMacroCode())) && (!this.isBeginEtiquetteLine(secondLine) || this.topFunction) || !secondLine.isEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || secondLine.isSpecialEtiquette() && secondLine.getConditionOrTreatment() == 'C' && this.getNextProcedureLine().getConditionOrTreatment() != 'C' || this.isEndEtiquetteLine(this.getNextProcedureLine()) || this.isLine900(this.getNextProcedureLine()) || this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) && this.getNextProcedureLine().getMacroCode() == null && !this.isBeginEtiquetteLine(secondLine)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else if (this.isLine900(secondLine)) {
                String tn;
                secondLine.tagName = tn = secondLine.getFL11().substring(0, secondLine.getFL11().indexOf("."));
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                if (secondLine.isCOA()) {
                    String tn;
                    secondLine.tagName = tn = secondLine.getFL11().substring(0, secondLine.getFL11().indexOf("."));
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    protected void procedure_F51HV(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
    }

    private void procedure_F51TM(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        String tn;
        if ("L".equals(secondLine.getG3())) {
            secondLine.tagName = tn = "END-OF-RECEPTION";
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
        if ("P".equals(secondLine.getG3())) {
            secondLine.tagName = tn = "END-OF-DISPLAY";
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
    }

    private void procedure_F52FF(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        String tn;
        if (this.isBreakOnG4(firstLine, secondLine)) {
            this.topF94 = 0;
        }
        if (!this.isBreakOnG4(firstLine, secondLine)) {
            if (this.topF94 == 1 && !this.isBreakOnG4(secondLine, this.getNextProcedureLine())) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (this.isBreakOnG7(firstLine, secondLine) || this.getNextProcedureLine().getFL11().substring(3, 7).equals("-FN.") && secondLine.getFL11().substring(0, 4).equals(this.getNextProcedureLine().getFL11().substring(0, 4))) {
                    result.add(MIAinfo.CLOSE_TAG);
                } else if (this.isEndFunctionEtiquetteLine(secondLine)) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            if (this.topF94 == 0) {
                this.topF94 = 1;
                if (!this.forMigration) {
                    secondLine.tagName = tn = "F" + secondLine.getG4() + "-BODY";
                    result.addAll(this.createATagFromMIAline(secondLine));
                    if (this.isBreakOnG7(secondLine, this.getNextProcedureLine()) || this.getNextProcedureLine().getFL11().substring(3, 7).equals("-FN.") && secondLine.getFL11().substring(0, 3).equals(this.getNextProcedureLine().getFL11().substring(0, 3))) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
            }
        } else {
            result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4(), this.getLevelFrom("05"), this));
            secondLine.tagName = tn = "F" + secondLine.getG4() + "-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
            this.topF94 = 1;
            if (this.isBreakOnG7(firstLine, secondLine) || this.getNextProcedureLine().getFL11().substring(3, 7).equals("-FN.") && secondLine.getFL11().substring(0, 4).equals(this.getNextProcedureLine().getFL11().substring(0, 4))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if (this.isBreakOnG4(secondLine, this.getNextProcedureLine())) {
            int numberOfClosetags = 0;
            if ("65".equals(secondLine.getG4()) || "30".equals(secondLine.getG4())) {
                result.addAll(this.closeTagsUntil(3));
            }
            if (result.contains(MIAinfo.CLOSE_TAG)) {
                Iterator<MIAinfo> itmi = result.iterator();
                while (itmi.hasNext()) {
                    if (!itmi.next().equals(MIAinfo.CLOSE_TAG)) continue;
                    ++numberOfClosetags;
                }
            }
            if (!this.forMigration) {
                String tn2;
                secondLine.tagName = tn2 = "F" + secondLine.getG4() + "-FN";
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            result.addAll(this.closeTagsUntil(2 + numberOfClosetags));
            return;
        }
    }

    private void procedure_F52GC(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        this.insertSpecialTagsForDialogFunction(firstLine, secondLine, result);
        result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG7B(), this.getLevelFrom("05.5"), this));
        if (!this.forMigration) {
            String tn;
            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (!this.forMigration && this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GD(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            String tn;
            result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG7B(), this.getLevelFrom("05.5"), this));
            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            String tn;
            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B();
            secondLine.addProperty("level", "05.5");
            result.addAll(this.createATagFromMIAline(secondLine));
        }
        if (("Z".equals(this.getNextProcedureLine().getG8()) || this.isBreakOnG7(secondLine, this.getNextProcedureLine()) || this.getNextProcedureLine().getG9B().equals("P")) && "65".equals(secondLine.getG4()) && !this.forMigration) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG7(secondLine, this.getNextProcedureLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GE(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            String tn;
            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-FN";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GK(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG8(firstLine, secondLine)) {
            result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG7B() + "-" + secondLine.getCORUB(), this.getLevelFrom(secondLine, null), this));
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + secondLine.getCORUB() + "-BODY";
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        if (!this.isBreakOnG8(firstLine, secondLine) && this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG8(firstLine, secondLine) && this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (!this.isBreakOnG8(firstLine, secondLine) && !this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void procedure_F52GM(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        if (!this.forMigration && "Z".equals(this.getNextProcedureLine().getG8()) && "65".equals(this.getNextProcedureLine().getG4())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GO(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.isInBuffer()) {
            String tn;
            if (this.isBeginEtiquetteLine(secondLine)) {
                result.addAll(this.closeTagsUntilBODY());
                result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG7B() + "-" + secondLine.getCORUB(), this.getLevelFrom(secondLine, null), this));
                this.SaveCorub = secondLine.getCORUB();
                if (!this.forMigration) {
                    secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + this.SaveCorub + "-BODY";
                    result.addAll(this.createATagFromMIAline(secondLine));
                    if ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
            }
            if (this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && !this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || this.isEndEtiquetteLine(secondLine)) {
                if ("I".equals(secondLine.getG8())) {
                    if (this.isEndEtiquetteLine(this.getNextProcedureLine()) && this.isEndEtiquetteLine(secondLine) && secondLine.getFL11().substring(0, secondLine.getFL11().indexOf("-FN")).trim().length() == this.getNextProcedureLine().getFL11().substring(0, this.getNextProcedureLine().getFL11().indexOf("-FN")).trim().length()) {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    } else if (this.isEndEtiquetteLine(secondLine)) {
                        if (!this.forMigration) {
                            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + this.SaveCorub + "-FN";
                            result.addAll(this.createOneTagFromMIAline(secondLine));
                        } else {
                            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                        }
                    }
                    if (result.isEmpty()) {
                        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    }
                    if (this.isEndEtiquetteLine(secondLine)) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                }
                if ("X".equals(secondLine.getG8())) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            if (!(this.isBeginEtiquetteLine(secondLine) || this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && !this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()) || this.isEndEtiquetteLine(secondLine))) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (!this.forMigration && ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || this.getNextProcedureLine().getG9B().equals("P") || this.isBufferBeginning(this.getNextProcedureLine().getCOBOLcontent()))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
    }

    private void procedure_F52GZ(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.forMigration && (this.isBreakOnG8(secondLine, this.getNextProcedureLine()) || this.getNextProcedureLine().getG9B().equals("P"))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isBreakOnG7(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    protected void procedure_F55_F80(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            String tn;
            result.addAll(MIAinfo.CreateATag("F80", this));
            secondLine.tagName = tn = "F80-BODY";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            String tn;
            secondLine.tagName = tn = "F80";
            secondLine.addProperty("level", "05");
            result.addAll(this.createATagFromMIAline(secondLine));
        }
    }

    protected void procedure_F55_OK(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG5(firstLine, secondLine) && !this.isBufferEnding(firstLine.getCOBOLcontent())) {
            if (!this.forMigration) {
                String tn;
                result.addAll(MIAinfo.CreateATag("F80-OK", this));
                secondLine.tagName = tn = "F80" + secondLine.getG5B() + "-BODY";
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                String tn;
                secondLine.tagName = tn = "F80-OK";
                secondLine.addProperty("level", "10");
                result.addAll(this.closeTagsUntil(3));
                result.addAll(this.createATagFromMIAline(secondLine));
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(3, 7))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    protected void procedure_F55(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.isInBuffer()) {
            String endFL11 = null;
            endFL11 = secondLine.getFL11().charAt(10) == '.' ? secondLine.getFL11().substring(9, 10) : secondLine.getFL11().substring(9, 11);
            if (secondLine.getG5().trim().length() == 0 && !"A".equals(secondLine.getG6())) {
                this.procedure_F55_F80(firstLine, secondLine, result);
            } else if ("99".equals(secondLine.getG5().trim())) {
                this.procedure_F55_OK(firstLine, secondLine, result);
            } else if (secondLine.getMacroCode() != null && ("IT".equals(this.screenType) || "F".equals(this.screenType) || "FM".equals(this.screenType))) {
                this.procedure_specialDialog_ForMacro(firstLine, secondLine, result);
                if (!this.isEndEtiquetteLine(secondLine) && !this.getNextProcedureLine().getG5B().equals(secondLine.getG5B())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else {
                String tn;
                StringBuilder sb = new StringBuilder(4);
                sb.append(secondLine.getG5().trim());
                sb.append(secondLine.getG7());
                if (this.isBreakOnG9A(firstLine, secondLine) && !this.isBufferEnding(firstLine.getCOBOLcontent())) {
                    result.addAll(MIAinfo.CreateATag("F80-" + sb.toString(), this.getLevelFrom("09.5"), this));
                    if (!this.forMigration) {
                        result.addAll(MIAinfo.CreateATag("F80-" + sb.toString() + "-" + endFL11, this));
                        secondLine.tagName = tn = "F80-" + secondLine.getG7B() + "-" + endFL11 + "-BODY";
                        result.addAll(this.createATagFromMIAline(secondLine));
                    } else {
                        secondLine.tagName = tn = "F80-" + sb.toString() + "-" + endFL11;
                        secondLine.addProperty("level", "10");
                        result.addAll(this.createATagFromMIAline(secondLine));
                    }
                }
                if (this.isBreakOnG9B(firstLine, secondLine) && !this.isBreakOnG9A(firstLine, secondLine)) {
                    if (!this.forMigration) {
                        result.addAll(MIAinfo.CreateATag("F80-" + sb.toString() + "-" + endFL11, this));
                        secondLine.tagName = tn = "F80-" + secondLine.getG7B() + "-" + endFL11 + "-BODY";
                        result.addAll(this.createATagFromMIAline(secondLine));
                    } else {
                        secondLine.tagName = tn = "F80-" + sb.toString() + "-" + endFL11;
                        secondLine.addProperty("level", "10");
                        result.addAll(this.createATagFromMIAline(secondLine));
                    }
                }
                if (this.isBreakOnG9B(secondLine, this.getNextProcedureLine())) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    result.add(MIAinfo.CLOSE_TAG);
                    if (!this.forMigration) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                }
                if (this.isBreakOnG9A(secondLine, this.getNextProcedureLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (!(this.isBreakOnG9A(firstLine, secondLine) || this.isBreakOnG9B(firstLine, secondLine) && !this.isBreakOnG9A(firstLine, secondLine) || this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) || this.isBreakOnG9B(secondLine, this.getNextProcedureLine()) && !this.isBreakOnG9A(secondLine, this.getNextProcedureLine()))) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
            }
        }
    }

    protected void procedure_F52ID(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (!this.isInBuffer()) {
            String tn;
            String endFL11 = null;
            endFL11 = secondLine.getFL11().charAt(10) == '.' ? secondLine.getFL11().substring(9, 10) : secondLine.getFL11().substring(9, 11);
            if (this.isBreakOnG9A(firstLine, secondLine)) {
                this.topALCARE = false;
                if ("D".equals(this.screenType)) {
                    result.addAll(this.closeTagsUntil(3));
                }
                result.addAll(MIAinfo.CreateATag("F80-" + secondLine.getCORUB(), this.getLevelFrom("09.5"), this));
                this.SaveCorub = secondLine.getCORUB();
                if (!this.forMigration) {
                    result.addAll(MIAinfo.CreateATag("F80-" + this.SaveCorub + "-" + endFL11, this));
                    secondLine.tagName = tn = "F80-" + secondLine.getG7B() + "-" + endFL11 + "-BODY";
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    secondLine.tagName = tn = "F80-" + this.SaveCorub + "-" + endFL11;
                    secondLine.addProperty("level", secondLine.getLevelValue(tn.substring(1)));
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
            }
            if (this.isBreakOnG9B(firstLine, secondLine) && !this.isBreakOnG9A(firstLine, secondLine)) {
                this.SaveCorub = secondLine.getCORUB();
                if ("D".equals(this.screenType)) {
                    result.addAll(this.closeTagsUntil(4));
                }
                if (!this.forMigration) {
                    result.addAll(MIAinfo.CreateATag("F80-" + this.SaveCorub + "-" + endFL11, this));
                    secondLine.tagName = tn = "F80-" + secondLine.getG7B() + "-" + endFL11 + "-BODY";
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    secondLine.tagName = tn = "F80-" + this.SaveCorub + "-" + endFL11;
                    secondLine.addProperty("level", secondLine.getLevelValue(tn.substring(1)));
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
            }
            if ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || this.isBreakOnG9B(secondLine, this.getNextProcedureLine()) && !this.isBreakOnG9A(secondLine, this.getNextProcedureLine())) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                if (!this.forMigration) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            if (this.isBreakOnG9A(secondLine, this.getNextProcedureLine())) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (this.getNextProcedureLine().getG9A().trim().length() != 0 || !this.getNextProcedureLine().isArtificialCreate()) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.topALCARE = false;
            }
            if (!("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || this.isBreakOnG9A(firstLine, secondLine) || this.isBreakOnG9B(firstLine, secondLine) && !this.isBreakOnG9A(firstLine, secondLine) || this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) || this.isBreakOnG9B(secondLine, this.getNextProcedureLine()) && !this.isBreakOnG9A(secondLine, this.getNextProcedureLine()))) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
    }

    private void procedure_F52KD(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG5(firstLine, secondLine)) {
            if (!this.forMigration) {
                String tn;
                if ("G95".equals(secondLine.getG5())) {
                    result.addAll(MIAinfo.CreateATag("F80-HELP", this));
                } else if ("G98".equals(secondLine.getG5())) {
                    result.addAll(MIAinfo.CreateATag("F80-LE00", this));
                } else if ("G99".equals(secondLine.getG5())) {
                    result.addAll(MIAinfo.CreateATag("F80-OKKO", this));
                } else {
                    int beginIndex = secondLine.getFL11().indexOf("-");
                    int endIndex = secondLine.getFL11().indexOf(".");
                    if (endIndex != -1) {
                        result.addAll(MIAinfo.CreateATag("F80" + secondLine.getFL11().substring(beginIndex, endIndex), this));
                    } else {
                        result.addAll(MIAinfo.CreateATag("F80" + secondLine.getFL11().substring(beginIndex), this));
                    }
                }
                secondLine.tagName = tn = "F80" + secondLine.getG5B() + "-BODY";
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                if ("G95".equals(secondLine.getG5())) {
                    String tn;
                    secondLine.tagName = tn = "F80-HELP";
                } else if ("G98".equals(secondLine.getG5())) {
                    String tn;
                    secondLine.tagName = tn = "F80-LE00";
                } else if ("G99".equals(secondLine.getG5())) {
                    String tn;
                    secondLine.tagName = tn = "F80-OKKO";
                } else {
                    int beginIndex = secondLine.getFL11().indexOf("-");
                    int endIndex = secondLine.getFL11().indexOf(".");
                    String tn = null;
                    tn = endIndex != -1 ? "F80" + secondLine.getFL11().substring(beginIndex, endIndex) : "F80" + secondLine.getFL11().substring(beginIndex);
                    secondLine.tagName = tn;
                }
                secondLine.addProperty("level", "09.5");
                result.addAll(this.closeTagsUntil(3));
                result.addAll(this.createATagFromMIAline(secondLine));
            }
        }
        if (secondLine.getG5B().trim().length() != 0 && "-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || !"D".equals(this.screenType) && this.isBreakOnG5(secondLine, this.getNextProcedureLine())) {
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (!"D".equals(this.screenType) && this.isBreakOnG5(secondLine, this.getNextProcedureLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if ("D".equals(this.screenType) && this.isBreakOnG5(secondLine, this.getNextProcedureLine())) {
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F80-" + secondLine.getG5B() + "-FN";
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (!(this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || "-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || this.isBreakOnG5(firstLine, secondLine))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void procedure_F52LD(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG8(firstLine, secondLine)) {
            result.addAll(this.closeTagsUntil(3));
            secondLine.tagName = "F80-ER  ";
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if (this.isBreakOnG8(secondLine, this.getNextProcedureLine())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    private void procedure_F52MD(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result, boolean topF60Spe) {
        if (this.isBeginEtiquetteLine(secondLine)) {
            String tagToCreate;
            if (this.containsTagBody()) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.allTagF60.contains(tagToCreate = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + secondLine.getCORUB()) || topF60Spe) {
                tagToCreate = String.valueOf(tagToCreate) + "-2";
            }
            result.addAll(MIAinfo.CreateATag(tagToCreate, this.getLevelFrom(secondLine, null), this));
            this.allTagF60.add(tagToCreate);
            this.hmMemo.put(secondLine.getFL11().substring(3, 5), secondLine.getCORUB());
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + this.hmMemo.get(secondLine.getFL11().substring(3, 5)) + "-BODY";
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (!this.forMigration && "-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && "-FN.".equals(secondLine.getFL11().substring(5, 9))) {
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + this.hmMemo.get(secondLine.getFL11().substring(3, 5)) + "-FN";
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        if (this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && !"-FN.".equals(secondLine.getFL11().substring(5, 9))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (!(this.isBeginEtiquetteLine(secondLine) || this.isBreakOnG9A(firstLine, secondLine) || "-FN.".equals(secondLine.getFL11().substring(5, 9)))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.forMigration && ("-FN.".equals(this.getNextProcedureLine().getFL11().substring(5, 9)) || this.getNextProcedureLine().getG9B().equals("P") && secondLine.getG4().equals(this.getNextProcedureLine().getG4()) && secondLine.getG9A().equals(this.getNextProcedureLine().getG9A()))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (!this.isBreakOnG9A(secondLine, this.getNextProcedureLine()) && !this.isBeginEtiquetteLine(secondLine) && "-FN.".equals(secondLine.getFL11().substring(5, 9))) {
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG7B() + "-" + this.hmMemo.get(secondLine.getFL11().substring(3, 5)) + "-FN";
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_ForHelp(MIA2LineProcedure firstLine, MIA2LineProcedure secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG5(firstLine, secondLine)) {
            result.addAll(MIAinfo.CreateATag("F" + secondLine.getG4() + secondLine.getG5B(), this.getLevelFrom(secondLine, null), this));
            if (!this.forMigration) {
                String tn;
                secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG5B() + "-BODY";
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        } else if (this.isEndEtiquetteLine(secondLine) && !this.forMigration) {
            String tn;
            secondLine.tagName = tn = "F" + secondLine.getG4() + secondLine.getG5B() + "-FN";
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG5(secondLine, this.getNextProcedureLine()) || !this.forMigration && this.isEndEtiquetteLine(this.getNextProcedureLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50CB(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("40 ".equals(secondLine.getG5())) {
            result.addAll(MIAinfo.CreateATag("ENVIRONMENT", this));
        }
        if (!"50 ".equals(secondLine.getG5())) {
            int num = MIA2File.TransformStringToInt(secondLine.getG5().substring(0, 2));
            if (num == 1 || num == 5 || num == 10 || num == 20 || num == 30 || !this.forMigration && num == 40) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else if (secondLine.isFromMacro()) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        if ("30 ".equals(secondLine.getG5())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if ("MV".equals(this.screenType)) {
            if ("10 ".equals(secondLine.getG5())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if ("50 ".equals(secondLine.getG5())) {
                secondLine.tagName = "CONFIGURATION";
                result.addAll(this.createATagFromMIAline(secondLine));
                if (this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.isBreakOnG3(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
    }

    private void working_F50DF(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.createATagFromMIAline(secondLine));
        if (this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG3(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50DI(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.createOneTagFromMIAline(secondLine));
        this.closeTagsIfNeeded(firstLine, secondLine, result);
    }

    private void working_F50DO(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.createOneTagFromMIAline(secondLine));
        this.closeTagsIfNeeded(firstLine, secondLine, result);
    }

    private void working_F50DS(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG6(firstLine, secondLine)) {
            secondLine.tagName = "SPECIAL-NAMES";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else if (secondLine.isFromMacro()) {
            secondLine.tagName = "SPECIAL-NAMES" + secondLine.getG9();
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (!"C".equals(this.getNextWorkingLine().getG3()) || !this.getNextWorkingLine().getG4().equals(secondLine.getG4())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG3(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50EE(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG4(firstLine, secondLine)) {
            secondLine.tagName = "IOSEC-FILECTRL";
            result.addAll(this.createATagFromMIAline(secondLine));
        } else if (secondLine.getG5().trim().length() > 0) {
            if (secondLine.getG6().equals("A")) {
                StringBuilder sb = new StringBuilder(12);
                sb.append("SELECT-");
                if (secondLine.getG5().trim().length() > 1) {
                    sb.append(secondLine.getG5().substring(0, 2));
                } else {
                    sb.append(secondLine.getG5().trim());
                    sb.append("0");
                }
                sb.append(secondLine.getG9());
                if (this.isBreakOnG9B(firstLine, secondLine)) {
                    secondLine.tagName = sb.toString();
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                if (this.isBreakOnG9B(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else {
                StringBuilder sb = new StringBuilder(9);
                sb.append("SELECT-");
                if (secondLine.getG5().trim().length() > 1) {
                    sb.append(secondLine.getG5().substring(0, 2));
                } else {
                    sb.append(secondLine.getG5().trim());
                    sb.append("0");
                }
                if (this.isBreakOnG6(firstLine, secondLine)) {
                    secondLine.tagName = sb.toString();
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
                if (this.isBreakOnG6(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.isBreakOnG3(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50FF(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        secondLine.tagName = "DATA";
        result.addAll(this.closeTagsUntil(1));
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working_F50GF(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        secondLine.tagName = "FILESEC" + secondLine.getG9();
        result.addAll(this.createOneTagFromMIAline(secondLine));
    }

    private void working_F50GK(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG4(firstLine, secondLine)) {
            secondLine.tagName = "FD-" + secondLine.getG4();
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && "F".equals(this.getNextWorkingLine().getG3())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if ("G".equals(this.getNextWorkingLine().getG3())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50IB(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        secondLine.tagName = "WORKING";
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working_F50IE(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("1".equals(secondLine.getG0()) && secondLine.getG8().trim().length() == 0) {
            result.addAll(MIAinfo.CreateATag("GENERATED-WORKING", this));
            secondLine.tagName = "WSS-BEGIN";
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if ("B".equals(this.getNextWorkingLine().getG8())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    protected void working_F50II(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("1".compareTo(secondLine.getG0()) > 0 || "AA".equals(this.getNextWorkingLine().getG4())) {
            if (secondLine.getG0().trim().length() == 0 && secondLine.getGA().trim().length() == 0) {
                secondLine.tagName = "CONSTANTS";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.topF34 = false;
                return;
            }
            if ("0".equals(this.getNextWorkingLine().getG0()) && "9".equals(this.getNextWorkingLine().getGA())) {
                if (System.getProperty("JUNIT_IN_PROGRESS") != null) {
                    secondLine.setCOBOLContent("CONSTANTES ECRASEES POUR TEST JUNIT\r\n");
                }
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                this.topF34 = true;
                return;
            }
            if ("0".equals(secondLine.getG0()) && "9".equals(secondLine.getGA())) {
                secondLine.tagName = "WSS-CONTINUATION";
                result.addAll(this.createATagFromMIAline(secondLine));
                return;
            }
            if ("AA".equals(this.getNextWorkingLine().getG4()) && !this.topF34) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (System.getProperty("JUNIT_IN_PROGRESS") != null && !secondLine.getCOBOLcontent().contains(" PICTURE ")) {
                secondLine.setCOBOLContent("CONSTANTES ECRASEES POUR TEST JUNIT\r\n");
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    protected void working_F50IL(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
    }

    protected void working_F50IP(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    private void working_F50IT(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("A".equals(secondLine.getG6()) && secondLine.getG7().trim().length() == 0 && secondLine.getG8().trim().length() == 0) {
            secondLine.tagName = "CONFIGURATIONS";
            result.addAll(this.createATagFromMIAline(secondLine));
        }
        if ("B".equals(secondLine.getG6()) || "A".equals(secondLine.getG6()) && "1 ".equals(secondLine.getG7())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.getNextWorkingLine().getG5().trim().length() > 0 || "B".compareTo(this.getNextWorkingLine().getG6()) < 0) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50IZ(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG7(firstLine, secondLine) && secondLine.getG7().trim().length() != 0) {
            secondLine.tagName = "SEG-" + secondLine.getG7();
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG7(secondLine, this.getNextWorkingLine()) && secondLine.getG7().trim().length() != 0) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50JA(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG7(firstLine, secondLine)) {
            secondLine.tagName = "SEG-" + secondLine.getG6() + secondLine.getG7();
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG7(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50JD(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        this.topNIV01 = false;
        if (" 01".equals(secondLine.getFL74().substring(0, 3))) {
            this.topF71 = 0;
            StringBuilder tn = new StringBuilder();
            int i = 4;
            while (i < secondLine.getFL74().trim().length()) {
                if (secondLine.getFL74().charAt(i) != ' ' && secondLine.getFL74().charAt(i) != '.' && tn.length() < 35) {
                    tn.append(secondLine.getFL74().charAt(i));
                    this.topNIV01 = true;
                }
                ++i;
            }
            secondLine.tagName = tn.toString();
            result.addAll(this.createATagFromMIAline(secondLine));
            if ((" 01".equals(this.getNextWorkingLine().getFL74().substring(0, 3)) || "EXEC SQL INCLUDE".equals(this.getNextWorkingLine().getFL74().substring(8, 24)) && "S".equals(this.screenType)) && this.topF71 == 0) {
                result.add(MIAinfo.CLOSE_TAG);
                this.topF71 = 1;
            }
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if ((" 01".equals(this.getNextWorkingLine().getFL74().substring(0, 3)) || "EXEC SQL INCLUDE".equals(this.getNextWorkingLine().getFL74().substring(8, 24)) && "S".equals(this.screenType)) && (this.topNIV01 || this.topF71 == 0)) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50KA(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        this.carTop = 0;
        if ("AA".equals(secondLine.getG4()) && "005".equals(secondLine.getG5()) && "EXEC SQL  DECLARE".equals(secondLine.getFL74().substring(8, 25))) {
            secondLine.tagName = "W-AA005";
            result.addAll(this.createOneTagFromMIAline(secondLine));
            return;
        }
        if (" 01".equals(secondLine.getFL74().substring(0, 3)) && this.isBreakOnG5(firstLine, secondLine) || "COPY DFHAID.".equals(secondLine.getFL74().substring(6, 18)) || " 02".equals(secondLine.getFL74().substring(5, 8)) && this.isBreakOnG5(firstLine, secondLine) || "***  SPA ".equals(secondLine.getFL74().substring(8, 17)) && this.isBreakOnG5(firstLine, secondLine) && secondLine.getCol7() == '*') {
            this.topF71 = 0;
            StringBuilder tn = new StringBuilder();
            if ("COPY DFHAID.".equals(secondLine.getFL74().substring(6, 18))) {
                tn.append("DFHAID");
            } else if (!" 01".equals(secondLine.getFL74().substring(0, 3))) {
                tn.append(secondLine.getG4());
                tn.append(secondLine.getG5());
            }
            if (" 01".equals(secondLine.getFL74().substring(0, 3))) {
                int i = 4;
                while (i < secondLine.getFL74().trim().length()) {
                    if (secondLine.getFL74().charAt(i) != ' ' && secondLine.getFL74().charAt(i) != '.' && tn.length() < 35) {
                        tn.append(secondLine.getFL74().charAt(i));
                        this.carTop = 1;
                    }
                    if (secondLine.getFL74().charAt(i) == ' ' && this.carTop == 1) break;
                    ++i;
                }
            }
            secondLine.tagName = " 01".equals(secondLine.getFL74().substring(0, 3)) && "AA351".equals(secondLine.getG4A5()) ? "AA351" : tn.toString();
            this.topCommonArea = "COMMON-AREA".equals(secondLine.getTagName());
            if (" 01".equals(secondLine.getFL74().substring(0, 3)) && secondLine.getG4A5().startsWith("AA35") && this.isBreakOnG7(firstLine, secondLine)) {
                String s;
                int index;
                if ("AA351".equals(secondLine.getG4A5())) {
                    result.addAll(MIAinfo.CreateATag("AA351", this));
                }
                s = (index = (s = secondLine.getFL74().substring(4).trim()).indexOf(" ")) != -1 ? s.substring(0, index) : s.substring(0, s.length() - 1);
                secondLine.tagName = s;
            }
            result.addAll(this.createATagFromMIAline(secondLine));
            if (" 01".equals(secondLine.getFL74().substring(0, 3)) && secondLine.getG4A5().startsWith("AA35") && secondLine.getG7().trim().length() > 0 && this.isBreakOnG7(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (((" 01".equals(secondLine.getFL74().substring(0, 3)) || " 02".equals(secondLine.getFL74().substring(5, 8))) && this.isBreakOnG5(secondLine, this.getNextWorkingLine()) || this.isBreakOnG4(secondLine, this.getNextWorkingLine())) && this.topF71 == 0) {
                result.add(MIAinfo.CLOSE_TAG);
                this.topF71 = 1;
            }
            if (this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && "99999".equals(this.getNextWorkingLine().getG4A5())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (this.isBreakOnG5(secondLine, this.getNextWorkingLine()) && "LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (!this.isBreakOnG4(secondLine, this.getNextWorkingLine()) || this.topF71 == 1) {
                return;
            }
        }
        if (" 01".equals(secondLine.getFL74().substring(0, 3)) && (secondLine.getG4A5().startsWith("AA350") && this.isBreakOnG5(firstLine, secondLine) || secondLine.getG4A5().startsWith("AA351") && this.isBreakOnG7(firstLine, secondLine))) {
            String s = secondLine.getFL74().substring(13).trim();
            secondLine.tagName = s.substring(0, s.length() - 1);
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (secondLine.getG4A5().equals("AA351") && secondLine.getG7().trim().length() > 0 && this.isBreakOnG7(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if ((this.isBreakOnG5(secondLine, this.getNextWorkingLine()) && !this.topCommonArea || this.topCommonArea && (this.getNextWorkingLine().getCol7() == '*' || " 01".equals(this.getNextWorkingLine().getFL74().substring(0, 3)))) && this.topF71 == 0) {
            result.add(MIAinfo.CLOSE_TAG);
            this.topF71 = 1;
        }
        if (this.isBreakOnG5(secondLine, this.getNextWorkingLine()) && this.topF71 == 0 && this.topCommonArea) {
            result.add(MIAinfo.CLOSE_TAG);
            this.topF71 = 1;
        }
        if (this.getNextWorkingLine() != null && this.isBreakOnG5(secondLine, this.getNextWorkingLine()) && ("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) || "99999".equals(this.getNextWorkingLine().getG4A5()))) {
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.getNextWorkingLine() != null && "99999".equals(this.getNextWorkingLine().getG4A5())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working_F50KK(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        int closeTagInResult = 0;
        if (this.isBreakOnG5(firstLine, secondLine)) {
            this.topSQL = true;
            if ("B".equals(secondLine.getG0())) {
                result.addAll(this.closeTagsUntil(5));
                closeTagInResult = Collections.frequency(result, MIAinfo.CLOSE_TAG);
                result.addAll(MIAinfo.CreateATag("SQL-" + secondLine.getG4A5().substring(0, 4), this));
            }
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
            ++closeTagInResult;
            if ("Z".equals(secondLine.getG0())) {
                result.add(MIAinfo.CLOSE_TAG);
                ++closeTagInResult;
                this.topSQL = false;
            }
        }
        if (this.getNextWorkingLine() != null && "LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim())) {
            result.addAll(this.closeTagsUntil(2 + closeTagInResult));
        }
    }

    protected void working_F50KM(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
    }

    protected void working_F50KP(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG5(firstLine, secondLine)) {
            result.addAll(MIAinfo.CreateATag("AA200", this));
            secondLine.tagName = "BEFORE-INDEX";
            result.addAll(this.createATagFromMIAline(secondLine));
            this.topAVIND = false;
            this.topAPIND = false;
            return;
        }
        StringBuilder sb10 = new StringBuilder();
        sb10.append(secondLine.getG5());
        sb10.append(secondLine.getG6());
        sb10.append(secondLine.getG7());
        sb10.append(secondLine.getG8());
        String sb07 = new String(sb10.toString());
        sb10.append(secondLine.getG9());
        String AA200 = this.AA200ForDialog;
        if ("S".equals(this.screenType) || "MS".equals(this.screenType) || "MV".equals(this.screenType)) {
            AA200 = this.AA200ForServer;
        } else if ("C".equals(this.screenType) || "MC".equals(this.screenType) || "FM".equals(this.screenType) || "IT".equals(this.screenType)) {
            AA200 = this.AA200ForClient;
        }
        if (!this.topIndiceMsp && ("D".equals(this.screenType) && AA200.compareTo(sb10.toString()) > 0 || !"D".equals(this.screenType) && AA200.compareTo(sb07) > 0)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            StringBuilder sbNext10 = new StringBuilder();
            sbNext10.append(this.getNextWorkingLine().getG4());
            sbNext10.append(this.getNextWorkingLine().getG5());
            sbNext10.append(this.getNextWorkingLine().getG6());
            sbNext10.append(this.getNextWorkingLine().getG7());
            sbNext10.append(this.getNextWorkingLine().getG8());
            String sbNext07 = new String(sbNext10.toString());
            sbNext10.append(this.getNextWorkingLine().getG9());
            String AA200d = "AA" + AA200;
            if ("D".equals(this.screenType) && AA200d.compareTo(sbNext10.toString()) <= 0 || !"D".equals(this.screenType) && AA200d.compareTo(sbNext07) <= 0 && !this.isBreakOnG5(secondLine, this.getNextWorkingLine()) && !this.topAVIND) {
                this.topAVIND = true;
                result.add(MIAinfo.CLOSE_TAG);
            }
            if ("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) && !this.topAVIND && this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
                this.topAVIND = true;
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (!this.topAVIND && this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
                this.topAVIND = true;
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if ("D".equals(this.screenType) && AA200.compareTo(sb10.toString()) < 0 || "FM".equals(this.screenType) && AA200.compareTo(sb07) <= 0 || !"D".equals(this.screenType) && !"FM".equals(this.screenType) && AA200.compareTo(sb07) < 0 || this.topIndiceMsp) {
            if (!this.topAPIND && this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
                secondLine.tagName = "AFTER-INDEX";
                result.addAll(this.createOneTagFromMIAline(secondLine));
                this.topAPIND = true;
                result.add(MIAinfo.CLOSE_TAG);
                if ("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) && !this.topAVIND && this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
                return;
            }
            if (!this.topAPIND) {
                result.addAll(MIAinfo.CreateATag("AFTER-INDEX", this));
                this.topAPIND = true;
            }
            if (secondLine.getG7A().equals("F") && secondLine.getG8().trim().length() > 0 && secondLine.getG9().trim().length() > 0 && this.isBreakOnG9B(firstLine, secondLine)) {
                secondLine.tagName = "5-" + secondLine.getG8() + secondLine.getG9() + "-LTH";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.topAPIND = true;
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
            if (secondLine.getG7A().equals("F") && secondLine.getG8().trim().length() > 0 && secondLine.getG9().trim().length() > 0 && this.isBreakOnG9B(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) || "99999".equals(this.getNextWorkingLine().getG4A5())) && this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
            }
            if ("99999".equals(this.getNextWorkingLine().getG4A5()) && this.isBreakOnG4(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void working_F50LS(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if ("LINKAGE SECTION.".equals(secondLine.getLICOB().trim()) && !"99".equals(this.getNextWorkingLine().getG4())) {
            result.addAll(this.closeTagsUntil(2));
            if (this.isBreakOnG5(firstLine, secondLine)) {
                this.topLINK = 1;
                if (secondLine.getG5().trim().length() > 0) {
                    result.addAll(MIAinfo.CreateATag("LINKAGE", this));
                    secondLine.tagName = "W-" + secondLine.getG4() + secondLine.getG5();
                    result.addAll(this.createATagFromMIAline(secondLine));
                    if (secondLine.isFromMacro()) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                } else {
                    secondLine.tagName = "LINKAGE";
                    result.addAll(this.createATagFromMIAline(secondLine));
                }
            }
            if (!this.isBreakOnG5(firstLine, secondLine)) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        if (this.getNextWorkingLine() != null && "99".equals(this.getNextWorkingLine().getG4()) && !"999".equals(this.getNextWorkingLine().getG5()) && !this.getNextWorkingLine().isFromMacro()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void working_F50ND(MIA2LineWorking firstLine, MIA2LineWorking secondLine, List<MIAinfo> result) {
        if (this.isBreakOnG5(firstLine, secondLine)) {
            secondLine.tagName = "W-" + secondLine.getG4() + secondLine.getG5();
            result.addAll(this.createATagFromMIAline(secondLine));
            if (!this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && !this.isBreakOnG5(secondLine, this.getNextWorkingLine())) {
                return;
            }
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() != null && !this.getNextWorkingLine().isFromMacro()) {
                if (this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && ("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) || "99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 0)) {
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if ("99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 1) {
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if ("99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 0) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if ("99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 2) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            return;
        }
        if ((this.isBreakOnG4(secondLine, this.getNextWorkingLine()) || this.isBreakOnG5(secondLine, this.getNextWorkingLine()) || this.isBufferBeginning(this.getNextWorkingLine().getCOBOLcontent())) && secondLine.getG5().trim().length() > 0) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() != null && !this.getNextWorkingLine().isFromMacro()) {
                if (this.getNextWorkingLine() != null && this.isBreakOnG4(secondLine, this.getNextWorkingLine()) && ("LINKAGE SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) || "99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 0)) {
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.getNextWorkingLine() != null && "99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 0) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.getNextWorkingLine() != null && "99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 1) {
                    result.add(MIAinfo.CLOSE_TAG);
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.getNextWorkingLine() != null && "99".equals(this.getNextWorkingLine().getG4()) && this.topLINK == 2) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.getNextWorkingLine() != null && "COMMUNICATION SECTION.".equals(this.getNextWorkingLine().getLICOB().trim()) && this.topLINK == 1) {
                    this.topLINK = 2;
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            return;
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    protected void moveSQLlinesInF80() {
        ArrayList<MIALineImpl> alBegin = new ArrayList<MIALineImpl>();
        ArrayList<MIALineImpl> alSQL = new ArrayList<MIALineImpl>();
        ArrayList<MIALineImpl> alEnd = new ArrayList<MIALineImpl>();
        boolean isBegin = true;
        boolean isSQL = false;
        String memoSF = null;
        int i = 0;
        while (i < this.allLines.size()) {
            MIALineImpl mli = (MIALineImpl)this.allLines.get(i);
            if (mli instanceof MIA2LineProcedure) {
                MIA2LineProcedure mlp = (MIA2LineProcedure)mli;
                if (mlp.getG4().equals("80") && (mlp.getG5B().trim().length() > 0 || mlp.getG7A().trim().length() > 0)) {
                    isBegin = false;
                }
                if (mlp.getCOBOLcontent().contains("*\u00f4SQL") && (mlp.getMacroCode() == null || !mlp.getMacroCode().trim().equals("\u00a3\u00a3USER"))) {
                    isSQL = true;
                    memoSF = mlp.getG5B();
                }
                if (isSQL) {
                    if (mlp.getCOBOLcontent().trim().charAt(0) == '*' && mlp.getG5B().equals(memoSF)) {
                        alSQL.add(mli);
                    } else {
                        isSQL = false;
                        memoSF = null;
                    }
                }
            }
            if (!isSQL) {
                if (isBegin) {
                    alBegin.add(mli);
                } else {
                    alEnd.add(mli);
                }
            }
            ++i;
        }
        i = 0;
        while (i < alSQL.size()) {
            alBegin.add((MIALineImpl)alSQL.get(i));
            ++i;
        }
        i = 0;
        while (i < alEnd.size()) {
            alBegin.add((MIALineImpl)alEnd.get(i));
            ++i;
        }
        this.allLines = alBegin;
    }

    @Override
    protected void organizeLines() {
        super.organizeLines();
        this.moveSQLlinesInF80();
    }

    @Override
    protected IGeneratedInfo modifyGeneratedInfoAtEnd(IGeneratedInfo gi) {
        IBuilderTag f25Tag;
        IBuilderTag tag;
        int[] tab;
        IGenInfoBuilder gib = gi.toGeneratedInfoBuilder();
        if (gib.tagFromName("F25") == null) {
            tab = MIA2File.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F25");
            tag = gib.tagFromName("END-OF-RECEPTION");
            tag = tag != null && tag.getBeginIndex() <= tab[0] ? gib.addTagBefore("F25", "END-OF-RECEPTION") : gib.addTag(tab[0], tab[1], "F25", "PROCEDURE");
            tag.setProperty("TagForXnnMP", "TagForXnnMP");
            tag.setProperty("level", "05");
        }
        if (gib.tagFromName("F35") == null) {
            tab = MIA2File.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F35");
            tag = gib.tagFromName("END-OF-RECEPTION");
            tag = tag != null && tag.getBeginIndex() <= tab[0] ? gib.addTagBefore("F35", "END-OF-RECEPTION") : gib.addTag(tab[0], tab[1], "F35", "PROCEDURE");
            tag.setProperty("TagForXnnMP", "TagForXnnMP");
            tag.setProperty("level", "05");
        }
        if ((f25Tag = gib.tagFromName("F25")) != null && !f25Tag.getParent().getName().equals("PROCEDURE")) {
            gib.removeTag("F25");
            tag = gib.addTagBefore("F25", "F35");
            tag.setProperty("TagForXnnMP", "TagForXnnMP");
            tag.setProperty("level", "05");
        }
        if (gib.tagFromName("F60") == null) {
            int[] tab2 = MIA2File.SearchSubFunctionFrom(gib.tagFromName("PROCEDURE"), "F60");
            IBuilderTag tag2 = gib.addTag(tab2[0], tab2[1], "F60", "PROCEDURE");
            tag2.setProperty("TagForXnnMP", "TagForXnnMP");
            tag2.setProperty("level", "05");
        }
        return gib.toGeneratedInfo();
    }

    public static int[] SearchSubFunctionFrom(IBuilderTag startTag, String function) {
        int[] tabRes = new int[2];
        IBuilderTag currentTag = startTag.firstSon();
        IBuilderTag result = startTag;
        String currentFct = null;
        boolean found = false;
        while (!found && currentTag != null) {
            currentFct = currentTag.getName().substring(0, 3);
            if (currentFct.charAt(0) == 'F') {
                boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) >= 0;
                if (found) {
                    currentFct = result.getName();
                    break;
                }
            }
            result = currentTag;
            currentTag = currentTag.nextTag();
        }
        if (found) {
            tabRes[0] = currentTag.getBeginIndex();
            found = false;
            while (!found && currentTag != null) {
                currentFct = currentTag.getName().substring(0, 3);
                if (currentFct.charAt(0) == 'F') {
                    boolean bl = found = EBCDICCompare.stringCompare((String)currentFct, (String)function) > 0;
                    if (found) {
                        currentFct = result.getName();
                        tabRes[1] = currentTag.getBeginIndex();
                        break;
                    }
                }
                result = currentTag;
                currentTag = currentTag.nextTag();
            }
        }
        return tabRes;
    }
}

