/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.pac.migration.help.mia.MIA1Constants;
import com.ibm.pdp.pac.migration.help.mia.MIA1file;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import java.util.Hashtable;

public class MIA1lineWorking
extends MIALineImpl
implements MIA1Constants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int MINIMUM_LINE_LENGTH = 30;
    private static Hashtable<String, String> TagNameForSortCriteria = null;
    public static final String PREFIX_WORKING_AD = "DATE_WORKING_";
    private String criteria_X3 = null;
    private String criteria_NUETAX = null;
    private String criteria_SEC;
    private String criteria_FONCT;
    private String criteria_COSFO;
    private String criteria_X01;
    private String criteria_X02;
    private String criteria_NUPAR = null;

    public Hashtable<String, String> getTagNameForSortCriteria() {
        if (TagNameForSortCriteria == null) {
            this.initializeTagTable();
        }
        return TagNameForSortCriteria;
    }

    private void initializeTagTable() {
        TagNameForSortCriteria = new Hashtable();
        TagNameForSortCriteria.put("H", "IDENTIFICATION");
        TagNameForSortCriteria.put("I  00", "IDENTIFICATION");
        TagNameForSortCriteria.put("I  01", "API-COBOL");
        TagNameForSortCriteria.put("I  05", "BATCH");
        TagNameForSortCriteria.put("I  10", "PROGRAM-ID");
        TagNameForSortCriteria.put("I  20", "AUTHOR");
        TagNameForSortCriteria.put("I  30", "DATE-COMPILED");
        TagNameForSortCriteria.put("I  40", "ENVIRONMENTDIV");
        TagNameForSortCriteria.put("100  ", "CONFIGURATION");
        TagNameForSortCriteria.put("10000", "SOURCE");
        TagNameForSortCriteria.put("10010", "OBJECT");
        TagNameForSortCriteria.put("10020   ", "SPECIAL-NAMES");
        TagNameForSortCriteria.put("101  ", "IOSEC-FILECTRL");
        TagNameForSortCriteria.put("160  ", "DATADIV");
        TagNameForSortCriteria.put("19999", "FILESEC");
        TagNameForSortCriteria.put("30A", "WSS-BEGIN");
        TagNameForSortCriteria.put("300   000", "CONSTANTS");
        TagNameForSortCriteria.put("300   009", "WSS-CONTINUATION");
        TagNameForSortCriteria.put("300   070", "DATE_WORKING_DAT6");
        TagNameForSortCriteria.put("300   080", "DATE_WORKING_DAT8");
        TagNameForSortCriteria.put("300   086", "DATE_WORKING_DAT8E");
        TagNameForSortCriteria.put("300   090", "DATE_WORKING_DAT6C");
        TagNameForSortCriteria.put("300   100", "DATE_WORKING_DAT8C");
        TagNameForSortCriteria.put("300   110", "DATE_WORKING_TIMCO");
        TagNameForSortCriteria.put("300   120", "DATE_WORKING_TIMDAY");
        TagNameForSortCriteria.put("300   200", "DATE_WORKING_DAT7");
        TagNameForSortCriteria.put("300   300", "DATE_WORKING_DATSEP");
        TagNameForSortCriteria.put("300   400", "DATE_WORKING_DATSET");
        TagNameForSortCriteria.put("300   402", "DATE_WORKING_DATSEW");
        TagNameForSortCriteria.put("300   410", "DATE_WORKING_DAT-TRANS");
        TagNameForSortCriteria.put("300   414", "DATE_WORKING_DAT-CTYT");
        TagNameForSortCriteria.put("300   416", "DATE_WORKING_DAT-CTY");
        TagNameForSortCriteria.put("300   420", "DATE_WORKING_DATE8S");
        TagNameForSortCriteria.put("300   422", "DATE_WORKING_DATE81");
        TagNameForSortCriteria.put("300   424", "DATE_WORKING_DATE82");
        TagNameForSortCriteria.put("300   426", "DATE_WORKING_NUM-DAYS");
        TagNameForSortCriteria.put("300   500", "DATE_WORKING_DATCTY");
        TagNameForSortCriteria.put("300   600", "DATE_WORKING_DAT7C");
        TagNameForSortCriteria.put("300   700", "DATE_WORKING_DAT8G");
        TagNameForSortCriteria.put("300   800", "DATE_WORKING_TT-DAT");
        TagNameForSortCriteria.put("4       ", "INDEXES-AUTO");
        TagNameForSortCriteria.put("7    ", "USERS-AREAS");
    }

    public MIA1lineWorking(MIA1file file) {
        super(file);
    }

    public MIA1lineWorking(MIA1file file, String lineContent) {
        super(file, lineContent);
    }

    @Override
    public void clean() {
        super.clean();
        this.criteria_COSFO = null;
        this.criteria_FONCT = null;
        this.criteria_NUETAX = null;
        this.criteria_NUPAR = null;
        this.criteria_SEC = null;
        this.criteria_X01 = null;
        this.criteria_X02 = null;
    }

    @Override
    public int getIndexForMacroLineNumberBeginIndex() {
        return 24;
    }

    @Override
    public int getIndexForCobolContentBegin() {
        return 30;
    }

    @Override
    public int getIndexForMacroCodeBegin() {
        return 114;
    }

    @Override
    public int getIndexForMacroCodeEnd() {
        return 120;
    }

    @Override
    public int getIndexForCobolContentEnd() {
        return 102;
    }

    @Override
    public int getIndexForSubFunctionCodeBegin() {
        return 112;
    }

    public String get_X3() {
        if (this.criteria_X3 == null) {
            this.criteria_X3 = this.lineContent.substring(17, 20);
        }
        return this.criteria_X3;
    }

    public String get_NUETAX() {
        if (this.criteria_NUETAX == null) {
            this.criteria_NUETAX = this.lineContent.substring(20, 21);
        }
        return this.criteria_NUETAX;
    }

    public String get_SEC() {
        if (this.criteria_SEC == null) {
            this.criteria_SEC = this.lineContent.substring(21, 22);
        }
        return this.criteria_SEC;
    }

    public String get_FONCT() {
        if (this.criteria_FONCT == null) {
            this.criteria_FONCT = this.lineContent.substring(22, 24);
        }
        return this.criteria_FONCT;
    }

    public String get_COSFO() {
        if (this.criteria_COSFO == null) {
            this.criteria_COSFO = this.lineContent.substring(24, 26);
        }
        return this.criteria_COSFO;
    }

    public String get_X01() {
        if (this.criteria_X01 == null) {
            this.criteria_X01 = this.lineContent.substring(26, 27);
        }
        return this.criteria_X01;
    }

    public String get_X02() {
        if (this.criteria_X02 == null) {
            this.criteria_X02 = this.lineContent.substring(27, 29);
        }
        return this.criteria_X02;
    }

    public String get_NUPAR() {
        if (this.criteria_NUPAR == null) {
            this.criteria_NUPAR = this.lineContent.substring(29, 30);
        }
        return this.criteria_NUPAR;
    }

    public String get_X3A() {
        return String.valueOf(this.get_X01()) + this.get_X02();
    }

    public String get_COFSF() {
        return String.valueOf(this.get_FONCT()) + this.get_COSFO();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getMiaFile().getEntityName() == null) {
            this.getMiaFile().setEntityName(this.lineContent.substring(6, 12).trim());
        }
        StringBuilder sb = new StringBuilder(this.get_SEC());
        this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
        if (this.tagName == null) {
            sb.append(this.get_FONCT());
            this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
            if (this.tagName == null) {
                sb.append(this.get_COSFO());
                this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
                if (this.tagName == null) {
                    sb.append(this.get_X01());
                    this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
                    if (this.tagName == null) {
                        sb.append(this.get_X02());
                        this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
                        if (this.tagName == null) {
                            sb.append(this.get_NUPAR());
                            this.tagName = this.getTagNameForSortCriteria().get(sb.toString());
                        }
                    }
                }
            }
        }
        if ("PROGRAM-ID".equals(this.tagName) && this.getMiaFile().getProgramID() == null) {
            String content = this.getCOBOLcontent().trim();
            int firstDot = content.indexOf(".");
            content = content.substring(firstDot + 1).trim();
            firstDot = content.indexOf(".");
            this.getMiaFile().setProgramID(content.substring(0, firstDot).trim());
        }
        if (System.getProperty("JUNIT_IN_PROGRESS") != null && "DATE-COMPILED".equals(this.tagName)) {
            this.lineContent = String.valueOf(this.lineContent.substring(0, 36)) + "*DATE-COMPILED.   01/01/13." + this.lineContent.substring(63);
        }
        if (this.getTagName() == null) {
            if ("1".equals(this.get_SEC())) {
                if ("01".equals(this.get_FONCT())) {
                    this.tagName = "SELECT-" + this.get_COSFO();
                } else if (this.isFromMacro() && "00".equals(this.get_FONCT()) && "20".equals(this.get_COSFO())) {
                    this.tagName = "SPECIAL-NAMES" + this.get_X02() + this.get_NUPAR();
                    return;
                }
            } else if ("2".equals(this.get_SEC())) {
                this.tagName = "  ".equals(this.get_COSFO()) ? "FDCLAUSE-" + this.get_FONCT() : "SEG-" + this.get_FONCT();
            } else if ("3".equals(this.get_SEC())) {
                if ("  ".equals(this.get_FONCT())) {
                    this.tagName = "WORKING-SECTION";
                    if (!this.getCOBOLcontent().trim().startsWith("WORKING-STORAGE SECTION")) {
                        throw new RuntimeException("Tag working mal positionn\u00e9");
                    }
                } else if (System.getProperty("JUNIT_IN_PROGRESS") != null) {
                    if ("300   006".equals(sb.toString())) {
                        this.lineContent = String.valueOf(this.lineContent.substring(0, 51)) + "'8500 BIB01/01/13 CODE   USER  13:13:13  CODE  RPP " + this.lineContent.substring(102);
                    } else if ("300   007".equals(sb.toString())) {
                        this.lineContent = String.valueOf(this.lineContent.substring(0, 36)) + "-    '01/01/2013 JUNIT 01/01/201301/01/2013'." + this.lineContent.substring(81);
                    }
                }
            }
            if (this.getTagName() == null && this.isFromMacro() && ("I".equals(this.get_SEC()) || "1".equals(this.get_SEC()) || "2".equals(this.get_SEC()))) {
                if ("  ".equals(this.get_FONCT())) {
                    this.tagName = "B__" + this.get_COSFO() + this.get_X02() + this.get_NUPAR();
                    return;
                }
                this.tagName = "B" + this.get_FONCT() + this.get_COSFO() + this.get_X02() + this.get_NUPAR();
                return;
            }
            if (this.tagName == null && (this.isFromMacro() || this.getMiaFile().isBufferBeginning(this.getCOBOLcontent()))) {
                this.tagName = "W-" + this.get_FONCT() + this.get_COSFO() + this.get_X01();
            }
        }
        if (this.tagName != null && ("I".equals(this.get_SEC()) || "1".equals(this.get_SEC()) || "2".equals(this.get_SEC())) && this.isFromMacro()) {
            this.tagName = this.tagName.concat(this.get_X02()).concat(this.get_NUPAR());
        }
    }

    @Override
    public boolean isProcedureLine() {
        return false;
    }
}

