/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.mia;

import com.ibm.pdp.engine.IBuilderTag;
import com.ibm.pdp.engine.IGenInfoBuilder;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.turbo.impl.GenInfoFactory;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.pac.migration.help.mia.MIA1Constants;
import com.ibm.pdp.pac.migration.help.mia.MIA1lineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIA1lineWorking;
import com.ibm.pdp.pac.migration.help.mia.MIALineImpl;
import com.ibm.pdp.pac.migration.help.mia.MIALineProcedure;
import com.ibm.pdp.pac.migration.help.mia.MIAfile;
import com.ibm.pdp.pac.migration.help.mia.MIAinfo;
import com.ibm.pdp.pac.migration.help.mia.MIAinfoType;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.extension.Ebcdic;
import com.ibm.pdp.pacbase.migration.plugin.NameSubstitution;
import com.ibm.pdp.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class MIA1file
extends MIAfile
implements MIA1Constants {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean top_W_DEBFI = false;
    private MIAinfo lastTagFromCOA = null;
    private boolean isAnotatedFileEmpty = false;
    private String top_W_DB2 = " ";
    private String top_W_PACTABLE = " ";
    private String top_W_BEGINS = " ";
    private String top_W_ENDSQL = " ";
    private String top_W_SEGSQL = " ";
    private String top_W_FINSEG = " ";
    private boolean top_W_ORACLE = false;
    private String top_W_X_FFNN = " ";
    private String top_W_SD = " ";
    private String w_P_COSEG;
    private String w_C_COSEG;
    private String w_CSEG;
    private String w_FIENR;
    private String w_SD_COSEG = "    ";
    private String w_SQLIND = " ";
    private String w_TRAITE = " ";
    private String w_E_OU_F = "E";
    private String top_W_TYP01 = "  ";
    private boolean top_W_FSEC6 = false;
    private boolean top_W_TAGSE = false;
    private String top_W_SEC = "";
    private String top_W_FONCT = "";
    private boolean closeTagAtTheEndOfMP = false;
    private String tagNameForAlphanumericLineNumberInMacro = null;
    private boolean forMigration = true;
    private boolean commentF05 = false;
    private String commentFxx = null;
    private String commentFxxyy = null;
    private String etiq = "";
    private String fonct = "";
    private String dsect = "";
    private String firstLineSaved = "";
    private String currentNuligMC = "";
    private boolean linesGroup = false;
    private HashMap<String, String> fctAndLevels = new HashMap();
    private List<String> tagToCreate = new ArrayList<String>();
    private List<String> COAFunctions = new ArrayList<String>();
    protected String firstMP = null;
    private ArrayList<String> all900linesWronglyAdded = new ArrayList();
    List<MIALineImpl> all900lines = new ArrayList<MIALineImpl>();
    boolean f9099_iter_fn_present = false;
    MIALineProcedure f9099_SUP_in_specific = null;

    public MIA1file(RadicalEntity entity) {
        super(entity, new HashMap<String, Boolean>());
    }

    public MIA1file(RadicalEntity entity, Map<String, Boolean> labelsAndEXIT) {
        super(entity, labelsAndEXIT);
    }

    @Override
    public void clean() {
        super.clean();
        this.top_W_DB2 = " ";
        this.top_W_PACTABLE = " ";
        this.top_W_DEBFI = false;
        this.top_W_TYP01 = "  ";
        this.top_W_FSEC6 = false;
        this.top_W_TAGSE = false;
        this.top_W_SEC = "";
        this.top_W_FONCT = "";
        this.commentF05 = false;
        this.commentFxx = null;
        this.commentFxxyy = null;
        this.etiq = "";
        this.fonct = "";
        this.dsect = "";
        this.firstLineSaved = "";
        this.currentNuligMC = "";
        this.linesGroup = false;
        this.closeTagAtTheEndOfMP = false;
    }

    @Override
    public String getPatternName() {
        return "com.ibm.pdp.pacbase.batch";
    }

    @Override
    public boolean isMicroPatternAnnotationsToKeep(String mpID) {
        return mpID.startsWith("AD") || "WI".equals(mpID) || "WE".equals(mpID) || "WS".equals(mpID) || "WF".equals(mpID) || "DAD".equals(mpID) || "DAO".equals(mpID) || "DCD".equals(mpID) || "DCF".equals(mpID) || "DID".equals(mpID) || "DIF".equals(mpID) || "DVD".equals(mpID) || "DVF".equals(mpID) || "TIM".equals(mpID) || "TIF".equals(mpID) || "OPE".equals(mpID) || "R".equals(mpID) || "W".equals(mpID) || "MCI".equals(mpID) || "SQL".equals(mpID);
    }

    @Override
    public void setFileToAnalyse(String anotatedFileName, String cobolFileName, List<NameSubstitution> lns) {
        if (this.entity != null && this.entity instanceof PacProgram) {
            PacProgram p = (PacProgram)this.entity;
            if (p.getProgramStructure().equals(PacProgramStructureValues._F_LITERAL)) {
                this.lns = lns;
                ArrayList<String> allFileLines = this.readFile(cobolFileName);
                this.allLines = new ArrayList();
                Iterator<String> it = allFileLines.iterator();
                String tempCobolC9 = it.next();
                List<MIALineImpl> currentLines = null;
                String blank = "                              ";
                String endMP = String.valueOf(blank) + "      *\u00ee";
                if (tempCobolC9.length() > 72 || this.isBufferBeginning(tempCobolC9)) {
                    currentLines = this.initializeMIALine(String.valueOf(blank) + tempCobolC9);
                }
                while (it.hasNext()) {
                    if (currentLines != null) {
                        this.allLines.addAll(currentLines);
                        currentLines = null;
                    }
                    if ((tempCobolC9 = it.next()).length() <= 72 && !this.isBufferBeginning(tempCobolC9)) continue;
                    if (!this.allLines.isEmpty() && this.isBufferBeginning(tempCobolC9)) {
                        this.allLines.addAll(this.initializeMIALine(endMP));
                    }
                    currentLines = this.initializeMIALine(String.valueOf(blank) + tempCobolC9);
                }
                if (currentLines != null) {
                    this.allLines.addAll(currentLines);
                }
                if (!this.allLines.isEmpty()) {
                    this.allLines.addAll(this.initializeMIALine(endMP));
                }
                return;
            }
            if (p.getVariante().equals(PacProgramVariantValues._C_LITERAL)) {
                return;
            }
            File f = new File(anotatedFileName);
            if (!f.exists() || f.length() < 1L) {
                this.isAnotatedFileEmpty = true;
                return;
            }
        }
        super.setFileToAnalyse(anotatedFileName, cobolFileName, lns);
    }

    @Override
    public IGeneratedInfo transformToGeneratedInfo() {
        PacProgram p;
        if (this.entity != null && this.entity instanceof PacProgram && ((p = (PacProgram)this.entity).getVariante().equals(PacProgramVariantValues._C_LITERAL) || this.isAnotatedFileEmpty)) {
            GenInfoFactory gif = new GenInfoFactory();
            gif.setProperty("pattern", "com.ibm.pdp.pacbase.batch");
            gif.beginTag(p.getName());
            gif.endTag();
            return gif.createGeneratedInfo();
        }
        return super.transformToGeneratedInfo();
    }

    @Override
    protected IGeneratedInfo endGeneratedInfo() {
        IGeneratedInfo gInfo = super.endGeneratedInfo();
        IGenInfoBuilder gib = gInfo.toGeneratedInfoBuilder();
        if (gib.tagFromName("PROCEDURE") == null && gib.getRootTag().lastSon() != null) {
            gib.addTagAfter("PROCEDURE", gib.getRootTag().lastSon().getName());
        }
        return gib.toGeneratedInfo();
    }

    private boolean isEtiquetteLine(MIA1lineProcedure line) {
        return line.getCOBOLcontent().charAt(6) != '*' && line.getCOBOLcontent().charAt(7) == 'F' && !line.getCOA().equals("COA") && this.getFNLine(line) == null && this.get900FromLine(line) == null;
    }

    protected boolean isLineToKeep(MIA1lineWorking line) {
        if ("4".equals(line.get_SEC()) && !"    ".equals(line.get_COFSF()) && !line.get_FONCT().startsWith(" ")) {
            String futureTagName = line.lineContent.substring(55, 61);
            if (this.allIndices.contains(futureTagName)) {
                return false;
            }
            this.allIndices.add(futureTagName);
        }
        if (this.isBufferBeginning(line.getCOBOLcontent())) {
            this.firstMP = line.getCOBOLcontent();
        }
        if (("3".equals(line.get_SEC()) || "7".equals(line.get_SEC())) && this.isBufferEnding(line.getCOBOLcontent()) && "9".equals(line.get_X01()) && "99".equals(line.get_COSFO()) && this.firstMP.length() > 10 && !this.firstMP.substring(0, 10).equals("      *\u00f4WF")) {
            return !this.isMPAtTheSamePlaceAsCDline(line, (MIA1lineWorking)this.previousLine_ReadFile);
        }
        return true;
    }

    private boolean isMPAtTheSamePlaceAsCDline(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return ("3".equals(secondLine.get_SEC()) || "7".equals(secondLine.get_SEC())) && firstLine.get_X01().equals(secondLine.get_X01()) && "9".equals(secondLine.get_X01()) && firstLine.get_COSFO().equals(secondLine.get_COSFO()) && "99".equals(secondLine.get_COSFO()) && firstLine.get_FONCT().equals(secondLine.get_FONCT()) && firstLine.get_X02().trim().length() == 0 && !"  ".equals(secondLine.get_X02());
    }

    protected boolean isLineToKeep(MIA1lineProcedure line) {
        String current900;
        if (this.isEtiquetteLine(line)) {
            String codFct = null;
            if (line.get_Col_Value(40).equals(".")) {
                codFct = line.get_FONCT();
                if (line.isFromMacro()) {
                    this.fctAndLevels.put(codFct, line.get_MCLEVEL().substring(2, 4));
                } else {
                    this.fctAndLevels.put(codFct, "05");
                }
            } else {
                codFct = line.get_FONCT();
                String codSSFct = String.valueOf(codFct) + line.get_COSFO();
                if (!this.fctAndLevels.containsKey(codSSFct)) {
                    if (line.isFromMacro()) {
                        this.fctAndLevels.put(codSSFct, line.get_MCLEVEL().substring(2, 4));
                    } else {
                        String cob;
                        this.fctAndLevels.put(codSSFct, "10");
                        if ("76-A".equals(codSSFct)) {
                            this.fctAndLevels.put("76", "05");
                        }
                        if ((cob = line.getCOBOLcontent().trim()).equals(String.valueOf(codSSFct = "F" + codSSFct) + ".")) {
                            this.all900linesWronglyAdded.add(codSSFct);
                        }
                    }
                }
            }
        }
        if (line.isFromMacro()) {
            String etiq;
            if (line.get_MCNUMLG().trim().length() > 0 && line.get_MCNUMLG().compareTo("000") > 0) {
                etiq = null;
                etiq = line.get_MCCOSFO() != null && line.get_MCCOSFO().trim().length() > 0 ? String.valueOf(line.get_MCFONCT()) + line.get_MCCOSFO() : line.get_MCFONCT();
                if (!this.tagToCreate.contains(etiq = "F" + etiq)) {
                    this.tagToCreate.add(etiq);
                }
            } else if (line.getCOA().equals("COA")) {
                String level;
                etiq = null;
                if (line.get_MCCOSFO() != null && line.get_MCCOSFO().trim().length() > 0) {
                    etiq = String.valueOf(line.get_MCFONCT()) + line.get_MCCOSFO();
                    level = "10";
                } else {
                    etiq = line.get_MCFONCT();
                    level = "05";
                }
                if (!this.fctAndLevels.containsKey(etiq)) {
                    this.fctAndLevels.put(etiq, level);
                }
                if (!this.tagToCreate.contains(etiq = "F" + etiq)) {
                    this.tagToCreate.add(etiq);
                }
            }
        }
        if ((current900 = this.get900FromLine(line)) != null && this.all900linesWronglyAdded.contains(current900)) {
            return false;
        }
        this.specialTreatmentForSup(line);
        return true;
    }

    @Override
    public MIALineImpl instanciateMIAline(String lineContent) {
        if (!this.isLineOk(lineContent)) {
            return null;
        }
        MIALineImpl line = null;
        if (lineContent.charAt(21) == '9' ? !this.isLineToKeep((MIA1lineProcedure)(line = new MIA1lineProcedure(this, lineContent))) : !this.isLineToKeep((MIA1lineWorking)(line = new MIA1lineWorking(this, lineContent)))) {
            return null;
        }
        return line;
    }

    protected String get900FromLine(MIALineImpl currentLine) {
        if (currentLine instanceof MIA1lineProcedure) {
            String firstWord;
            MIA1lineProcedure current = (MIA1lineProcedure)currentLine;
            if ("COA".equals(current.getCOA())) {
                return null;
            }
            String line = current.getCOBOLcontent().trim();
            int index = line.indexOf(32);
            if (index == -1) {
                index = line.length();
            }
            if ((firstWord = line.substring(0, index)).endsWith("-900.")) {
                return firstWord.substring(0, index - 5);
            }
        }
        return null;
    }

    @Override
    protected void storeLineIfNeeded(MIALineImpl line) {
        super.storeLineIfNeeded(line);
        if (line instanceof MIA1lineProcedure) {
            MIA1lineProcedure current = (MIA1lineProcedure)line;
            String previous900 = this.get900FromLine(this.previousLine_ReadFile);
            String currentContent = current.getCOBOLcontent().trim();
            if (previous900 != null) {
                String firstWord;
                int index = currentContent.indexOf(32);
                if (index == -1) {
                    index = currentContent.length();
                }
                if ((firstWord = currentContent.substring(0, index)).endsWith("-FN.")) {
                    if (!previous900.equals(firstWord = firstWord.substring(0, index - 4))) {
                        this.all900lines.add(this.previousLine_ReadFile);
                    }
                } else {
                    this.all900lines.add(this.previousLine_ReadFile);
                }
                return;
            }
            if (currentContent.startsWith("F9099-ITER-FN")) {
                this.f9099_iter_fn_present = true;
                if (current.isSUP() && !current.isFromMacro()) {
                    this.f9099_SUP_in_specific = current;
                }
            }
        }
    }

    @Override
    protected void organizeLines() {
        super.organizeLines();
        if (this.f9099_SUP_in_specific != null) {
            int indexBefore = -1;
            int indexAfter = -1;
            while ((indexAfter = this.moveFN_LinesBefore(indexBefore = this.allLines.indexOf(this.f9099_SUP_in_specific))) < indexBefore) {
            }
        }
        if (this.all900lines.isEmpty()) {
            return;
        }
        ArrayList<MIALineImpl> allNewLines = new ArrayList<MIALineImpl>();
        this.allLines.removeAll(this.all900lines);
        Iterator<MIALineImpl> it900 = this.all900lines.iterator();
        Iterator itAll = this.allLines.iterator();
        MIALineImpl current900 = it900.next();
        String fnToFind = String.valueOf(this.get900FromLine(current900)) + "-FN.";
        while (itAll.hasNext()) {
            String cobol;
            MIALineImpl line = (MIALineImpl)itAll.next();
            if (current900 != null && line instanceof MIA1lineProcedure && (cobol = line.getCOBOLcontent().trim()).startsWith(fnToFind)) {
                allNewLines.add(current900);
                current900 = it900.hasNext() ? it900.next() : null;
            }
            allNewLines.add(line);
        }
        this.allLines = allNewLines;
    }

    @Override
    protected boolean closeFunctionEvenIfSubFunction(MIALineImpl line) {
        String fct = line.getCurrentFunction();
        return fct.equals("9099") && this.ffToAdd.equals("90") && this.f9099_iter_fn_present && !line.isFromMacro();
    }

    public boolean isCurrentLineFromGenerated(MIALineImpl currentLine) {
        String generatedCode;
        return currentLine.toString().length() >= 102 && (generatedCode = currentLine.toString().substring(102)).startsWith(this.getProgramID());
    }

    @Override
    public Iterator<MIAinfo> analyseFirstMIAline(MIALineImpl currentMIAline) {
        List<MIAinfo> result = MIAinfo.CreateATag("ENTITY_" + this.getEntityName(), this);
        PacProgram p = (PacProgram)this.entity;
        if (!this.isBufferBeginning(currentMIAline.getCOBOLcontent()) && p != null && p.getProgramStructure().equals(PacProgramStructureValues._S_LITERAL)) {
            result.addAll(MIAinfo.CreateATagWithTextAndProperty(currentMIAline.getTagName(), currentMIAline.getCOBOLcontent(), currentMIAline.getProperties(), this));
            if (currentMIAline.isFromMacro() && !result.isEmpty()) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        } else {
            result.addAll(this.createATagFromMIAline(currentMIAline));
        }
        return result.iterator();
    }

    @Override
    public Iterator<MIAinfo> analyseLastMIAline(MIALineImpl currentMIAline) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        MIALineImpl obj = currentMIAline;
        if (obj instanceof MIA1lineProcedure) {
            if ("F9099-ITER-FN".equals(((MIA1lineProcedure)currentMIAline).getSortCriteria5())) {
                this.procedure_F52HB((MIA1lineProcedure)currentMIAline, result);
            } else {
                this.compareMIA1linesProcedure((MIA1lineProcedure)currentMIAline, null, result);
            }
        }
        return result.iterator();
    }

    @Override
    public int getMinimumLineLength() {
        return 30;
    }

    public MIA1lineWorking getNextWorkingLine() {
        if (this.getNextLine() instanceof MIA1lineWorking) {
            return (MIA1lineWorking)this.getNextLine();
        }
        return null;
    }

    public MIA1lineProcedure getNextProcedureLine() {
        if (this.getNextLine() instanceof MIA1lineProcedure) {
            return (MIA1lineProcedure)this.getNextLine();
        }
        return null;
    }

    @Override
    public Iterator<MIAinfo> compareMIAlines(MIALineImpl firstLine, MIALineImpl secondLine) {
        ArrayList<MIAinfo> result = new ArrayList<MIAinfo>();
        if (this.isInProcedure()) {
            this.compareMIA1linesProcedure((MIA1lineProcedure)firstLine, (MIA1lineProcedure)secondLine, result);
        } else if (secondLine instanceof MIA1lineWorking) {
            this.compareMIA1linesWorking((MIA1lineWorking)firstLine, (MIA1lineWorking)secondLine, result);
            if (this.w_P_COSEG != null && !this.w_P_COSEG.equals(this.w_C_COSEG)) {
                this.w_P_COSEG = this.w_C_COSEG;
            }
        } else {
            this.setInProcedure(true);
            this.firstMIA1lineProcedure((MIA1lineWorking)firstLine, (MIA1lineProcedure)secondLine, result);
        }
        return result.iterator();
    }

    public List<MIAinfo> compareMIA1linesWorking(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        if (this.isBufferBeginning(secondLine.getCOBOLcontent())) {
            if (this.containsTag("BEGINSQL") || this.containsTag("ENDSQL")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (!secondLine.isFromMacro() && this.containsTag(secondLine.getTagName())) {
                this.closeTagAtTheEndOfMP = true;
            }
            result.addAll(this.createATagBeforeBufferFromMIAline(secondLine));
            this.initWorkingTops(firstLine, secondLine);
            return result;
        }
        if (this.isBufferEnding(secondLine.getCOBOLcontent()) || this.isInBuffer() && this.isMPAtTheSamePlaceAsCDline(firstLine, secondLine) && this.buffer.length() > 10 && !this.buffer.substring(0, 10).equals("      *\u00f4WF")) {
            if (!this.isBufferEnding(secondLine.getCOBOLcontent())) {
                result.addAll(MIAinfo.InsertText("      *\u00ee", this));
                if (this.closeTagAtTheEndOfMP) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.closeTagAtTheEndOfMP = false;
                this.top_W_TAGSE = false;
                this.top_W_DEBFI = false;
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                if (this.closeTagAtTheEndOfMP) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.closeTagAtTheEndOfMP = false;
                this.top_W_TAGSE = false;
                this.top_W_DEBFI = false;
                return result;
            }
        }
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return result;
        }
        this.initWorkingTops(firstLine, secondLine);
        if ("I".equals(secondLine.get_SEC()) && "  ".equals(secondLine.get_FONCT())) {
            this.workingI_F50HE(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO())) {
            this.working1_F50HS(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "00".equals(secondLine.get_COSFO())) {
            this.working1_F50HV(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "10".equals(secondLine.get_COSFO())) {
            this.working1_F50IB(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "20".equals(secondLine.get_COSFO())) {
            this.working1_F50IC(firstLine, secondLine, result);
        }
        if (Ebcdic.stringCompare((String)"101", (String)(String.valueOf(secondLine.get_SEC()) + secondLine.get_FONCT())) <= 0 && this.containsTag("CONFIGURATION")) {
            this.working1_F50ID(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "01".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO())) {
            this.working1_F50IH(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "01".equals(secondLine.get_FONCT()) && !"  ".equals(secondLine.get_COSFO())) {
            this.working1_F50IJ(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "60".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO())) {
            this.working1_F50IO(firstLine, secondLine, result);
        }
        if ("1".equals(secondLine.get_SEC()) && "99".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO())) {
            this.working1_F50IP(firstLine, secondLine, result);
        }
        if ("2".equals(secondLine.get_SEC()) && "  ".equals(secondLine.get_COSFO())) {
            this.working2_F50IQ(firstLine, secondLine, result);
        }
        if ("2".equals(secondLine.get_SEC()) && !"  ".equals(secondLine.get_COSFO())) {
            this.working2_F50IT(firstLine, secondLine, result);
        }
        if ("3".equals(secondLine.get_SEC()) && "  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO())) {
            this.working3_F50JB(firstLine, secondLine, result);
        }
        if ("3".equals(secondLine.get_SEC()) && "0A".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO())) {
            this.working3_F50JC(firstLine, secondLine, result);
            return result;
        }
        if ("3".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) && " 00".equals(secondLine.get_X3A())) {
            this.working3_F50JD(firstLine, secondLine, result);
        }
        if ("3_7_8".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && !"  ".equals(secondLine.get_COSFO()) && !" ".equals(secondLine.get_X01()) && (!"  ".equals(secondLine.get_X02()) && !"V".equals(secondLine.get_NUETAX()) && !"S-PASSWO".equals(secondLine.lineContent.substring(55, 63)) && ("Z".equals(secondLine.get_NUPAR()) || "0".equals(secondLine.get_NUPAR())) || "  ".equals(secondLine.get_X02()) && this.isWorkingBreakOn_5_X01(firstLine, secondLine) && this.getNextWorkingLine() != null && !this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine())) && !this.top_W_DEBFI && '*' != secondLine.lineContent.charAt(36) || "*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46)) && "3_7_8".indexOf(secondLine.get_SEC()) != -1 && (this.isWorkingBreakOn_5_X01(firstLine, secondLine) || this.isMPAtTheSamePlaceAsCDline(firstLine, secondLine))) {
            if ("*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46))) {
                this.top_W_DB2 = "1";
            }
            if (!("1".equals(this.top_W_SD) || "1".equals(this.top_W_SEGSQL) || "1".equals(this.top_W_PACTABLE) || "08".equals(this.top_W_TYP01) || "7".equals(secondLine.get_SEC()) && "Z".equals(secondLine.get_NUPAR()) && "9".equals(secondLine.get_X3().subSequence(0, 1)) || "37".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && "  ".equals(secondLine.get_X02()) || "8".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) || "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(17, 31)))) {
                this.working_F50JH(firstLine, secondLine, result);
                this.working_F50JI(firstLine, secondLine, result);
                if (result != null && result.size() != 0) {
                    return result;
                }
            }
        }
        if (!(!this.top_W_DEBFI || !this.isWorkingBreakOn_6_X02(firstLine, secondLine) || !this.top_W_TAGSE || !"V-".equals(secondLine.lineContent.substring(54, 56)) && "M_N_O_P".indexOf(secondLine.get_NUPAR()) != -1 || this.top_W_SEGSQL.equals("1") || "37".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && "  ".equals(secondLine.get_X02()) || "8".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()))) {
            this.working_F50JK(firstLine, secondLine, result);
            return result;
        }
        if (!(!this.top_W_DEBFI || !this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine()) || this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) || !this.top_W_TAGSE || !"V-".equals(secondLine.lineContent.substring(54, 56)) && "M_N_O_P".indexOf(secondLine.get_NUPAR()) != -1 || "1".equals(this.top_W_SEGSQL) || "37".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && "  ".equals(secondLine.get_X02()) || "8".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) || this.getNextWorkingLine() != null && "M".equals(this.getNextWorkingLine().get_NUPAR()) && "*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14)))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (!this.isInBuffer()) {
                result.add(MIAinfo.CLOSE_TAG);
                if (this.getNextWorkingLine() != null && "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31))) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            return result;
        }
        if ((this.top_W_DEBFI && this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) && "3_7".indexOf(secondLine.get_SEC()) != -1 && ("V-".equals(secondLine.lineContent.substring(54, 56)) || "M_N_O_P".indexOf(secondLine.get_NUPAR()) == -1) || "3".equals(secondLine.get_SEC()) && "M".equals(this.getNextWorkingLine().get_NUPAR()) && "*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14))) && !"1".equals(this.top_W_SEGSQL)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (this.top_W_TAGSE && !"1".equals(this.top_W_FINSEG)) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (!this.top_W_TAGSE) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.top_W_DEBFI = false;
            this.top_W_TAGSE = false;
            return result;
        }
        if (!(!this.top_W_DEBFI && !"1".equals(this.top_W_ENDSQL) || !"8".equals(secondLine.get_SEC()) || this.getNextWorkingLine() == null || !this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine()) || "37".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && "  ".equals(secondLine.get_X02()) || "8".indexOf(secondLine.get_SEC()) != -1 && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()))) {
            this.working_F50JT(firstLine, secondLine, result);
            return result;
        }
        if ("6".equals(secondLine.get_SEC()) && (("E".equals(secondLine.get_NUETAX()) || "M".equals(secondLine.get_NUETAX())) && this.isWorkingBreakOn_3_FONCT(firstLine, secondLine) || " ".equals(secondLine.get_NUETAX()) && "  ".equals(secondLine.get_COSFO()) && "A".equals(secondLine.get_X01()) || "*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46))) && !this.top_W_FSEC6) {
            this.top_W_FSEC6 = true;
            this.working6_F50KB(firstLine, secondLine, result);
            return result;
        }
        if ("6".equals(secondLine.get_SEC()) && this.top_W_FONCT.equals(secondLine.get_FONCT()) && this.top_W_SEC.equals(secondLine.get_SEC()) && (this.getNextWorkingLine() == null || !this.top_W_FONCT.equals(this.getNextWorkingLine().get_FONCT()) || !this.top_W_SEC.equals(this.getNextWorkingLine().get_SEC()))) {
            this.working6_F50KF(firstLine, secondLine, result);
            return result;
        }
        if ("6".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) && "   ".equals(secondLine.get_X3A())) {
            this.working6_F50KJ(firstLine, secondLine, result);
            return result;
        }
        if ("6".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && this.containsTag(tagName = "COE-" + secondLine.get_FONCT()) && this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            this.working6_F50KL(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && "K".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT())) {
            this.working5_F50KO(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT()) && this.containsTag("CAT-TAB") && "10".equals(this.getNextWorkingLine().get_X02())) {
            this.working5_F50KQ(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT()) && " ".equals(secondLine.get_X01()) && "10".equals(secondLine.get_X02())) {
            this.working5_F50KT(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT()) && !"   ".equals(secondLine.get_X3A()) && this.containsTag("CAT") && this.isWorkingBreakOn_5_X01(firstLine, secondLine)) {
            this.working5_F50KW(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT()) && !"   ".equals(secondLine.get_X3A()) && this.containsTag("CAT") && this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine())) {
            this.working5_F50LB(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "95".equals(secondLine.get_FONCT()) && "ZZ".equals(secondLine.get_COSFO())) {
            if (!this.containsTag("CAT-SIZE")) {
                secondLine.tagName = "CAT-SIZE";
                result.addAll(this.createATagFromMIAline(secondLine));
                return result;
            }
            if (this.getNextWorkingLine() == null || !"ZZ".equals(this.getNextWorkingLine().get_COSFO())) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                return result;
            }
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "97".equals(secondLine.get_FONCT())) {
            if (!this.containsTag("REPORT-VAR")) {
                secondLine.tagName = "REPORT-VAR";
                result.addAll(this.createATagFromMIAline(secondLine));
                return result;
            }
            if (this.getNextWorkingLine() == null || !"97".equals(this.getNextWorkingLine().get_FONCT())) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                return result;
            }
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "99".equals(secondLine.get_FONCT()) && this.isWorkingBreakOn_3_FONCT(firstLine, secondLine)) {
            this.working5_F50LP(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "99".equals(secondLine.get_FONCT()) && this.isWorkingBreakOn_5_X01(firstLine, secondLine)) {
            this.working5_F50LT(firstLine, secondLine, result);
            return result;
        }
        if ("5".equals(secondLine.get_SEC()) && " ".equals(secondLine.get_NUETAX()) && "99".equals(secondLine.get_FONCT()) && this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine())) {
            this.working5_F50LW(firstLine, secondLine, result);
            return result;
        }
        if (!(!"3".equals(secondLine.get_SEC()) || "  ".equals(secondLine.get_FONCT()) || "  ".equals(secondLine.get_COSFO()) || " ".equals(secondLine.get_X01()) || "  ".equals(secondLine.get_X02()) || "M_N_O_P".indexOf(secondLine.get_NUPAR()) == -1)) {
            this.working5_F50LY(firstLine, secondLine, result);
            return result;
        }
        if ("7".equals(secondLine.get_SEC()) && "  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) && " ".equals(secondLine.get_X01())) {
            this.working7_F50LZ(firstLine, secondLine, result);
            return result;
        }
        if ("3".equals(secondLine.get_SEC()) && !this.top_W_DB2.equals("1") && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && this.working5_F50L1(firstLine, secondLine, result)) {
            return result;
        }
        if (secondLine.tagName == null && !this.isInBuffer() && " 01".equals(secondLine.getCOBOLcontent().substring(6, 9)) && ("V".equals(secondLine.get_NUETAX()) && "3".equals(secondLine.get_SEC()) && "05  ".equals(secondLine.get_COFSF()) || " ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "    ".equals(secondLine.get_COFSF()) || " ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "CE  ".equals(secondLine.get_COFSF()) || " ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "CF  ".equals(secondLine.get_COFSF()) || "Q".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "EN  ".equals(secondLine.get_COFSF()) || " ".equals(secondLine.get_NUETAX()) && "6".equals(secondLine.get_SEC()) && !"    ".equals(secondLine.get_COFSF()) && "   ".equals(secondLine.get_X3A()) && "2".equals(secondLine.get_NUPAR()) || " ".equals(secondLine.get_NUETAX()) && !"    ".equals(secondLine.get_COFSF()) && "G-".equals(secondLine.lineContent.substring(47, 49)) && ("3".equals(secondLine.get_SEC()) || "8".equals(secondLine.get_SEC()) && this.isWorkingBreakOn_5_X01(firstLine, secondLine)) || " ".equals(secondLine.get_NUETAX()) && "6".equals(secondLine.get_SEC()) && !"    ".equals(secondLine.get_COFSF()) && "   ".equals(secondLine.get_X3A()) && "A".equals(secondLine.get_NUPAR()) && this.isWorkingBreakOn_5_X01(firstLine, secondLine))) {
            this.working_F50MB(firstLine, secondLine, result);
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ("7".equals(secondLine.get_SEC()) && PacTool.IsLinkageSectionStarting((String)secondLine.getCOBOLcontent())) {
            result.addAll(this.closeTagsUntil(2));
            this.top_W_TYP01 = "  ";
            result.addAll(MIAinfo.CreateATag("LINKAGE", this));
            result.addAll(this.createOneTagFromMIAline(secondLine));
            return result;
        }
        if (!("  ".equals(this.top_W_TYP01) || !(this.getNextWorkingLine() == null || " 01".equals(this.getNextWorkingLine().getCOBOLcontent().substring(6, 9)) || this.getNextWorkingLine().isFromMacro() && this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine()) || "           EXEC SQL ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(6, 26)) || this.getNextWorkingLine().getCOBOLcontent().charAt(6) == '*' || "08".equals(this.top_W_TYP01) && this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine())) && !"9".equals(this.getNextWorkingLine().get_SEC()) || this.getNextWorkingLine() == null || this.getNextWorkingLine().get_COFSF().equals(secondLine.get_COFSF()) && (this.getNextWorkingLine().get_X3A().equals(secondLine.get_X3A()) && !this.getNextWorkingLine().get_NUPAR().equals(secondLine.get_NUPAR()) && "07".equals(this.top_W_TYP01) || !this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) && "09".equals(this.top_W_TYP01)))) {
            this.working_F50MD(firstLine, secondLine, result);
            return result;
        }
        if ("4".equals(secondLine.get_SEC())) {
            this.working4_F50MF(firstLine, secondLine, result);
            return result;
        }
        if ("7".equals(secondLine.get_SEC()) && !this.top_W_DB2.equals("1") && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO()) && this.working5_F50NA(firstLine, secondLine, result)) {
            return result;
        }
        if ("8".equals(secondLine.get_SEC()) && !this.top_W_DB2.equals("1") && !this.top_W_PACTABLE.equals("1") && !"  ".equals(secondLine.get_FONCT()) && this.working5_F50OA(firstLine, secondLine, result)) {
            return result;
        }
        if ("3_7".indexOf(secondLine.get_SEC()) != -1 && !this.top_W_DB2.equals("1") && !this.top_W_PACTABLE.equals("1") && !"  ".equals(secondLine.get_FONCT()) && "99".equals(secondLine.get_COSFO())) {
            this.working5_F50QA(firstLine, secondLine, result);
            if (result != null && result.size() != 0) {
                return result;
            }
        }
        if ("3".equals(secondLine.get_SEC()) && !"  ".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) && "Z".equals(secondLine.get_NUPAR()) && " COPY".equals(secondLine.getCOBOLcontent().substring(6, 11))) {
            this.working5_F50R1(firstLine, secondLine, result);
        }
        if ("8".equals(secondLine.get_SEC()) && !"  ".equals(secondLine.get_FONCT()) && !"  ".equals(secondLine.get_COSFO()) && "AA0".equals(secondLine.get_X3A()) && "XZ".contains(secondLine.get_NUPAR())) {
            this.working5_F50SB(firstLine, secondLine, result);
        }
        if ("8".equals(secondLine.get_SEC()) && "999".equals(secondLine.get_X3()) && !"  ".equals(secondLine.get_FONCT()) && !"  ".equals(secondLine.get_COSFO()) && !"   ".equals(secondLine.get_X3A()) && "56".contains(secondLine.get_NUPAR()) && this.getNextWorkingLine() != null && this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            this.working5_F50SF(firstLine, secondLine, result);
        }
        int num = -1;
        try {
            num = MIA1file.TransformStringToInt(secondLine.get_SEC());
        }
        catch (NumberFormatException numberFormatException) {
            num = -1;
        }
        if (!"1".equals(this.w_TRAITE) && (("3".equals(secondLine.get_SEC()) && !"  ".equals(secondLine.get_FONCT()) && !"0A".equals(secondLine.get_FONCT()) && !"00".equals(secondLine.get_FONCT()) || "3".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && !" 00".equals(secondLine.get_X3A()) || num > 3 && num < 9) && secondLine.getCOBOLcontent().charAt(6) != '*' || ("*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14)) || "*BEGIN DB2".equals(secondLine.getCOBOLcontent().substring(6, 16))) && this.top_W_DEBFI || "*BEGIN DB2".equals(secondLine.getCOBOLcontent().substring(6, 16)) && this.top_W_FSEC6)) {
            this.working_F50TB(firstLine, secondLine, result);
            return result;
        }
        if (result.isEmpty()) {
            if (secondLine.getTagName() != null) {
                if (!this.containsTag(secondLine.getTagName())) {
                    if (secondLine.isFromMacro()) {
                        result.addAll(this.createOneTagFromMIAline(secondLine));
                    }
                } else {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        return result;
    }

    public void initWorkingTops(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        this.working4_F50BB(firstLine, secondLine);
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine) && "378".contains(secondLine.get_SEC())) {
            this.top_W_TAGSE = false;
            this.top_W_DEBFI = false;
        }
        if (this.isWorkingBreakOn_5_X01(firstLine, secondLine) && "37".contains(secondLine.get_SEC())) {
            this.w_P_COSEG = "    ";
            this.w_C_COSEG = "    ";
        }
        if (this.isWorkingBreakOn_4_COSFO(firstLine, secondLine) && "8".contains(secondLine.get_SEC())) {
            this.w_P_COSEG = "    ";
            this.w_C_COSEG = "    ";
        }
        if (this.isWorkingBreakOn_2_SEC(firstLine, secondLine)) {
            this.w_E_OU_F = "E";
            if ("3".contains(secondLine.get_SEC())) {
                this.w_E_OU_F = "F";
            }
        }
        if ("1".equals(this.top_W_PACTABLE) && "7".equals(secondLine.get_SEC()) && "EXEC SQL".equals(secondLine.getCOBOLcontent().substring(18, 26))) {
            this.top_W_PACTABLE = " ";
        }
    }

    private boolean working5_F50L1(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("G-".equals(secondLine.lineContent.substring(47, 49)) && ".".equals(secondLine.lineContent.substring(53, 54)) && " ".equals(secondLine.lineContent.substring(36, 37)) && " ".equals(secondLine.get_NUETAX())) {
            String tagName;
            this.top_W_PACTABLE = "1";
            this.w_C_COSEG = secondLine.lineContent.substring(49, 53);
            secondLine.tagName = tagName = String.valueOf(secondLine.get_FONCT()) + "999-PACTABLE-COM-" + this.w_C_COSEG;
            result.addAll(this.createATagFromMIAline(secondLine));
            return true;
        }
        if ("1".equals(this.top_W_PACTABLE) && (this.getNextWorkingLine() == null || this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine()))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_TYP01 = "  ";
            return true;
        }
        return false;
    }

    private boolean working5_F50NA(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("G-".equals(secondLine.lineContent.substring(47, 49)) && ".".equals(secondLine.lineContent.substring(53, 54)) && " ".equals(secondLine.lineContent.substring(36, 37)) && " ".equals(secondLine.get_NUETAX())) {
            String tagName;
            this.top_W_PACTABLE = "1";
            this.w_C_COSEG = secondLine.lineContent.substring(49, 53);
            if (this.isWorkingBreakOn_5_X01(firstLine, secondLine) || this.w_P_COSEG == "    " && !this.w_P_COSEG.equals(this.w_C_COSEG)) {
                tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01() + this.w_E_OU_F;
                result.addAll(MIAinfo.CreateATag(tagName, this));
            }
            secondLine.tagName = tagName = String.valueOf(secondLine.get_FONCT()) + "999-PACTABLE-COM-" + this.w_C_COSEG;
            result.addAll(this.createATagFromMIAline(secondLine));
            this.w_TRAITE = "1";
            return true;
        }
        if ("1".equals(this.top_W_PACTABLE) && (this.getNextWorkingLine() == null || this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine()))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() != null && (this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) || "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31)))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.top_W_TYP01 = "  ";
            return true;
        }
        return false;
    }

    private void working_F50JT(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (!this.top_W_ORACLE) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_CSEG = " ";
            return;
        }
        if ("1".equals(this.top_W_ENDSQL)) {
            this.top_W_ENDSQL = "2";
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_CSEG = " ";
            return;
        }
        if ("5".equals(secondLine.get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(18, 32))) {
            String tagName;
            this.top_W_ENDSQL = "2";
            secondLine.tagName = tagName = "ENDSQL";
            result.addAll(this.createATagFromMIAline(secondLine));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_CSEG = " ";
            return;
        }
        if ("1".equals(this.top_W_X_FFNN)) {
            this.top_W_X_FFNN = "2";
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_CSEG = " ";
            return;
        }
    }

    private void working4_F50BB(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        this.w_TRAITE = " ";
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine)) {
            this.top_W_X_FFNN = " ";
            this.top_W_ENDSQL = " ";
            this.top_W_ORACLE = false;
            this.top_W_PACTABLE = " ";
            this.top_W_SD = " ";
        }
        if (this.isWorkingBreakOn_5_X01(firstLine, secondLine)) {
            this.top_W_SEGSQL = " ";
            this.top_W_FINSEG = " ";
        }
        if (this.isWorkingBreakOn_6_X02(firstLine, secondLine)) {
            this.w_SQLIND = " ";
            this.top_W_DB2 = " ";
        }
        if (this.isWorkingBreakOn_6_X02(firstLine, secondLine) && "7".equals(secondLine.get_SEC()) && " 01".equals(secondLine.lineContent.substring(36, 39)) && !"G-".equals(secondLine.lineContent.substring(47, 49))) {
            this.top_W_PACTABLE = " ";
        }
    }

    private void working5_F50R1(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName = "W-" + secondLine.get_FONCT() + "___" + this.w_E_OU_F;
        result.addAll(MIAinfo.CreateATag(tagName, this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void working5_F50SF(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("6".equals(secondLine.get_NUPAR()) && "EXEC SQL INCLUDE".equals(secondLine.getCOBOLcontent().substring(18, 34)) && "1".equals(this.top_W_ENDSQL)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_ENDSQL = "2";
            this.w_TRAITE = "1";
        }
        if ("5".equals(secondLine.get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(18, 32))) {
            String tagName;
            this.top_W_ENDSQL = "1";
            this.top_W_ORACLE = true;
            if ("1".equals(this.top_W_X_FFNN)) {
                this.top_W_X_FFNN = "2";
                result.add(MIAinfo.CLOSE_TAG);
                secondLine.tagName = tagName = "ENDSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.w_TRAITE = "1";
            }
            if (this.getNextWorkingLine() != null && "6".equals(this.getNextWorkingLine().get_NUPAR()) && "EXEC SQL INCLUDE".equals(this.getNextWorkingLine().getCOBOLcontent().substring(18, 34))) {
                secondLine.tagName = tagName = "ENDSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.top_W_ENDSQL = "1";
                this.w_TRAITE = "1";
            } else {
                secondLine.tagName = tagName = "ENDSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                result.add(MIAinfo.CLOSE_TAG);
                this.top_W_ENDSQL = "2";
                this.w_TRAITE = "1";
            }
        }
    }

    private void working5_F50SB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        if ("X".equals(secondLine.get_NUPAR()) && "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(18, 32)) && "USERID  ".equals(secondLine.getCOBOLcontent().substring(26, 34))) {
            this.top_W_BEGINS = "1";
            secondLine.tagName = tagName = "BEGINSQL";
            result.addAll(this.createATagFromMIAline(secondLine));
            this.top_W_ORACLE = true;
            this.w_TRAITE = "1";
        }
        if ("X".equals(secondLine.get_NUPAR()) && "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(18, 32)) && !"USERID  ".equals(secondLine.getCOBOLcontent().substring(26, 34))) {
            this.top_W_BEGINS = "2";
            secondLine.tagName = tagName = "BEGINSQL";
            result.addAll(this.createATagFromMIAline(secondLine));
            this.top_W_ORACLE = true;
            result.add(MIAinfo.CLOSE_TAG);
            this.w_TRAITE = "1";
        }
        if ("Z".equals(secondLine.get_NUPAR()) && "S-PASSWO".equals(secondLine.getCOBOLcontent().substring(26, 34)) && "1".equals(this.top_W_BEGINS)) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_TRAITE = "1";
        }
    }

    private boolean working5_F50OA(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine) && " ".equals(secondLine.get_X01()) && "Z".equals(secondLine.get_NUPAR()) && "A".equals(this.getNextWorkingLine().get_X01()) && ("Z".equals(this.getNextWorkingLine().get_NUPAR()) || "0".equals(this.getNextWorkingLine().get_NUPAR()))) {
            String tagName;
            this.w_SD_COSEG = secondLine.get_COFSF();
            secondLine.tagName = tagName = "X-" + this.w_SD_COSEG;
            this.top_W_SD = "1";
            result.addAll(this.createATagFromMIAline(secondLine));
            return true;
        }
        if ("1".equals(this.top_W_SD) && (this.getNextWorkingLine() == null || this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine()))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            return true;
        }
        if ("1".equals(this.top_W_SD)) {
            return false;
        }
        if ("AA0".equals(secondLine.get_X3A()) && "  ".equals(secondLine.get_COSFO()) && "XZ".contains(secondLine.get_NUPAR())) {
            if ("X".equals(secondLine.get_NUPAR()) && "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(17, 31)) && this.getNextWorkingLine() != null && "USERID  ".equals(this.getNextWorkingLine().getCOBOLcontent().subSequence(25, 33))) {
                this.top_W_BEGINS = "1";
                this.w_C_COSEG = "SQLB";
                secondLine.tagName = "BEGINSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.top_W_ORACLE = true;
                this.w_TRAITE = "1";
            }
            if ("X".equals(secondLine.get_NUPAR()) && "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(17, 31)) && (this.getNextWorkingLine() == null || this.getNextWorkingLine() != null && !"USERID  ".equals(this.getNextWorkingLine().getCOBOLcontent().subSequence(25, 33)))) {
                this.top_W_BEGINS = "2";
                secondLine.tagName = "BEGINSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                this.top_W_ORACLE = true;
                result.add(MIAinfo.CLOSE_TAG);
                this.w_TRAITE = "1";
            }
            if ("SQLB".equals(this.w_C_COSEG) && "S-PASSWO".equals(secondLine.getCOBOLcontent().subSequence(25, 33)) && "1".equals(this.top_W_BEGINS)) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                this.w_TRAITE = "1";
            }
            if ("1".equals(this.w_TRAITE)) {
                return true;
            }
        }
        if ("5".equals(secondLine.get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31)) || "6".equals(secondLine.get_NUPAR()) && "EXEC SQL INCLUDE".equals(secondLine.getCOBOLcontent().substring(17, 33))) {
            if ("5".equals(secondLine.get_NUPAR()) && this.getNextWorkingLine() != null && !"6".equals(this.getNextWorkingLine().get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31))) {
                secondLine.tagName = "ENDSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                result.add(MIAinfo.CLOSE_TAG);
                this.top_W_ENDSQL = "2";
                this.w_CSEG = "";
                this.w_TRAITE = "1";
                return true;
            }
            if ("56".indexOf(secondLine.get_NUPAR()) != -1 && !"*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14))) {
                if ("56".indexOf(secondLine.get_NUPAR()) != -1 && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31))) {
                    secondLine.tagName = "ENDSQL";
                    result.addAll(this.createATagFromMIAline(secondLine));
                    this.w_TRAITE = "1";
                    return true;
                }
                if ("6".equals(secondLine.get_NUPAR()) && "EXEC SQL INCLUDE".equals(secondLine.getCOBOLcontent().substring(17, 33))) {
                    result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                    result.add(MIAinfo.CLOSE_TAG);
                    this.top_W_ENDSQL = "2";
                    this.w_TRAITE = "1";
                    return true;
                }
            }
        }
        if (" 01".equals(secondLine.getCOBOLcontent().substring(6, 9)) && !"  ".equals(secondLine.get_COSFO()) && !"USERID".equals(secondLine.getCOBOLcontent().subSequence(25, 31)) && !"S-PASSWO".equals(secondLine.getCOBOLcontent().subSequence(25, 33)) && (!secondLine.get_COFSF().equals(this.w_P_COSEG) || "A00".equals(secondLine.get_X3()) && "Z".equals(secondLine.get_NUPAR()))) {
            this.w_C_COSEG = this.w_FIENR = secondLine.get_COFSF();
            if (this.top_W_DEBFI) {
                return false;
            }
            this.w_CSEG = secondLine.get_COFSF();
            this.w_C_COSEG = secondLine.get_COFSF();
            secondLine.tagName = "X-" + this.w_CSEG;
            result.addAll(this.createATagFromMIAline(secondLine));
            return true;
        }
        if (!"  ".equals(secondLine.get_COSFO()) && (!this.w_P_COSEG.equals(this.w_C_COSEG) || this.getNextWorkingLine() != null && this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine()) || this.getNextWorkingLine() != null && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31)))) {
            if (this.top_W_DEBFI && !"EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31))) {
                return false;
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            this.w_TRAITE = "1";
            return true;
        }
        return false;
    }

    private void working5_F50QA(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("AA0".equals(secondLine.get_X3()) && "XZ".contains(secondLine.get_NUPAR())) {
            if ("X".equals(secondLine.get_NUPAR()) && "EXEC SQL BEGIN".equals(secondLine.getCOBOLcontent().substring(17, 31))) {
                this.top_W_SEGSQL = "1";
                if ("USERID  ".equals(this.getNextLine().getCOBOLcontent().subSequence(25, 33))) {
                    String tagName2;
                    this.top_W_BEGINS = "1";
                    secondLine.tagName = tagName2 = "BEGINSQL";
                    result.addAll(this.createATagFromMIAline(secondLine));
                } else {
                    String tagName2;
                    this.top_W_BEGINS = "2";
                    secondLine.tagName = tagName2 = "BEGINSQL";
                    result.addAll(this.createATagFromMIAline(secondLine));
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
            if ("Z".equals(secondLine.get_NUPAR()) && "S-PASSWO".equals(secondLine.getCOBOLcontent().substring(25, 33)) && this.top_W_BEGINS == "1") {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (" 01".equals(secondLine.getCOBOLcontent().substring(6, 9)) && "9  ".equals(secondLine.get_X3()) && " ".equals(secondLine.get_NUPAR())) {
            String tagName;
            this.w_C_COSEG = this.w_FIENR = secondLine.lineContent.substring(56, 60);
            this.top_W_SEGSQL = "1";
            if (this.isWorkingBreakOn_5_X01(firstLine, secondLine)) {
                tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01() + this.w_E_OU_F;
                result.addAll(MIAinfo.CreateATag(tagName, this));
            }
            this.w_SQLIND = "1";
            secondLine.tagName = tagName = "V-" + secondLine.getCOBOLcontent().substring(26, 30) + "-SQL-INDICATORS";
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if ("5".equals(secondLine.get_NUPAR()) && this.getNextWorkingLine() != null && !"6".equals(this.getNextWorkingLine().get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31))) {
            String tagName;
            this.top_W_SEGSQL = "1";
            secondLine.tagName = tagName = "ENDSQL";
            result.addAll(this.createATagFromMIAline(secondLine));
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        if ("56".contains(secondLine.get_NUPAR()) && !"*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14))) {
            if ("5".equals(secondLine.get_NUPAR()) && this.getNextWorkingLine() != null && "6".equals(this.getNextWorkingLine().get_NUPAR()) && "EXEC SQL END  ".equals(secondLine.getCOBOLcontent().substring(17, 31))) {
                String tagName;
                this.top_W_SEGSQL = "1";
                secondLine.tagName = tagName = "ENDSQL";
                result.addAll(this.createATagFromMIAline(secondLine));
                return;
            }
            if ("6".equals(secondLine.get_NUPAR()) && "EXEC SQL INCLUDE".equals(secondLine.getCOBOLcontent().substring(17, 33))) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
        }
        if (secondLine.get_X3().charAt(0) == '9' && secondLine.get_X3().charAt(1) != ' ' && "1".equals(this.w_SQLIND) && (this.getNextWorkingLine() != null && this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine()) || this.getNextWorkingLine() != null && "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31))) && !"*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() != null && (this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) || "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31)))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.w_SQLIND = " ";
            return;
        }
        if (" 01".equals(secondLine.getCOBOLcontent().substring(6, 9)) && !"USERID".equals(secondLine.lineContent.substring(55, 61)) && !"S-PASSWO".equals(secondLine.lineContent.substring(55, 63)) && (!secondLine.lineContent.substring(56, 60).equals(this.w_P_COSEG) || "A00".equals(secondLine.get_X3()) && "Z".equals(secondLine.get_NUPAR()))) {
            String tagName;
            if (secondLine.isFromMacro()) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
                return;
            }
            this.w_C_COSEG = this.w_FIENR = secondLine.lineContent.substring(56, 60);
            if (this.isWorkingBreakOn_5_X01(firstLine, secondLine) || this.w_P_COSEG == "    " && !this.w_P_COSEG.equals(this.w_C_COSEG)) {
                tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01() + this.w_E_OU_F;
                result.addAll(MIAinfo.CreateATag(tagName, this));
            }
            secondLine.tagName = tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01() + "-" + this.w_FIENR;
            result.addAll(this.createATagFromMIAline(secondLine));
            return;
        }
        if (!"*END DB2".equals(secondLine.getCOBOLcontent().substring(6, 14)) && this.getNextWorkingLine() != null && ("9  ".equals(this.getNextWorkingLine().get_X3()) || this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine()) || "A00".equals(this.getNextWorkingLine().get_X3()) && " 01".equals(this.getNextWorkingLine().getCOBOLcontent().substring(6, 9)) && "Z".equals(this.getNextWorkingLine().get_NUPAR()) || "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31)))) {
            if (secondLine.isFromMacro()) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
                return;
            }
            this.top_W_FINSEG = "1";
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() != null && (this.isWorkingBreakOn_5_X01(secondLine, this.getNextWorkingLine()) || "EXEC SQL END  ".equals(this.getNextWorkingLine().getCOBOLcontent().substring(17, 31)))) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            this.w_TRAITE = "1";
            return;
        }
    }

    public List<MIAinfo> firstMIA1lineProcedure(MIA1lineWorking firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        this.commentFxx = null;
        this.commentFxxyy = null;
        this.firstLineSaved = "";
        result.addAll(this.closeTagsUntil(1));
        result.addAll(MIAinfo.CreateATag("PROCEDURE", this));
        if (!secondLine.lineContent.endsWith(this.getProgramID())) {
            if (secondLine.tagName != null) {
                result.addAll(MIAinfo.CreateATag("PROCEDURE-DIVISION", this));
                result.addAll(this.createOneTagFromMIAline(secondLine));
            }
        } else {
            secondLine.tagName = "PROCEDURE-DIVISION";
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
        return result;
    }

    protected void specialTreatmentForFNlines(MIALineProcedure currentLine, List<MIAinfo> result) {
        String firstToken = this.getFNLine(currentLine);
        if (firstToken != null && firstToken.equals(this.lastTagCreated().getTextOrTagName()) && this.lastTagCreated().getProperties().containsKey("msp")) {
            result.addAll(MIAinfo.InsertText(currentLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    public List<MIAinfo> compareMIA1linesProcedure(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        if (this.containsTag("PROCEDURE-DIVISION") && (firstLine.tagName == null || !firstLine.tagName.startsWith("W"))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if ("PROCEDURE DIV".equals(firstLine.getSortCriteria5())) {
            return null;
        }
        if ("COA".equals(firstLine.getCOA())) {
            this.currentNuligMC = "";
            this.procedure_F52FY(firstLine, secondLine, result);
            return result;
        }
        int s = result.size();
        this.specialTreatmentForFNlines(firstLine, result);
        if (result.size() > s) {
            return result;
        }
        if (!firstLine.isFromMacro()) {
            if ("*".equals(firstLine.get_Col_Value(36)) && "*.".equals(firstLine.getSortCriteria3()) && "F05.".equals(secondLine.getSortCriteria4())) {
                this.procedure_F52AV(firstLine, secondLine, result);
                this.commentF05 = true;
                return result;
            }
            if ("N05.".equals(firstLine.getSortCriteria4()) && "*.".equals(firstLine.getSortCriteria3())) {
                this.procedure_F52AX(firstLine, result);
                this.commentF05 = true;
                return result;
            }
            if (this.commentF05 && ("*.".equals(firstLine.getSortCriteria3()) || "* ".equals(firstLine.getSortCriteria3()))) {
                this.procedure_F52AY(firstLine, result);
                if ("*.".equals(firstLine.getSortCriteria3())) {
                    this.commentF05 = false;
                }
                return result;
            }
        }
        if ("*".equals(firstLine.get_Col_Value(36)) && ("*.".equals(firstLine.getSortCriteria3()) || "* ".equals(firstLine.getSortCriteria3()) && (this.commentFxx != null || this.commentFxxyy != null))) {
            this.commentF05 = false;
            if (!"N".equals(firstLine.get_Col_Value(37)) || this.commentFxx != null && this.commentFxx.equals(firstLine.get_FONCT()) || this.commentFxxyy != null && this.commentFxxyy.equals(firstLine.get_FONCT().concat(firstLine.get_COSFO()))) {
                this.procedure_F52BD(firstLine, secondLine, result);
                return result;
            }
            if ("N".equals(firstLine.get_Col_Value(37)) && ".".equals(firstLine.get_Col_Value(40)) && (this.commentFxx == null || this.commentFxx != null && !this.commentFxx.equals(firstLine.get_FONCT()))) {
                this.procedure_F52BF(firstLine, result);
                return result;
            }
            if ("N".equals(firstLine.get_Col_Value(37)) && ".".equals(firstLine.get_Col_Value(42)) && (this.commentFxxyy == null || this.commentFxxyy != null && !this.commentFxxyy.equals(firstLine.get_FONCT().concat(firstLine.get_COSFO())))) {
                if (firstLine.getSortCriteria8().equals("*N76-A") && this.fonct.equals("76")) {
                    result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                    return result;
                }
                this.procedure_F52BH(firstLine, result);
                return result;
            }
        }
        if (" DECLARATIVES.".equals(firstLine.getSortCriteria21())) {
            this.procedure_F52FP(firstLine, result);
            return result;
        }
        if (" SEC".equals(firstLine.getSortCriteria23()) && "SECTION.".equals(firstLine.getSortCriteria22()) && !"00".equals(firstLine.getSortCriteria7())) {
            this.procedure_F52FR(firstLine, result);
            this.dsect = "1";
            return result;
        }
        if ("1".equals(this.dsect)) {
            this.procedure_F52FS(firstLine, secondLine, result);
            return result;
        }
        if ("END DECLARATIVES.".equals(firstLine.getSortCriteria24())) {
            this.procedure_F52FU(firstLine, result);
            return result;
        }
        if (" SEC00 SECTION".equals(firstLine.getSortCriteria21())) {
            this.procedure_F52FV(firstLine, result);
            return result;
        }
        if (firstLine.isFromMacro()) {
            this.procedure_F52FY(firstLine, secondLine, result);
            return result;
        }
        if (!firstLine.isFromMacro() && firstLine.lineContent.length() > 103 && (!" F".equals(firstLine.getSortCriteria2()) || " F".equals(firstLine.getSortCriteria2()) && "-".equals(firstLine.get_Col_Value(42)) && (!"FN".equals(firstLine.getSortCriteria9()) || !".".equals(firstLine.get_Col_Value(45))) && !"ITER".equals(firstLine.getSortCriteria10()) && !"10".equals(firstLine.getSortCriteria9()) || " F".equals(firstLine.getSortCriteria2()) && "-".equals(firstLine.get_Col_Value(40)) && (".".equals(firstLine.get_Col_Value(42)) || ".".equals(firstLine.get_Col_Value(43)) && !"FN".equals(firstLine.getSortCriteria11())) || "-10".equals(firstLine.getSortCriteria12()) && this.etiq.equals(firstLine.getSortCriteria13()))) {
            if (firstLine.getSortCriteria13().equals("F76-A") && firstLine.get_FONCT().equals("76")) {
                result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                return result;
            }
            if (this.etiq.equals("F05") && secondLine != null && "F05".equals(secondLine.getSortCriteria14()) && "-FN.".equals(secondLine.getSortCriteria15())) {
                this.procedure_F52FX(firstLine, result);
                return result;
            }
            this.procedure_F52FY(firstLine, secondLine, result);
            return result;
        }
        if (".".equals(firstLine.get_Col_Value(40)) || firstLine.getSortCriteria13().equals("F76-A") && firstLine.get_FONCT().equals("76")) {
            this.commentFxx = null;
            this.commentF05 = false;
            this.firstLineSaved = "";
            String etiquFct = "F" + firstLine.get_FONCT();
            if (this.needToWriteEtiqu(etiquFct)) {
                this.procedure_F52GE(firstLine, secondLine, result);
            }
            return result;
        }
        if (".".equals(firstLine.get_Col_Value(42)) || "-10".equals(firstLine.getSortCriteria12()) && !firstLine.getSortCriteria13().equals(this.etiq)) {
            if (this.firstLineSaved.trim().length() > 0) {
                this.firstLineSaved = "";
                this.commentFxxyy = null;
                this.procedure_F52GH(firstLine, secondLine, result);
                return result;
            }
            this.firstLineSaved = "";
            this.procedure_F52GI(firstLine, secondLine, result);
            return result;
        }
        if ("-FN".equals(firstLine.getSortCriteria19())) {
            this.procedure_F52GN(firstLine, result);
            return result;
        }
        if ("-FN".equals(firstLine.getSortCriteria12())) {
            if (this.etiq.equals(firstLine.getSortCriteria13())) {
                this.procedure_F52GT(firstLine, result);
                return result;
            }
            this.procedure_F52GV(firstLine, result);
            return result;
        }
        if ("F9099-ITER-FN".equals(firstLine.getSortCriteria5())) {
            this.procedure_F52HB(firstLine, result);
            return result;
        }
        return result;
    }

    private boolean needToWriteEtiqu(String etiquFct) {
        if (this.fctAndLevels.containsKey(etiquFct.substring(1))) {
            return true;
        }
        return this.tagToCreate.contains(etiquFct);
    }

    private void workingI_F50HE(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        int num;
        if ("40".equals(secondLine.get_COSFO()) && !secondLine.isFromMacro()) {
            result.addAll(this.closeTagsUntil(1));
            result.addAll(MIAinfo.CreateATag("ENVIRONMENT", this));
        }
        if ((num = MIA1file.TransformStringToInt(secondLine.get_COSFO())) == 1 || num == 5 || num == 10 || num == 20 || num == 30 || !this.forMigration && num == 40 || secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if ("30".equals(secondLine.get_COSFO())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working1_F50HS(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            result.addAll(this.createATagFromMIAline(secondLine));
        }
    }

    private void working1_F50HV(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.createOneTagFromMIAline(secondLine));
        this.closeTagsIfNeeded(firstLine, secondLine, result);
    }

    private void closeTagsIfNeeded(MIALineImpl firstLine, MIALineImpl secondLine, List<MIAinfo> result) {
        if (this.getNextWorkingLine() == null || "01".compareTo(this.getNextWorkingLine().get_FONCT()) <= 0 && this.containsTag("CONFIGURATION")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (this.getNextWorkingLine() == null || "60".compareTo(this.getNextWorkingLine().get_FONCT()) <= 0 && this.containsTag("ENVIRONMENT")) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void closePriorTagIfNeeded(String currentEtiq, List<MIAinfo> result) {
        if (this.fctAndLevels.containsKey(currentEtiq)) {
            Stack<MIAinfo> mis = this.getTagsStack();
            if (mis.isEmpty()) {
                Util.rethrow((Throwable)new Exception("Tagging problem : " + currentEtiq));
            }
            MIAinfo mi = (MIAinfo)mis.lastElement();
            if (this.lastTagCreated().getTextOrTagName().equals("F" + currentEtiq)) {
                return;
            }
            int index = mis.indexOf(mi) - 1;
            if (!mi.getTextOrTagName().subSequence(1, 3).equals(currentEtiq.substring(0, 2))) {
                while (index >= 0 && !mi.getTextOrTagName().startsWith("PROCEDURE")) {
                    mi = (MIAinfo)mis.elementAt(index--);
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else if (mi == this.lastTagFromCOA && mi.getTextOrTagName().length() > 3) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void closeTagsFromOtherFunctions(String functionCode, List<MIAinfo> result) {
        Stack<MIAinfo> mis = this.getTagsStack();
        if (mis.isEmpty()) {
            Util.rethrow((Throwable)new Exception("Tagging problem : " + functionCode));
        }
        MIAinfo mi = (MIAinfo)mis.lastElement();
        int index = mis.indexOf(mi) - 1;
        if (!mi.getTextOrTagName().subSequence(1, 3).equals(functionCode)) {
            while (index >= 0 && !mi.getTextOrTagName().startsWith("PROCEDURE")) {
                mi = (MIAinfo)mis.elementAt(index--);
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void working1_F50IB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.createOneTagFromMIAline(secondLine));
        this.closeTagsIfNeeded(firstLine, secondLine, result);
    }

    private void working1_F50IC(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String specialTagName = null;
        if (secondLine.isFromMacro()) {
            specialTagName = "SPECIAL-NAMES" + secondLine.get_X02() + secondLine.get_NUPAR();
        }
        if (!this.containsTag("SPECIAL-NAMES") && !this.containsTag(specialTagName)) {
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.getNextWorkingLine() == null || !"1".equals(this.getNextWorkingLine().get_SEC()) || !"00".equals(this.getNextWorkingLine().get_FONCT()) || !"20".equals(this.getNextWorkingLine().get_COSFO()) || secondLine.isFromMacro()) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        this.closeTagsIfNeeded(firstLine, secondLine, result);
    }

    private void working1_F50ID(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
    }

    private void working1_F50IH(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine)) {
            if (!secondLine.isFromMacro()) {
                result.addAll(MIAinfo.CreateATag("IOSEC-FILECTRL", this));
            } else {
                result.addAll(this.createOneTagFromMIAline(secondLine));
                return;
            }
        }
        if (secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
            return;
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
    }

    private void working1_F50IJ(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_4_COSFO(firstLine, secondLine)) {
            if (secondLine.isFromMacro()) {
                result.addAll(this.createOneTagFromMIAline(secondLine));
                return;
            }
            result.addAll(MIAinfo.CreateATag(secondLine.getTagName(), this));
        }
        if (secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
            return;
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        if (this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
            if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (this.getTagsStack().peek().getTextOrTagName().equals("ENVIRONMENT")) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        }
    }

    private void working1_F50IO(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.closeTagsUntil(1));
        result.addAll(MIAinfo.CreateATag("DATA", this));
        if (this.forMigration && !secondLine.isFromMacro()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        } else {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
    }

    private void working1_F50IP(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (!this.containsTag("FILE")) {
            result.addAll(MIAinfo.CreateATag("FILE", this));
        }
        if (this.forMigration && !secondLine.isFromMacro()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        } else {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
    }

    private void working2_F50IQ(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        this.top_W_DEBFI = false;
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine)) {
            String fd = "FD-" + secondLine.get_FONCT();
            result.addAll(MIAinfo.CreateATag(fd, this));
            if (!secondLine.isFromMacro()) {
                result.addAll(this.createATagFromMIAline(secondLine));
            } else {
                fd = "FDCLAUSE-" + secondLine.get_FONCT();
                result.addAll(MIAinfo.CreateATag(fd, this));
                result.addAll(this.createOneTagFromMIAline(secondLine));
            }
            if (this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.isWorkingBreakOn_2_SEC(secondLine, this.getNextWorkingLine())) {
                int nbClose = Collections.frequency(result, MIAinfo.CLOSE_TAG);
                int nbTags = this.getTagsStack().size();
                for (MIAinfo mi : result) {
                    if (mi.getType() != MIAinfoType.CREATE_TAG) continue;
                    ++nbTags;
                }
                while (nbTags - nbClose++ > 2) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            }
        } else {
            if (!secondLine.isFromMacro()) {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            } else {
                result.addAll(this.createOneTagFromMIAline(secondLine));
            }
            if (this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
                if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                    if (this.isWorkingBreakOn_2_SEC(secondLine, this.getNextWorkingLine())) {
                        result.add(MIAinfo.CLOSE_TAG);
                    }
                }
            }
        }
    }

    private void working2_F50IT(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_4_COSFO(firstLine, secondLine) && !this.top_W_DEBFI) {
            this.top_W_DEBFI = true;
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
        if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            MIAinfo mi;
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_DEBFI = false;
            if (this.isWorkingBreakOn_2_SEC(secondLine, this.getNextWorkingLine()) && (mi = this.lastTagCreated()) != null && mi.getTextOrTagName().equals("FILE")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private void working3_F50JB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(this.closeTagsUntil(2));
        result.addAll(MIAinfo.CreateATag("WORKING", this));
        if (this.forMigration) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        } else {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        }
    }

    private void working3_F50JC(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_3_FONCT(firstLine, secondLine)) {
            result.addAll(this.closeTagsUntil(3));
            result.addAll(MIAinfo.CreateATag("GENERATED-WORKING", this));
            result.addAll(this.createATagFromMIAline(secondLine));
        } else if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void working3_F50JD(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("0".equals(secondLine.get_NUPAR())) {
            result.addAll(this.createATagFromMIAline(secondLine));
        } else if ("7".equals(secondLine.get_NUPAR())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
        } else if ("9".equals(secondLine.get_NUPAR())) {
            result.addAll(this.createATagFromMIAline(secondLine));
        } else {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        }
    }

    private void working_F50JH(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        this.top_W_DEBFI = true;
        this.top_W_TAGSE = false;
        this.w_FIENR = secondLine.lineContent.substring(56, 60);
        if ("3_7".indexOf(secondLine.get_SEC()) != -1 && (("Z".equals(secondLine.get_NUPAR()) || "0".equals(secondLine.get_NUPAR())) && !"   ".equals(secondLine.get_X3()) || "*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46)))) {
            this.top_W_TAGSE = true;
        }
    }

    private void working_F50JI(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        if ("1".equals(this.top_W_SEGSQL)) {
            return;
        }
        if (this.top_W_TAGSE) {
            if (!this.isInBuffer() && (this.isWorkingBreakOn_5_X01(firstLine, secondLine) || this.isMPAtTheSamePlaceAsCDline(firstLine, secondLine))) {
                tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01();
                result.addAll(MIAinfo.CreateATag(String.valueOf(tagName) + this.w_E_OU_F, this));
                secondLine.tagName = tagName = String.valueOf(tagName) + "-" + secondLine.getCOBOLcontent().substring(26, 30);
                result.addAll(this.createATagFromMIAline(secondLine));
                if (this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
            } else {
                result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            }
        }
        if (!this.top_W_TAGSE && "3_7".indexOf(secondLine.get_SEC()) != -1) {
            secondLine.tagName = tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01();
            result.addAll(this.createATagFromMIAline(secondLine));
        }
        if ("8".equals(secondLine.get_SEC())) {
            this.top_W_X_FFNN = "1";
            secondLine.tagName = tagName = "X-" + secondLine.get_COFSF();
            result.addAll(this.createATagFromMIAline(secondLine));
        }
    }

    private void working_F50JK(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return;
        }
        this.w_FIENR = secondLine.lineContent.substring(56, 60);
        if ("1".equals(this.top_W_SEGSQL)) {
            return;
        }
        if ("*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46))) {
            this.top_W_DB2 = "1";
        }
        if ("3_7".indexOf(secondLine.get_SEC()) != -1) {
            secondLine.tagName = tagName = "W-" + secondLine.get_COFSF() + secondLine.get_X01() + "-" + secondLine.getCOBOLcontent().substring(26, 30);
            result.addAll(this.createATagFromMIAline(secondLine));
        }
        if ("3_7".indexOf(secondLine.get_SEC()) != -1 && this.isWorkingBreakOn_6_X02(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_TAGSE = false;
        }
        if ("3_7".indexOf(secondLine.get_SEC()) != -1 && (this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine()) || "M".equals(secondLine.get_NUPAR()))) {
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_DEBFI = false;
        }
        if ("8".equals(secondLine.get_SEC())) {
            secondLine.tagName = tagName = "X-" + secondLine.get_COFSF();
            result.addAll(this.createATagFromMIAline(secondLine));
        }
    }

    private void working6_F50KB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName = null;
        if ("E".equals(secondLine.get_NUETAX()) || " ".equals(secondLine.get_NUETAX())) {
            tagName = "W-1";
        }
        if ("M".equals(secondLine.get_NUETAX()) || "*BEGIN DB2".equals(secondLine.lineContent.substring(36, 46)) && this.getNextWorkingLine() != null && "M".equals(this.getNextWorkingLine().get_NUETAX())) {
            tagName = "W-2";
        }
        secondLine.tagName = tagName = String.valueOf(tagName) + secondLine.lineContent.substring(56, 58);
        result.addAll(this.createATagFromMIAline(secondLine));
        this.top_W_SEC = secondLine.get_SEC();
        this.top_W_FONCT = secondLine.get_FONCT();
        if (this.getNextWorkingLine() == null || this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
            this.top_W_FSEC6 = false;
            this.top_W_SEC = "";
            this.top_W_FONCT = "";
        }
    }

    private void working6_F50KF(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        this.top_W_FSEC6 = false;
        this.top_W_SEC = "";
        this.top_W_FONCT = "";
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void working6_F50KJ(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = "COE-" + secondLine.get_FONCT();
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working6_F50KL(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void working5_F50KO(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = "CAT-TAB";
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working5_F50KQ(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void working5_F50KT(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = "CAT";
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working5_F50KW(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = "CAT" + secondLine.get_X01();
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working5_F50LB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
        if (this.getNextWorkingLine() == null || "ZZ".equals(this.getNextWorkingLine().get_COSFO())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working5_F50LP(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        secondLine.tagName = "LABEL";
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working5_F50LT(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = "LAB" + secondLine.get_X01();
        result.addAll(this.createATagFromMIAline(secondLine));
    }

    private void working5_F50LW(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
        if (this.isWorkingBreakOn_3_FONCT(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void working5_F50LY(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        secondLine.tagName = tagName = secondLine.lineContent.substring(48, 59);
        result.addAll(this.createOneTagFromMIAline(secondLine));
    }

    private void working7_F50LZ(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        String tagName;
        result.addAll(this.closeTagsUntil(5));
        secondLine.tagName = tagName = "USERS-AREAS";
        result.addAll(this.createOneTagFromMIAline(secondLine));
    }

    private void working_F50MB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (!"  ".equals(this.top_W_TYP01)) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if ("V".equals(secondLine.get_NUETAX()) && "3".equals(secondLine.get_SEC()) && "05  ".equals(secondLine.get_COFSF())) {
            this.top_W_TYP01 = "01";
            secondLine.tagName = "CONDITIONAL-VARIABLES";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if (" ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "    ".equals(secondLine.get_COFSF())) {
            this.top_W_TYP01 = "03";
            secondLine.tagName = "CONF-CALCULATION-AREA";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if (" ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "CE  ".equals(secondLine.get_COFSF())) {
            this.top_W_TYP01 = "04";
            secondLine.tagName = "FILE-COUNTERS";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if (" ".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "CF  ".equals(secondLine.get_COFSF())) {
            this.top_W_TYP01 = "05";
            secondLine.tagName = "STATUS-AREA";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if ("Q".equals(secondLine.get_NUETAX()) && "5".equals(secondLine.get_SEC()) && "EN  ".equals(secondLine.get_COFSF())) {
            this.top_W_TYP01 = "06";
            secondLine.tagName = "VALIDATION-VARIABLES";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if (" ".equals(secondLine.get_NUETAX()) && "6".equals(secondLine.get_SEC()) && !"    ".equals(secondLine.get_COFSF()) && "   ".equals(secondLine.get_X3A()) && ("2".equals(secondLine.get_NUPAR()) || "0".equals(secondLine.get_NUPAR())) || " ".equals(secondLine.get_NUETAX()) && "7".equals(secondLine.get_SEC()) && !"    ".equals(secondLine.get_COFSF()) && " ".equals(secondLine.get_NUPAR())) {
            if ("6".equals(secondLine.get_SEC())) {
                this.top_W_TYP01 = "07";
                MIA1lineWorking line = secondLine;
                if ("0".equals(secondLine.get_NUPAR())) {
                    line = this.getNextWorkingLine();
                    this.top_W_TYP01 = "  ";
                }
                secondLine.tagName = String.valueOf(line.lineContent.substring(54, 60)) + "-SQL-INDICATORS";
                if (!this.containsTag(secondLine.tagName)) {
                    result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
                }
            } else {
                String tmpTag = secondLine.lineContent.substring(58, 60).trim();
                if (secondLine.get_X02().equals(tmpTag)) {
                    tmpTag = secondLine.lineContent.substring(54, 56);
                    if (tmpTag.trim().length() == 0) {
                        return;
                    }
                    this.top_W_TYP01 = "07";
                    if (" V".equals(tmpTag)) {
                        tmpTag = "V-";
                    }
                    secondLine.tagName = String.valueOf(tmpTag) + secondLine.lineContent.substring(56, 60) + "-SQL-INDICATORS";
                    result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
                }
            }
        }
        if (" ".equals(secondLine.get_NUETAX()) && !"    ".equals(secondLine.get_COFSF()) && "G-".equals(secondLine.lineContent.substring(47, 49)) && ("3".equals(secondLine.get_SEC()) || "8".equals(secondLine.get_SEC()) && this.isWorkingBreakOn_5_X01(firstLine, secondLine))) {
            this.top_W_TYP01 = "08";
            this.top_W_PACTABLE = "1";
            String newTagName = secondLine.get_COFSF();
            if ("3".equals(secondLine.get_SEC())) {
                newTagName = String.valueOf(newTagName) + secondLine.get_X01();
                newTagName = String.valueOf(newTagName) + "-PACTABLE-COM-";
                int indexOfDot = secondLine.lineContent.indexOf(".", 49);
                String tmpS = secondLine.lineContent.substring(49, indexOfDot);
                secondLine.tagName = String.valueOf(newTagName) + tmpS;
            } else if ("8".equals(secondLine.get_SEC())) {
                secondLine.tagName = newTagName = String.valueOf(newTagName) + "-PACTABLE-COM-AREA";
            }
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        if (" ".equals(secondLine.get_NUETAX()) && "6".equals(secondLine.get_SEC()) && !"    ".equals(secondLine.get_COFSF()) && "  ".equals(secondLine.get_X02()) && "A".equals(secondLine.get_NUPAR())) {
            this.top_W_TYP01 = "09";
            secondLine.tagName = secondLine.get_X01().trim().length() == 0 ? String.valueOf(secondLine.get_COFSF()) + "-SSA" : String.valueOf(secondLine.get_FONCT()) + secondLine.get_X01() + secondLine.get_COSFO() + "-SSA";
            result.addAll(MIAinfo.CreateATag(secondLine.tagName, this));
        }
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        if ("07".equals(this.top_W_TYP01) && this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine())) {
            result.add(MIAinfo.CLOSE_TAG);
            if (this.getNextWorkingLine() == null || "9".equals(this.getNextWorkingLine().get_SEC())) {
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                result.add(MIAinfo.CLOSE_TAG);
                this.top_W_TYP01 = "  ";
            }
        }
    }

    private void working_F50MD(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        if ("01_03_04_05_06_07_08_09".contains(this.top_W_TYP01)) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        this.top_W_TYP01 = "  ";
    }

    private void working4_F50MF(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if (this.isWorkingBreakOn_2_SEC(firstLine, secondLine)) {
            result.addAll(MIAinfo.CreateATag("INDEXES", this));
            result.addAll(this.createATagFromMIAline(secondLine));
            if (this.isWorkingBreakOn_4_COSFO(secondLine, this.getNextWorkingLine()) && "    ".equals(secondLine.get_COFSF())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (secondLine.get_FONCT().startsWith(" ") && this.getNextWorkingLine() != null && this.getNextWorkingLine().get_FONCT().startsWith(" ") && "4".equals(this.getNextWorkingLine().get_SEC())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            return;
        }
        if (!(!secondLine.get_FONCT().startsWith(" ") || this.getNextWorkingLine() == null || this.getNextWorkingLine().get_FONCT().startsWith(" ") && "4".equals(this.getNextWorkingLine().get_SEC()))) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            if (this.isWorkingBreakOn_2_SEC(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (!"    ".equals(secondLine.get_COFSF()) && !secondLine.get_FONCT().startsWith(" ")) {
            String tagName;
            secondLine.tagName = tagName = secondLine.lineContent.substring(55, 61);
            result.addAll(this.createOneTagFromMIAline(secondLine));
            if (this.isWorkingBreakOn_2_SEC(secondLine, this.getNextWorkingLine())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
    }

    private void working_F50TB(MIA1lineWorking firstLine, MIA1lineWorking secondLine, List<MIAinfo> result) {
        if ("3".equals(secondLine.get_SEC()) && "00".equals(secondLine.get_FONCT()) && "  ".equals(secondLine.get_COSFO()) && " ".equals(secondLine.get_X01())) {
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
        } else if (!this.isInBuffer() && secondLine.isFromMacro()) {
            result.addAll(this.createOneTagFromMIAline(secondLine));
        } else {
            boolean closeEndSqlTag = false;
            if ("3_7_8".indexOf(secondLine.get_SEC()) != -1 && (secondLine.getCOBOLcontent().contains("EXEC SQL END   DECLARE SECTION END-EXEC.") || secondLine.getCOBOLcontent().contains("EXEC SQL BEGIN DECLARE SECTION END-EXEC."))) {
                if ("8".equals(secondLine.get_SEC())) {
                    if (this.containsTag("LINKAGE")) {
                        result.addAll(this.closeTagsUntil(3));
                    } else {
                        result.addAll(this.closeTagsUntil(5));
                    }
                }
                if (secondLine.getCOBOLcontent().contains("EXEC SQL END   DECLARE SECTION END-EXEC.")) {
                    Properties p = new Properties();
                    p.put("mp", "ENDSQL");
                    result.addAll(MIAinfo.CreateATag("ENDSQL", p, this));
                    MIA1lineWorking nextLine = this.getNextWorkingLine();
                    if (nextLine != null && !nextLine.getCOBOLcontent().contains("EXEC SQL INCLUDE SQLCA         END-EXEC.")) {
                        closeEndSqlTag = true;
                    }
                } else if (secondLine.getCOBOLcontent().contains("EXEC SQL BEGIN DECLARE SECTION END-EXEC.")) {
                    Properties p = new Properties();
                    p.put("mp", "BEGINSQL");
                    result.addAll(MIAinfo.CreateATag("BEGINSQL", p, this));
                }
            }
            result.addAll(MIAinfo.InsertText(secondLine.getCOBOLcontent(), this));
            if (closeEndSqlTag) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (this.containsTag("BEGINSQL") && secondLine.getCOBOLcontent().contains("01                S-PASSWO      PICTURE X(20).") || this.containsTag("ENDSQL") && secondLine.getCOBOLcontent().contains("EXEC SQL INCLUDE SQLCA         END-EXEC.")) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
    }

    private boolean isWorkingBreakOn_2_SEC(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return secondLine == null || !firstLine.get_SEC().equals(secondLine.get_SEC());
    }

    private boolean isWorkingBreakOn_3_FONCT(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return this.isWorkingBreakOn_2_SEC(firstLine, secondLine) || !firstLine.get_FONCT().equals(secondLine.get_FONCT());
    }

    private boolean isWorkingBreakOn_4_COSFO(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return this.isWorkingBreakOn_3_FONCT(firstLine, secondLine) || !firstLine.get_COSFO().equals(secondLine.get_COSFO());
    }

    private boolean isWorkingBreakOn_5_X01(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return this.isWorkingBreakOn_4_COSFO(firstLine, secondLine) || !firstLine.get_X01().equals(secondLine.get_X01());
    }

    private boolean isWorkingBreakOn_6_X02(MIA1lineWorking firstLine, MIA1lineWorking secondLine) {
        return this.isWorkingBreakOn_5_X01(firstLine, secondLine) || !firstLine.get_X02().equals(secondLine.get_X02());
    }

    private void closeTagsIfNeeded(String functionCode, List<MIAinfo> result) {
        Stack<MIAinfo> mis = this.getTagsStack();
        Iterator it = mis.iterator();
        boolean findFct = false;
        while (it.hasNext()) {
            if (!((MIAinfo)it.next()).getTextOrTagName().equals(functionCode)) continue;
            findFct = true;
        }
        if (!findFct) {
            return;
        }
        MIAinfo mi = (MIAinfo)mis.lastElement();
        int index = mis.indexOf(mi) - 1;
        while (index >= 0 && !mi.getTextOrTagName().equals(functionCode)) {
            mi = (MIAinfo)mis.elementAt(index--);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private String getLineNumber(MIA1lineProcedure line) {
        if (line.getConditionOrTreatment() != ' ' || "COA".equals(line.getCOA())) {
            if (line.getConditionOrTreatment() == 'C') {
                return line.get_MCNUMLG();
            }
            return String.valueOf(this.currentNuligMC.trim().length() == 0 ? line.get_MCNUMLG() : this.currentNuligMC) + line.get_MCNUMLG();
        }
        return line.get_MCNUMLG();
    }

    private void procedure_F52AV(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        String etiqu = secondLine.get_FONCT();
        Properties p = MIAinfo.DuplicateProperties(secondLine.getProperties());
        if (this.fctAndLevels.containsKey(etiqu)) {
            p.put("level", this.fctAndLevels.get(etiqu));
        }
        result.addAll(MIAinfo.CreateATag("F05", p, this));
        firstLine.tagName = "N05";
        result.addAll(this.createOneTagFromMIAline(firstLine));
        this.firstLineSaved = firstLine.getCOBOLcontent();
    }

    private void procedure_F52HB(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        if (this.f9099_SUP_in_specific != null) {
            if (!this.containsTag("F9099")) {
                result.addAll(MIAinfo.CreateATag("F9099", this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
            return;
        }
        int nbTagToKeep = 2;
        Iterator itTag = this.getTagsStack().iterator();
        if (itTag.hasNext()) {
            itTag.next();
        }
        if (itTag.hasNext()) {
            itTag.next();
        }
        while (itTag.hasNext()) {
            String lev;
            MIAinfo mi = (MIAinfo)itTag.next();
            boolean lev10 = false;
            if (mi.getProperties() != null && (lev = mi.getProperties().getProperty("level")) != null) {
                boolean bl = lev10 = Integer.parseInt(lev) < 10;
            }
            if (!mi.getTextOrTagName().equals("F90") && !mi.getTextOrTagName().equals("F9099") && !lev10) continue;
            ++nbTagToKeep;
        }
        result.addAll(this.closeTagsUntil(nbTagToKeep));
        if (!this.containsTag("F9099")) {
            result.addAll(MIAinfo.CreateATag("F9099", this));
        }
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void procedure_F52AX(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        if (!this.forMigration) {
            result.addAll(MIAinfo.CreateATag("N05-BODY", this));
        }
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
    }

    private void procedure_F52AY(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        if ("*.".equals(firstLine.getSortCriteria3()) && !this.forMigration) {
            result.add(MIAinfo.CLOSE_TAG);
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52BD(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        if (!"*".equals(secondLine.get_Col_Value(36)) || "*N".equals(secondLine.getSortCriteria2()) && !secondLine.get_FONCT().equals(this.commentFxx) && !".".equals(secondLine.get_Col_Value(42)) && this.commentFxx != null && this.commentFxx.trim().length() > 0) {
            result.add(MIAinfo.CLOSE_TAG);
            this.commentFxx = null;
            this.firstLineSaved = "";
        }
        if ((!"*".equals(secondLine.get_Col_Value(36)) || "*N".equals(secondLine.getSortCriteria2()) && !secondLine.get_FONCT().concat(secondLine.get_COSFO()).equals(this.commentFxxyy) && !".".equals(secondLine.get_Col_Value(42))) && this.commentFxxyy != null && this.commentFxxyy.trim().length() > 0) {
            result.add(MIAinfo.CLOSE_TAG);
            this.commentFxxyy = null;
            this.firstLineSaved = "";
        }
    }

    private void procedure_F52BF(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        this.currentNuligMC = "";
        String tn = null;
        String etiqu = firstLine.get_FONCT();
        Properties p = MIAinfo.DuplicateProperties(firstLine.getProperties());
        if (this.fctAndLevels.containsKey(etiqu)) {
            p.put("level", this.fctAndLevels.get(etiqu));
        }
        this.closePriorTagIfNeeded(etiqu, result);
        if (firstLine.isFromMacro()) {
            result.addAll(MIAinfo.CreateATag("F".concat(firstLine.get_FONCT()), p, this));
            tn = "N" + firstLine.get_MCFONCT() + firstLine.get_MCNUMLG();
        } else {
            result.addAll(MIAinfo.CreateATag("F".concat(firstLine.get_FONCT()), p, this));
            tn = "N" + firstLine.get_FONCT();
        }
        firstLine.tagName = tn;
        result.addAll(this.createATagFromMIAline(firstLine));
        this.firstLineSaved = firstLine.getCOBOLcontent();
        this.commentFxx = firstLine.get_FONCT();
        this.commentFxxyy = null;
    }

    private void procedure_F52BH(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        this.currentNuligMC = "";
        String tn = null;
        String etiqu = firstLine.get_FONCT().concat(firstLine.get_COSFO());
        Properties p = MIAinfo.DuplicateProperties(firstLine.getProperties());
        if (this.fctAndLevels.containsKey(etiqu)) {
            p.put("level", this.fctAndLevels.get(etiqu));
        } else {
            p.put("level", "10");
        }
        this.closePriorTagIfNeeded(etiqu, result);
        if (firstLine.isFromMacro()) {
            String tagname = "F".concat(firstLine.get_MCFONCT().concat(firstLine.get_MCCOSFO()));
            if (!this.containsTag(tagname)) {
                result.addAll(MIAinfo.CreateATag(tagname, p, this));
            }
            tn = "N" + firstLine.get_MCFONCT() + firstLine.get_MCCOSFO() + firstLine.get_MCNUMLG();
        } else {
            String tagname = "F".concat(firstLine.get_FONCT()).concat(firstLine.get_COSFO());
            if (!this.containsTag(tagname)) {
                result.addAll(MIAinfo.CreateATag(tagname, p, this));
            }
            tn = "N" + firstLine.get_FONCT() + firstLine.get_COSFO();
        }
        firstLine.tagName = tn;
        result.addAll(this.createATagFromMIAline(firstLine));
        result.add(MIAinfo.CLOSE_TAG);
        this.commentFxxyy = firstLine.get_FONCT().concat(firstLine.get_COSFO());
        this.firstLineSaved = firstLine.getCOBOLcontent();
    }

    private void procedure_F52FP(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        this.fonct = firstLine.get_FONCT();
        Properties p = MIAinfo.DuplicateProperties(firstLine.getProperties());
        p.put("level", "05");
        result.addAll(MIAinfo.CreateATag("F0A", p, this));
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
    }

    private void procedure_F52FR(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        String etiqu = "0A".concat(firstLine.get_COSFO());
        Properties p = MIAinfo.DuplicateProperties(firstLine.getProperties());
        if (this.fctAndLevels.containsKey(etiqu)) {
            p.put("level", this.fctAndLevels.get(etiqu));
        }
        result.addAll(MIAinfo.CreateATag("F0A".concat(firstLine.get_COSFO()), p, this));
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        this.etiq = "F0A".concat(firstLine.get_COSFO());
    }

    private void procedure_F52FS(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        if (" F0A".equals(secondLine.getSortCriteria23()) && "-FN.".equals(secondLine.getSortCriteria15())) {
            this.dsect = "";
        }
    }

    private void procedure_F52FU(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
    }

    private void procedure_F52FV(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        result.add(MIAinfo.CLOSE_TAG);
    }

    private void procedure_F52FX(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        if (!this.forMigration) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52FY(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        this.firstLineSaved = "";
        String tn = null;
        if (this.isBufferBeginning(firstLine.getCOBOLcontent()) && !firstLine.isFromMacro()) {
            this.closeTagsFromOtherFunctions(firstLine.get_MCFONCT(), result);
            String etiqu = String.valueOf(firstLine.get_MCFONCT()) + firstLine.get_MCCOSFO();
            Properties p = MIAinfo.DuplicateProperties(firstLine.getProperties());
            if (this.fctAndLevels.containsKey(etiqu)) {
                p.put("level", this.fctAndLevels.get(etiqu));
            }
            if ("F9099".equals(tn = "F" + firstLine.get_MCFONCT() + firstLine.get_MCCOSFO())) {
                if (!this.containsTag(tn) && this.f9099_iter_fn_present) {
                    result.addAll(MIAinfo.CreateATag(tn, this));
                }
            } else if (!this.containsTag(tn) && this.tagToCreate.contains(tn)) {
                this.COAFunctions.add(tn);
                result.addAll(MIAinfo.CreateATag(tn, this));
            } else {
                result.addAll(MIAinfo.CreateAShadowTag(tn, this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            return;
        }
        if (this.isBufferEnding(firstLine.getCOBOLcontent())) {
            if (secondLine == null || secondLine.get_MCNUMLG().trim().length() == 0 || Ebcdic.stringCompare((String)this.currentNuligMC, (String)secondLine.get_MCNUMLG()) <= 0) {
                this.currentNuligMC = "";
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            return;
        }
        if (this.isInBuffer()) {
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            return;
        }
        String etiqu = null;
        String level = "10";
        if (firstLine.get_MCCOSFO().trim().length() > 0) {
            etiqu = String.valueOf(firstLine.get_MCFONCT()) + firstLine.get_MCCOSFO();
        } else {
            etiqu = firstLine.get_MCFONCT();
            level = "05";
        }
        int size = result.size();
        this.closePriorTagIfNeeded(etiqu, result);
        etiqu = "F" + etiqu;
        if (this.tagToCreate.contains(etiqu) && !this.containsTag(etiqu)) {
            MIAinfo mi = MIAinfo.CreateATag(etiqu, this).get(0);
            mi.addProperty("level", level);
            if ("COA".equals(firstLine.getCOA())) {
                if (size != result.size()) {
                    this.lastTagFromCOA = null;
                }
                if (this.lastTagFromCOA != null && this.lastTagCreated() == this.lastTagFromCOA && level.compareTo(this.lastTagFromCOA.getProperties().getProperty("level")) <= 0) {
                    result.add(MIAinfo.CLOSE_TAG);
                }
                this.lastTagFromCOA = mi;
                this.COAFunctions.add(mi.getTextOrTagName());
            }
            result.add(mi);
        }
        if (firstLine.isFromMacro()) {
            if (!"COA".equals(firstLine.getCOA()) && (firstLine.getSortCriteria28().equals("-900") || firstLine.getSortCriteria15().equals("-900"))) {
                firstLine.tagName = tn = "F" + firstLine.get_FONCT() + firstLine.get_COSFO() + "-900";
                result.addAll(this.createATagFromMIAline(firstLine));
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            etiqu = "F" + firstLine.get_MCFONCT() + firstLine.get_MCCOSFO();
            String firstLineNumber = null;
            if (firstLine.tagName == null) {
                firstLineNumber = this.getLineNumber(firstLine);
                if (this.currentNuligMC.trim().length() > 0 && Ebcdic.stringCompare((String)this.currentNuligMC, (String)firstLine.get_MCNUMLG()) <= 0) {
                    this.currentNuligMC = "";
                }
                if ((tn = String.valueOf(etiqu) + firstLineNumber).equals(this.tagNameForAlphanumericLineNumberInMacro)) {
                    tn = String.valueOf(tn) + "999";
                    firstLineNumber = String.valueOf(firstLineNumber) + "999";
                    this.tagNameForAlphanumericLineNumberInMacro = null;
                } else if (this.tagNameForAlphanumericLineNumberInMacro != null && !this.tagNameForAlphanumericLineNumberInMacro.startsWith(etiqu)) {
                    this.tagNameForAlphanumericLineNumberInMacro = null;
                }
            } else {
                tn = firstLine.tagName;
            }
            tn = this.writeTextAndTagForSpecialMP(tn, firstLine, false);
            if (secondLine == null && !this.linesGroup) {
                firstLine.tagName = tn;
                if (!this.containsTag(tn)) {
                    result.addAll(this.createATagFromMIAline(firstLine));
                } else {
                    result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                }
                result.add(MIAinfo.CLOSE_TAG);
                return;
            }
            if (secondLine == null && this.linesGroup) {
                result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                this.linesGroup = false;
                return;
            }
            if (this.isBufferBeginning(firstLine.getCOBOLcontent())) {
                firstLine.tagName = tn;
                result.addAll(this.createATagBeforeBufferFromMIAline(firstLine));
                this.linesGroup = false;
                return;
            }
            String tnNext = "F" + secondLine.get_MCFONCT() + secondLine.get_MCCOSFO() + this.getLineNumber(secondLine);
            if (!tn.equals(tnNext) && !this.linesGroup || tn.equals(tnNext) && !secondLine.isFromMacro() && this.isBufferBeginning(secondLine.getCOBOLcontent())) {
                if (this.containsTag(tn)) {
                    result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                } else {
                    firstLine.tagName = tn;
                    if (firstLineNumber != null && firstLineNumber.length() <= 3 && this.isNumber(firstLineNumber) && !this.isNumber(this.getLineNumber(secondLine))) {
                        this.tagNameForAlphanumericLineNumberInMacro = tn;
                    }
                    result.addAll(this.createATagFromMIAline(firstLine));
                }
                result.add(MIAinfo.CLOSE_TAG);
                if (!secondLine.isFromMacro() && this.isBufferBeginning(secondLine.getCOBOLcontent())) {
                    if (firstLine.getConditionOrTreatment() == 'C') {
                        this.currentNuligMC = firstLine.get_MCNUMLG();
                    }
                    return;
                }
            }
            if (tn.equals(tnNext) && firstLine.get_MCFONCT().equals(secondLine.get_MCFONCT()) && firstLine.get_MCCOSFO().equals(secondLine.get_MCCOSFO())) {
                String nextTag;
                boolean verifyNS = false;
                if (!this.linesGroup) {
                    if (this.currentNuligMC.trim().length() > 0) {
                        firstLine.tagName = tn;
                        secondLine.tagName = tn;
                        if (this.containsTag(tn)) {
                            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                        } else {
                            result.addAll(this.createATagFromMIAline(firstLine));
                        }
                    } else {
                        verifyNS = true;
                        firstLine.tagName = tn;
                        result.addAll(this.createATagFromMIAline(firstLine));
                        this.linesGroup = true;
                    }
                } else {
                    result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                }
                if (verifyNS && this.lastMPtagCreated != null && !(nextTag = this.writeTextAndTagForSpecialMP(tnNext, secondLine, true)).equals(tnNext)) {
                    result.add(MIAinfo.CLOSE_TAG);
                    this.linesGroup = false;
                }
            }
            if (!tn.equals(tnNext) && this.linesGroup) {
                result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
                result.add(MIAinfo.CLOSE_TAG);
                this.linesGroup = false;
            }
            if (secondLine.get_MCNUMLG().trim().length() > 0 && !this.linesGroup) {
                if (firstLine.get_MCFONCT().equals(secondLine.get_MCFONCT()) && firstLine.get_MCCOSFO().equals(secondLine.get_MCCOSFO()) && secondLine.isFromMacro()) {
                    if (this.tagNameForAlphanumericLineNumberInMacro == null && Ebcdic.stringCompare((String)secondLine.get_MCNUMLG(), (String)firstLine.get_MCNUMLG()) < 0) {
                        this.currentNuligMC = firstLine.get_MCNUMLG();
                    } else if (this.currentNuligMC.trim().length() > 0 && Ebcdic.stringCompare((String)secondLine.get_MCNUMLG(), (String)this.currentNuligMC) > 0) {
                        this.currentNuligMC = "";
                    }
                }
            } else {
                this.currentNuligMC = "";
            }
        } else {
            String tagName = this.writeTextAndTagForSpecialMP(null, firstLine, false);
            if (tagName != null) {
                result.addAll(MIAinfo.CreateATag(tagName, firstLine.getProperties(), this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            if (tagName != null) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            if (secondLine.getSortCriteria16().trim().length() > 0 && "FN".equals(secondLine.getSortCriteria10()) && "-FN.".equals(secondLine.getSortCriteria15())) {
                result.add(MIAinfo.CLOSE_TAG);
            }
        }
        if (!(this.forMigration || secondLine.getSortCriteria16().trim().length() <= 0 || !"FN".equals(secondLine.getSortCriteria11()) && (secondLine.getSortCriteria9().trim().length() >= 1 || "F26-".equals(secondLine.getSortCriteria4()) || "F76-".equals(secondLine.getSortCriteria4()) || "N76-".equals(secondLine.getSortCriteria4())) && !this.etiq.equals("F51") || "*".equals(firstLine.get_Col_Value(36)) || "SEC".equals(firstLine.getSortCriteria17()))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private boolean isNumber(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void procedure_F52GE(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        String etiquette = firstLine.get_FONCT();
        this.createTagIfNeededFromLine(firstLine, etiquette, result);
        if (!this.forMigration) {
            result.addAll(MIAinfo.CreateATag("F".concat(firstLine.get_FONCT()).concat("-BODY"), this));
        }
        this.fonct = firstLine.get_FONCT();
        String tn = null;
        if (firstLine.isFromMacro()) {
            firstLine.tagName = tn = "F" + firstLine.get_MCFONCT() + firstLine.get_MCNUMLG();
            result.addAll(this.createATagFromMIAline(firstLine));
            result.add(MIAinfo.CLOSE_TAG);
        } else {
            this.createArtificialCreateTagAndTextIfNeeded(firstLine, result);
        }
        if (!this.forMigration && (secondLine.getSortCriteria16().trim().length() > 0 && (!secondLine.getSortCriteria17().equals(firstLine.getSortCriteria17()) && !" F05.".equals(firstLine.getSortCriteria18()) && !"*N05.".equals(secondLine.getSortCriteria18()) && !" S".equals(secondLine.getSortCriteria2()) && !"SECT".equals(secondLine.getSortCriteria10()) || "-FN".equals(secondLine.getSortCriteria19()) || ".".equals(secondLine.get_Col_Value(42)) || "-".equals(secondLine.get_Col_Value(42))) || " F05.".equals(firstLine.getSortCriteria18()) && !"*N05.".equals(secondLine.getSortCriteria18()) && secondLine.getSortCriteria18().trim().length() > 0)) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        if (!(secondLine == null || secondLine.getSortCriteria20().trim().length() <= 0 || secondLine.lineContent.length() >= 48 && (secondLine.lineContent.length() < 48 || "***********".equals(secondLine.lineContent.subSequence(36, 47))) || secondLine.getSortCriteria6().equals(firstLine.getSortCriteria6()) || firstLine.lineContent.substring(22, 24).equals(secondLine.lineContent.substring(22, 24)))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        this.etiq = firstLine.getSortCriteria17();
    }

    protected void createTagIfNeededFromLine(MIA1lineProcedure line, String etiquette, List<MIAinfo> result) {
        String f_etiquette = "F" + etiquette;
        if (!this.containsTag(f_etiquette)) {
            this.closePriorTagIfNeeded(etiquette, result);
            if (this.fctAndLevels.containsKey(etiquette)) {
                Properties p = MIAinfo.DuplicateProperties(line.getProperties());
                p.put("level", this.fctAndLevels.get(etiquette));
                result.addAll(MIAinfo.CreateATag(f_etiquette, p, this));
            } else {
                result.addAll(MIAinfo.CreateATag(f_etiquette, this));
            }
        }
    }

    private void procedure_F52GH(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        String etiquette = String.valueOf(firstLine.get_FONCT()) + firstLine.get_COSFO();
        this.createTagIfNeededFromLine(firstLine, etiquette, result);
        if (!this.forMigration) {
            result.addAll(MIAinfo.CreateATag("F" + etiquette + "-BODY", this));
        }
        if (firstLine.isFromMacro()) {
            String tn;
            firstLine.tagName = tn = "F" + firstLine.get_MCFONCT() + firstLine.get_MCCOSFO() + firstLine.get_MCNUMLG();
            result.addAll(this.createATagFromMIAline(firstLine));
            result.add(MIAinfo.CLOSE_TAG);
        } else {
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
        }
        if (!(this.forMigration || secondLine.getSortCriteria16().trim().length() <= 0 || (secondLine.getSortCriteria13().equals(firstLine.getSortCriteria13()) || secondLine.getSortCriteria13().trim().length() <= 0) && "-FN".equals(secondLine.getSortCriteria12()) || " F5110.".equals(firstLine.getSortCriteria13()))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        this.etiq = firstLine.getSortCriteria13();
    }

    private void procedure_F52GI(MIA1lineProcedure firstLine, MIA1lineProcedure secondLine, List<MIAinfo> result) {
        String etiquette = String.valueOf(firstLine.get_FONCT()) + firstLine.get_COSFO();
        this.createTagIfNeededFromLine(firstLine, etiquette, result);
        if (!this.forMigration) {
            result.addAll(MIAinfo.CreateATag("F" + etiquette + "-BODY", this));
        }
        this.createArtificialCreateTagAndTextIfNeeded(firstLine, result);
        if (!(this.forMigration || secondLine.getSortCriteria16().trim().length() <= 0 || (secondLine.getSortCriteria13().equals(firstLine.getSortCriteria13()) || secondLine.getSortCriteria13().trim().length() <= 0) && "-FN".equals(secondLine.getSortCriteria12()) || " F5110.".equals(firstLine.getSortCriteria13()))) {
            result.add(MIAinfo.CLOSE_TAG);
        }
        this.etiq = firstLine.getSortCriteria13();
    }

    private void procedure_F52GN(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        String functionCode = "F".concat(firstLine.get_FONCT());
        this.closeTagsIfNeeded(functionCode, result);
        if (this.containsTag(functionCode)) {
            if (!this.forMigration) {
                result.addAll(MIAinfo.CreateATag(functionCode.concat("-FN"), this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GT(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        String functionCode = "F".concat(firstLine.get_FONCT()).concat(firstLine.get_COSFO());
        this.closeTagsIfNeeded(functionCode, result);
        if (this.containsTag(functionCode)) {
            if (!this.forMigration) {
                result.addAll(MIAinfo.CreateATag(functionCode.concat("-FN"), this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    private void procedure_F52GV(MIA1lineProcedure firstLine, List<MIAinfo> result) {
        String etiq = "F".concat(firstLine.get_FONCT()).concat(firstLine.get_COSFO());
        this.firstLineSaved = "";
        if (!this.needToWriteEtiqu(etiq)) {
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            if (this.containsTag(etiq)) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            return;
        }
        if (firstLine.get_MCNUMLG().length() > 0) {
            result.addAll(MIAinfo.CreateATag(etiq, this));
            if (!this.forMigration) {
                result.addAll(MIAinfo.CreateATag(etiq.concat("-FN"), this));
            }
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            if (!this.forMigration) {
                result.add(MIAinfo.CLOSE_TAG);
            }
            result.add(MIAinfo.CLOSE_TAG);
        } else if (this.containsTag(etiq)) {
            result.addAll(MIAinfo.InsertText(firstLine.getCOBOLcontent(), this));
            result.add(MIAinfo.CLOSE_TAG);
        }
    }

    @Override
    protected IGeneratedInfo modifyGeneratedInfoAtEnd(IGeneratedInfo gi) {
        if (this.COAFunctions.isEmpty()) {
            return super.modifyGeneratedInfoAtEnd(gi);
        }
        IGenInfoBuilder gib = gi.toGeneratedInfoBuilder();
        for (String function : this.COAFunctions) {
            String lev;
            String tagName;
            IBuilderTag prevTag;
            String fctCode = function.substring(0, 3);
            IBuilderTag tag = gib.tagFromName(function);
            if (tag == null || (prevTag = tag.previousTag()) == null || this.COAFunctions.contains(tagName = prevTag.getName()) || "F80".equals(fctCode) || !fctCode.equals(tagName.substring(0, 3)) || (lev = prevTag.getProperty("level")) == null) continue;
            try {
                int n = Integer.decode(lev);
                tag.setProperty("level", String.valueOf(n += 5));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return gib.toGeneratedInfo();
    }
}

