/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help.actions;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.IPTElement;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.plugin.IPTActionContributor;
import com.ibm.pdp.explorer.view.actiongroup.PTGenerateActionGroup;
import com.ibm.pdp.explorer.view.service.PTViewService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pac.migration.help.actions.MigrationHelpAction;
import com.ibm.pdp.pacbase.PacTool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.KeyEvent;

public class MigrationActionManager
implements IPTActionContributor {
    private static MigrationActionManager _instance = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static MigrationActionManager getInstance() {
        if (_instance == null) {
            _instance = new MigrationActionManager();
        }
        return _instance;
    }

    public MigrationActionManager() {
        _instance = this;
    }

    public void menuAboutToShow(IMenuManager menu) {
        IStructuredSelection selection = PTViewService.getSelection();
        if (selection.size() > 1 || selection.isEmpty() || !PacTool.isOsSupported()) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IPTElement) {
            String type = ((IPTElement)o).toString();
            int typeIndex = type.lastIndexOf(46);
            if (typeIndex != -1 && typeIndex < type.length()) {
                type = type.substring(typeIndex + 1);
            }
            if ("pacprogram".equals(type)) {
                RadicalEntity re = PTEditorService.getSharedResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacProgram)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            } else if ("pacscreen".equals(type)) {
                RadicalEntity re = PTModelService.getResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacScreen)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            } else if ("pacserver".equals(type)) {
                RadicalEntity re = PTModelService.getResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacServer)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            } else if ("pacdialog".equals(type)) {
                RadicalEntity re = PTModelService.getResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacDialog)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            } else if ("paccommunicationmonitor".equals(type)) {
                RadicalEntity re = PTModelService.getResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacCommunicationMonitor)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            } else if ("pacfolder".equals(type)) {
                RadicalEntity re = PTModelService.getResource((IPath)((IPTElement)o).getPath());
                if (re == null) {
                    return;
                }
                PacGenerationHeader genParam = ((PacFolder)re).getGenerationHeader();
                if (genParam == null || genParam instanceof PacLibrarySubstitutionGenerationHeader) {
                    menu.add((IContributionItem)new Separator());
                    MigrationHelpAction migrationHelpAction = new MigrationHelpAction((IPTElement)o);
                    menu.insertAfter(PTGenerateActionGroup._ID, (IAction)migrationHelpAction);
                }
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }
}

