/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help;

import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.EditorLink;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IMarkerUpdateExtension;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.pacbase.generator.AbstractPacbasePattern;
import com.ibm.pdp.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class MigrationHelpMarkerUpdateExtension
implements IMarkerUpdateExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public void updateMarkers(IController controler, IFile resourceFile) {
        this.updateMarkers(controler, resourceFile, false);
    }

    public void updateMarkers(IController controler, IFile resourceFile, boolean debug) {
        try {
            IMarker[] markers = resourceFile.findMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                if (marker.exists()) {
                    ITextProcessor tp = controler.getTextProcessor();
                    tp.getEditTree();
                    int controlBeginIndex = marker.getAttribute("START_CONTROL_INDEX_ATTRIBUTE", -1);
                    int controlEndIndex = marker.getAttribute("STOP_CONTROL_INDEX_ATTRIBUTE", -1);
                    if (controlBeginIndex == -1 || controlEndIndex == -1 && !debug) {
                        this.logMarkerError(controler, resourceFile, marker, controlBeginIndex, controlEndIndex, i, markers.length);
                        ValidationContoler.applyMigrationType((Controller)controler);
                        this.updateMarkers(controler, resourceFile, true);
                        if (debug) {
                            throw new RuntimeException("MigrationHelpMarkerUpdateExtension:updateMarker : controlIndex not initialized");
                        }
                        return;
                    }
                    marker.setAttribute("charStart", controlBeginIndex);
                    marker.setAttribute("charEnd", controlEndIndex);
                    EditorLink editorLink = (EditorLink)controler.getEditorLink();
                    IDocument doc = editorLink.getDocument();
                    if (doc != null) {
                        try {
                            int line = doc.getLineOfOffset(controlBeginIndex);
                            marker.setAttribute("lineNumber", line);
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
    }

    private void logMarkerError(IController controler, IFile resourceFile, IMarker marker, int controlBeginIndex, int controlEndIndex, int markerIndex, int markersNumber) {
        try {
            System.out.println("MigrationHelpMarkerUpdateExtension:updateMarker : controlIndex not initialized - start");
            System.out.println("Controller resource : " + controler.getResourceName());
            System.out.println("IFile resource : " + resourceFile.getFullPath());
            System.out.println("controlBeginIndex : " + controlBeginIndex);
            System.out.println("controlBeginIndex : " + controlEndIndex);
            System.out.println("Marker index : " + markerIndex + "/" + markersNumber);
            System.out.println("Marker message : " + marker.getAttribute("message", ""));
            System.out.println("Marker severity : " + marker.getAttribute("severity", ""));
            System.out.println("Controler warnings :");
            StringBuilder sb = new StringBuilder();
            MigrationWarnings mws = ((Controller)controler).getMigrationWarnings();
            if (mws != null) {
                int i = 1;
                for (MigrationWarningIndexes migrationWarningIndexes : mws.getWarningsList()) {
                    sb.append("(");
                    sb.append(i);
                    sb.append(",");
                    sb.append(migrationWarningIndexes.controlBeginIndex);
                    sb.append(",");
                    sb.append(migrationWarningIndexes.controlEndIndex);
                    sb.append(",");
                    sb.append(migrationWarningIndexes.generatedBeginIndex);
                    sb.append(",");
                    sb.append(migrationWarningIndexes.generatedEndIndex);
                    sb.append(",");
                    sb.append("migrationWarningIndexes.patternID");
                    sb.append(")\n");
                    ++i;
                }
            }
            System.out.println(sb.toString());
            System.out.println("MigrationHelpMarkerUpdateExtension:updateMarker : controlIndex not initialized - end");
        }
        catch (Throwable throwable) {}
    }

    public boolean canUpdateMarkers(IPattern pattern, IFile file) {
        return pattern instanceof AbstractPacbasePattern;
    }
}

