/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencerWithSignificantDots;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.engine.tree.IEditTree;
import com.ibm.pdp.explorer.model.marker.PTMarkerManager;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenResult;
import com.ibm.pdp.framework.GenStatus;
import com.ibm.pdp.framework.GeneratedElement;
import com.ibm.pdp.framework.GenerationLink;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpTool;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.ResourceLink;
import com.ibm.pdp.framework.ResourceReference;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IGeneratedElement;
import com.ibm.pdp.framework.interfaces.IGenerationContext;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IResourceReference;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.framework.serialization.PDPXMLMigrationHelpLocalGeneratedCodeDeserializer;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialog;
import com.ibm.pdp.mdl.pacbase.PacAbstractDialogServer;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramStructureValues;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.pac.migration.help.Messages;
import com.ibm.pdp.pac.migration.help.MigrationControlExtension;
import com.ibm.pdp.pac.migration.help.MigrationHelpGenerationOptions;
import com.ibm.pdp.pac.migration.help.MigrationHelpProblem;
import com.ibm.pdp.pac.migration.help.mia.MIA1file;
import com.ibm.pdp.pac.migration.help.mia.MIA2File;
import com.ibm.pdp.pac.migration.help.mia.MIA3File;
import com.ibm.pdp.pac.migration.help.mia.MIA4File;
import com.ibm.pdp.pac.migration.help.mia.MIAfile;
import com.ibm.pdp.pacbase.PacTool;
import com.ibm.pdp.pacbase.csclient.pattern.PacbaseCSClientPattern;
import com.ibm.pdp.pacbase.generator.CobolPacbasePattern;
import com.ibm.pdp.pacbase.migration.modeltrans.ModelTransformation2;
import com.ibm.pdp.pacbase.migration.plugin.ImportMigration2;
import com.ibm.pdp.pacbase.migration.plugin.NameSubstitution;
import com.ibm.pdp.util.Interval;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.diff.DiffCursor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class MigrationHelp2 {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CONSTANTES_PAC = " CONSTANTES-PAC.";
    private static final String PACBASE_CONSTANTS = " PACBASE-CONSTANTS.";
    private static final String RELATION_CBL_ENTRYPOINT = "generation_1_entrypoint";
    private static final String RELATION_MAP_ENTRYPOINT = "generation_2_entrypoint";
    private RadicalEntity re;
    private String specificCobolPath;
    private String lightCobolpath;
    private Controller contr;
    private char flowPosition;
    private String validationFile;
    private String reportFolder;
    private char csvSep;
    private char csvTextSep;
    private boolean generateReport;
    private String templatesFilterFile;
    private boolean batchMode;
    List<MigrationHelpProblem> problems = new ArrayList<MigrationHelpProblem>();
    public static final String CONTROL_EXTENSION = "_control";
    public static final String MIGRATION_MARKER_TYPE = "com.ibm.pdp.pac.migration.marker";
    public static final String TAG_NAME = "TagName";
    public static final String CONSTANTES = "CONSTANTES";
    public static final String START_GENERATED_INDEX_ATTRIBUTE = "START_GENERATED_INDEX_ATTRIBUTE";
    public static final String STOP_GENERATED_INDEX_ATTRIBUTE = "STOP_GENERATED_INDEX_ATTRIBUTE";
    public static final String START_CONTROL_INDEX_ATTRIBUTE = "START_CONTROL_INDEX_ATTRIBUTE";
    public static final String STOP_CONTROL_INDEX_ATTRIBUTE = "STOP_CONTROL_INDEX_ATTRIBUTE";
    private static String ERROR_MESS = "Errors in {0} prevent the generation launching. Fix the error(s) before relaunching the generation.";
    public static final String MARK_BEFORE_GENERATED = "MARK_BEFORE_GENERATED";
    public static final String MARK_AFTER_GENERATED = "MARK_AFTER_GENERATED";
    private boolean isMIA1Migration = false;
    private boolean isMIA2Migration = false;
    private boolean isMIA4Migration = false;
    private boolean isF25InSpecific = false;
    private boolean isF35InSpecific = false;
    private boolean isF60InSpecific = false;
    private boolean isF65InSpecific = false;
    private boolean isSchGeneration = false;
    private Map<String, Boolean> allLabelsAndExit = new HashMap<String, Boolean>();

    public MigrationHelp2(RadicalEntity re, String specificCobolPath, String lightCobolPath, char flowPosition, String validationFile, String reportFolder, char csvSep, char csvTextSep, boolean generateReport, String templatesFilterFile, boolean batchMode) {
        this.re = re;
        this.specificCobolPath = specificCobolPath;
        this.lightCobolpath = lightCobolPath;
        this.flowPosition = flowPosition;
        this.validationFile = validationFile;
        this.batchMode = batchMode;
        this.reportFolder = reportFolder;
        this.csvSep = csvSep;
        this.csvTextSep = csvTextSep;
        this.generateReport = generateReport;
        this.templatesFilterFile = templatesFilterFile;
    }

    public List<IStatus> run(IProgressMonitor monitor) throws OperationCanceledException {
        ArrayList<IStatus> statusList = new ArrayList<IStatus>();
        boolean stopMigration = false;
        if (this.re == null) {
            this.loadOrSaveTemplates();
            return statusList;
        }
        IGeneratedInfo refGenInfo = null;
        IController controler = null;
        try {
            IGeneratedElement generatedElement;
            MIAfile m;
            List paths = PTNature.getPaths((String)this.re.getProject());
            int maxError = PTMarkerManager.checkMarkers((RadicalEntity)this.re, (boolean)false, (List)paths);
            if (maxError > 1) {
                String mess = NLS.bind((String)ERROR_MESS, (Object[])new Object[]{this.re.getName()});
                statusList.add((IStatus)new Status(4, "com.ibm.pdp.pac.migration.help", 1, mess, null));
                this.loadOrSaveTemplates();
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            IFile file = this.re.getFile(null);
            String fileName = file.getFullPath().toString();
            String designFileId = this.re.getDesignId(this.re.getProject());
            String fullCblFileName = PacTool.getFullCobolFileNameFromDesignFileName((RadicalEntity)this.re, (String)fileName);
            IFile cblFile = PdpTool.getFile((String)fullCblFileName);
            if (stopMigration = this.checkMacrosPresence(stopMigration, cblFile, statusList)) {
                this.loadOrSaveTemplates();
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            if (monitor != null && monitor.isCanceled()) {
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            File fileControl = new File(this.lightCobolpath);
            if (!fileControl.exists()) {
                if (this.re instanceof PacProgram) {
                    PacProgram program = (PacProgram)this.re;
                    if (program.getVariante() != PacProgramVariantValues._C_LITERAL && !program.getProgramStructure().equals(PacProgramStructureValues._F_LITERAL)) {
                        this.loadOrSaveTemplates();
                        ArrayList<IStatus> arrayList = statusList;
                        return arrayList;
                    }
                } else {
                    this.loadOrSaveTemplates();
                    ArrayList<IStatus> arrayList = statusList;
                    return arrayList;
                }
            }
            List<NameSubstitution> lns = this.loadNameSubstitution(this.re.getLocation());
            this.isMIA1Migration = this.re instanceof PacProgram;
            this.isMIA2Migration = this.re instanceof PacAbstractDialog && this.isMIA2MigrationHelpFile(this.re);
            this.isMIA4Migration = this.re instanceof PacAbstractDialogServer || this.re instanceof PacCommunicationMonitor || this.re instanceof PacFolder;
            String specificCobolFile = this.readCobolFile(this.specificCobolPath, lns, this.isMIA2Migration);
            String patternName = null;
            if (this.re instanceof PacProgram) {
                m = new MIA1file(this.re, this.allLabelsAndExit);
                m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                refGenInfo = m.transformToGeneratedInfo();
                refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" CONSTANTES-PAC.     ");
                refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                PacProgram pgm = (PacProgram)this.re;
                PacProgramVariantValues ppvv = pgm.getVariante();
                refGenInfo.setProperty("variant", ppvv.getName());
                PacProgramStructureValues ppsv = pgm.getProgramStructure();
                refGenInfo.setProperty("nature", ppsv.getName());
                patternName = m.getPatternName();
            }
            if (this.re instanceof PacAbstractDialog) {
                if (this.isMIA2MigrationHelpFile(this.re)) {
                    m = new MIA2File(this.re, this.allLabelsAndExit);
                    m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                    refGenInfo = m.transformToGeneratedInfo();
                    refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                    patternName = m.getPatternName();
                } else if (this.isMIA3MigrationHelpFile(this.re)) {
                    m = new MIA3File(this.re, this.allLabelsAndExit);
                    m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                    refGenInfo = m.transformToGeneratedInfo();
                    refGenInfo = PacbaseCSClientPattern.allignConstantsAndDateForClient((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                    patternName = m.getPatternName();
                }
            }
            if (this.re instanceof PacAbstractDialogServer) {
                m = new MIA4File(this.re, this.allLabelsAndExit);
                m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                refGenInfo = m.transformToGeneratedInfo();
                refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                patternName = m.getPatternName();
            }
            if (this.re instanceof PacCommunicationMonitor) {
                m = new MIA4File(this.re, this.allLabelsAndExit);
                m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                refGenInfo = m.transformToGeneratedInfo();
                refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                patternName = m.getPatternName();
            }
            if (this.re instanceof PacFolder) {
                m = new MIA4File(this.re, this.allLabelsAndExit);
                m.setFileToAnalyse(this.lightCobolpath, this.specificCobolPath, lns);
                refGenInfo = m.transformToGeneratedInfo();
                refGenInfo = CobolPacbasePattern.allignConstantsAndDate((IGeneratedInfo)refGenInfo, (String)specificCobolFile, (String)" PACBASE-CONSTANTS.      ");
                patternName = m.getPatternName();
            }
            if (specificCobolFile == null || refGenInfo == null) {
                this.loadOrSaveTemplates();
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            this.writeCobolEclipseFile(monitor, cblFile, specificCobolFile);
            String[] generators = GenerationManager.generatorsFor((String)fileName);
            if (generators == null || generators.length == 0 || generators[0] == null) {
                throw new RuntimeException("Generator not found for " + fileName);
            }
            if (patternName == null) {
                patternName = generators[0];
            }
            Controller refControler = (Controller)ControllerFactory.getInstance().getController(designFileId, patternName, fullCblFileName);
            refControler.getTextProcessor().initialize(refGenInfo);
            refControler.getTextProcessor().setText((CharSequence)specificCobolFile);
            MigrationWarnings migrationWarnings = refControler.getMigrationWarnings();
            if (migrationWarnings == null) {
                migrationWarnings = new MigrationWarnings("");
                refControler.setMigrationWarnings(migrationWarnings);
            }
            if (MigrationControlExtension.entryPoints_Generated_Couples == null) {
                MigrationControlExtension.entryPoints_Generated_Couples = new ArrayList<MigrationControlExtension.EntrypointGenCouple>();
            }
            this.addEntryPointAndGenerationOutput((IController)refControler, patternName);
            ((ResourceLink)refControler.getResourceLink()).saveResourceWithoutUpdateAnnotation();
            ControllerFactory.getInstance().dispose((IController)refControler);
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            refControler = (Controller)ControllerFactory.getInstance().getController(designFileId, patternName, fullCblFileName);
            controllers.add(refControler);
            IGeneratedInfo _igi = null;
            if (monitor != null && monitor.isCanceled()) {
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            MigrationControlExtension.controlCobolFileName = this.lightCobolpath;
            MigrationControlExtension.fromWizard = true;
            MigrationControlExtension.flowPosition = this.flowPosition;
            MigrationControlExtension.reportFolder = this.reportFolder;
            MigrationControlExtension.csvSep = this.csvSep;
            MigrationControlExtension.csvTextSep = this.csvTextSep;
            MigrationControlExtension.generateReport = this.generateReport;
            MigrationControlExtension.templatesFilterFile = this.templatesFilterFile;
            MigrationControlExtension.batchMode = this.batchMode;
            if (this.batchMode && this.flowPosition != 'S' && this.flowPosition != 'E') {
                MigrationControlExtension.loadAndSaveValidationFile(this.validationFile);
            }
            IPattern pattern = PdpPatternManager.getPdpPattern((String)patternName);
            IGenResult result = GenerationManager.generateWithOption(controllers, (Object)this.re, (IPattern)pattern, (IProgressMonitor)monitor, (IGenerationContext)new MigrationHelpGenerationOptions());
            Iterator generationOutputs = result.getGeneratedElements();
            if (monitor != null && monitor.isCanceled()) {
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            if (result.getGenStatus().getState() == 1) {
                Iterator messages = result.getGenStatus().getMessages();
                if (messages.hasNext()) {
                    IStatusMessage iStatusMessage = (IStatusMessage)messages.next();
                    statusList.add((IStatus)new Status(4, "com.ibm.pdp.pac.migration.help", iStatusMessage.getMessageStatus(), iStatusMessage.getText(), null));
                }
                this.loadOrSaveTemplates();
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            if (generationOutputs.hasNext()) {
                generatedElement = (IGeneratedElement)generationOutputs.next();
                _igi = generatedElement.getGeneratedInfo();
            }
            if (generationOutputs.hasNext()) {
                generatedElement = (IGeneratedElement)generationOutputs.next();
                String designId = this.re.getDesignId(this.re.getProject());
                String stateId = this.re.getStateId();
                String outMapName = generatedElement.getGenerarationOutput().getResource();
                MigrationControlExtension.EntrypointGenCouple e = new MigrationControlExtension.EntrypointGenCouple(outMapName, designId, stateId, RELATION_MAP_ENTRYPOINT, patternName);
                MigrationControlExtension.entryPoints_Generated_Couples.add(e);
            }
            if (_igi == null) {
                throw new RuntimeException("The generated info is null");
            }
            controler = ControllerFactory.getInstance().getController(designFileId, patternName, fullCblFileName);
            Iterator segments = controler.getTextProcessor().segments();
            if (segments.hasNext()) {
                segments.next();
            }
            if (!(controler instanceof Controller)) {
                this.loadOrSaveTemplates();
                ArrayList<IStatus> arrayList = statusList;
                return arrayList;
            }
            try {
                this.contr = (Controller)controler;
            }
            catch (Exception e) {
                this.loadOrSaveTemplates();
                Util.rethrow((Throwable)e);
            }
        }
        finally {
            MigrationControlExtension.controlCobolFileName = null;
            MigrationControlExtension.fromWizard = false;
            MigrationControlExtension.flowPosition = (char)32;
            MigrationControlExtension.reportFolder = null;
            MigrationControlExtension.generateReport = true;
            MigrationControlExtension.templatesFilterFile = null;
            MigrationControlExtension.batchMode = false;
        }
        return statusList;
    }

    private void loadOrSaveTemplates() {
        try {
            try {
                MigrationControlExtension.flowPosition = this.flowPosition;
                MigrationControlExtension.reportFolder = this.reportFolder;
                MigrationControlExtension.csvSep = this.csvSep;
                MigrationControlExtension.csvTextSep = this.csvTextSep;
                MigrationControlExtension.generateReport = this.generateReport;
                MigrationControlExtension.controlCobolFileName = "";
                MigrationControlExtension.templatesFilterFile = this.templatesFilterFile;
                MigrationHelpTool.processMigrationControl2((Controller)this.contr, (CharSequence)"", (CharSequence)"", null);
            }
            catch (Exception e) {
                Util.rethrow((Throwable)e);
                MigrationControlExtension.flowPosition = (char)32;
                MigrationControlExtension.reportFolder = null;
                MigrationControlExtension.controlCobolFileName = null;
                MigrationControlExtension.templatesFilterFile = null;
            }
        }
        finally {
            MigrationControlExtension.flowPosition = (char)32;
            MigrationControlExtension.reportFolder = null;
            MigrationControlExtension.controlCobolFileName = null;
            MigrationControlExtension.templatesFilterFile = null;
        }
    }

    private void writeCobolEclipseFile(IProgressMonitor monitor, IFile cblFile, String specificCobolFile) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(specificCobolFile.getBytes(cblFile.getCharset()));
            cblFile.create((InputStream)stream, 1, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private String modifyCobol(String specificCobolFile, List<NameSubstitution> lns) {
        String op;
        String line;
        StringBuilder result = new StringBuilder();
        boolean cropEndOfLine = !PacTool.markAtEndOfLine();
        String lineDelim = PdpTool.determineDelimiterOfV2((CharSequence)specificCobolFile);
        int currentIndex = 0;
        int endOfLineIndex = specificCobolFile.indexOf(lineDelim);
        boolean isProcedure = false;
        boolean isGeneratedMark = false;
        int mpLine = 0;
        boolean isMpWi = false;
        boolean isSQL = false;
        String rightMarginForXnn = "";
        boolean isLineToReport = true;
        int mpId = 0;
        int indexForF80 = -1;
        boolean onlySpecificMP = false;
        if (this.re instanceof PacProgram) {
            onlySpecificMP = ((PacProgram)this.re).getProgramStructure().equals(PacProgramStructureValues._F_LITERAL);
        }
        StringBuilder allSQL = new StringBuilder();
        boolean isSpecificMP = false;
        while (endOfLineIndex != -1) {
            line = specificCobolFile.substring(currentIndex, endOfLineIndex);
            isLineToReport = true;
            if (this.re instanceof PacFolder) {
                line = line.replaceAll("^[0-9]{6}", "      ");
            }
            if (line.length() >= 8 && (line.substring(6, 8).equals("*}") || line.substring(6, 8).equals("*\u00ee")) || isSpecificMP && onlySpecificMP && line.length() < 72) {
                if (!isGeneratedMark && mpLine > 0 && isSpecificMP) {
                    --mpId;
                }
                if (!onlySpecificMP) {
                    currentIndex = endOfLineIndex + lineDelim.length();
                    endOfLineIndex = specificCobolFile.indexOf(lineDelim, endOfLineIndex + 1);
                }
                isGeneratedMark = false;
                isMpWi = false;
                if (!this.isMIA4Migration && !this.isMIA1Migration && isSQL) {
                    allSQL.append(line);
                    allSQL.append(lineDelim);
                }
                rightMarginForXnn = "";
                mpLine = 0;
                isSpecificMP = false;
                continue;
            }
            if (line.length() >= 8) {
                op = line.substring(6, 8);
                if (op.equals("*\u00f4")) {
                    int index = (line = String.valueOf(line.substring(0, 6)) + "*!" + line.substring(8)).indexOf(" ", 8);
                    if (index == -1) {
                        index = line.length();
                    }
                    String id = line.substring(8, index);
                    mpLine = 1;
                    if ("WE".equals(id) || "WI".equals(id) || "WS".equals(id)) {
                        isMpWi = true;
                    } else if ("SQL".equals(id)) {
                        isSQL = true;
                    }
                    if (line.length() < 72) {
                        ++mpId;
                        isSpecificMP = true;
                    } else {
                        String rightMargin = line.substring(72).trim();
                        if (rightMargin.length() > 0) {
                            if (rightMargin.equals("dot")) {
                                ++mpId;
                                isSpecificMP = true;
                            } else {
                                boolean bl = isLineToReport = !this.isXnnWithoutAnnotation(id);
                                if (!isLineToReport) {
                                    rightMarginForXnn = rightMargin;
                                }
                            }
                        }
                    }
                } else {
                    if (!cropEndOfLine && mpLine > 0) {
                        String comm = line.substring(6);
                        if (!(comm.startsWith("*") && !comm.startsWith("*BEGIN DB2") || isMpWi && mpLine <= 1)) {
                            isGeneratedMark = true;
                        }
                        ++mpLine;
                    }
                    if (!isProcedure && !op.trim().equals("*") && line.contains("EXEC")) {
                        int ind;
                        int i1 = endOfLineIndex + lineDelim.length();
                        int endi1 = specificCobolFile.indexOf(lineDelim, endOfLineIndex + 1);
                        String line1 = "";
                        if (endi1 > i1) {
                            line1 = specificCobolFile.substring(i1, endi1);
                        }
                        if (line1.contains("DECLARE") && (ind = line1.indexOf("DISPLAY_")) > 0) {
                            String segment = line1.substring(ind + 8, ind + 12);
                            i1 = endi1 + lineDelim.length();
                            endi1 = specificCobolFile.indexOf(lineDelim, i1 + 1);
                            String line2 = specificCobolFile.substring(i1, endi1);
                            if (line1.contains("CURSOR") || line2.contains("CURSOR")) {
                                result.append("      *SQL-DECLARE-CURSOR-" + segment);
                                result.append(lineDelim);
                            }
                        }
                    }
                }
            }
            if (isLineToReport) {
                line = this.modifyRightColumn(cropEndOfLine, line, lns, isProcedure, isGeneratedMark, isSpecificMP, mpId, rightMarginForXnn);
                if (!this.isMIA1Migration && isSQL) {
                    if (line.indexOf("-FN.") != -1) {
                        isSQL = false;
                    } else {
                        if (this.isMIA4Migration) {
                            result.append(line);
                            result.append(lineDelim);
                        } else {
                            allSQL.append(line);
                        }
                        allSQL.append(lineDelim);
                    }
                } else {
                    result.append(line);
                    result.append(lineDelim);
                }
            }
            if (line.startsWith("       PROCEDURE DIVISION")) {
                isProcedure = true;
            }
            if (line.startsWith("       F80.")) {
                indexForF80 = result.length();
            }
            currentIndex = endOfLineIndex + lineDelim.length();
            endOfLineIndex = specificCobolFile.indexOf(lineDelim, endOfLineIndex + 1);
        }
        if (currentIndex == specificCobolFile.length()) {
            if (!this.isMIA4Migration && !this.isMIA1Migration && indexForF80 != -1 && allSQL.length() > 0) {
                result.insert(indexForF80, allSQL);
            }
            return result.toString();
        }
        line = specificCobolFile.substring(currentIndex);
        if (line.length() >= 8) {
            op = line.substring(6, 8);
            if (op.equals("*\u00f4")) {
                line = String.valueOf(line.substring(0, 6)) + "*!" + line.substring(8);
            } else if (op.equals("*\u00e2")) {
                line = String.valueOf(line.substring(0, 6)) + "*@" + line.substring(8);
            }
        }
        result.append(line);
        result.insert(indexForF80, allSQL);
        return result.toString();
    }

    private boolean isXnnWithoutAnnotation(String id) {
        if (id.charAt(0) == 'X') {
            if (this.isMIA2Migration && ("XR".equals(id) || "XRU".equals(id) || "XRN".equals(id) || "XD".equals(id) || "XUN".equals(id) || "XP".equals(id) || "XP1".equals(id) || "XW".equals(id) || "XRW".equals(id))) {
                return false;
            }
            return !(this.re instanceof PacAbstractDialogServer) || !"XT".equals(id);
        }
        return false;
    }

    private List<NameSubstitution> loadNameSubstitution(String locationName) {
        String wcs_file = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + ".metadata/" + "wcs" + locationName + ".txt";
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(wcs_file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new ArrayList<NameSubstitution>();
        }
        ArrayList<NameSubstitution> lns = new ArrayList<NameSubstitution>();
        while (scanner.hasNextLine()) {
            lns.add(new NameSubstitution(scanner.nextLine()));
        }
        scanner.close();
        return lns;
    }

    private String modifyRightColumn(boolean cropEndOfLine, String line, List<NameSubstitution> lns, boolean isProcedure, boolean isGeneratedMark, boolean isSpecificMp, int mpId, String rightMarginForXnn) {
        String rightMargin;
        if (isProcedure && line.length() >= 11 && line.length() < 72 && (line.substring(6, 11).equals("*@SCH") || line.substring(6, 11).equals("*@SCB"))) {
            this.isSchGeneration = true;
        }
        String mpIdent = "000000";
        if (mpId > 0) {
            mpIdent = String.valueOf(mpIdent) + mpId;
            mpIdent = mpIdent.substring(mpIdent.length() - 6);
        }
        boolean isLabel = false;
        if (isProcedure && line.length() > 8 && line.substring(0, 7).trim().length() == 0 && line.charAt(7) != ' ') {
            isLabel = true;
            this.storeLabelProperties(line);
        }
        if (line.length() <= 72) {
            String name;
            if (!isGeneratedMark) {
                if (this.isMIA2Migration && (!this.isF25InSpecific && line.startsWith("       F25-FN.") || !this.isF35InSpecific && line.startsWith("       F35-FN.") || !this.isF60InSpecific && line.startsWith("       F60-FN.") || !this.isF65InSpecific && line.startsWith("       F65-FN."))) {
                    StringBuilder sb = new StringBuilder(line);
                    while (sb.length() < 72) {
                        sb.append(" ");
                    }
                    sb.append(this.re.getName());
                    return sb.toString();
                }
                if (isLabel && this.isSchGeneration && !line.contains("-FN.")) {
                    StringBuilder sb = new StringBuilder(line);
                    while (sb.length() < 72) {
                        sb.append(" ");
                    }
                    sb.append("coa");
                    this.isSchGeneration = false;
                    return sb.toString();
                }
                return line;
            }
            String string = name = rightMarginForXnn.length() > 0 ? rightMarginForXnn : this.re.getName();
            if (isSpecificMp) {
                name = mpIdent;
            }
            StringBuilder sb = new StringBuilder(line);
            while (sb.length() < 72) {
                sb.append(" ");
            }
            sb.append(name);
            return sb.toString();
        }
        if (isLabel && this.isSchGeneration) {
            this.isSchGeneration = false;
        }
        if ((rightMargin = line.substring(72).trim()).length() > 0) {
            if (isLabel && rightMargin.startsWith("lv") && line.substring(7).indexOf(". ") < 5 && !rightMargin.startsWith("lv05")) {
                line = line.replace(rightMargin.trim(), "lv05");
            }
            if (rightMargin.equals("DOT") && !isLabel || rightMargin.startsWith("lv") || rightMargin.equals("dot")) {
                if (this.isMIA2Migration) {
                    if (line.startsWith("       F25.")) {
                        this.isF25InSpecific = true;
                    } else if (line.startsWith("       F35.")) {
                        this.isF35InSpecific = true;
                    } else if (line.startsWith("       F60.")) {
                        this.isF60InSpecific = true;
                    } else if (line.startsWith("       F65.")) {
                        this.isF65InSpecific = true;
                    }
                }
                return line;
            }
            if (isLabel && !rightMargin.equals("COA") && !rightMargin.equals("coa")) {
                return ModelTransformation2.trimRight((String)line.substring(0, 72));
            }
            if (isSpecificMp && !rightMargin.equals("COA") && !rightMargin.equals("coa")) {
                line = line.substring(0, 72);
                return String.valueOf(line) + mpIdent;
            }
            if (rightMarginForXnn.length() > 0) {
                line = line.substring(0, 72);
                return String.valueOf(line) + rightMarginForXnn;
            }
        }
        if (cropEndOfLine) {
            line = line.substring(0, 72);
            line = ModelTransformation2.trimRight((String)line);
        } else if (lns != null && lns.size() > 0) {
            String entityName = ModelTransformation2.trimRight((String)rightMargin);
            String realName = ImportMigration2.defineRealNameForEntity((String)entityName, lns);
            if (realName.equals(entityName)) {
                return line;
            }
            line = String.valueOf(line.substring(0, 72)) + realName;
        }
        return line;
    }

    private void storeLabelProperties(String line) {
        String etiq = line.substring(7);
        boolean isEXITexists = false;
        StringTokenizer st = new StringTokenizer(etiq);
        if (st.hasMoreTokens()) {
            etiq = st.nextToken();
            if (st.hasMoreTokens()) {
                isEXITexists = "EXIT.".equals(st.nextToken());
            }
        }
        if (this.allLabelsAndExit.containsKey(etiq)) {
            etiq = String.valueOf(etiq) + "-duplicate";
        }
        this.allLabelsAndExit.put(etiq, isEXITexists);
    }

    private boolean checkMacrosPresence(boolean stopMigration, IFile cblFile, List<IStatus> statusList) {
        if (cblFile.exists()) {
            String message = Messages.Resource_File_Exists;
            message = NLS.bind((String)message, (Object)this.re.getName());
            statusList.add((IStatus)new Status(4, "com.ibm.pdp.pac.migration.help", 1, message, null));
            stopMigration = true;
        }
        return stopMigration;
    }

    public String readCobolFile(String path, List<NameSubstitution> lns, boolean isMIA2Migration) {
        String specificCobolFileWithoutMPEndDeclarations = this.modifyCobol(PdpTool.readFileContents((String)path), lns);
        return specificCobolFileWithoutMPEndDeclarations;
    }

    public static String getCblGenFileNameFromDesignFileName(String designfileName) {
        int i = designfileName.lastIndexOf(".");
        String cblFile = String.valueOf(designfileName.substring(0, i)) + ".cblmsp";
        return cblFile;
    }

    public List<MigrationHelpProblem> getProblems() {
        if (this.problems.size() != 0 || this.contr == null) {
            return this.problems;
        }
        ITextProcessor tp = this.contr.getTextProcessor();
        IEditTree editTree = tp.getEditTree();
        MigrationWarnings migWarns = this.contr.getMigrationWarnings();
        if (migWarns == null) {
            return this.problems;
        }
        for (MigrationWarningIndexes mwi : migWarns.getWarningsList()) {
            Interval interval = MigrationHelpTool.convertGeneratedIntervalToInterval((int)mwi.generatedBeginIndex, (int)mwi.generatedEndIndex, (IEditTree)editTree);
            String fullCobol = tp.getText().subSequence(interval.begin, interval.end).toString();
            String controlGeneratedCobol = migWarns.getGeneratedControlText().subSequence(mwi.controlBeginIndex, mwi.controlEndIndex).toString();
            String generatedCobol = tp.getGeneratedInfo().getText().subSequence(mwi.generatedBeginIndex, mwi.generatedEndIndex).toString();
            MigrationHelpProblem mhp = new MigrationHelpProblem(fullCobol, generatedCobol, controlGeneratedCobol);
            this.problems.add(mhp);
        }
        return this.problems;
    }

    private boolean isMIA2MigrationHelpFile(RadicalEntity re) {
        PacDialog dialog;
        PacDialogTypeValues typeValue;
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            PacDialogTypeValues typeValue2 = screen.getDialogType();
            if (screen.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacGenerationHeader header;
                PacDialog dialog2 = screen.getDialog();
                if (dialog2 == null && (header = screen.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacScreen referencedScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)header).getGeneratedRadicalEntity();
                    dialog2 = referencedScreen.getDialog();
                }
                typeValue2 = dialog2.getDialogType();
            }
            if (typeValue2.equals(PacDialogTypeValues._NONE_LITERAL)) {
                return true;
            }
            return typeValue2.equals(PacDialogTypeValues._MW_LITERAL);
        }
        return re instanceof PacDialog && (typeValue = (dialog = (PacDialog)re).getDialogType()).equals(PacDialogTypeValues._NONE_LITERAL);
    }

    private boolean isMIA3MigrationHelpFile(RadicalEntity re) {
        if (re instanceof PacScreen) {
            PacScreen screen = (PacScreen)re;
            PacDialogTypeValues typeValue = screen.getDialogType();
            if (screen.getDialogType().equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacGenerationHeader header;
                PacDialog dialog = screen.getDialog();
                if (dialog == null && (header = screen.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
                    PacScreen referencedScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)header).getGeneratedRadicalEntity();
                    dialog = referencedScreen.getDialog();
                }
                typeValue = dialog.getDialogType();
            }
            if (typeValue.equals(PacDialogTypeValues._C_LITERAL) || typeValue.equals(PacDialogTypeValues._SC_LITERAL) || typeValue.equals(PacDialogTypeValues._MC_LITERAL)) {
                return true;
            }
        }
        return false;
    }

    private void addEntryPointAndGenerationOutput(IController controler, String _patternName) {
        String programCblFile = PacTool.getLogicalCobolFileNameFromDesign((RadicalEntity)this.re);
        ArrayList messages = new ArrayList();
        GenStatus currentStatus = new GenStatus(0, messages);
        ArrayList<GeneratedElement> generatedElements = new ArrayList<GeneratedElement>(2);
        ArrayList references = new ArrayList();
        GeneratedElement generatedElement = new GeneratedElement(null, references, (IResourceReference)new ResourceReference(programCblFile, ""));
        generatedElements.add(generatedElement);
        String designId = this.re.getDesignId(this.re.getProject());
        ResourceReference entryPoint = new ResourceReference(designId, this.re.getStateId());
        GenResult genResult = new GenResult((IGenStatus)currentStatus, _patternName, (IResourceReference)entryPoint, generatedElements, null);
        GenerationManager.normalizeGeneratedElements((IGenResult)genResult);
        String generationID = generatedElement.getId();
        ((GenerationLink)controler.getGenerationLink()).collectReferences((IGenResult)genResult, generationID);
        if (Util.isRPPInBatchMode()) {
            MigrationControlExtension.EntrypointGenCouple couple = new MigrationControlExtension.EntrypointGenCouple(programCblFile, designId, this.re.getStateId(), RELATION_CBL_ENTRYPOINT, _patternName);
            MigrationControlExtension.entryPoints_Generated_Couples.add(couple);
        }
    }

    public static void rebuildDifferenceBankFromWorkspace(IProgressMonitor monitor, String differenceBankFileName) {
        long comparisonTime = System.currentTimeMillis();
        List pdpFiles = PdpTool.findAllPDPFiles((IProgressMonitor)monitor);
        int size = pdpFiles.size();
        if (monitor != null) {
            monitor.beginTask("", size);
            monitor.setTaskName("Rebuild DifferenceBank.xml file");
        }
        int i = 0;
        int step = size / 100;
        if (step == 0) {
            step = size / 10;
        }
        if (step == 0) {
            step = 2;
        }
        DifferenceBank diffBank = new DifferenceBank();
        diffBank.setNbFiles(pdpFiles.size());
        for (IFile iFile : pdpFiles) {
            String localGeneratedCode;
            String pdpFileLocation;
            block25: {
                InputStream is;
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                if (monitor != null && i % step == 0) {
                    monitor.worked(step);
                }
                ++i;
                pdpFileLocation = iFile.getFullPath().toString();
                try {
                    is = iFile.getContents();
                }
                catch (CoreException e1) {
                    Util.rethrow((Throwable)e1);
                    return;
                }
                PDPXMLMigrationHelpLocalGeneratedCodeDeserializer deserializer = new PDPXMLMigrationHelpLocalGeneratedCodeDeserializer();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                XMLStreamReader xmlReader = null;
                localGeneratedCode = null;
                try {
                    try {
                        xmlReader = inputFactory.createXMLStreamReader(is);
                        localGeneratedCode = deserializer.deserializeLocalGeneratedCode(is, xmlReader);
                    }
                    catch (XMLStreamException f) {
                        Util.rethrow((Throwable)f);
                        if (xmlReader != null) {
                            try {
                                xmlReader.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (xmlReader != null) {
                    try {
                        xmlReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (localGeneratedCode == null) continue;
            String sourceFileLocation = PdpTool.computeSourceFileLocationFromPdpFileLocation((String)pdpFileLocation);
            IFile file1 = PdpTool.getFile((String)sourceFileLocation);
            String fileNamefullPath = file1.getLocation().toOSString();
            String controlCobol = PdpTool.readFileContents((String)fileNamefullPath);
            PacbaseCobolDifferencerWithSignificantDots differencer = new PacbaseCobolDifferencerWithSignificantDots(controlCobol, localGeneratedCode);
            DiffCursor cursor = differencer.newTokenDifferencesCursor();
            if (cursor.searchNextDifference()) {
                diffBank.setNbModifiedFiles(diffBank.getNbModifiedFiles() + 1);
            }
            if (cursor.hasFoundDifference()) {
                diffBank.appendDifference(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
            }
            while (cursor.searchNextDifference()) {
                diffBank.appendDifference(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
            }
        }
        MigrationControlExtension.saveDifferenceBank(diffBank, differenceBankFileName);
        comparisonTime = System.currentTimeMillis() - comparisonTime;
        System.out.println("MigrationHelp2:rebuildDifferenceBankFromWorkspace() :" + comparisonTime);
    }
}

