/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.pac.migration.help;

import com.ibm.pdp.cobolcompare.CobolDifferencer;
import com.ibm.pdp.cobolcompare.CobolToken;
import com.ibm.pdp.cobolcompare.DifferenceBank;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencer;
import com.ibm.pdp.cobolcompare.PacbaseCobolDifferencerWithSignificantDots;
import com.ibm.pdp.cobolcompare.Word;
import com.ibm.pdp.cobolcompare.WordDifference;
import com.ibm.pdp.cobolcompare.serialization.DifferenceBankDeserializer;
import com.ibm.pdp.cobolcompare.serialization.DifferenceBankSerializer;
import com.ibm.pdp.engine.IGeneratedInfo;
import com.ibm.pdp.engine.IGeneratedTag;
import com.ibm.pdp.engine.ITextProcessor;
import com.ibm.pdp.framework.Controller;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.MigrationHelpResult;
import com.ibm.pdp.framework.MigrationWarningIndexes;
import com.ibm.pdp.framework.MigrationWarnings;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IMigrationControlExtension;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.pac.migration.help.Messages;
import com.ibm.pdp.pac.migration.help.validation.CacheData;
import com.ibm.pdp.pac.migration.help.validation.MigrationHelpValidationTool;
import com.ibm.pdp.pac.migration.help.validation.SourceCodeMigrationDifferences;
import com.ibm.pdp.pac.migration.help.validation.Validation;
import com.ibm.pdp.pac.migration.help.validation.ValidationCache;
import com.ibm.pdp.pac.migration.help.validation.ValidationContoler;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.csv.CsvWriter;
import com.ibm.pdp.util.diff.DiffCursor;
import com.ibm.pdp.util.performance.PerformanceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class MigrationControlExtension
implements IMigrationControlExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2012, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean GENERATE_MIGRATION_GEN_INFO_CSV = "true".equals(System.getProperty("generateMigrationGenInfo"));
    public static String controlCobolFileName;
    public static boolean fromWizard;
    public static int constantsAndDatePref;
    public static char flowPosition;
    public static String reportFolder;
    public static char csvSep;
    public static char csvTextSep;
    public static boolean generateReport;
    public static String templatesFilterFile;
    public static boolean batchMode;
    public static List<EntrypointGenCouple> entryPoints_Generated_Couples;
    private static DifferenceBank diffBank;
    protected static int totalDiffCount;
    private static CsvWriter overview;
    private static CsvWriter templates;
    private static CsvWriter diffList;
    private static CsvWriter genInfoOverview;
    private static CsvWriter genInfoDiffList;
    private static CsvWriter genInfoSummary;
    protected static int totalGenInfoCount;
    protected static int totalModifiedGenInfoCount;
    protected static int totalGenInfoDiffCount;
    protected static int genInfoDiffCount;
    public static final String COBOL_COMPARISON_TOTAL_TIME = "COBOL_COMPARISON_TOTAL_TIME";
    public static final int MIGRATION_CONSTANTS_KEEP_LOCAL = 1;
    public static final int MIGRATION_CONSTANTS_KEEP_ORIGINAL = 2;
    public static final int MIGRATION_CONSTANTS_KEEP_ORIGINAL_AND_WARNING = 3;
    public static final String CONSTANTES = "CONSTANTES";
    public static final String DATE_COMPILED = "DATE-COMPILED";
    public static final String FOLDER_DIFFERENCE_BANK = ".metadata/";
    public static final String FILE_DIFFERENCE_BANK = "DifferenceBank.xml";
    public static final String COLUMN_TITLE_DELETED_NB = "Deleted#";
    public static final String COLUMN_TITLE_ADDED_NB = "Added#";
    public static final String COLUMN_TITLE_DELETED = "Deleted";
    public static final String COLUMN_TITLE_ADDED = "Added";
    protected static boolean addTemplateHashCode;
    protected static final CobolToken PROCEDURE_TOKEN;
    protected static final CobolToken DIVISION_TOKEN;

    static {
        totalDiffCount = 0;
        totalGenInfoCount = 0;
        totalModifiedGenInfoCount = 0;
        totalGenInfoDiffCount = 0;
        genInfoDiffCount = 0;
        addTemplateHashCode = false;
        addTemplateHashCode = "true".equals(System.getProperty("addTemplateHashCode"));
        PROCEDURE_TOKEN = new CobolToken(1, (CharSequence)"PROCEDURE");
        DIVISION_TOKEN = new CobolToken(1, (CharSequence)"DIVISION");
    }

    public static DifferenceBank getDiffBank() {
        return diffBank;
    }

    public MigrationHelpResult postGenerationMigrationControl(IController contr, CharSequence referenceText, CharSequence newGeneratedText, IGeneratedInfo localGeneratedInfo) throws Exception {
        if (controlCobolFileName != null) {
            return MigrationControlExtension.processMigrationControl2(contr, localGeneratedInfo, referenceText, newGeneratedText, controlCobolFileName, fromWizard, constantsAndDatePref, flowPosition, reportFolder, csvSep, csvTextSep, generateReport, templatesFilterFile);
        }
        MigrationHelpResult mhResult = new MigrationHelpResult();
        MigrationWarnings warnings = ((Controller)contr).getMigrationWarnings();
        if (warnings != null) {
            CharSequence controlCobol = referenceText;
            int datePref = warnings.getDateAndConstantsChoice();
            if (controlCobol != null && controlCobol.length() != 0) {
                mhResult = MigrationControlExtension.processMigrationControl2(contr, localGeneratedInfo, controlCobol, newGeneratedText, "", false, datePref, ' ', null, ' ', ' ', false, templatesFilterFile);
                if (((Controller)contr).getMigrationWarnings() == null) {
                    IFile file = PdpTool.getFile((String)contr.getResourceName());
                    try {
                        file.deleteMarkers("com.ibm.pdp.pac.migration.marker", false, 2);
                    }
                    catch (CoreException coreException) {
                        mhResult.setStatus(false);
                    }
                }
            }
        }
        return mhResult;
    }

    public boolean isMigrationControlActivated(IController contr) {
        MigrationWarnings warnings = ((Controller)contr).getMigrationWarnings();
        return warnings != null;
    }

    public static MigrationHelpResult processMigrationControl2(IController controler, IGeneratedInfo localGeneratedInfo, CharSequence controlCobol, CharSequence newGeneratedText, String controlCobolFileName, boolean fromWizard, int constantsAndDatePref, char flowPosition, String reportFolder, char csvSep, char csvTextSep, boolean generateReport, String templatesFilterFile) throws Exception {
        boolean isInProcedure;
        Controller control;
        MigrationWarnings migrationWarnings;
        MigrationControlExtension.loadDifferenceBank(flowPosition);
        MigrationControlExtension.updateDifferenceBank(templatesFilterFile, csvSep, csvTextSep);
        MigrationControlExtension.initGenInfoCounts(flowPosition);
        MigrationControlExtension.createAllCsvWriters(reportFolder, csvSep, csvTextSep, generateReport, flowPosition);
        if (controler == null) {
            MigrationControlExtension.writeTemplates(controlCobolFileName);
            MigrationControlExtension.writeGenInfoSummary();
            if (overview != null) {
                overview.close();
            }
            if (diffList != null) {
                diffList.close();
            }
            if (genInfoDiffList != null) {
                genInfoDiffList.close();
            }
            if (genInfoOverview != null) {
                genInfoOverview.close();
            }
            MigrationControlExtension.saveDifferenceBank(flowPosition);
            MigrationHelpResult result = new MigrationHelpResult();
            result.setStatus(false);
            return result;
        }
        if (generateReport) {
            diffBank.setNbFiles(diffBank.getNbFiles() + 1);
        }
        long comparisonTime = System.currentTimeMillis();
        PacbaseCobolDifferencerWithSignificantDots differencer = new PacbaseCobolDifferencerWithSignificantDots(controlCobol.toString(), newGeneratedText.toString());
        int procedureDivisionFirstTokenRank = MigrationControlExtension.procedureDivisionFirstTokenRank((PacbaseCobolDifferencer)differencer);
        DiffCursor cursor = differencer.newTokenDifferencesCursor();
        int diffCount = 0;
        int procedureDiffCount = 0;
        int initialNbModifiedFilesWithFilter = diffBank.getNbModifiedFilesWithFilter();
        if (cursor.searchNextDifference() && generateReport) {
            diffBank.setNbModifiedFiles(diffBank.getNbModifiedFiles() + 1);
        }
        if ((migrationWarnings = (control = (Controller)controler).getMigrationWarnings()) == null) {
            migrationWarnings = new MigrationWarnings(controlCobol.toString());
            migrationWarnings.setGeneratedText(newGeneratedText.toString());
            control.setMigrationWarnings(migrationWarnings);
        } else {
            migrationWarnings.getWarningsList().clear();
            migrationWarnings.setGeneratedText(newGeneratedText.toString());
        }
        String rightFileName = "RPP cobol after generation";
        if (cursor.hasFoundDifference()) {
            diffBank.appendDifference(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
            boolean bl = isInProcedure = cursor.getReferenceEndIndex() >= procedureDivisionFirstTokenRank;
            if (isInProcedure) {
                ++procedureDiffCount;
            }
            MigrationControlExtension.manageTokenDifference(++diffCount, controlCobolFileName, rightFileName, (PacbaseCobolDifferencer)differencer, cursor, isInProcedure, migrationWarnings, initialNbModifiedFilesWithFilter);
        }
        while (cursor.searchNextDifference()) {
            diffBank.appendDifference(differencer.getReferenceTokens(), cursor, differencer.getModifiedTokens());
            boolean bl = isInProcedure = cursor.getReferenceEndIndex() >= procedureDivisionFirstTokenRank;
            if (isInProcedure) {
                ++procedureDiffCount;
            }
            MigrationControlExtension.manageTokenDifference(++diffCount, controlCobolFileName, rightFileName, (PacbaseCobolDifferencer)differencer, cursor, isInProcedure, migrationWarnings, initialNbModifiedFilesWithFilter);
        }
        comparisonTime = System.currentTimeMillis() - comparisonTime;
        PerformanceManager.getInstance().addTotalTimeMillis(COBOL_COMPARISON_TOTAL_TIME, comparisonTime);
        diffBank.setComparisonTotalTime(diffBank.getComparisonTotalTime() + comparisonTime);
        diffBank.updateTimeForCobol(controlCobolFileName, Long.valueOf(comparisonTime));
        MigrationHelpResult mhResult = new MigrationHelpResult();
        mhResult.setStatus(true);
        if (migrationWarnings.getWarningsList().size() == 0) {
            control.setMigrationWarnings(null);
            control.setGenInfoForMigration(null);
        } else if (batchMode && ValidationContoler.validation != null && ValidationContoler.validation.getValidationTypes().size() != 0) {
            if (Util.isEnableCobolValComparison()) {
                GenerationManager.saveCOBOLfileForComparison((IController)control, (String)newGeneratedText.toString(), (String)".before.val");
            }
            MigrationControlExtension.applyValidationTypes(control, mhResult, flowPosition);
        }
        if (flowPosition == 'E' || flowPosition == ' ') {
            ValidationCache cache = ValidationCache.getCache();
            if (cache != null) {
                cache.setState(1);
            }
            ValidationContoler.closeLog();
        }
        if (overview != null) {
            if (!addTemplateHashCode) {
                overview.addIntegerCell(diffBank.getNbFiles()).addCell(controlCobolFileName).addCell(rightFileName).addIntegerCell(diffCount).addIntegerCell(procedureDiffCount).addTextCell(differencer.getReferencePacbaseConstants()).addTextCell(differencer.getModifiedPacbaseConstants()).endOfRow();
            } else {
                overview.addIntegerCell(diffBank.getNbFiles()).addCell(controlCobolFileName).addCell(rightFileName).addIntegerCell(diffCount).addIntegerCell(procedureDiffCount).addTextCell(differencer.getReferencePacbaseConstants()).addTextCell(differencer.getModifiedPacbaseConstants()).addTextCell("design=" + controler.getDesignLink().getFileId()).endOfRow();
            }
        }
        MigrationControlExtension.writeTemplates(null);
        if (overview != null) {
            overview.close();
        }
        if (diffList != null) {
            diffList.close();
        }
        MigrationControlExtension.saveDifferenceBank(flowPosition);
        if (generateReport) {
            MigrationControlExtension.compareGeneratedInfos(controler.getTextProcessor().getGeneratedInfo(), localGeneratedInfo, controlCobolFileName);
            if (genInfoDiffList != null) {
                genInfoDiffList.close();
            }
            if (genInfoOverview != null) {
                genInfoOverview.close();
            }
            MigrationControlExtension.writeGenInfoSummary();
        }
        return mhResult;
    }

    private static String applyValidationTypes(Controller controller, MigrationHelpResult mhResult, char flowPosition) {
        String newGeneratedCode;
        String pdpFileLocation;
        ValidationCache cache;
        String mergedCode;
        CacheData cd;
        block7: {
            MigrationWarnings warnings;
            block6: {
                block5: {
                    cd = null;
                    mergedCode = null;
                    try {
                        cache = ValidationCache.getCache();
                        cache.initializeTemplates();
                        SourceCodeMigrationDifferences sourceDifferences = new SourceCodeMigrationDifferences(controller);
                        String sourceFileLocation = controller.getResourceName();
                        pdpFileLocation = PdpTool.computePdpFileLocationFromSourceFileLocation((String)sourceFileLocation);
                        cd = ValidationContoler.applyMigrationType(sourceDifferences, cache, sourceFileLocation, pdpFileLocation, controller.getDesignLink().getFileId(), true);
                        if (cd.getFilteredMigrationWarningNumber() == 0) break block5;
                        return null;
                    }
                    catch (Throwable th) {
                        ValidationContoler.log(4, String.valueOf(Messages.MigrationControlExtension_validation_exception) + controller.getResourceName(), th);
                        return null;
                    }
                }
                warnings = controller.getMigrationWarnings();
                if (warnings != null) break block6;
                return null;
            }
            newGeneratedCode = warnings.getGeneratedControlText();
            if (newGeneratedCode != null) break block7;
            return null;
        }
        ITextProcessor tp = controller.getTextProcessor();
        CharSequence specificCode = tp.getText();
        mergedCode = MigrationHelpValidationTool.automaticallyReportMigrationChoices(newGeneratedCode, specificCode, controller).toString();
        mhResult.setNewFullCode(mergedCode);
        cache.getPdpFilesToValidate().remove(pdpFileLocation);
        controller.setMigrationWarnings(null);
        MigrationControlExtension.logValidation(cd);
        return mergedCode;
    }

    private static void logValidation(CacheData cd) {
        if (cd == null) {
            return;
        }
        StringBuilder s = new StringBuilder(String.valueOf(Messages.MigrationControlExtension_validation_successfull) + cd.getDesignName());
        s.append(" - ");
        s.append(cd.getGeneratedProductFullName());
        s.append(" - ");
        int[] validationTypes = cd.getFilteredValidationTypes();
        int i = 0;
        while (i < validationTypes.length) {
            s.append(validationTypes[i]);
            s.append(" ");
            ++i;
        }
        ValidationContoler.log(1, s.toString());
    }

    private static void updateDifferenceBank(String templatesFilterFile2, char csvSep, char csvTextSep) {
        if (templatesFilterFile2 == null || templatesFilterFile2.trim().length() == 0) {
            return;
        }
        File file = new File(templatesFilterFile2);
        if (!file.exists()) {
            System.err.println("The file " + templatesFilterFile2 + " does not exist.");
            return;
        }
        List<String> lines = null;
        try {
            lines = MigrationControlExtension.readFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.rethrow((Throwable)e);
        }
        MigrationControlExtension.decodeTemplates(lines, diffBank, csvSep, csvTextSep);
    }

    private static void compareGeneratedInfos(IGeneratedInfo generatedInfo, IGeneratedInfo localGeneratedInfo, String controlCobolFileName2) {
        if (!GENERATE_MIGRATION_GEN_INFO_CSV) {
            return;
        }
        genInfoDiffCount = 0;
        IGeneratedTag localRootTag = localGeneratedInfo.getRootTag();
        LinkedList<IGeneratedTag> localTags = new LinkedList<IGeneratedTag>();
        MigrationControlExtension.populateListFromTags(localRootTag, localTags);
        LinkedList<IGeneratedTag> localTags2 = new LinkedList<IGeneratedTag>();
        Iterator iter = localTags.iterator();
        while (iter.hasNext()) {
            localTags2.add((IGeneratedTag)iter.next());
        }
        HashSet<IGeneratedTag> tagsDeletedInLocal = new HashSet<IGeneratedTag>();
        HashSet<IGeneratedTag> tagsInsertedInLocal = new HashSet<IGeneratedTag>();
        MigrationControlExtension.compareInsertedAndRemovedGeneratedNodes(generatedInfo.getRootTag(), localTags, null, controlCobolFileName2, tagsDeletedInLocal);
        ListIterator localTagsIter = localTags.listIterator();
        while (localTagsIter.hasNext()) {
            IGeneratedTag localTag = (IGeneratedTag)localTagsIter.next();
            genInfoDiffList.addIntegerCell(++totalGenInfoDiffCount).addIntegerCell(++genInfoDiffCount).addCell(controlCobolFileName2).addCell("").addCell(localTag.getName()).addCell("").addCell("").endOfRow();
            tagsInsertedInLocal.add(localTag);
        }
        MigrationControlExtension.compareMovedNodesAndContentGeneratedNodes(generatedInfo.getRootTag(), localTags2, null, controlCobolFileName2, tagsInsertedInLocal, tagsDeletedInLocal);
        genInfoOverview.addIntegerCell(++totalGenInfoCount).addIntegerCell(genInfoDiffCount).addCell(controlCobolFileName2).endOfRow();
        if (genInfoDiffCount != 0) {
            ++totalModifiedGenInfoCount;
        }
    }

    private static ListIterator<IGeneratedTag> compareMovedNodesAndContentGeneratedNodes(IGeneratedTag tag, LinkedList<IGeneratedTag> list, ListIterator<IGeneratedTag> listIter, String controlCobolFileName2, HashSet<IGeneratedTag> tagsInsertedInLocal, HashSet<IGeneratedTag> tagsDeletedInLocal) {
        int nbSons;
        if (listIter == null) {
            listIter = list.listIterator();
        }
        boolean sameTagFound = false;
        boolean atFirstPosition = true;
        while (listIter.hasNext()) {
            IGeneratedTag localGeneratedTag = (IGeneratedTag)listIter.next();
            if (localGeneratedTag.getName().equals(tag.getName())) {
                MigrationControlExtension.compareTags(tag, localGeneratedTag, tagsInsertedInLocal, tagsDeletedInLocal, controlCobolFileName2);
                listIter.remove();
                sameTagFound = true;
                break;
            }
            atFirstPosition = false;
        }
        if (!sameTagFound || !atFirstPosition) {
            listIter = null;
        }
        if ((nbSons = tag.nbOfSons()) != 0) {
            Iterator sons = tag.sons();
            while (sons.hasNext()) {
                IGeneratedTag son = (IGeneratedTag)sons.next();
                listIter = MigrationControlExtension.compareMovedNodesAndContentGeneratedNodes(son, list, listIter, controlCobolFileName2, tagsInsertedInLocal, tagsDeletedInLocal);
            }
        }
        return listIter;
    }

    private static void compareTags(IGeneratedTag tag, IGeneratedTag localGeneratedTag, HashSet<IGeneratedTag> tagsInsertedInLocal, HashSet<IGeneratedTag> tagsDeletedInLocal, String controlCobolFileName2) {
        if (tag.getName().equals("CONSTANTS")) {
            return;
        }
        String contentTag = MigrationControlExtension.buildContentForTag(tag, tagsDeletedInLocal);
        String contentLocalTag = MigrationControlExtension.buildContentForTag(localGeneratedTag, tagsInsertedInLocal);
        CobolDifferencer diff = new CobolDifferencer(contentTag, contentLocalTag);
        DiffCursor diffCursor = diff.newCharDifferencesCursor();
        diffCursor.searchNextDifference();
        while (diffCursor.hasFoundDifference()) {
            int refBeginIndex = diffCursor.getReferenceBeginIndex();
            int refEndIndex = diffCursor.getReferenceEndIndex();
            int modifiedBeginIndex = diffCursor.getModifiedBeginIndex();
            int modifiedEndIndex = diffCursor.getModifiedEndIndex();
            String referenceText = MigrationControlExtension.extractTenLines(contentTag, refBeginIndex, refEndIndex);
            String modifiedText = MigrationControlExtension.extractTenLines(contentLocalTag, modifiedBeginIndex, modifiedEndIndex);
            genInfoDiffList.addIntegerCell(++totalGenInfoDiffCount).addIntegerCell(++genInfoDiffCount).addCell(controlCobolFileName2).addCell(tag.getName()).addCell(localGeneratedTag.getName()).addCell(referenceText).addCell(modifiedText).endOfRow();
            diffCursor.searchNextDifference();
        }
    }

    private static String extractTenLines(String content, int beginIndex, int endIndex) {
        try {
            int newLineIndex = content.indexOf("\n", beginIndex);
            if (newLineIndex == -1 || newLineIndex >= endIndex) {
                return content.substring(beginIndex, endIndex);
            }
            int newLineCount = 1;
            newLineIndex = content.indexOf("\n", newLineIndex + 1);
            while (newLineIndex >= 0 && newLineIndex < endIndex && newLineCount < 5) {
                ++newLineCount;
                newLineIndex = content.indexOf("\n", newLineIndex + 1);
            }
            if (newLineCount < 5 || newLineIndex == -1) {
                return content.substring(beginIndex, endIndex);
            }
            newLineCount = 0;
            int lastNewLineIndexFromBeginning = newLineIndex;
            newLineIndex = content.lastIndexOf("\n", endIndex);
            while (newLineIndex >= 0 && newLineIndex > lastNewLineIndexFromBeginning && newLineCount < 5) {
                ++newLineCount;
                newLineIndex = content.lastIndexOf("\n", newLineIndex - 1);
            }
            if (newLineIndex <= lastNewLineIndexFromBeginning) {
                return content.substring(beginIndex, endIndex);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(content.subSequence(beginIndex, lastNewLineIndexFromBeginning + 1));
            sb.append("...\n");
            sb.append(content.subSequence(newLineIndex + 1, endIndex));
            return sb.toString();
        }
        catch (Throwable throwable) {
            return ".........";
        }
    }

    private static String buildContentForTag(IGeneratedTag tag, HashSet<IGeneratedTag> tagsNotEquals) {
        CharSequence text = tag.getGeneratedInfo().getText();
        StringBuilder textToBuild = new StringBuilder();
        int beginIndex = tag.getBeginIndex();
        Iterator sons = tag.sons();
        while (sons.hasNext()) {
            IGeneratedTag son = (IGeneratedTag)sons.next();
            int endIndex = son.getBeginIndex();
            if (beginIndex != endIndex) {
                textToBuild.append(text.subSequence(beginIndex, endIndex));
            }
            if (!tagsNotEquals.contains(son)) {
                textToBuild.append("       <" + son.getName() + ">\n");
            } else {
                textToBuild.append(MigrationControlExtension.buildContentForTag(son, tagsNotEquals));
            }
            beginIndex = son.getEndIndex();
        }
        if (beginIndex != tag.getEndIndex()) {
            textToBuild.append(text.subSequence(beginIndex, tag.getEndIndex()));
        }
        return textToBuild.toString();
    }

    private static void populateListFromTags(IGeneratedTag tag, List<IGeneratedTag> list) {
        list.add(tag);
        int nbSons = tag.nbOfSons();
        if (nbSons != 0) {
            Iterator sons = tag.sons();
            while (sons.hasNext()) {
                IGeneratedTag son = (IGeneratedTag)sons.next();
                MigrationControlExtension.populateListFromTags(son, list);
            }
        }
    }

    private static ListIterator<IGeneratedTag> compareInsertedAndRemovedGeneratedNodes(IGeneratedTag tag, LinkedList<IGeneratedTag> list, ListIterator<IGeneratedTag> listIter, String controlCobolFileName2, HashSet<IGeneratedTag> tagsDeletedInLocal) {
        int nbSons;
        if (listIter == null) {
            listIter = list.listIterator();
        }
        boolean sameTagFound = false;
        boolean atFirstPosition = true;
        while (listIter.hasNext()) {
            IGeneratedTag localGeneratedTag = (IGeneratedTag)listIter.next();
            if (localGeneratedTag.getName().equals(tag.getName())) {
                listIter.remove();
                sameTagFound = true;
                break;
            }
            atFirstPosition = false;
        }
        if (!sameTagFound || !atFirstPosition) {
            listIter = null;
        }
        if (!sameTagFound) {
            genInfoDiffList.addIntegerCell(++totalGenInfoDiffCount).addIntegerCell(++genInfoDiffCount).addCell(controlCobolFileName2).addCell(tag.getName()).addCell("").addCell("").addCell("").endOfRow();
            tagsDeletedInLocal.add(tag);
        }
        if ((nbSons = tag.nbOfSons()) != 0) {
            Iterator sons = tag.sons();
            while (sons.hasNext()) {
                IGeneratedTag son = (IGeneratedTag)sons.next();
                listIter = MigrationControlExtension.compareInsertedAndRemovedGeneratedNodes(son, list, listIter, controlCobolFileName2, tagsDeletedInLocal);
            }
        }
        return listIter;
    }

    private static void writeGenInfoSummary() {
        if (!GENERATE_MIGRATION_GEN_INFO_CSV) {
            return;
        }
        if (genInfoSummary == null) {
            return;
        }
        genInfoSummary.appendTextToCell("Number of generated info = ").appendIntegerToCell(totalGenInfoCount).endOfRow();
        genInfoSummary.appendTextToCell("Number of modified generated info = ").appendIntegerToCell(totalModifiedGenInfoCount).endOfRow();
        genInfoSummary.appendTextToCell("Number of differences = ").appendIntegerToCell(totalGenInfoDiffCount).endOfRow();
        genInfoSummary.endOfRow();
        genInfoSummary.close();
    }

    private static void initGenInfoCounts(char flowPosition2) {
        if (!GENERATE_MIGRATION_GEN_INFO_CSV) {
            return;
        }
        if (flowPosition == 'B') {
            totalGenInfoCount = 0;
            totalGenInfoDiffCount = 0;
            totalModifiedGenInfoCount = 0;
        }
    }

    private static void saveDifferenceBank(char flowPosition) {
        if (flowPosition == ' ' || flowPosition == 'E') {
            MigrationControlExtension.saveDifferenceBank(diffBank, null);
            if (Util.isRPPInBatchMode() && flowPosition == 'E') {
                MigrationControlExtension.recordEntryPointsInLucene();
            }
        }
    }

    static void saveDifferenceBank(DifferenceBank differenceBank, String differenceBankFileName) {
        if (differenceBankFileName == null || differenceBankFileName.trim().length() == 0) {
            differenceBankFileName = MigrationControlExtension.getDiffBankFileName();
        }
        DifferenceBankSerializer x = new DifferenceBankSerializer();
        x.serialize(differenceBank, differenceBankFileName);
        diffBank = null;
    }

    private static Reference getReference(String entryPoint, String sourceId, String stateID, String relationName, String patternName) {
        Reference aRef = MetaFactory.eINSTANCE.createReference();
        aRef.setSourceId(sourceId);
        aRef.setTargetId(entryPoint);
        aRef.setStateId(stateID);
        aRef.setRelation(relationName);
        Property prop = MetaFactory.eINSTANCE.createProperty();
        prop.setName("pattern");
        prop.setValue(patternName);
        aRef.getProperties().add(prop);
        return aRef;
    }

    private static Document getDocument(String generatedFileName) {
        Document doc = MetaFactory.eINSTANCE.getDocument(generatedFileName, true, true);
        return doc;
    }

    private static void recordEntryPointsInLucene() {
        if (!Util.isRPPInBatchMode()) {
            return;
        }
        MetadataAccess metadataAccess = MetadataAccess.getMetadataAccess();
        HashMap<String, Document> documents = new HashMap<String, Document>();
        HashMap entryPoints = new HashMap();
        for (EntrypointGenCouple x : entryPoints_Generated_Couples) {
            Document doc = MigrationControlExtension.getDocument(x.getGenFileLogicalName());
            Reference aRef = MigrationControlExtension.getReference(x.getEntryPointLogicalName(), x.getGenFileLogicalName(), x.getStateID(), x.getRelation(), x.getPatternName());
            documents.put(x.getGenFileLogicalName(), doc);
            ArrayList<Reference> aList = new ArrayList<Reference>();
            aList.add(aRef);
            entryPoints.put(x.getGenFileLogicalName(), aList);
        }
        metadataAccess.deleteDocuments(documents.keySet());
        metadataAccess.writeDocuments(PdpResourcesMgr.PUBLIC_GENERATION_CAT_SET, new ArrayList(documents.values()));
        metadataAccess.deleteReferences(documents.keySet());
        metadataAccess.writeReferences(PdpResourcesMgr.PUBLIC_ENTRYPOINT_CAT_SET, entryPoints);
    }

    private static void writeTemplates(String controlCobolFileName) {
        MigrationControlExtension.showHeader(templates, controlCobolFileName);
        if (templates != null) {
            if (addTemplateHashCode) {
                templates.addCell("Template").addCell("Occurs").addCell("Nature").addCell(COLUMN_TITLE_DELETED_NB).addCell(COLUMN_TITLE_ADDED_NB).addCell("HashCode").addCell(COLUMN_TITLE_DELETED).addCell(COLUMN_TITLE_ADDED).endOfRow();
            } else {
                templates.addCell("Template").addCell("Occurs").addCell("Nature").addCell(COLUMN_TITLE_DELETED_NB).addCell(COLUMN_TITLE_ADDED_NB).addCell(COLUMN_TITLE_DELETED).addCell(COLUMN_TITLE_ADDED).endOfRow();
            }
            WordDifference[] differences = new WordDifference[diffBank.size()];
            diffBank.copyDifferencesTo(differences, false);
            WordDifference[] wordDifferenceArray = differences;
            int n = differences.length;
            int n2 = 0;
            while (n2 < n) {
                WordDifference diff = wordDifferenceArray[n2];
                templates.addIntegerCell(1 + diff.getRank()).addIntegerCell(diff.getOccurrenceCount()).addCell(diff.getDifferenceNature().toString()).addIntegerCell(diff.deletedWordsCount()).addIntegerCell(diff.addedWordsCount());
                if (addTemplateHashCode) {
                    templates.addIntegerCell(new Integer(diff.getHashCode()).intValue());
                }
                MigrationControlExtension.catenateWords(templates, diff.deletedWords()).endOfCell();
                MigrationControlExtension.catenateWords(templates, diff.addedWords()).endOfRow();
                ++n2;
            }
            templates.close();
        }
    }

    private static void createAllCsvWriters(String reportFolder, char csvSep, char csvTextSep, boolean generateReport, char flowPosition) throws IOException {
        boolean isFileExists;
        String genInfoSummaryFileName;
        String genInfoDiffListFilename;
        String genInfoOverviewFilename;
        String diffListFilename;
        String templatesFilename;
        String overviewFilename;
        overview = null;
        templates = null;
        diffList = null;
        genInfoOverview = null;
        genInfoDiffList = null;
        genInfoSummary = null;
        if (!generateReport) {
            return;
        }
        if (reportFolder == null || reportFolder.length() == 0) {
            overviewFilename = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationControlOverview.csv";
            templatesFilename = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationTemplates.csv";
            diffListFilename = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationDiffList.csv";
            genInfoOverviewFilename = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationGenInfoOverview.csv";
            genInfoDiffListFilename = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationGenInfoDiffList.csv";
            genInfoSummaryFileName = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + "MigrationGenInfoSummary.csv";
        } else {
            overviewFilename = String.valueOf(reportFolder) + "/" + "MigrationControlOverview.csv";
            templatesFilename = String.valueOf(reportFolder) + "/" + "MigrationTemplates.csv";
            diffListFilename = String.valueOf(reportFolder) + "/" + "MigrationDiffList.csv";
            genInfoOverviewFilename = String.valueOf(reportFolder) + "/" + "MigrationGenInfoOverview.csv";
            genInfoDiffListFilename = String.valueOf(reportFolder) + "/" + "MigrationGenInfoDiffList.csv";
            genInfoSummaryFileName = String.valueOf(reportFolder) + "/" + "MigrationGenInfoSummary.csv";
        }
        if (flowPosition == 'B' || flowPosition == 'S') {
            templatesFilename = null;
            genInfoSummaryFileName = null;
        }
        if (!(isFileExists = new File(overviewFilename).exists()) && new File(overviewFilename).getParentFile() != null) {
            new File(overviewFilename).getParentFile().mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(overviewFilename, isFileExists);
            overview = new CsvWriter((Writer)writer, csvSep, csvTextSep);
            if (!isFileExists) {
                if (addTemplateHashCode) {
                    overview.addCell("Line").addCell("Left").addCell("Right").addCell("Diff#").addCell("Procedure").addCell("LeftPacConstants").addCell("RightPacConstants").addCell("Design").endOfRow();
                } else {
                    overview.addCell("Line").addCell("Left").addCell("Right").addCell("Diff#").addCell("Procedure").addCell("LeftPacConstants").addCell("RightPacConstants").endOfRow();
                }
            }
            if (templatesFilename != null) {
                writer = new FileWriter(templatesFilename, false);
                templates = new CsvWriter((Writer)writer, csvSep, csvTextSep);
            }
            writer = new FileWriter(diffListFilename, isFileExists);
            diffList = new CsvWriter((Writer)writer, csvSep, csvTextSep);
            if (!isFileExists) {
                diffList.addCell("Line").addCell("Diff").addCell("Template").addCell("Procedure").addCell("Left").addCell("Right").addCell("Left Text").addCell("Right Text").endOfRow();
            }
            if (GENERATE_MIGRATION_GEN_INFO_CSV) {
                writer = new FileWriter(genInfoOverviewFilename, isFileExists);
                genInfoOverview = new CsvWriter((Writer)writer, csvSep, csvTextSep);
                if (!isFileExists) {
                    genInfoOverview.addCell("Line").addCell("Diff Count").addCell("Cobol").endOfRow();
                }
                writer = new FileWriter(genInfoDiffListFilename, isFileExists);
                genInfoDiffList = new CsvWriter((Writer)writer, csvSep, csvTextSep);
                if (!isFileExists) {
                    genInfoDiffList.addCell("Line").addCell("Diff").addCell("Cobol").addCell("Control Tag").addCell("Local Tag").addCell("Control Text").addCell("Local Text").endOfRow();
                }
                if (genInfoSummaryFileName != null) {
                    writer = new FileWriter(genInfoSummaryFileName, false);
                    genInfoSummary = new CsvWriter((Writer)writer, csvSep, csvTextSep);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw Util.rethrow((Throwable)fnfe);
        }
    }

    private static void loadDifferenceBank(char flowPosition) {
        if (flowPosition == ' ' || flowPosition == 'B' || diffBank == null) {
            MigrationControlExtension.loadDifferenceBankFromDisk();
        }
    }

    public static DifferenceBank loadDifferenceBankFromDisk() {
        String differenceBankFileName = MigrationControlExtension.getDiffBankFileName();
        File file = new File(differenceBankFileName);
        if (file.exists()) {
            DifferenceBankDeserializer difBankDeserializer = new DifferenceBankDeserializer();
            try {
                DifferenceBank db = difBankDeserializer.deserialize((InputStream)new FileInputStream(file));
                totalDiffCount = db != null ? db.occurrences() : 0;
                diffBank = db;
                return db;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        diffBank = new DifferenceBank();
        totalDiffCount = 0;
        return diffBank;
    }

    protected static int procedureDivisionFirstTokenRank(PacbaseCobolDifferencer differencer) {
        CobolToken[] refTokens = differencer.getReferenceTokens();
        int rank = 0;
        int max = refTokens.length - 1;
        while (rank < max) {
            if (refTokens[rank].equals((Object)PROCEDURE_TOKEN) && refTokens[rank + 1].equals((Object)DIVISION_TOKEN)) {
                return rank + 2;
            }
            ++rank;
        }
        return refTokens.length;
    }

    protected static void manageTokenDifference(int count, String leftFileName, String rightFileName, PacbaseCobolDifferencer differencer, DiffCursor cursor, boolean isInProcedure, MigrationWarnings migrationWarnings, int initialNbDifferencesWithFilter) {
        ++totalDiffCount;
        String leftCobol = differencer.getReferenceCobol();
        int[] leftLineStartIndexes = differencer.getReferenceLineIndexes();
        CobolToken[] leftTokens = differencer.getReferenceTokens();
        String rightCobol = differencer.getModifiedCobol();
        int[] rightLineStartIndexes = differencer.getModifiedLineIndexes();
        CobolToken[] rightTokens = differencer.getModifiedTokens();
        WordDifference template = diffBank.getDifference(leftTokens, cursor, rightTokens);
        String strTemplate = template != null ? String.valueOf(1 + template.getRank()) : "";
        String strTemplateAndHashCode = null;
        if ("true".equals(System.getProperty("showHashCode"))) {
            String string = strTemplateAndHashCode = template != null ? String.valueOf(strTemplate) + " " + String.valueOf(template.getHashCode()) : strTemplate;
        }
        if (!diffBank.isFilteredTemplate(template, csvTextSep)) {
            if (initialNbDifferencesWithFilter == diffBank.getNbModifiedFilesWithFilter()) {
                diffBank.setNbModifiedFilesWithFilter(diffBank.getNbModifiedFilesWithFilter() + 1);
            }
            diffBank.setNbDifferencesWithFilter(diffBank.getNbDifferencesWithFilter() + 1);
        }
        int leftBeginLineRank = MigrationControlExtension.refBeginLineRank(differencer, cursor);
        int leftEndLineRank = MigrationControlExtension.refEndLineRank(differencer, cursor);
        int rightBeginLineRank = MigrationControlExtension.modBeginLineRank(differencer, cursor);
        int rightEndLineRank = MigrationControlExtension.modEndLineRank(differencer, cursor);
        if (diffList != null) {
            String strProcedure = isInProcedure ? "Procedure" : "";
            diffList.addIntegerCell(totalDiffCount).addIntegerCell(count).addCell(strTemplate).addCell(strProcedure).addCell(leftFileName).addCell(rightFileName);
            MigrationControlExtension.appendCobol(diffList, leftFileName, leftCobol, leftLineStartIndexes, leftBeginLineRank, leftEndLineRank).endOfCell();
            MigrationControlExtension.appendCobol(diffList, rightFileName, rightCobol, rightLineStartIndexes, rightBeginLineRank, rightEndLineRank).endOfRow();
        }
        int nodeGeneratedTextStop = MigrationControlExtension.beforeLineFeed(rightCobol, MigrationControlExtension.endOfLine(rightCobol, rightLineStartIndexes, rightEndLineRank));
        int nodeGeneratedTextStart = MigrationControlExtension.beginingOfLine(rightCobol, rightLineStartIndexes, rightBeginLineRank);
        nodeGeneratedTextStart = MigrationControlExtension.extendBeginIndex(rightCobol, nodeGeneratedTextStart, nodeGeneratedTextStop, rightLineStartIndexes, rightBeginLineRank, rightEndLineRank);
        int lightNodeGeneratedTextStop = MigrationControlExtension.beforeLineFeed(leftCobol, MigrationControlExtension.endOfLine(leftCobol, leftLineStartIndexes, leftEndLineRank));
        int lightNodeGeneratedTextStart = MigrationControlExtension.beginingOfLine(leftCobol, leftLineStartIndexes, leftBeginLineRank);
        lightNodeGeneratedTextStart = MigrationControlExtension.extendBeginIndex(leftCobol, lightNodeGeneratedTextStart, lightNodeGeneratedTextStop, leftLineStartIndexes, leftBeginLineRank, leftEndLineRank);
        String hashCodeTemplate = template == null ? null : String.valueOf(template.getHashCode());
        MigrationWarningIndexes indexes = new MigrationWarningIndexes(nodeGeneratedTextStart, nodeGeneratedTextStop, lightNodeGeneratedTextStart, lightNodeGeneratedTextStop, strTemplateAndHashCode == null ? strTemplate : strTemplateAndHashCode, hashCodeTemplate);
        migrationWarnings.getWarningsList().add(indexes);
    }

    protected static int refBeginLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        int refBeginTokenRank = cursor.getReferenceBeginIndex();
        if (refBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getReferenceTokens()[refBeginTokenRank - 1].endIdx;
        return differencer.referenceLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int refEndLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        CobolToken[] refTokens = differencer.getReferenceTokens();
        int refEndTokenRank = cursor.getReferenceEndIndex();
        if (refEndTokenRank == refTokens.length) {
            return differencer.getReferenceLineIndexes().length;
        }
        int nextTokenBeginIdx = refTokens[refEndTokenRank].beginIdx;
        return differencer.referenceLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static int modBeginLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        int modBeginTokenRank = cursor.getModifiedBeginIndex();
        if (modBeginTokenRank == 0) {
            return 0;
        }
        int previousTokenEndIdx = differencer.getModifiedTokens()[modBeginTokenRank - 1].endIdx;
        return differencer.modifiedLineRankFromCharIndex(previousTokenEndIdx);
    }

    protected static int modEndLineRank(PacbaseCobolDifferencer differencer, DiffCursor cursor) {
        CobolToken[] modTokens = differencer.getModifiedTokens();
        int modEndTokenRank = cursor.getModifiedEndIndex();
        if (modEndTokenRank == modTokens.length) {
            return differencer.getModifiedLineIndexes().length;
        }
        int nextTokenBeginIdx = modTokens[modEndTokenRank].beginIdx;
        return differencer.modifiedLineRankFromCharIndex(nextTokenBeginIdx);
    }

    protected static CsvWriter appendCobol(CsvWriter csv, String name, String cobol, int[] lineStartIndexes, int lineBeginRank, int lineEndRank) {
        int beginIdx = MigrationControlExtension.beginingOfLine(cobol, lineStartIndexes, lineBeginRank);
        int endIdx = MigrationControlExtension.beforeLineFeed(cobol, MigrationControlExtension.endOfLine(cobol, lineStartIndexes, lineEndRank));
        csv.appendTextToCell(name).appendTextToCell('[').appendIntegerToCell(1 + lineBeginRank).appendTextToCell(',').appendIntegerToCell(1 + lineEndRank).appendTextToCell("]:").appendEolToCell();
        int nbOfLines = lineEndRank - lineBeginRank;
        if (nbOfLines <= 10) {
            beginIdx = MigrationControlExtension.extendBeginIndex(cobol, beginIdx, endIdx, lineStartIndexes, lineBeginRank, lineEndRank);
            csv.appendTextToCell(cobol, beginIdx, endIdx);
        } else {
            int endOfFirst5Idx = MigrationControlExtension.endOfLine(cobol, lineStartIndexes, lineBeginRank + 5);
            int beginOfLast5Idx = MigrationControlExtension.beginingOfLine(cobol, lineStartIndexes, lineEndRank - 5);
            csv.appendTextToCell(cobol, beginIdx, endOfFirst5Idx);
            csv.appendTextToCell("       ... + ").appendIntegerToCell(nbOfLines - 10).appendTextToCell(" lines").appendEolToCell();
            csv.appendTextToCell(cobol, beginOfLast5Idx, endIdx);
        }
        return csv;
    }

    private static int extendBeginIndex(String cobol, int beginIdx, int endIdx, int[] lineStartIndexes, int lineBeginRank, int lineEndRank) {
        if (lineBeginRank == lineEndRank && endIdx - beginIdx >= 40 && MigrationControlExtension.isValueDifference(cobol, beginIdx, endIdx)) {
            beginIdx = MigrationControlExtension.beginingOfLine(cobol, lineStartIndexes, lineBeginRank - 1);
        }
        return beginIdx;
    }

    private static boolean isValueDifference(String cobol, int beginIdx, int endIdx) {
        int offset = 0;
        while (beginIdx + offset < endIdx && cobol.charAt(beginIdx + offset) == ' ') {
            ++offset;
        }
        if (beginIdx + offset + 4 < endIdx && cobol.charAt(beginIdx + offset) == 'V' && cobol.charAt(beginIdx + offset + 1) == 'A' && cobol.charAt(beginIdx + offset + 2) == 'L' && cobol.charAt(beginIdx + offset + 3) == 'U' && cobol.charAt(beginIdx + offset + 4) == 'E') {
            offset += 5;
            while (beginIdx + offset < endIdx && cobol.charAt(beginIdx + offset) == ' ') {
                ++offset;
            }
            if (beginIdx + offset < endIdx && cobol.charAt(beginIdx + offset) == '+') {
                ++offset;
                while (beginIdx + offset < endIdx && Character.isDigit(cobol.charAt(beginIdx + offset))) {
                    ++offset;
                }
                if (beginIdx + offset < endIdx && cobol.charAt(beginIdx + offset) == '.') {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String test = "                        VALUE      +";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "                    VALUE      +1";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "                    VALUE      +1.";
        test = "                    VALUE      +13333.";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "                    VALUE      +13.";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "                    VAL";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "VAL";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "         VALUE      +003.                                RDP425";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
        test = "                                VALUE      +2971.                       LC0001";
        System.out.println(String.valueOf(test) + " -> " + MigrationControlExtension.isValueDifference(test, 0, test.length()));
    }

    protected static int beforeLineFeed(String cobol, int idx) {
        if (idx == 0) {
            return 0;
        }
        char previousChar = cobol.charAt(idx - 1);
        if (previousChar == '\n') {
            return idx - 1 != 0 && cobol.charAt(idx - 2) == '\r' ? idx - 2 : idx - 1;
        }
        if (previousChar == '\r') {
            return idx - 1 != 0 && cobol.charAt(idx - 2) == '\n' ? idx - 2 : idx - 1;
        }
        return idx;
    }

    protected static int beginingOfLine(String cobol, int[] linesStartIndexes, int lineRank) {
        return linesStartIndexes[lineRank];
    }

    protected static int endOfLine(String cobol, int[] linesStartIndexes, int lineRank) {
        return lineRank >= linesStartIndexes.length - 1 ? cobol.length() : linesStartIndexes[lineRank + 1];
    }

    protected static CsvWriter catenateWords(CsvWriter csv, Word[] words) {
        int i;
        if (words.length == 0) {
            return csv;
        }
        int leftCut = 0;
        int nbChars = 0;
        while (leftCut < words.length) {
            if ((nbChars += 1 + words[leftCut++].length()) >= 80) break;
        }
        int rightCut = leftCut;
        nbChars = 0;
        int wordCount = leftCut;
        while (wordCount < words.length) {
            nbChars += 1 + words[wordCount].length();
            while (nbChars >= 80) {
                nbChars -= 1 + words[rightCut++].length();
            }
            ++wordCount;
        }
        csv.appendTextToCell('|');
        if (leftCut + 1 >= words.length) {
            i = 0;
            while (i < words.length - 1) {
                MigrationControlExtension.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        } else {
            i = 0;
            while (i < leftCut) {
                MigrationControlExtension.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
            csv.appendTextToCell(" ...\n... ");
            i = rightCut;
            while (i < words.length - 1) {
                MigrationControlExtension.appendWord(csv, words[i]).appendTextToCell(' ');
                ++i;
            }
        }
        return MigrationControlExtension.appendWord(csv, words[words.length - 1]).appendTextToCell('|');
    }

    protected static CsvWriter appendWord(CsvWriter csv, Word word) {
        switch (word.length()) {
            case 1: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell('\'');
            }
            case 2: {
                if (!word.quoted()) {
                    return csv.appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar());
                }
                return csv.appendTextToCell('\'').appendTextToCell(word.firstChar()).appendTextToCell(word.lastChar()).appendTextToCell('\'');
            }
        }
        if (!word.quoted()) {
            return csv.appendTextToCell(word.chars());
        }
        return csv.appendTextToCell('\'').appendTextToCell(word.chars()).appendTextToCell('\'');
    }

    protected static void showHeader(CsvWriter csv, String controlFolder) {
        if (csv == null) {
            return;
        }
        csv.appendTextToCell("Number of files = ").appendIntegerToCell(diffBank.getNbFiles()).endOfRow();
        csv.appendTextToCell("Number of modified files = ").appendIntegerToCell(diffBank.getNbModifiedFiles()).endOfRow();
        csv.appendTextToCell("Number of templates = ").appendIntegerToCell(diffBank.size()).endOfRow();
        csv.appendTextToCell("Number of differences = ").appendIntegerToCell(diffBank.occurrences()).endOfRow();
        if (diffBank.getFilteredTemplates() != null && diffBank.getFilteredTemplates().length != 0) {
            csv.appendTextToCell("Number of modified file (filtered) = ").appendIntegerToCell(diffBank.getNbModifiedFilesWithFilter()).endOfRow();
            csv.appendTextToCell("Number of differences (filtered) = ").appendIntegerToCell(diffBank.getNbDifferencesWithFilter()).endOfRow();
            csv.appendTextToCell("Number of filtered templates = ").appendIntegerToCell(diffBank.getFilteredTemplates().length).endOfRow();
        }
        if (DifferenceBank.logComparisonTime) {
            csv.appendTextToCell("Total comparison time = ").appendIntegerToCell((int)diffBank.getComparisonTotalTime()).endOfRow();
            ArrayList timeforCobols = diffBank.getTimesForCobol();
            if (timeforCobols != null) {
                for (DifferenceBank.TimeForCobol timeForCobol : timeforCobols) {
                    if (timeForCobol == null) continue;
                    csv.appendTextToCell("Ten longest time = ").appendIntegerToCell((int)timeForCobol.getTime()).appendTextToCell("  (" + timeForCobol.getCobolName() + ")").endOfRow();
                }
            }
        }
        csv.endOfRow();
    }

    public static List<String> readFile(File aFile) throws Exception {
        ArrayList<String> contents = new ArrayList<String>();
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                contents.add(line);
            }
        }
        finally {
            input.close();
        }
        return contents;
    }

    private static void decodeTemplates(List<String> lines, DifferenceBank diffBank, char separator, char textDelimiter) {
        int deletedNBColumn = -1;
        int addedNBColumn = -1;
        int deletedColumn = -1;
        int addedColumn = -1;
        boolean titleLineFound = false;
        ArrayList<DifferenceBank.FilteredTemplate> filteredTemplates = new ArrayList<DifferenceBank.FilteredTemplate>();
        int i = 0;
        String normalizedTemplateName = String.valueOf(textDelimiter) + "Template" + textDelimiter + separator;
        String defaultTemplateName = "Template" + separator;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (!titleLineFound) {
                if ((line.startsWith(defaultTemplateName) || line.startsWith(normalizedTemplateName)) && line.indexOf(COLUMN_TITLE_DELETED_NB) != -1) {
                    titleLineFound = true;
                    deletedNBColumn = MigrationControlExtension.getColumnIndex(separator, textDelimiter, line, COLUMN_TITLE_DELETED_NB);
                    deletedColumn = MigrationControlExtension.getColumnIndex(separator, textDelimiter, line, COLUMN_TITLE_DELETED);
                    addedNBColumn = MigrationControlExtension.getColumnIndex(separator, textDelimiter, line, COLUMN_TITLE_ADDED_NB);
                    addedColumn = MigrationControlExtension.getColumnIndex(separator, textDelimiter, line, COLUMN_TITLE_ADDED);
                }
                ++i;
                continue;
            }
            String reccord = line;
            if (!line.endsWith("" + textDelimiter) && !line.endsWith("" + textDelimiter + separator) && i + 1 < lines.size()) {
                StringBuilder sb = new StringBuilder(line);
                do {
                    line = lines.get(++i);
                    sb.append("\n");
                    sb.append(line);
                } while (!line.endsWith("" + textDelimiter) && !line.endsWith("" + textDelimiter + separator) && i + 1 < lines.size());
                reccord = sb.toString();
            }
            String deletedNB = MigrationControlExtension.getColumnString(separator, reccord, deletedNBColumn).trim();
            String addedNB = MigrationControlExtension.getColumnString(separator, reccord, addedNBColumn).trim();
            int deletedNBInt = Integer.parseInt(deletedNB);
            int addedNBInt = Integer.parseInt(addedNB);
            String deleted = MigrationControlExtension.getColumnString(separator, reccord, deletedColumn);
            String added = MigrationControlExtension.getColumnString(separator, reccord, addedColumn);
            DifferenceBank.FilteredTemplate fTemplate = new DifferenceBank.FilteredTemplate(added, deleted, addedNBInt, deletedNBInt);
            filteredTemplates.add(fTemplate);
            ++i;
        }
        if (filteredTemplates.size() != 0) {
            DifferenceBank.FilteredTemplate[] fts = new DifferenceBank.FilteredTemplate[filteredTemplates.size()];
            fts = filteredTemplates.toArray(fts);
            diffBank.setFilteredTemplates(fts);
        }
    }

    private static int getColumnIndex(char separator, char textDelimiter, String line, String columnToSearch) {
        String columnContent;
        int columnCount = 0;
        int startIndex = 0;
        int separatorIndex = line.indexOf(separator);
        while (separatorIndex != -1) {
            columnContent = line.substring(startIndex, separatorIndex);
            if (columnContent.equals(columnToSearch) || columnContent.equals(String.valueOf(textDelimiter) + columnToSearch + textDelimiter)) {
                return columnCount;
            }
            startIndex = separatorIndex + 1;
            separatorIndex = line.indexOf(separator, startIndex);
            ++columnCount;
        }
        columnContent = line.substring(startIndex);
        if (columnContent.equals(columnToSearch) || columnContent.equals(String.valueOf(textDelimiter) + columnToSearch + textDelimiter)) {
            return columnCount;
        }
        System.err.println("Column " + columnToSearch + "not found");
        throw new RuntimeException("Cannot find column  : " + columnToSearch);
    }

    private static String getColumnString(char separator, String line, int columnIndex) {
        int columnCount = 0;
        int startIndex = 0;
        int separatorIndex = line.indexOf(separator);
        while (separatorIndex != -1) {
            if (columnCount == columnIndex) {
                return line.substring(startIndex, separatorIndex);
            }
            startIndex = separatorIndex + 1;
            separatorIndex = line.indexOf(separator, startIndex);
            ++columnCount;
        }
        if (columnCount == columnIndex) {
            return line.substring(startIndex);
        }
        throw new RuntimeException("Column " + columnIndex + " not found for line" + line);
    }

    public static String getDefaultDiffBankFileName() {
        return String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + FOLDER_DIFFERENCE_BANK + FILE_DIFFERENCE_BANK;
    }

    public static String getDiffBankFileName() {
        Validation validation = ValidationContoler.getValidation();
        String templateFilePath = validation.getTemplatesFilesPath();
        String differenceBankFileName = null;
        differenceBankFileName = templateFilePath == null || templateFilePath.trim().length() == 0 ? MigrationControlExtension.getDefaultDiffBankFileName() : templateFilePath.trim();
        return differenceBankFileName;
    }

    public boolean refreshMarkers(IController controler, IResource resource) {
        return ValidationContoler.refreshMigrationMarkers(controler, resource);
    }

    public static void loadAndSaveValidationFile(String validationFileName) {
        if (validationFileName == null) {
            return;
        }
        ValidationContoler.loadValidation(validationFileName);
        ValidationContoler.saveValidationOnDisk();
    }

    public boolean isMigrationControlActivated(String generatedID) {
        ValidationCache vc = ValidationCache.getCache();
        int validationCacheState = vc.getState();
        if (validationCacheState != 1) {
            throw new RuntimeException(Messages.ValidationCacheToRebuild);
        }
        Map<String, CacheData> pdpFilesToValidMap = vc.getPdpFilesToValidate();
        if (pdpFilesToValidMap == null || pdpFilesToValidMap.size() == 0) {
            return false;
        }
        return pdpFilesToValidMap.containsKey(generatedID);
    }

    public static class EntrypointGenCouple {
        private String _genFileLogicalName;
        private String _entryPointLogicalName;
        private String _stateID;
        private String _relation;
        private String _patternName;

        public EntrypointGenCouple(String genFileLogicalName, String entryPointLogicalName, String stateID, String relationName, String patternName) {
            this._genFileLogicalName = genFileLogicalName;
            this._entryPointLogicalName = entryPointLogicalName;
            this._stateID = stateID;
            this._relation = relationName;
            this._patternName = patternName;
        }

        public String getGenFileLogicalName() {
            return this._genFileLogicalName;
        }

        public String getEntryPointLogicalName() {
            return this._entryPointLogicalName;
        }

        public String getStateID() {
            return this._stateID;
        }

        public String getRelation() {
            return this._relation;
        }

        public String getPatternName() {
            return this._patternName;
        }
    }
}

