/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import com.ibm.pdp.micropattern.pacbase.analyzer.PacAnalyzerLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WFAnalyzer
extends AbstractPacAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PARAM_DSP = "DSP";
    public static final String _PARAM_DSL = "DSL";
    public static final String _PARAM_SEL = "SEL";
    public static final String _PARAM_FOR = "FOR";
    public static final String _PARAM_DES = "DES";
    public static final String _PARAM_LEV = "LEV";
    public static final String _PARAM_ORG = "ORG";
    public static final String _PARAM_SSC = "SSC";
    public static final String _PARAM_BLC = "BLC";
    public static final String _PARAM_GRP = "GRP";
    public static final String _PARAM_PLT = "PLT";
    public static final String _PARAM_PFX = "PFX";
    public static final String _PARAM_SIP = "SIP";
    public static final Set<String> _DES_VALUES = new HashSet<String>(Arrays.asList("", "1", "2", "3", "4"));
    public static final Set<String> _FOR_VALUES = new HashSet<String>(Arrays.asList("I", "E", "S"));
    public static final Set<String> _ORG_VALUES = new HashSet<String>(Arrays.asList("D", "G", "H", "M", "N", "P", "Q", "T", "2", "9"));
    public static final Set<String> _GRP_VALUES = new HashSet<String>(Arrays.asList("Y", "N"));
    private static final String EMPTY_STRING = "";
    private static final String DATA_UNIT = "dataunit";
    private static final String DATA_AGGREGATE = "dataaggregate";
    private static final String DSL_STRING = "DSL=";
    private static final String DSP_STRING = "DSP=";
    private static final String SEL_STRING = "SEL=";
    private static final String WF_MICRO_PATTERN = "WF";

    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) {
        String sGrp;
        String sBlc;
        Integer iSsc;
        String sOrg;
        Integer iLev;
        String sDes;
        String sFor;
        Object[] array;
        Object prmDsp = parameters.get(_PARAM_DSP);
        Object prmFor = parameters.get(_PARAM_FOR);
        Object prmDes = parameters.get(_PARAM_DES);
        Object prmLev = parameters.get(_PARAM_LEV);
        Object prmOrg = parameters.get(_PARAM_ORG);
        Object prmSsc = parameters.get(_PARAM_SSC);
        Object prmBlc = parameters.get(_PARAM_BLC);
        Object prmGrp = parameters.get(_PARAM_GRP);
        Object prmSel = parameters.get(_PARAM_SEL);
        Object prmSip = parameters.get(_PARAM_SIP);
        Object prmPfx = parameters.get(_PARAM_PFX);
        boolean result = true;
        if (prmDsp != null) {
            String sDsp;
            if (prmSip != null) {
                malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INCOMPATIBLE_DSP));
                result = false;
            }
            if ((sDsp = (String)prmDsp).length() != 2) {
                array = new String[]{sDsp};
                malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_DSP, array));
                result = false;
            }
        }
        if (prmFor != null && !_FOR_VALUES.contains(sFor = (String)prmFor)) {
            array = new String[]{sFor};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_FOR, array));
            result = false;
        }
        if (prmDes != null && !_DES_VALUES.contains(sDes = (String)prmDes)) {
            array = new String[]{sDes};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_DES, array));
            result = false;
        }
        if (prmLev != null && ((iLev = (Integer)prmLev) < 1 || iLev > 7)) {
            array = new String[]{Integer.toString(iLev)};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_LEV, array));
            result = false;
        }
        if (prmOrg != null && !_ORG_VALUES.contains(sOrg = (String)prmOrg)) {
            array = new String[]{sOrg};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_ORG, array));
            result = false;
        }
        if (prmSsc != null && ((iSsc = (Integer)prmSsc) < 0 || iSsc > 9)) {
            array = new String[]{Integer.toString(iSsc)};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_SSC, array));
            result = false;
        }
        if (prmBlc != null && (sBlc = (String)prmBlc).length() > 6) {
            array = new String[]{sBlc};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_BLC, array));
            result = false;
        }
        if (prmGrp != null && !_GRP_VALUES.contains(sGrp = (String)prmGrp)) {
            array = new String[]{sGrp};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_GRP, array));
            result = false;
        }
        if (prmSip != null) {
            String sSel = (String)prmSel;
            if (sSel == null) {
                malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_MANDATORY_SEL));
                result = false;
            }
            if (prmSel != null && (sSel.equals(EMPTY_STRING) || sSel.length() > 2)) {
                malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INVALID_SEL));
                result = false;
            }
            if (prmPfx != null) {
                malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._WF_INCOMPATIBLE_PFX));
                result = false;
            }
        }
        return result;
    }

    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx, IAnalyzerResult mpAnalyserResult) {
        int dslLength;
        String remainingStr;
        String snippet = text.substring(beginIdx, endIdx);
        int idxDSL = snippet.indexOf(DSL_STRING);
        int idxDSP = snippet.indexOf(DSP_STRING);
        if (idxDSL == -1 && idxDSP == -1) {
            return null;
        }
        int idx = idxDSL;
        if (idxDSL == -1) {
            idx = idxDSP;
        }
        if ((remainingStr = this.getStringAfterEqual(snippet, idx + (dslLength = DSL_STRING.length()))).indexOf(36) != -1) {
            return null;
        }
        String ds = null;
        if (remainingStr.length() == 4) {
            ds = remainingStr.substring(1, 3);
        } else if (remainingStr.length() == 2) {
            ds = remainingStr;
        } else {
            return null;
        }
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        int offsetForDSLValue = beginIdx + idxDSL + dslLength;
        this.createAndAddDataStructure(refEntities, ds, offsetForDSLValue);
        int selLength = SEL_STRING.length();
        int idx2 = snippet.indexOf(SEL_STRING);
        if (idx2 == -1) {
            return refEntities;
        }
        remainingStr = this.getStringAfterEqual(snippet, idx2 + selLength);
        String segments = null;
        if (remainingStr.length() > 0) {
            segments = remainingStr.charAt(0) == '\'' || remainingStr.charAt(0) == '\"' ? remainingStr.substring(1, remainingStr.length() - 1) : remainingStr;
        } else {
            return refEntities;
        }
        segments = this.removeDollarsAndEqualsSymbols(segments);
        if (segments.length() == 0) {
            return refEntities;
        }
        int offsetForSELValue = beginIdx + idx2 + selLength;
        this.addSegments(refEntities, segments, ds, offsetForSELValue);
        return refEntities;
    }

    private String getStringAfterEqual(String snippet, int start) {
        String result = EMPTY_STRING;
        char charToSearch = ' ';
        if (snippet.charAt(start) == '\'') {
            charToSearch = '\'';
            ++start;
        } else if (snippet.charAt(start) == '\"') {
            charToSearch = '\"';
            ++start;
        }
        int i = start;
        while (i < snippet.length()) {
            if (charToSearch != ' ') {
                if (snippet.charAt(i) == charToSearch) {
                    result = snippet.substring(start, i).trim();
                    return result;
                }
            } else if (Character.isWhitespace(snippet.charAt(i))) {
                result = snippet.substring(start, i);
                return result;
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    private void createAndAddDataStructure(List<ReferencedEntity> refEntities, String ds, int offset) {
        ReferencedEntity re = new ReferencedEntity(ds, null, DATA_UNIT, WF_MICRO_PATTERN, offset);
        refEntities.add(re);
    }

    private String removeDollarsAndEqualsSymbols(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '=') {
                i += 3;
                continue;
            }
            if (c == '$') {
                i += 2;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private void addSegments(List<ReferencedEntity> refEntities, String segments, String ds, int offset) {
        if (segments.length() % 2 != 0) {
            return;
        }
        int i = 0;
        while (i < segments.length()) {
            String seg = segments.substring(i, i + 2);
            if (seg.indexOf(36) == -1) {
                ReferencedEntity re = new ReferencedEntity(String.valueOf(ds) + seg, null, DATA_AGGREGATE, WF_MICRO_PATTERN, offset);
                refEntities.add(re);
            }
            i += 2;
        }
    }
}

