/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import com.ibm.pdp.micropattern.pacbase.analyzer.PacAnalyzerLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SQLAnalyzer
extends AbstractPacAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PARAM_CSR = "CSR";
    public static final String _PARAM_SE1 = "SE1";
    public static final String _PARAM_AC1 = "AC1";
    public static final String _PARAM_AC2 = "AC2";
    private static String PAC_DATAAGGREGATE = "dataaggregate";

    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) {
        Object prmcsr = parameters.get(_PARAM_CSR);
        boolean result = true;
        if (prmcsr == null || prmcsr.toString().trim().length() == 0) {
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._SQL_ABSENCE_CSR));
            result = false;
        }
        return result;
    }

    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx, IAnalyzerResult mpAnalyserResult) {
        String dataAggregateName;
        if (mpAnalyserResult == null) {
            return Collections.emptyList();
        }
        Map parameters = mpAnalyserResult.getParameters();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        Object prmDe1 = parameters.get(_PARAM_CSR);
        Object prmDe2 = parameters.get(_PARAM_SE1);
        if (prmDe1 != null && prmDe2 == null) {
            String sDef1;
            dataAggregateName = sDef1 = (String)prmDe1;
            refEntities.add(new ReferencedEntity(dataAggregateName, null, PAC_DATAAGGREGATE, this.getIdentifier()));
        }
        if (prmDe2 != null) {
            String sDef2;
            dataAggregateName = sDef2 = (String)prmDe2;
            refEntities.add(new ReferencedEntity(dataAggregateName, null, PAC_DATAAGGREGATE, this.getIdentifier()));
        }
        return refEntities;
    }
}

