/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import com.ibm.pdp.micropattern.pacbase.analyzer.PacAnalyzerLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ERRAnalyzer
extends AbstractPacAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PARAM_ERC = "ERC";
    public static final String _PARAM_DEC = "DEC";
    public static final String _PARAM_IND = "IND";
    public static final String _PARAM_LVC = "LVC";
    private static String PAC_DATAELEMENT = "dataelement";
    private static String PAC_DATAAGGREGATE = "dataaggregate";

    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) {
        String sLvc;
        Object[] array;
        String sErc;
        Object prmErc = parameters.get(_PARAM_ERC);
        Object prmLvc = parameters.get(_PARAM_LVC);
        boolean result = true;
        if (prmErc != null && (sErc = (String)prmErc).length() != 1) {
            array = new String[]{sErc};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._ERR_INVALID_ERC, array));
            result = false;
        }
        if (prmLvc != null && (sLvc = (String)prmLvc).length() > 4) {
            array = new String[]{sLvc};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._ERR_INVALID_LVC, array));
            result = false;
        }
        return result;
    }

    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx, IAnalyzerResult mpAnalyserResult) {
        Object prmDe2;
        if (mpAnalyserResult == null) {
            return Collections.emptyList();
        }
        Map parameters = mpAnalyserResult.getParameters();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        Object prmDe1 = parameters.get(_PARAM_DEC);
        if (prmDe1 != null) {
            String sDef1 = (String)prmDe1;
            String dataElementName = ERRAnalyzer.GetPacDataElementFromParameter(sDef1);
            refEntities.add(new ReferencedEntity(dataElementName, null, PAC_DATAELEMENT, this.getIdentifier()));
        }
        if ((prmDe2 = parameters.get(_PARAM_LVC)) != null) {
            String sDef2;
            String dataAggregateName = sDef2 = (String)prmDe2;
            refEntities.add(new ReferencedEntity(dataAggregateName, null, PAC_DATAAGGREGATE, this.getIdentifier()));
        }
        return refEntities;
    }
}

