/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.analyzer.tool.MPDesignReference;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import com.ibm.pdp.micropattern.pacbase.analyzer.PacAnalyzerLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DAOAnalyzer
extends AbstractPacAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PARAM_DF1 = "DF1";
    public static final String _PARAM_SNB = "SNB";
    public static final String _PARAM_DE1 = "DE1";
    private static String PAC_DATAELEMENT = "dataelement";
    public static final Set<String> _DF_VALUES = new HashSet<String>(Arrays.asList("I", "D", "E", "S", "G", "C", "M"));
    private static final Map<String, String> _preDefinedDataElements = new HashMap<String, String>(9);

    static {
        _preDefinedDataElements.put("DATCE", "S");
        _preDefinedDataElements.put("DATOR", "I");
        _preDefinedDataElements.put("DAT6", "I");
        _preDefinedDataElements.put("DAT7", "D");
        _preDefinedDataElements.put("DAT8", "E");
        _preDefinedDataElements.put("DAT6C", "S");
        _preDefinedDataElements.put("DAT7C", "C");
        _preDefinedDataElements.put("DAT8C", "M");
        _preDefinedDataElements.put("DAT8G", "G");
    }

    public static final Map<String, String> getPredefinedDataElements() {
        return _preDefinedDataElements;
    }

    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) {
        String sSnb;
        Object[] array;
        String sDf1;
        Object prmDf1 = parameters.get(_PARAM_DF1);
        Object prmSnb = parameters.get(_PARAM_SNB);
        boolean result = true;
        if (prmDf1 != null && !_DF_VALUES.contains(sDf1 = (String)prmDf1)) {
            array = new String[]{sDf1};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._AD_INVALID_DF, array));
            result = false;
        }
        if (prmSnb != null && (sSnb = (String)prmSnb).length() > 0 && sSnb.charAt(0) != '+' && sSnb.charAt(0) != '-') {
            array = new String[]{sSnb};
            malformedMessages.add(PacAnalyzerLabel.getString(PacAnalyzerLabel._DAO_INVALID_SNB, array));
            result = false;
        }
        return result;
    }

    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx, IAnalyzerResult mpAnalyserResult) {
        if (mpAnalyserResult == null) {
            return Collections.emptyList();
        }
        Map parameters = mpAnalyserResult.getParameters();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        MPDesignReference designRef1 = (MPDesignReference)parameters.get(_PARAM_DE1);
        if (designRef1 != null) {
            String sDef1 = designRef1.getName();
            String dataElementName = DAOAnalyzer.GetPacDataElementFromParameter(sDef1);
            refEntities.add(new ReferencedEntity(dataElementName, null, PAC_DATAELEMENT, this.getIdentifier()));
        }
        return refEntities;
    }
}

