/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.micropattern.analyzer.MPAbstractAnalyzer;
import com.ibm.pdp.micropattern.analyzer.MPParameter;

public abstract class AbstractPacAnalyzer
extends MPAbstractAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] _macroParams = new String[]{"$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H", "$I", "$J"};

    public AbstractPacAnalyzer() {
        this.addPredefinedParameters();
    }

    public boolean accept(String text) {
        if (!this.getIdentifier().endsWith("*")) {
            return super.accept(text);
        }
        String identifier = this.getIdentifier();
        if (!text.regionMatches(_PREFIX_END, identifier, 0, identifier.length() - 1) || !text.regionMatches(6, "*!", 0, _MP_DECLARATION_TOKEN_LENGTH)) {
            return false;
        }
        int start = _PREFIX_END + identifier.length() - 1;
        int end = text.indexOf(32, start);
        end = (end >= 0 ? end : text.length()) - start;
        return end >= 1 && end <= 4;
    }

    public boolean isValueCheckable(String value) {
        String[] stringArray = _macroParams;
        int n = _macroParams.length;
        int n2 = 0;
        while (n2 < n) {
            String macroParam = stringArray[n2];
            if (value.contains(macroParam)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void addPredefinedParameters() {
        MPParameter idParameter = new MPParameter("id", null, "Numeric", null, true, false, null);
        this.getParameters().add(idParameter);
        this.getKeyedParameters().put(idParameter.getName(), idParameter);
        MPParameter plParameter = new MPParameter("pl", null, "String", null, true, false, null);
        this.getParameters().add(plParameter);
        this.getKeyedParameters().put(plParameter.getName(), plParameter);
    }

    public static String GetPacDataElementFromParameter(String description) {
        String code = "";
        if (description != null && description.length() > 0) {
            int index;
            int spaceIndex = description.indexOf(32);
            if (spaceIndex != -1) {
                description = description.substring(0, spaceIndex);
            }
            if (description.contains("(")) {
                int beginIndex = description.lastIndexOf(40);
                description = description.substring(0, beginIndex);
            }
            if ((index = description.lastIndexOf(45)) != -1) {
                String lgrub = description.substring(index + 1);
                if (lgrub.length() < 7 && (code = lgrub).length() > 0) {
                    return code;
                }
            } else {
                code = description;
                return code;
            }
        }
        return null;
    }
}

