/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.pacbase.analyzer;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractADxAnalyzer
extends AbstractPacAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _PARAM_DE1 = "DE1";
    public static final String _PARAM_DE2 = "DE2";
    private static String PAC_DATAELEMENT = "dataelement";
    private static final Map<String, String> _preDefinedDataElements = new HashMap<String, String>(9);

    static {
        _preDefinedDataElements.put("DATCE", "S");
        _preDefinedDataElements.put("DATOR", "I");
        _preDefinedDataElements.put("DAT6", "I");
        _preDefinedDataElements.put("DAT7", "D");
        _preDefinedDataElements.put("DAT8", "E");
        _preDefinedDataElements.put("DAT6C", "S");
        _preDefinedDataElements.put("DAT7C", "C");
        _preDefinedDataElements.put("DAT8C", "M");
        _preDefinedDataElements.put("DAT8G", "G");
    }

    public static final Map<String, String> getPredefinedDataElements() {
        return _preDefinedDataElements;
    }

    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx, IAnalyzerResult mpAnalyserResult) {
        Object prmDe2;
        if (mpAnalyserResult == null) {
            return Collections.emptyList();
        }
        Map parameters = mpAnalyserResult.getParameters();
        ArrayList<ReferencedEntity> refEntities = new ArrayList<ReferencedEntity>();
        Object prmDe1 = parameters.get(_PARAM_DE1);
        if (prmDe1 != null) {
            String sDef1 = (String)prmDe1;
            String dataElementName = AbstractADxAnalyzer.GetPacDataElementFromParameter(sDef1);
            refEntities.add(new ReferencedEntity(dataElementName, null, PAC_DATAELEMENT, this.getIdentifier()));
        }
        if ((prmDe2 = parameters.get(_PARAM_DE2)) != null) {
            String sDef2 = (String)prmDe2;
            String dataElementName = AbstractADxAnalyzer.GetPacDataElementFromParameter(sDef2);
            refEntities.add(new ReferencedEntity(dataElementName, null, PAC_DATAELEMENT, this.getIdentifier()));
        }
        return refEntities;
    }
}

