/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.extended.pacbase.analyzer.service;

import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.service.IPTLocation;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.micropattern.analyzer.tool.MPDesignReference;
import com.ibm.pdp.micropattern.pacbase.analyzer.AbstractPacAnalyzer;

public class PacExtendedAnalyzerService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019, 2020. All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String getDesignProject(IMicroPatternProcessingContext context) {
        Object data = context.getData("DESIGN_FILE_IN_CONTEXT");
        String designProject = null;
        if (data instanceof RadicalEntity) {
            designProject = ((RadicalEntity)data).getProject();
        }
        return designProject;
    }

    public static boolean exists(String designProject, MPDesignReference designRef, String lineSeparator, IMicroPatternProcessingContext context) {
        if (designProject == null || designRef == null || context == null) {
            return false;
        }
        PTNature nature = PTNature.getNature((String)designProject);
        if (nature == null) {
            return false;
        }
        IPTLocation location = PTModelService.getLocation((String)nature.getLocation());
        if (location == null) {
            return false;
        }
        String sDef1 = designRef.getName();
        String deCode = AbstractPacAnalyzer.GetPacDataElementFromParameter((String)sDef1);
        for (String path : PTNature.getPaths((String)designProject)) {
            String designId = PTModelService.getDesignId((String)path, (String)"", (String)deCode, (String)"", (String)designRef.getType());
            if (location.getElement(designId) == null) continue;
            return true;
        }
        return false;
    }

    public static RadicalEntity resolveSharedResource(String context, String packageName, String name, String type) {
        return PacExtendedAnalyzerService.resolveSharedResource(context, packageName, name, "", type);
    }

    public static RadicalEntity resolveSharedResource(String context, String packageName, String name, String metaType, String type) {
        return PTEditorService.resolveSharedResource((String)context, (String)packageName, (String)name, (String)metaType, (String)type);
    }
}

