/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.micropattern.extended.pacbase.analyzer;

import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacOrganizationValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreenSubSchemaValues;
import com.ibm.pdp.micropattern.analyzer.MPException;
import com.ibm.pdp.micropattern.extended.pacbase.analyzer.PacAbstractExtendedAnalyzer;
import com.ibm.pdp.micropattern.extended.pacbase.analyzer.PacExtendedAnalyzerLabel;
import com.ibm.pdp.pacbase.extension.micropattern.internal.SegmentDatasForWF;
import com.ibm.pdp.pacbase.util.sql.AbstractTPGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.AccessGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.ProgramGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.ScreenGeneratorInfosForSQL;
import com.ibm.pdp.pacbase.util.sql.ServerGeneratorInfosForSQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLExtendedAnalyzer
extends PacAbstractExtendedAnalyzer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public String access;
    public String cursor;
    public String specificAccess;
    public String method;

    public boolean acceptParameters(Map<String, Object> parameters, String lineSeparator, IMicroPatternProcessingContext context, List<String> malformedMessages) throws MPException {
        if (context == null) {
            return true;
        }
        boolean accept = true;
        String prmcsr = "";
        String prmse1 = "";
        String prmac1 = "";
        String prmac2 = "";
        ArrayList<String> paramList = new ArrayList<String>();
        if (parameters.get("CSR") != null) {
            prmcsr = parameters.get("CSR").toString();
            paramList.add(prmcsr);
            if (prmcsr.trim().length() != 4) {
                Object[] array = new String[]{"CSR"};
                malformedMessages.add(PacExtendedAnalyzerLabel.getString(PacExtendedAnalyzerLabel._ERRONEOUS_CSR, array));
                return false;
            }
        }
        if (parameters.get("SE1") != null) {
            prmse1 = parameters.get("SE1").toString();
            paramList.add(prmse1);
            if (prmse1.trim().length() != 4) {
                Object[] array = new String[]{"SE1"};
                malformedMessages.add(PacExtendedAnalyzerLabel.getString(PacExtendedAnalyzerLabel._ERRONEOUS_SE1, array));
                return false;
            }
        }
        if (parameters.get("AC1") != null) {
            prmac1 = parameters.get("AC1").toString();
            paramList.add(prmac1);
        }
        if (parameters.get("AC2") != null) {
            prmac2 = parameters.get("AC2").toString();
            paramList.add(prmac2);
        }
        if (parameters.containsKey("CSR") && parameters.containsKey("AC1")) {
            accept = true;
        }
        Object data = context.getData("DESIGN_FILE_IN_CONTEXT");
        if (parameters.get("AC1") == null && data instanceof PacProgram) {
            Object[] array = new String[]{"AC1"};
            malformedMessages.add(PacExtendedAnalyzerLabel.getString(PacExtendedAnalyzerLabel._MISSING_PRM, array));
            accept = false;
            return accept;
        }
        if (paramList.size() == 1 && data instanceof PacProgram) {
            malformedMessages.add(PacExtendedAnalyzerLabel.getString(PacExtendedAnalyzerLabel._MISSING_PRM));
            accept = false;
        }
        return accept;
    }

    public void transformWFinCD(HashMap<String, SegmentDatasForWF> lsSegWF, AccessGeneratorInfosForSQL entInfos, ArrayList<String> paramList) {
        SegmentDatasForWF segWF;
        ((ProgramGeneratorInfosForSQL)entInfos).checkAccessAndCursor(paramList);
        ProgramGeneratorInfosForSQL pgmInfos = (ProgramGeneratorInfosForSQL)entInfos;
        String segCodeInProgram = "";
        String sdCodeInProgram = "";
        if (lsSegWF != null && !lsSegWF.isEmpty() && (segWF = lsSegWF.get(pgmInfos.getCursorCode())) != null) {
            for (String segInLib : segWF.getSegmentInLibrary()) {
                AccessGeneratorInfosForSQL.CDLineInProgram cdline = new AccessGeneratorInfosForSQL.CDLineInProgram();
                PacBlockBase pbb = (PacBlockBase)PTEditorService.resolveSharedResource((String)pgmInfos.getProgram().getProject(), (String)pgmInfos.getProgram().getPackage(), (String)segWF.getBlockBaseCode(), (String)"pacblockbase");
                cdline.setBbase(pbb);
                cdline.setOrg(PacOrganizationValues.get((String)("_" + segWF.getOrg())));
                cdline.setSubschema(segWF.getSsSchema());
                pgmInfos.getCdlinesMapSv().put(String.valueOf(segInLib.substring(0, 2)) + segInLib, cdline);
                StringBuilder keymap = new StringBuilder(segInLib.substring(0, 2));
                segCodeInProgram = pgmInfos.getCursorCode();
                sdCodeInProgram = segCodeInProgram.substring(0, 2);
                keymap.append(sdCodeInProgram);
                keymap.append(segCodeInProgram);
                cdline.setSdCodeInPgm(sdCodeInProgram);
                pgmInfos.getCdlinesMap().put(keymap.toString(), cdline);
            }
        }
    }

    public void transformWFinCS(HashMap<String, SegmentDatasForWF> lsSegWF, AccessGeneratorInfosForSQL entInfos, ArrayList<String> paramList) {
        SegmentDatasForWF segWF;
        this.getParam(paramList);
        AbstractTPGeneratorInfosForSQL scrInfos = (AbstractTPGeneratorInfosForSQL)entInfos;
        String project = "";
        String pack = "";
        String cursorCode = "";
        if (entInfos instanceof ScreenGeneratorInfosForSQL) {
            project = ((ScreenGeneratorInfosForSQL)entInfos).getScreen().getProject();
            pack = ((ScreenGeneratorInfosForSQL)entInfos).getScreen().getPackage();
            cursorCode = ((ScreenGeneratorInfosForSQL)entInfos).getCursorCode();
        }
        if (entInfos instanceof ServerGeneratorInfosForSQL) {
            project = ((ServerGeneratorInfosForSQL)entInfos).getServer().getProject();
            pack = ((ServerGeneratorInfosForSQL)entInfos).getServer().getPackage();
            cursorCode = ((ServerGeneratorInfosForSQL)entInfos).getCursorCode();
        }
        if (lsSegWF != null && !lsSegWF.isEmpty() && (segWF = lsSegWF.get(scrInfos.getCursorCode())) != null) {
            for (String segInLib : segWF.getSegmentInLibrary()) {
                AccessGeneratorInfosForSQL.CSLineInScrOrSrv csline = new AccessGeneratorInfosForSQL.CSLineInScrOrSrv();
                PacBlockBase pbb = (PacBlockBase)PTEditorService.resolveSharedResource((String)project, (String)pack, (String)segWF.getBlockBaseCode(), (String)"pacblockbase");
                DataAggregate dag = (DataAggregate)PTEditorService.resolveSharedResource((String)project, (String)pack, (String)segInLib, (String)"dataaggregate");
                csline.setOrganisation(segWF.getOrg());
                csline.setSubschema(PacScreenSubSchemaValues.get((String)("_" + segWF.getSsSchema())));
                csline.setSeg(dag);
                String blockOrganization = "CIMNPQRS2";
                if (!blockOrganization.contains(segWF.getOrg())) continue;
                csline.setBbase(pbb);
                ((AbstractTPGeneratorInfosForSQL)entInfos).getCslinesMap().put(cursorCode, csline);
            }
        }
    }

    private void getParam(ArrayList<String> paramList) {
        char nbparam = Character.forDigit(paramList.size(), 10);
        switch (nbparam) {
            case '1': {
                break;
            }
            case '2': {
                this.cursor = paramList.get(0);
                this.access = paramList.get(1);
                this.method = "";
                this.specificAccess = "";
                if (paramList.get(0).length() != 4) {
                    this.access = "";
                    break;
                }
                int indequ = this.access.indexOf(61);
                if (indequ != -1) {
                    String newstd;
                    this.access = newstd = this.access.substring(indequ + 1);
                }
                String[] lsAuthorizedAccess = new String[]{"DC", "R", "RU", "RN", "W", "RW", "D", "CL", "P", "RA"};
                boolean isRealST = false;
                int i = 0;
                while (i < lsAuthorizedAccess.length) {
                    String acc = lsAuthorizedAccess[i];
                    if (paramList.get(1).equals(acc)) {
                        isRealST = true;
                        break;
                    }
                    ++i;
                }
                if (isRealST) {
                    this.specificAccess = paramList.get(1);
                    break;
                }
                this.access = paramList.get(1);
                break;
            }
            case '3': {
                this.cursor = paramList.get(0);
                this.access = paramList.get(1);
                if (paramList.get(2).trim().length() > 2 || this.access.equals("EX")) {
                    this.method = paramList.get(2);
                    this.specificAccess = "";
                    break;
                }
                this.method = "";
                this.specificAccess = paramList.get(2);
                break;
            }
            case '4': {
                this.cursor = paramList.get(0);
                this.access = paramList.get(1);
                if (paramList.get(2).trim().length() > 2) {
                    this.method = paramList.get(2);
                    this.specificAccess = "";
                    break;
                }
                this.method = "";
                this.specificAccess = paramList.get(2);
                break;
            }
        }
    }
}

