/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer.tool;

public class MPDesignReference {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private String _name;
    private String _metaType;
    private String _type;
    private String _mpName;

    public MPDesignReference(String name, String type, String mpName) {
        this(name, "", type, mpName);
    }

    public MPDesignReference(String name, String metaType, String type, String mpName) {
        _mpName = mpName;
        _name = name;
        _metaType = metaType;
        _type = type;
    }

    public String getName() {
        if (_name == null)
            _name = "";
        return _name;
    }

    public String getMetaType() {
        if (_metaType == null)
            _metaType = "";
        return _metaType;
    }

    public String getType() {
        if (_type == null)
            _type = "";
        return _type;
    }

    public String getMPName() {
        if (_mpName == null)
            _mpName = "";
        return _mpName;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(getName());
        buffer.append('.');
        if (getMetaType().length() > 0)
            buffer.append(getMetaType()).append('.');

        buffer.append(getType()).append('(').append(getMPName()).append(')');
        return buffer.toString();
    }
}
