/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer.plugin;

import java.util.List;
import java.util.Map;

import com.ibm.pdp.engine.IMicroPatternProcessingContext;
import com.ibm.pdp.micropattern.analyzer.MPException;

/**
 * Contribute to the Design Explorer view contextual menu.
 */
public interface IMPExtendedAnalyzer {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    /**
     * Get/Set the declared namespace for this micro-pattern implementation.
     */
    public String getNamespace();

    public void setNamespace(String namespace);

    /**
     * Get/Set the declared identifier for this micro-pattern implementation.
     */
    public String getIdentifier();

    public void setIdentifier(String identifier);

    /**
     * Indicates if the 'parameters' describes a valid map of parameters, according to the micro-pattern extension implementation.
     * The context is required for the access to the design files content. If this parameter is null, this access is not done, and true is returned.
     * Return a boolean if the syntax is correct,
     * Return null, and feed the 'malformedMessages' list otherwise.
     */
    public boolean acceptParameters(Map<String, Object> parameters, String lineSeparator, IMicroPatternProcessingContext context, List<String> malformedMessages)
            throws MPException;
}
