/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2018, 2020
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer.plugin;

import java.util.List;
import java.util.Map;

import com.ibm.pdp.engine.IAnalyzerResult;
import com.ibm.pdp.mdl.link.design.ReferencedEntity;
import com.ibm.pdp.micropattern.analyzer.MPException;
import com.ibm.pdp.micropattern.analyzer.MPParameter;
import com.ibm.pdp.micropattern.analyzer.MPPattern;

/**
 * Contribute to the Design Explorer view contextual menu.
 */
public interface IMPAnalyzer {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public final static int _STAR_COLUMN = 6;
    public final static int _RIGHT_MARGIN = 72;
    public final static String _STAR = "*"; //$NON-NLS-1$
    public final static String _CLAM = "!"; //$NON-NLS-1$
    public final static String _DASH = "-"; //$NON-NLS-1$
    public final static String _MP_DECLARATION_TOKEN = "*!"; //$NON-NLS-1$
    public final static int _MP_DECLARATION_TOKEN_LENGTH = _MP_DECLARATION_TOKEN.length();
    public final static String _MP_NEXT_LINE_TOKEN = "*!-"; //$NON-NLS-1$
    public final static int _MP_NEXT_LINE_TOKEN_LENGTH = _MP_NEXT_LINE_TOKEN.length();
    public final static int _PREFIX_END = _STAR_COLUMN+_MP_DECLARATION_TOKEN_LENGTH;
    public final static int _NEXT_PREFIX_END = _STAR_COLUMN+_MP_NEXT_LINE_TOKEN_LENGTH;


    public final static String _TYPE_STRING = "String"; //$NON-NLS-1$
    public final static String _TYPE_NUMERIC = "Numeric"; //$NON-NLS-1$
    public final static String _TYPE_BOOLEAN = "Boolean"; //$NON-NLS-1$
    public final static String _TYPE_DESIGN = "Design"; //$NON-NLS-1$

    public final static String _AREA_ALL = "All"; //$NON-NLS-1$
    public final static String _AREA_PROCEDURE = "Procedure"; //$NON-NLS-1$
    public final static String _AREA_WORKING = "Working"; //$NON-NLS-1$

    /**
     * Section dedicated to the micro-pattern definition according the extension point instantiation
     */
    /**
     * Get/Set the declared namespace for this micro-pattern implementation.
     */
    public String getNamespace();

    public void setNamespace(String namespace);

    /**
     * Get/Set the declared identifier for this micro-pattern implementation.
     */
    public String getIdentifier();

    public void setIdentifier(String identifier);

    /**
     * Get/Set the declared description for this micro-pattern implementation.
     */
    public String getDescription();

    public void setDescription(String description);

    /**
     * Get/Set the definition area for this micro-pattern implementation.
     */
    public String getArea();

    public void setArea(String area);

    /**
     * Get/Set the content assist status for this micro-pattern implementation.
     */
    public boolean getContentAssist();

    public void setContentAssist(boolean contentAssist);

    /**
     * Get the declared list of parameters for this micro-pattern implementation.
     */
    public List<MPParameter> getParameters();

    /**
     * Get the declared map of parameters for this micro-pattern implementation.
     */
    public Map<String, MPParameter> getKeyedParameters();

    /**
     * Get the declared map of patterns for this micro-pattern implementation.
     */
    public Map<String, MPPattern> getKeyedPatterns();

    /**
     * Section dedicated to the checking of the micro-pattern syntax (identifier and parameters)
     */
    /**
     * Indicates if the value is ckeckable.
     */
    public boolean isValueCheckable(String value);

    /**
     * Indicates if the text given in parameter is recognized by the micro-pattern implementation.
     */
    public boolean accept(String text);

    /**
     * Indicates if the 'parameters' describes a valid map of parameters, according to the micro-pattern implementation.
     * Return a boolean if the syntax is correct,
     * Return null, and feed the 'malformedMessages' list otherwise.
     */
    public boolean acceptParameters(Map<String, Object> parameters, List<String> malformedMessages) throws MPException;

    /**
     * Return the list of referenced design entities.
     * (Code refactoring from com.ibm.pdp.mdl.link.design.IMpAnalyzer). 
     */
    public List<ReferencedEntity> getReferencedEntities(String text, int beginIdx, int endIdx,  IAnalyzerResult mpAnalyserResult);

}
