/**
 * IBM Confidential
 * OCO Source Materials
 * 5725-H03
 * (C) Copyright IBM Corp. 2019
 * The source code for this program is not published or 
 * otherwise divested of its trade secrets, irrespective of 
 * what has been deposited with the U.S. Copyright Office.
 */
package com.ibm.pdp.micropattern.analyzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MPPattern {

    public final static String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    // runtime attributes
    private String _patternId;
    private String _description;
    private List<MPParameter> _parameters;
    private Map<String, MPParameter> _keyedParameters;

    /**
     * Constructor
     */
    public MPPattern(String patternId, String description) {
        _patternId = patternId;
        _description = description;
    }

    /**
     * Get the pattern Id
     */
    public String getPatternId() {
        if (_patternId == null)
            _patternId = "";
        return _patternId;
    }

    /**
     * Get the description
     */
    public String getDescription() {
        if (_description == null)
            _description = "";
        return _description;
    }

    /**
     * Get the declared list of specific parameters for this micro-pattern pattern implementation.
     */
    public List<MPParameter> getParameters() {
        if (_parameters == null)
            _parameters = new ArrayList<MPParameter>();
        return _parameters;
    }

    /**
     * Get the declared map of specific parameters for this micro-pattern pattern implementation.
     */
    public Map<String, MPParameter> getKeyedParameters() {
        if (_keyedParameters == null)
            _keyedParameters = new HashMap<String, MPParameter>();
        return _keyedParameters;
    }
}